/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-01-22 11:56:14 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `j3nd_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1292 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=63599 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=3839 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=1269 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_e_submissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint unsigned NOT NULL,
  `referer` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip` varchar(46) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int DEFAULT '0',
  `actions_succeeded_count` int DEFAULT '0',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1393 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_e_submissions_actions_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL,
  `action_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB AUTO_INCREMENT=1393 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_e_submissions_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=5569 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=109917 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2017 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=927 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_wpforms_logs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `types` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `create_at` datetime NOT NULL,
  `form_id` bigint DEFAULT NULL,
  `entry_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_wpforms_payment_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `payment_id` bigint NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_wpforms_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `form_id` bigint NOT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subtotal_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `discount_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `total_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `currency` varchar(3) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `entry_id` bigint NOT NULL DEFAULT '0',
  `gateway` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `type` varchar(12) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `mode` varchar(4) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `transaction_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `customer_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscription_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscription_status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `date_created_gmt` datetime NOT NULL,
  `date_updated_gmt` datetime NOT NULL,
  `is_published` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`(8)),
  KEY `total_amount` (`total_amount`),
  KEY `type` (`type`(8)),
  KEY `transaction_id` (`transaction_id`(32)),
  KEY `customer_id` (`customer_id`(32)),
  KEY `subscription_id` (`subscription_id`(32)),
  KEY `subscription_status` (`subscription_status`(8)),
  KEY `title` (`title`(64))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `j3nd_wpforms_tasks_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: j3nd_actionscheduler_actions */
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1153", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-12-27 11:27:42", "2025-12-27 06:27:42", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766834862;s:18:\"\0*\0first_timestamp\";i:1738381450;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766834862;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-12-27 11:28:49", "2025-12-27 06:28:49", "60393", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1158", "wpforms_process_forms_locator_scan", "complete", "2025-12-22 13:26:31", "2025-12-22 08:26:31", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766409991;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766409991;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-22 13:32:19", "2025-12-22 08:32:19", "59664", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1159", "wpforms_process_purge_spam", "complete", "2025-12-22 13:26:32", "2025-12-22 08:26:32", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766409992;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766409992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-22 13:32:19", "2025-12-22 08:32:19", "59664", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1160", "wpforms_process_forms_locator_scan", "complete", "2025-12-22 13:26:32", "2025-12-22 08:26:32", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766409992;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766409992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-22 13:32:19", "2025-12-22 08:32:19", "59664", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1161", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-23 09:06:10", "2025-12-23 04:06:10", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766480770;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766480770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-23 09:07:06", "2025-12-23 04:07:06", "59796", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1162", "wpforms_process_forms_locator_scan", "complete", "2025-12-23 13:32:19", "2025-12-23 08:32:19", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766496739;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766496739;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-23 14:27:40", "2025-12-23 09:27:40", "59814", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1163", "wpforms_process_purge_spam", "complete", "2025-12-23 13:32:19", "2025-12-23 08:32:19", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766496739;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766496739;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-23 14:27:40", "2025-12-23 09:27:40", "59814", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1164", "wpforms_process_forms_locator_scan", "complete", "2025-12-23 13:32:19", "2025-12-23 08:32:19", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766496739;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766496739;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-23 14:27:40", "2025-12-23 09:27:40", "59814", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1165", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-24 09:07:06", "2025-12-24 04:07:06", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766567226;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766567226;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-24 09:35:46", "2025-12-24 04:35:46", "59934", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1166", "wpforms_process_forms_locator_scan", "complete", "2025-12-24 14:27:40", "2025-12-24 09:27:40", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766586460;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766586460;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-24 14:30:22", "2025-12-24 09:30:22", "59962", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1167", "wpforms_process_purge_spam", "complete", "2025-12-24 14:27:40", "2025-12-24 09:27:40", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766586460;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766586460;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-24 14:30:22", "2025-12-24 09:30:22", "59962", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1168", "wpforms_process_forms_locator_scan", "complete", "2025-12-24 14:27:40", "2025-12-24 09:27:40", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766586460;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766586460;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-24 14:30:22", "2025-12-24 09:30:22", "59962", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1169", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-25 09:35:46", "2025-12-25 04:35:46", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766655346;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766655346;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-25 10:16:21", "2025-12-25 05:16:21", "60089", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1170", "wpforms_process_forms_locator_scan", "complete", "2025-12-25 14:30:22", "2025-12-25 09:30:22", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766673022;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766673022;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-25 14:41:45", "2025-12-25 09:41:45", "60107", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1171", "wpforms_process_purge_spam", "complete", "2025-12-25 14:30:22", "2025-12-25 09:30:22", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766673022;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766673022;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-25 14:41:45", "2025-12-25 09:41:45", "60107", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1172", "wpforms_process_forms_locator_scan", "complete", "2025-12-25 14:30:22", "2025-12-25 09:30:22", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766673022;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766673022;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-25 14:41:45", "2025-12-25 09:41:45", "60107", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1173", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-26 10:16:21", "2025-12-26 05:16:21", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766744181;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766744181;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-26 10:40:29", "2025-12-26 05:40:29", "60195", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1174", "wpforms_process_forms_locator_scan", "complete", "2025-12-26 14:41:45", "2025-12-26 09:41:45", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766760105;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766760105;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-26 14:52:58", "2025-12-26 09:52:58", "60267", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1175", "wpforms_process_purge_spam", "complete", "2025-12-26 14:41:45", "2025-12-26 09:41:45", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766760105;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766760105;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-26 14:52:58", "2025-12-26 09:52:58", "60267", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1176", "wpforms_process_forms_locator_scan", "complete", "2025-12-26 14:41:45", "2025-12-26 09:41:45", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766760105;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766760105;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-26 14:52:58", "2025-12-26 09:52:58", "60267", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1177", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-27 10:40:29", "2025-12-27 05:40:29", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766832029;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766832029;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-27 10:46:56", "2025-12-27 05:46:56", "60388", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1178", "wpforms_process_forms_locator_scan", "complete", "2025-12-27 14:52:58", "2025-12-27 09:52:58", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766847178;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766847178;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-27 14:57:23", "2025-12-27 09:57:23", "60410", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1179", "wpforms_process_purge_spam", "complete", "2025-12-27 14:52:58", "2025-12-27 09:52:58", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766847178;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766847178;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-27 14:57:23", "2025-12-27 09:57:23", "60410", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1180", "wpforms_process_forms_locator_scan", "complete", "2025-12-27 14:52:58", "2025-12-27 09:52:58", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766847178;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766847178;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-27 14:57:23", "2025-12-27 09:57:23", "60410", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1181", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-28 10:46:56", "2025-12-28 05:46:56", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766918816;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766918816;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-28 10:53:25", "2025-12-28 05:53:25", "60518", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1182", "wpforms_email_summaries_fetch_info_blocks", "complete", "2026-01-03 11:28:49", "2026-01-03 06:28:49", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767439729;s:18:\"\0*\0first_timestamp\";i:1738381450;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767439729;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2026-01-03 11:41:47", "2026-01-03 06:41:47", "61401", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1183", "wpforms_process_forms_locator_scan", "complete", "2025-12-28 14:57:23", "2025-12-28 09:57:23", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766933843;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766933843;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-28 15:23:17", "2025-12-28 10:23:17", "60549", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1184", "wpforms_process_purge_spam", "complete", "2025-12-28 14:57:23", "2025-12-28 09:57:23", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766933843;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766933843;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-28 15:23:17", "2025-12-28 10:23:17", "60549", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1185", "wpforms_process_forms_locator_scan", "complete", "2025-12-28 14:57:23", "2025-12-28 09:57:23", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766933843;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766933843;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-28 15:23:17", "2025-12-28 10:23:17", "60549", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1186", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-29 10:53:25", "2025-12-29 05:53:25", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767005605;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767005605;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-29 10:54:51", "2025-12-29 05:54:51", "60648", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1187", "wpforms_process_forms_locator_scan", "complete", "2025-12-29 15:23:17", "2025-12-29 10:23:17", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767021797;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767021797;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-29 15:28:17", "2025-12-29 10:28:17", "60673", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1188", "wpforms_process_purge_spam", "complete", "2025-12-29 15:23:17", "2025-12-29 10:23:17", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767021797;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767021797;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-29 15:28:18", "2025-12-29 10:28:18", "60673", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1189", "wpforms_process_forms_locator_scan", "complete", "2025-12-29 15:23:17", "2025-12-29 10:23:17", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767021797;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767021797;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-29 15:28:18", "2025-12-29 10:28:18", "60673", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1190", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-30 10:54:51", "2025-12-30 05:54:51", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767092091;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767092091;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-30 10:59:55", "2025-12-30 05:59:55", "60784", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1191", "wpforms_process_forms_locator_scan", "complete", "2025-12-30 15:28:17", "2025-12-30 10:28:17", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767108497;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767108497;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-30 15:36:54", "2025-12-30 10:36:54", "60806", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1192", "wpforms_process_purge_spam", "complete", "2025-12-30 15:28:18", "2025-12-30 10:28:18", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767108498;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767108498;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-30 15:36:54", "2025-12-30 10:36:54", "60806", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1193", "wpforms_process_forms_locator_scan", "complete", "2025-12-30 15:28:18", "2025-12-30 10:28:18", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767108498;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767108498;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-30 15:36:54", "2025-12-30 10:36:54", "60806", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1194", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-31 10:59:55", "2025-12-31 05:59:55", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767178795;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767178795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-31 11:03:24", "2025-12-31 06:03:24", "61017", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1195", "wpforms_process_forms_locator_scan", "complete", "2025-12-31 15:36:54", "2025-12-31 10:36:54", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767195414;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767195414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-31 15:39:56", "2025-12-31 10:39:56", "61037", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1196", "wpforms_process_purge_spam", "complete", "2025-12-31 15:36:54", "2025-12-31 10:36:54", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767195414;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767195414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-31 15:39:56", "2025-12-31 10:39:56", "61037", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1197", "wpforms_process_forms_locator_scan", "complete", "2025-12-31 15:36:54", "2025-12-31 10:36:54", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767195414;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767195414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-31 15:39:56", "2025-12-31 10:39:56", "61037", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1198", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-01 11:03:24", "2026-01-01 06:03:24", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767265404;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767265404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-01 11:05:54", "2026-01-01 06:05:54", "61135", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1199", "wpforms_process_forms_locator_scan", "complete", "2026-01-01 15:39:56", "2026-01-01 10:39:56", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767281996;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767281996;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-01 15:41:55", "2026-01-01 10:41:55", "61190", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1200", "wpforms_process_purge_spam", "complete", "2026-01-01 15:39:56", "2026-01-01 10:39:56", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767281996;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767281996;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-01 15:41:55", "2026-01-01 10:41:55", "61190", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1201", "wpforms_process_forms_locator_scan", "complete", "2026-01-01 15:39:56", "2026-01-01 10:39:56", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767281996;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767281996;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-01 15:41:55", "2026-01-01 10:41:55", "61190", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1202", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-02 11:05:54", "2026-01-02 06:05:54", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767351954;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767351954;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-02 11:07:15", "2026-01-02 06:07:15", "61279", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1203", "wpforms_process_forms_locator_scan", "complete", "2026-01-02 15:41:55", "2026-01-02 10:41:55", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767368515;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767368515;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-02 15:42:21", "2026-01-02 10:42:21", "61302", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1204", "wpforms_process_purge_spam", "complete", "2026-01-02 15:41:55", "2026-01-02 10:41:55", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767368515;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767368515;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-02 15:42:21", "2026-01-02 10:42:21", "61302", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1205", "wpforms_process_forms_locator_scan", "complete", "2026-01-02 15:41:55", "2026-01-02 10:41:55", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767368515;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767368515;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-02 15:42:21", "2026-01-02 10:42:21", "61302", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1206", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-03 11:07:15", "2026-01-03 06:07:15", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767438435;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767438435;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-03 11:41:47", "2026-01-03 06:41:47", "61401", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1207", "wpforms_process_forms_locator_scan", "complete", "2026-01-03 15:42:21", "2026-01-03 10:42:21", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767454941;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767454941;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-03 16:02:17", "2026-01-03 11:02:17", "61425", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1208", "wpforms_process_purge_spam", "complete", "2026-01-03 15:42:21", "2026-01-03 10:42:21", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767454941;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767454941;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-03 16:02:17", "2026-01-03 11:02:17", "61425", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1209", "wpforms_process_forms_locator_scan", "complete", "2026-01-03 15:42:21", "2026-01-03 10:42:21", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767454941;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767454941;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-03 16:02:17", "2026-01-03 11:02:17", "61425", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1210", "wpforms_email_summaries_fetch_info_blocks", "complete", "2026-01-10 11:41:47", "2026-01-10 06:41:47", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768045307;s:18:\"\0*\0first_timestamp\";i:1738381450;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768045307;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2026-01-10 12:10:54", "2026-01-10 07:10:54", "62226", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1211", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-04 11:41:47", "2026-01-04 06:41:47", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767526907;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767526907;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-04 11:51:01", "2026-01-04 06:51:01", "61534", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1212", "wpforms_process_forms_locator_scan", "complete", "2026-01-04 16:02:17", "2026-01-04 11:02:17", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767542537;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767542537;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-04 16:17:31", "2026-01-04 11:17:31", "61554", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1213", "wpforms_process_purge_spam", "complete", "2026-01-04 16:02:17", "2026-01-04 11:02:17", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767542537;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767542537;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-04 16:17:31", "2026-01-04 11:17:31", "61554", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1214", "wpforms_process_forms_locator_scan", "complete", "2026-01-04 16:02:17", "2026-01-04 11:02:17", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767542537;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767542537;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-04 16:17:31", "2026-01-04 11:17:31", "61554", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1215", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-05 11:51:01", "2026-01-05 06:51:01", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767613861;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767613861;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-05 12:01:29", "2026-01-05 07:01:29", "61672", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1216", "wpforms_process_forms_locator_scan", "complete", "2026-01-05 16:17:31", "2026-01-05 11:17:31", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767629851;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767629851;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-05 16:17:33", "2026-01-05 11:17:33", "61696", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1217", "wpforms_process_purge_spam", "complete", "2026-01-05 16:17:31", "2026-01-05 11:17:31", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767629851;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767629851;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-05 16:17:33", "2026-01-05 11:17:33", "61696", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1218", "wpforms_process_forms_locator_scan", "complete", "2026-01-05 16:17:31", "2026-01-05 11:17:31", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767629851;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767629851;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-05 16:17:33", "2026-01-05 11:17:33", "61696", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1219", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-06 12:01:29", "2026-01-06 07:01:29", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767700889;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767700889;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-06 12:06:50", "2026-01-06 07:06:50", "61781", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1220", "wpforms_process_forms_locator_scan", "complete", "2026-01-06 16:17:33", "2026-01-06 11:17:33", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767716253;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767716253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-06 16:30:19", "2026-01-06 11:30:19", "61793", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1221", "wpforms_process_purge_spam", "complete", "2026-01-06 16:17:33", "2026-01-06 11:17:33", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767716253;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767716253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-06 16:30:19", "2026-01-06 11:30:19", "61793", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1222", "wpforms_process_forms_locator_scan", "complete", "2026-01-06 16:17:33", "2026-01-06 11:17:33", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767716253;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767716253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-06 16:30:19", "2026-01-06 11:30:19", "61793", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1223", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-07 12:06:50", "2026-01-07 07:06:50", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767787610;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767787610;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-07 22:06:09", "2026-01-07 17:06:09", "61868", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1224", "wpforms_process_forms_locator_scan", "complete", "2026-01-07 16:30:19", "2026-01-07 11:30:19", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767803419;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767803419;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-07 22:06:09", "2026-01-07 17:06:09", "61868", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1225", "wpforms_process_purge_spam", "complete", "2026-01-07 16:30:19", "2026-01-07 11:30:19", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767803419;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767803419;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-07 22:06:09", "2026-01-07 17:06:09", "61868", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1226", "wpforms_process_forms_locator_scan", "complete", "2026-01-07 16:30:19", "2026-01-07 11:30:19", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767803419;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767803419;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-07 22:06:09", "2026-01-07 17:06:09", "61868", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1227", "wpforms_process_forms_locator_scan", "complete", "2026-01-08 22:06:09", "2026-01-08 17:06:09", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767909969;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767909969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-08 22:14:55", "2026-01-08 17:14:55", "62012", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1228", "wpforms_process_purge_spam", "complete", "2026-01-08 22:06:09", "2026-01-08 17:06:09", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767909969;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767909969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-08 22:14:55", "2026-01-08 17:14:55", "62012", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1229", "wpforms_process_forms_locator_scan", "complete", "2026-01-08 22:06:09", "2026-01-08 17:06:09", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767909969;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767909969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-08 22:14:55", "2026-01-08 17:14:55", "62012", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1230", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-08 22:06:09", "2026-01-08 17:06:09", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767909969;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767909969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-08 22:14:55", "2026-01-08 17:14:55", "62012", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1231", "wpforms_process_forms_locator_scan", "complete", "2026-01-09 22:14:55", "2026-01-09 17:14:55", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767996895;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767996895;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-09 22:25:20", "2026-01-09 17:25:20", "62163", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1232", "wpforms_process_purge_spam", "complete", "2026-01-09 22:14:55", "2026-01-09 17:14:55", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767996895;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767996895;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-09 22:25:20", "2026-01-09 17:25:20", "62163", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1233", "wpforms_process_forms_locator_scan", "complete", "2026-01-09 22:14:55", "2026-01-09 17:14:55", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767996895;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767996895;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-09 22:25:20", "2026-01-09 17:25:20", "62163", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1234", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-09 22:14:55", "2026-01-09 17:14:55", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767996895;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767996895;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-09 22:25:20", "2026-01-09 17:25:20", "62163", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1235", "wpforms_process_forms_locator_scan", "complete", "2026-01-10 22:25:20", "2026-01-10 17:25:20", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768083920;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768083920;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-10 22:49:28", "2026-01-10 17:49:28", "62270", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1236", "wpforms_process_purge_spam", "complete", "2026-01-10 22:25:20", "2026-01-10 17:25:20", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768083920;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768083920;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-10 22:49:28", "2026-01-10 17:49:28", "62270", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1237", "wpforms_process_forms_locator_scan", "complete", "2026-01-10 22:25:20", "2026-01-10 17:25:20", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768083920;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768083920;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-10 22:49:28", "2026-01-10 17:49:28", "62270", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1238", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-10 22:25:20", "2026-01-10 17:25:20", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768083920;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768083920;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-10 22:49:28", "2026-01-10 17:49:28", "62270", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1239", "wpforms_email_summaries_fetch_info_blocks", "complete", "2026-01-17 12:10:54", "2026-01-17 07:10:54", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768651854;s:18:\"\0*\0first_timestamp\";i:1738381450;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768651854;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2026-01-17 12:47:11", "2026-01-17 07:47:11", "63001", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1240", "wpforms_process_forms_locator_scan", "complete", "2026-01-11 22:49:28", "2026-01-11 17:49:28", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768171768;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768171768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-11 22:58:29", "2026-01-11 17:58:29", "62449", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1241", "wpforms_process_purge_spam", "complete", "2026-01-11 22:49:28", "2026-01-11 17:49:28", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768171768;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768171768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-11 22:58:29", "2026-01-11 17:58:29", "62449", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1242", "wpforms_process_forms_locator_scan", "complete", "2026-01-11 22:49:28", "2026-01-11 17:49:28", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768171768;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768171768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-11 22:58:29", "2026-01-11 17:58:29", "62449", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1243", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-11 22:49:28", "2026-01-11 17:49:28", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768171768;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768171768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-11 22:58:29", "2026-01-11 17:58:29", "62449", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1244", "wpforms_process_forms_locator_scan", "complete", "2026-01-12 22:58:29", "2026-01-12 17:58:29", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768258709;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768258709;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-12 23:13:18", "2026-01-12 18:13:18", "62552", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1245", "wpforms_process_purge_spam", "complete", "2026-01-12 22:58:29", "2026-01-12 17:58:29", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768258709;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768258709;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-12 23:13:18", "2026-01-12 18:13:18", "62552", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1246", "wpforms_process_forms_locator_scan", "complete", "2026-01-12 22:58:29", "2026-01-12 17:58:29", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768258709;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768258709;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-12 23:13:18", "2026-01-12 18:13:18", "62552", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1247", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-12 22:58:29", "2026-01-12 17:58:29", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768258709;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768258709;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-12 23:13:18", "2026-01-12 18:13:18", "62552", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1248", "wpforms_process_forms_locator_scan", "complete", "2026-01-13 23:13:18", "2026-01-13 18:13:18", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768345998;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768345998;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-13 23:27:33", "2026-01-13 18:27:33", "62666", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1249", "wpforms_process_purge_spam", "complete", "2026-01-13 23:13:18", "2026-01-13 18:13:18", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768345998;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768345998;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-13 23:27:33", "2026-01-13 18:27:33", "62666", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1250", "wpforms_process_forms_locator_scan", "complete", "2026-01-13 23:13:18", "2026-01-13 18:13:18", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768345998;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768345998;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-13 23:27:33", "2026-01-13 18:27:33", "62666", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1251", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-13 23:13:18", "2026-01-13 18:13:18", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768345998;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768345998;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-13 23:27:33", "2026-01-13 18:27:33", "62666", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1252", "wpforms_process_forms_locator_scan", "complete", "2026-01-14 23:27:33", "2026-01-14 18:27:33", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768433253;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768433253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-14 23:28:35", "2026-01-14 18:28:35", "62797", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1253", "wpforms_process_purge_spam", "complete", "2026-01-14 23:27:33", "2026-01-14 18:27:33", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768433253;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768433253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-14 23:28:35", "2026-01-14 18:28:35", "62797", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1254", "wpforms_process_forms_locator_scan", "complete", "2026-01-14 23:27:33", "2026-01-14 18:27:33", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768433253;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768433253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-14 23:28:35", "2026-01-14 18:28:35", "62797", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1255", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-14 23:27:33", "2026-01-14 18:27:33", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768433253;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768433253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-14 23:28:35", "2026-01-14 18:28:35", "62797", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1256", "wpforms_process_forms_locator_scan", "complete", "2026-01-15 23:28:35", "2026-01-15 18:28:35", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768519715;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768519715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-15 23:44:14", "2026-01-15 18:44:14", "62889", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1257", "wpforms_process_purge_spam", "complete", "2026-01-15 23:28:35", "2026-01-15 18:28:35", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768519715;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768519715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-15 23:44:14", "2026-01-15 18:44:14", "62889", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1258", "wpforms_process_forms_locator_scan", "complete", "2026-01-15 23:28:35", "2026-01-15 18:28:35", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768519715;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768519715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-15 23:44:14", "2026-01-15 18:44:14", "62889", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1259", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-15 23:28:35", "2026-01-15 18:28:35", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768519715;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768519715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-15 23:44:14", "2026-01-15 18:44:14", "62889", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1260", "wpforms_process_forms_locator_scan", "complete", "2026-01-16 23:44:14", "2026-01-16 18:44:14", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768607054;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768607054;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-17 01:16:18", "2026-01-16 20:16:18", "62962", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1261", "wpforms_process_purge_spam", "complete", "2026-01-16 23:44:14", "2026-01-16 18:44:14", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768607054;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768607054;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-17 01:16:18", "2026-01-16 20:16:18", "62962", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1262", "wpforms_process_forms_locator_scan", "complete", "2026-01-16 23:44:14", "2026-01-16 18:44:14", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768607054;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768607054;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-17 01:16:18", "2026-01-16 20:16:18", "62962", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1263", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-16 23:44:14", "2026-01-16 18:44:14", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768607054;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768607054;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-17 01:16:18", "2026-01-16 20:16:18", "62962", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1264", "wpforms_process_forms_locator_scan", "complete", "2026-01-18 01:16:18", "2026-01-17 20:16:18", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768698978;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768698978;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-18 01:28:02", "2026-01-17 20:28:02", "63029", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1265", "wpforms_process_purge_spam", "complete", "2026-01-18 01:16:18", "2026-01-17 20:16:18", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768698978;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768698978;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-18 01:28:02", "2026-01-17 20:28:02", "63029", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1266", "wpforms_process_forms_locator_scan", "complete", "2026-01-18 01:16:18", "2026-01-17 20:16:18", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768698978;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768698978;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-18 01:28:02", "2026-01-17 20:28:02", "63029", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1267", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-18 01:16:18", "2026-01-17 20:16:18", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768698978;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768698978;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-18 01:28:02", "2026-01-17 20:28:02", "63029", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1268", "wpforms_email_summaries_fetch_info_blocks", "pending", "2026-01-24 12:47:11", "2026-01-24 07:47:11", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769258831;s:18:\"\0*\0first_timestamp\";i:1738381450;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769258831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1269", "wpforms_process_forms_locator_scan", "complete", "2026-01-19 01:28:02", "2026-01-18 20:28:02", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768786082;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768786082;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-19 01:31:02", "2026-01-18 20:31:02", "63125", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1270", "wpforms_process_purge_spam", "complete", "2026-01-19 01:28:02", "2026-01-18 20:28:02", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768786082;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768786082;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-19 01:31:02", "2026-01-18 20:31:02", "63125", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1271", "wpforms_process_forms_locator_scan", "complete", "2026-01-19 01:28:02", "2026-01-18 20:28:02", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768786082;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768786082;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-19 01:31:02", "2026-01-18 20:31:02", "63125", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1272", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-19 01:28:02", "2026-01-18 20:28:02", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768786082;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768786082;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-19 01:31:02", "2026-01-18 20:31:02", "63125", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1273", "wpforms_process_forms_locator_scan", "complete", "2026-01-20 01:31:02", "2026-01-19 20:31:02", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768872662;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768872662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-20 01:51:41", "2026-01-19 20:51:41", "63309", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1274", "wpforms_process_purge_spam", "complete", "2026-01-20 01:31:02", "2026-01-19 20:31:02", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768872662;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768872662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-20 01:51:41", "2026-01-19 20:51:41", "63309", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1275", "wpforms_process_forms_locator_scan", "complete", "2026-01-20 01:31:02", "2026-01-19 20:31:02", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768872662;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768872662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-20 01:51:41", "2026-01-19 20:51:41", "63309", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1276", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-20 01:31:02", "2026-01-19 20:31:02", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768872662;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768872662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-20 01:51:41", "2026-01-19 20:51:41", "63309", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1277", "wpforms_process_forms_locator_scan", "complete", "2026-01-21 01:51:41", "2026-01-20 20:51:41", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768960301;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768960301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-21 02:00:50", "2026-01-20 21:00:50", "63485", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1278", "wpforms_process_purge_spam", "complete", "2026-01-21 01:51:41", "2026-01-20 20:51:41", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768960301;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768960301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-21 02:00:50", "2026-01-20 21:00:50", "63485", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1279", "wpforms_process_forms_locator_scan", "complete", "2026-01-21 01:51:41", "2026-01-20 20:51:41", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768960301;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768960301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-21 02:00:50", "2026-01-20 21:00:50", "63485", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1280", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-21 01:51:41", "2026-01-20 20:51:41", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768960301;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768960301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-21 02:00:50", "2026-01-20 21:00:50", "63485", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1281", "wpforms_process_forms_locator_scan", "complete", "2026-01-22 02:00:50", "2026-01-21 21:00:50", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769047250;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769047250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-22 02:19:41", "2026-01-21 21:19:41", "63566", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1282", "wpforms_process_purge_spam", "complete", "2026-01-22 02:00:50", "2026-01-21 21:00:50", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769047250;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769047250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-22 02:19:41", "2026-01-21 21:19:41", "63566", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1283", "wpforms_process_forms_locator_scan", "complete", "2026-01-22 02:00:50", "2026-01-21 21:00:50", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769047250;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769047250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-22 02:19:41", "2026-01-21 21:19:41", "63566", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1284", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-22 02:00:50", "2026-01-21 21:00:50", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769047250;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769047250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-22 02:19:41", "2026-01-21 21:19:41", "63566", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1285", "wpforms_process_forms_locator_scan", "pending", "2026-01-23 02:19:41", "2026-01-22 21:19:41", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769134781;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769134781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1286", "wpforms_process_purge_spam", "pending", "2026-01-23 02:19:41", "2026-01-22 21:19:41", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769134781;s:18:\"\0*\0first_timestamp\";i:1738210612;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769134781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1287", "wpforms_process_forms_locator_scan", "pending", "2026-01-23 02:19:41", "2026-01-22 21:19:41", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769134781;s:18:\"\0*\0first_timestamp\";i:1739514433;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769134781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1288", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2026-01-23 02:19:41", "2026-01-22 21:19:41", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769134781;s:18:\"\0*\0first_timestamp\";i:1754069554;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769134781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1289", "wpforms_admin_notifications_update", "complete", "2026-01-22 11:52:02", "2026-01-22 11:52:02", "10", "{\"tasks_meta_id\":9}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2026-01-22 11:54:33", "2026-01-22 06:54:33", "63595", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1290", "wpforms_admin_addons_cache_update", "pending", "2026-01-29 11:54:52", "2026-01-29 06:54:52", "10", "{\"tasks_meta_id\":10}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769687692;s:18:\"\0*\0first_timestamp\";i:1769687692;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769687692;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `j3nd_actionscheduler_actions` VALUES("1291", "wpforms_admin_builder_templates_cache_update", "pending", "2026-01-29 11:54:52", "2026-01-29 06:54:52", "10", "{\"tasks_meta_id\":11}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769687692;s:18:\"\0*\0first_timestamp\";i:1769687692;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769687692;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: j3nd_actionscheduler_groups */
INSERT INTO `j3nd_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `j3nd_actionscheduler_groups` VALUES("2", "wpforms");
INSERT INTO `j3nd_actionscheduler_groups` VALUES("3", "ActionScheduler");

/* INSERT TABLE DATA: j3nd_actionscheduler_logs */
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3428", "1153", "action created", "2025-12-20 11:27:42", "2025-12-20 06:27:42");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3443", "1158", "action created", "2025-12-21 13:26:31", "2025-12-21 08:26:31");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3446", "1159", "action created", "2025-12-21 13:26:32", "2025-12-21 08:26:32");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3449", "1160", "action created", "2025-12-21 13:26:32", "2025-12-21 08:26:32");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3452", "1161", "action created", "2025-12-22 09:06:10", "2025-12-22 04:06:10");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3453", "1158", "action started via WP Cron", "2025-12-22 13:32:19", "2025-12-22 08:32:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3454", "1158", "action complete via WP Cron", "2025-12-22 13:32:19", "2025-12-22 08:32:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3455", "1162", "action created", "2025-12-22 13:32:19", "2025-12-22 08:32:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3456", "1159", "action started via WP Cron", "2025-12-22 13:32:19", "2025-12-22 08:32:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3457", "1159", "action complete via WP Cron", "2025-12-22 13:32:19", "2025-12-22 08:32:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3458", "1163", "action created", "2025-12-22 13:32:19", "2025-12-22 08:32:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3459", "1160", "action started via WP Cron", "2025-12-22 13:32:19", "2025-12-22 08:32:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3460", "1160", "action complete via WP Cron", "2025-12-22 13:32:19", "2025-12-22 08:32:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3461", "1164", "action created", "2025-12-22 13:32:19", "2025-12-22 08:32:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3462", "1161", "action started via WP Cron", "2025-12-23 09:07:06", "2025-12-23 04:07:06");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3463", "1161", "action complete via WP Cron", "2025-12-23 09:07:06", "2025-12-23 04:07:06");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3464", "1165", "action created", "2025-12-23 09:07:06", "2025-12-23 04:07:06");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3465", "1162", "action started via WP Cron", "2025-12-23 14:27:40", "2025-12-23 09:27:40");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3466", "1162", "action complete via WP Cron", "2025-12-23 14:27:40", "2025-12-23 09:27:40");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3467", "1166", "action created", "2025-12-23 14:27:40", "2025-12-23 09:27:40");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3468", "1163", "action started via WP Cron", "2025-12-23 14:27:40", "2025-12-23 09:27:40");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3469", "1163", "action complete via WP Cron", "2025-12-23 14:27:40", "2025-12-23 09:27:40");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3470", "1167", "action created", "2025-12-23 14:27:40", "2025-12-23 09:27:40");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3471", "1164", "action started via WP Cron", "2025-12-23 14:27:40", "2025-12-23 09:27:40");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3472", "1164", "action complete via WP Cron", "2025-12-23 14:27:40", "2025-12-23 09:27:40");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3473", "1168", "action created", "2025-12-23 14:27:40", "2025-12-23 09:27:40");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3474", "1165", "action started via WP Cron", "2025-12-24 09:35:45", "2025-12-24 04:35:45");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3475", "1165", "action complete via WP Cron", "2025-12-24 09:35:46", "2025-12-24 04:35:46");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3476", "1169", "action created", "2025-12-24 09:35:46", "2025-12-24 04:35:46");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3477", "1166", "action started via WP Cron", "2025-12-24 14:30:22", "2025-12-24 09:30:22");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3478", "1166", "action complete via WP Cron", "2025-12-24 14:30:22", "2025-12-24 09:30:22");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3479", "1170", "action created", "2025-12-24 14:30:22", "2025-12-24 09:30:22");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3480", "1167", "action started via WP Cron", "2025-12-24 14:30:22", "2025-12-24 09:30:22");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3481", "1167", "action complete via WP Cron", "2025-12-24 14:30:22", "2025-12-24 09:30:22");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3482", "1171", "action created", "2025-12-24 14:30:22", "2025-12-24 09:30:22");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3483", "1168", "action started via WP Cron", "2025-12-24 14:30:22", "2025-12-24 09:30:22");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3484", "1168", "action complete via WP Cron", "2025-12-24 14:30:22", "2025-12-24 09:30:22");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3485", "1172", "action created", "2025-12-24 14:30:22", "2025-12-24 09:30:22");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3486", "1169", "action started via WP Cron", "2025-12-25 10:16:21", "2025-12-25 05:16:21");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3487", "1169", "action complete via WP Cron", "2025-12-25 10:16:21", "2025-12-25 05:16:21");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3488", "1173", "action created", "2025-12-25 10:16:21", "2025-12-25 05:16:21");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3489", "1170", "action started via WP Cron", "2025-12-25 14:41:45", "2025-12-25 09:41:45");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3490", "1170", "action complete via WP Cron", "2025-12-25 14:41:45", "2025-12-25 09:41:45");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3491", "1174", "action created", "2025-12-25 14:41:45", "2025-12-25 09:41:45");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3492", "1171", "action started via WP Cron", "2025-12-25 14:41:45", "2025-12-25 09:41:45");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3493", "1171", "action complete via WP Cron", "2025-12-25 14:41:45", "2025-12-25 09:41:45");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3494", "1175", "action created", "2025-12-25 14:41:45", "2025-12-25 09:41:45");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3495", "1172", "action started via WP Cron", "2025-12-25 14:41:45", "2025-12-25 09:41:45");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3496", "1172", "action complete via WP Cron", "2025-12-25 14:41:45", "2025-12-25 09:41:45");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3497", "1176", "action created", "2025-12-25 14:41:45", "2025-12-25 09:41:45");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3498", "1173", "action started via WP Cron", "2025-12-26 10:40:29", "2025-12-26 05:40:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3499", "1173", "action complete via WP Cron", "2025-12-26 10:40:29", "2025-12-26 05:40:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3500", "1177", "action created", "2025-12-26 10:40:29", "2025-12-26 05:40:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3501", "1174", "action started via WP Cron", "2025-12-26 14:52:58", "2025-12-26 09:52:58");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3502", "1174", "action complete via WP Cron", "2025-12-26 14:52:58", "2025-12-26 09:52:58");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3503", "1178", "action created", "2025-12-26 14:52:58", "2025-12-26 09:52:58");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3504", "1175", "action started via WP Cron", "2025-12-26 14:52:58", "2025-12-26 09:52:58");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3505", "1175", "action complete via WP Cron", "2025-12-26 14:52:58", "2025-12-26 09:52:58");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3506", "1179", "action created", "2025-12-26 14:52:58", "2025-12-26 09:52:58");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3507", "1176", "action started via WP Cron", "2025-12-26 14:52:58", "2025-12-26 09:52:58");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3508", "1176", "action complete via WP Cron", "2025-12-26 14:52:58", "2025-12-26 09:52:58");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3509", "1180", "action created", "2025-12-26 14:52:58", "2025-12-26 09:52:58");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3510", "1177", "action started via WP Cron", "2025-12-27 10:46:56", "2025-12-27 05:46:56");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3511", "1177", "action complete via WP Cron", "2025-12-27 10:46:56", "2025-12-27 05:46:56");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3512", "1181", "action created", "2025-12-27 10:46:56", "2025-12-27 05:46:56");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3513", "1153", "action started via WP Cron", "2025-12-27 11:28:49", "2025-12-27 06:28:49");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3514", "1153", "action complete via WP Cron", "2025-12-27 11:28:49", "2025-12-27 06:28:49");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3515", "1182", "action created", "2025-12-27 11:28:49", "2025-12-27 06:28:49");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3516", "1178", "action started via WP Cron", "2025-12-27 14:57:23", "2025-12-27 09:57:23");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3517", "1178", "action complete via WP Cron", "2025-12-27 14:57:23", "2025-12-27 09:57:23");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3518", "1183", "action created", "2025-12-27 14:57:23", "2025-12-27 09:57:23");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3519", "1179", "action started via WP Cron", "2025-12-27 14:57:23", "2025-12-27 09:57:23");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3520", "1179", "action complete via WP Cron", "2025-12-27 14:57:23", "2025-12-27 09:57:23");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3521", "1184", "action created", "2025-12-27 14:57:23", "2025-12-27 09:57:23");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3522", "1180", "action started via WP Cron", "2025-12-27 14:57:23", "2025-12-27 09:57:23");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3523", "1180", "action complete via WP Cron", "2025-12-27 14:57:23", "2025-12-27 09:57:23");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3524", "1185", "action created", "2025-12-27 14:57:23", "2025-12-27 09:57:23");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3525", "1181", "action started via WP Cron", "2025-12-28 10:53:25", "2025-12-28 05:53:25");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3526", "1181", "action complete via WP Cron", "2025-12-28 10:53:25", "2025-12-28 05:53:25");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3527", "1186", "action created", "2025-12-28 10:53:25", "2025-12-28 05:53:25");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3528", "1183", "action started via WP Cron", "2025-12-28 15:23:17", "2025-12-28 10:23:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3529", "1183", "action complete via WP Cron", "2025-12-28 15:23:17", "2025-12-28 10:23:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3530", "1187", "action created", "2025-12-28 15:23:17", "2025-12-28 10:23:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3531", "1184", "action started via WP Cron", "2025-12-28 15:23:17", "2025-12-28 10:23:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3532", "1184", "action complete via WP Cron", "2025-12-28 15:23:17", "2025-12-28 10:23:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3533", "1188", "action created", "2025-12-28 15:23:17", "2025-12-28 10:23:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3534", "1185", "action started via WP Cron", "2025-12-28 15:23:17", "2025-12-28 10:23:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3535", "1185", "action complete via WP Cron", "2025-12-28 15:23:17", "2025-12-28 10:23:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3536", "1189", "action created", "2025-12-28 15:23:17", "2025-12-28 10:23:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3537", "1186", "action started via WP Cron", "2025-12-29 10:54:51", "2025-12-29 05:54:51");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3538", "1186", "action complete via WP Cron", "2025-12-29 10:54:51", "2025-12-29 05:54:51");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3539", "1190", "action created", "2025-12-29 10:54:51", "2025-12-29 05:54:51");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3540", "1187", "action started via WP Cron", "2025-12-29 15:28:17", "2025-12-29 10:28:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3541", "1187", "action complete via WP Cron", "2025-12-29 15:28:17", "2025-12-29 10:28:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3542", "1191", "action created", "2025-12-29 15:28:17", "2025-12-29 10:28:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3543", "1188", "action started via WP Cron", "2025-12-29 15:28:17", "2025-12-29 10:28:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3544", "1188", "action complete via WP Cron", "2025-12-29 15:28:17", "2025-12-29 10:28:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3545", "1192", "action created", "2025-12-29 15:28:18", "2025-12-29 10:28:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3546", "1189", "action started via WP Cron", "2025-12-29 15:28:18", "2025-12-29 10:28:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3547", "1189", "action complete via WP Cron", "2025-12-29 15:28:18", "2025-12-29 10:28:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3548", "1193", "action created", "2025-12-29 15:28:18", "2025-12-29 10:28:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3549", "1190", "action started via WP Cron", "2025-12-30 10:59:55", "2025-12-30 05:59:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3550", "1190", "action complete via WP Cron", "2025-12-30 10:59:55", "2025-12-30 05:59:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3551", "1194", "action created", "2025-12-30 10:59:55", "2025-12-30 05:59:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3552", "1191", "action started via WP Cron", "2025-12-30 15:36:54", "2025-12-30 10:36:54");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3553", "1191", "action complete via WP Cron", "2025-12-30 15:36:54", "2025-12-30 10:36:54");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3554", "1195", "action created", "2025-12-30 15:36:54", "2025-12-30 10:36:54");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3555", "1192", "action started via WP Cron", "2025-12-30 15:36:54", "2025-12-30 10:36:54");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3556", "1192", "action complete via WP Cron", "2025-12-30 15:36:54", "2025-12-30 10:36:54");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3557", "1196", "action created", "2025-12-30 15:36:54", "2025-12-30 10:36:54");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3558", "1193", "action started via WP Cron", "2025-12-30 15:36:54", "2025-12-30 10:36:54");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3559", "1193", "action complete via WP Cron", "2025-12-30 15:36:54", "2025-12-30 10:36:54");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3560", "1197", "action created", "2025-12-30 15:36:54", "2025-12-30 10:36:54");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3561", "1194", "action started via WP Cron", "2025-12-31 11:03:24", "2025-12-31 06:03:24");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3562", "1194", "action complete via WP Cron", "2025-12-31 11:03:24", "2025-12-31 06:03:24");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3563", "1198", "action created", "2025-12-31 11:03:24", "2025-12-31 06:03:24");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3564", "1195", "action started via WP Cron", "2025-12-31 15:39:56", "2025-12-31 10:39:56");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3565", "1195", "action complete via WP Cron", "2025-12-31 15:39:56", "2025-12-31 10:39:56");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3566", "1199", "action created", "2025-12-31 15:39:56", "2025-12-31 10:39:56");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3567", "1196", "action started via WP Cron", "2025-12-31 15:39:56", "2025-12-31 10:39:56");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3568", "1196", "action complete via WP Cron", "2025-12-31 15:39:56", "2025-12-31 10:39:56");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3569", "1200", "action created", "2025-12-31 15:39:56", "2025-12-31 10:39:56");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3570", "1197", "action started via WP Cron", "2025-12-31 15:39:56", "2025-12-31 10:39:56");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3571", "1197", "action complete via WP Cron", "2025-12-31 15:39:56", "2025-12-31 10:39:56");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3572", "1201", "action created", "2025-12-31 15:39:56", "2025-12-31 10:39:56");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3573", "1198", "action started via WP Cron", "2026-01-01 11:05:54", "2026-01-01 06:05:54");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3574", "1198", "action complete via WP Cron", "2026-01-01 11:05:54", "2026-01-01 06:05:54");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3575", "1202", "action created", "2026-01-01 11:05:54", "2026-01-01 06:05:54");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3576", "1199", "action started via WP Cron", "2026-01-01 15:41:55", "2026-01-01 10:41:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3577", "1199", "action complete via WP Cron", "2026-01-01 15:41:55", "2026-01-01 10:41:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3578", "1203", "action created", "2026-01-01 15:41:55", "2026-01-01 10:41:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3579", "1200", "action started via WP Cron", "2026-01-01 15:41:55", "2026-01-01 10:41:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3580", "1200", "action complete via WP Cron", "2026-01-01 15:41:55", "2026-01-01 10:41:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3581", "1204", "action created", "2026-01-01 15:41:55", "2026-01-01 10:41:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3582", "1201", "action started via WP Cron", "2026-01-01 15:41:55", "2026-01-01 10:41:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3583", "1201", "action complete via WP Cron", "2026-01-01 15:41:55", "2026-01-01 10:41:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3584", "1205", "action created", "2026-01-01 15:41:55", "2026-01-01 10:41:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3585", "1202", "action started via WP Cron", "2026-01-02 11:07:15", "2026-01-02 06:07:15");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3586", "1202", "action complete via WP Cron", "2026-01-02 11:07:15", "2026-01-02 06:07:15");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3587", "1206", "action created", "2026-01-02 11:07:15", "2026-01-02 06:07:15");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3588", "1203", "action started via WP Cron", "2026-01-02 15:42:21", "2026-01-02 10:42:21");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3589", "1203", "action complete via WP Cron", "2026-01-02 15:42:21", "2026-01-02 10:42:21");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3590", "1207", "action created", "2026-01-02 15:42:21", "2026-01-02 10:42:21");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3591", "1204", "action started via WP Cron", "2026-01-02 15:42:21", "2026-01-02 10:42:21");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3592", "1204", "action complete via WP Cron", "2026-01-02 15:42:21", "2026-01-02 10:42:21");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3593", "1208", "action created", "2026-01-02 15:42:21", "2026-01-02 10:42:21");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3594", "1205", "action started via WP Cron", "2026-01-02 15:42:21", "2026-01-02 10:42:21");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3595", "1205", "action complete via WP Cron", "2026-01-02 15:42:21", "2026-01-02 10:42:21");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3596", "1209", "action created", "2026-01-02 15:42:21", "2026-01-02 10:42:21");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3597", "1182", "action started via WP Cron", "2026-01-03 11:41:47", "2026-01-03 06:41:47");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3598", "1182", "action complete via WP Cron", "2026-01-03 11:41:47", "2026-01-03 06:41:47");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3599", "1210", "action created", "2026-01-03 11:41:47", "2026-01-03 06:41:47");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3600", "1206", "action started via WP Cron", "2026-01-03 11:41:47", "2026-01-03 06:41:47");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3601", "1206", "action complete via WP Cron", "2026-01-03 11:41:47", "2026-01-03 06:41:47");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3602", "1211", "action created", "2026-01-03 11:41:47", "2026-01-03 06:41:47");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3603", "1207", "action started via WP Cron", "2026-01-03 16:02:17", "2026-01-03 11:02:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3604", "1207", "action complete via WP Cron", "2026-01-03 16:02:17", "2026-01-03 11:02:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3605", "1212", "action created", "2026-01-03 16:02:17", "2026-01-03 11:02:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3606", "1208", "action started via WP Cron", "2026-01-03 16:02:17", "2026-01-03 11:02:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3607", "1208", "action complete via WP Cron", "2026-01-03 16:02:17", "2026-01-03 11:02:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3608", "1213", "action created", "2026-01-03 16:02:17", "2026-01-03 11:02:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3609", "1209", "action started via WP Cron", "2026-01-03 16:02:17", "2026-01-03 11:02:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3610", "1209", "action complete via WP Cron", "2026-01-03 16:02:17", "2026-01-03 11:02:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3611", "1214", "action created", "2026-01-03 16:02:17", "2026-01-03 11:02:17");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3612", "1211", "action started via WP Cron", "2026-01-04 11:51:01", "2026-01-04 06:51:01");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3613", "1211", "action complete via WP Cron", "2026-01-04 11:51:01", "2026-01-04 06:51:01");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3614", "1215", "action created", "2026-01-04 11:51:01", "2026-01-04 06:51:01");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3615", "1212", "action started via WP Cron", "2026-01-04 16:17:31", "2026-01-04 11:17:31");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3616", "1212", "action complete via WP Cron", "2026-01-04 16:17:31", "2026-01-04 11:17:31");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3617", "1216", "action created", "2026-01-04 16:17:31", "2026-01-04 11:17:31");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3618", "1213", "action started via WP Cron", "2026-01-04 16:17:31", "2026-01-04 11:17:31");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3619", "1213", "action complete via WP Cron", "2026-01-04 16:17:31", "2026-01-04 11:17:31");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3620", "1217", "action created", "2026-01-04 16:17:31", "2026-01-04 11:17:31");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3621", "1214", "action started via WP Cron", "2026-01-04 16:17:31", "2026-01-04 11:17:31");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3622", "1214", "action complete via WP Cron", "2026-01-04 16:17:31", "2026-01-04 11:17:31");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3623", "1218", "action created", "2026-01-04 16:17:31", "2026-01-04 11:17:31");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3624", "1215", "action started via WP Cron", "2026-01-05 12:01:29", "2026-01-05 07:01:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3625", "1215", "action complete via WP Cron", "2026-01-05 12:01:29", "2026-01-05 07:01:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3626", "1219", "action created", "2026-01-05 12:01:29", "2026-01-05 07:01:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3627", "1216", "action started via WP Cron", "2026-01-05 16:17:33", "2026-01-05 11:17:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3628", "1216", "action complete via WP Cron", "2026-01-05 16:17:33", "2026-01-05 11:17:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3629", "1220", "action created", "2026-01-05 16:17:33", "2026-01-05 11:17:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3630", "1217", "action started via WP Cron", "2026-01-05 16:17:33", "2026-01-05 11:17:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3631", "1217", "action complete via WP Cron", "2026-01-05 16:17:33", "2026-01-05 11:17:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3632", "1221", "action created", "2026-01-05 16:17:33", "2026-01-05 11:17:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3633", "1218", "action started via WP Cron", "2026-01-05 16:17:33", "2026-01-05 11:17:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3634", "1218", "action complete via WP Cron", "2026-01-05 16:17:33", "2026-01-05 11:17:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3635", "1222", "action created", "2026-01-05 16:17:33", "2026-01-05 11:17:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3636", "1219", "action started via WP Cron", "2026-01-06 12:06:50", "2026-01-06 07:06:50");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3637", "1219", "action complete via WP Cron", "2026-01-06 12:06:50", "2026-01-06 07:06:50");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3638", "1223", "action created", "2026-01-06 12:06:50", "2026-01-06 07:06:50");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3639", "1220", "action started via WP Cron", "2026-01-06 16:30:19", "2026-01-06 11:30:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3640", "1220", "action complete via WP Cron", "2026-01-06 16:30:19", "2026-01-06 11:30:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3641", "1224", "action created", "2026-01-06 16:30:19", "2026-01-06 11:30:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3642", "1221", "action started via WP Cron", "2026-01-06 16:30:19", "2026-01-06 11:30:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3643", "1221", "action complete via WP Cron", "2026-01-06 16:30:19", "2026-01-06 11:30:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3644", "1225", "action created", "2026-01-06 16:30:19", "2026-01-06 11:30:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3645", "1222", "action started via WP Cron", "2026-01-06 16:30:19", "2026-01-06 11:30:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3646", "1222", "action complete via WP Cron", "2026-01-06 16:30:19", "2026-01-06 11:30:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3647", "1226", "action created", "2026-01-06 16:30:19", "2026-01-06 11:30:19");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3648", "1224", "action started via WP Cron", "2026-01-07 22:06:09", "2026-01-07 17:06:09");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3649", "1224", "action complete via WP Cron", "2026-01-07 22:06:09", "2026-01-07 17:06:09");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3650", "1227", "action created", "2026-01-07 22:06:09", "2026-01-07 17:06:09");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3651", "1225", "action started via WP Cron", "2026-01-07 22:06:09", "2026-01-07 17:06:09");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3652", "1225", "action complete via WP Cron", "2026-01-07 22:06:09", "2026-01-07 17:06:09");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3653", "1228", "action created", "2026-01-07 22:06:09", "2026-01-07 17:06:09");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3654", "1226", "action started via WP Cron", "2026-01-07 22:06:09", "2026-01-07 17:06:09");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3655", "1226", "action complete via WP Cron", "2026-01-07 22:06:09", "2026-01-07 17:06:09");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3656", "1229", "action created", "2026-01-07 22:06:09", "2026-01-07 17:06:09");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3657", "1223", "action started via WP Cron", "2026-01-07 22:06:09", "2026-01-07 17:06:09");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3658", "1223", "action complete via WP Cron", "2026-01-07 22:06:09", "2026-01-07 17:06:09");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3659", "1230", "action created", "2026-01-07 22:06:09", "2026-01-07 17:06:09");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3660", "1227", "action started via WP Cron", "2026-01-08 22:14:55", "2026-01-08 17:14:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3661", "1227", "action complete via WP Cron", "2026-01-08 22:14:55", "2026-01-08 17:14:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3662", "1231", "action created", "2026-01-08 22:14:55", "2026-01-08 17:14:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3663", "1228", "action started via WP Cron", "2026-01-08 22:14:55", "2026-01-08 17:14:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3664", "1228", "action complete via WP Cron", "2026-01-08 22:14:55", "2026-01-08 17:14:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3665", "1232", "action created", "2026-01-08 22:14:55", "2026-01-08 17:14:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3666", "1229", "action started via WP Cron", "2026-01-08 22:14:55", "2026-01-08 17:14:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3667", "1229", "action complete via WP Cron", "2026-01-08 22:14:55", "2026-01-08 17:14:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3668", "1233", "action created", "2026-01-08 22:14:55", "2026-01-08 17:14:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3669", "1230", "action started via WP Cron", "2026-01-08 22:14:55", "2026-01-08 17:14:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3670", "1230", "action complete via WP Cron", "2026-01-08 22:14:55", "2026-01-08 17:14:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3671", "1234", "action created", "2026-01-08 22:14:55", "2026-01-08 17:14:55");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3672", "1231", "action started via WP Cron", "2026-01-09 22:25:20", "2026-01-09 17:25:20");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3673", "1231", "action complete via WP Cron", "2026-01-09 22:25:20", "2026-01-09 17:25:20");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3674", "1235", "action created", "2026-01-09 22:25:20", "2026-01-09 17:25:20");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3675", "1232", "action started via WP Cron", "2026-01-09 22:25:20", "2026-01-09 17:25:20");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3676", "1232", "action complete via WP Cron", "2026-01-09 22:25:20", "2026-01-09 17:25:20");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3677", "1236", "action created", "2026-01-09 22:25:20", "2026-01-09 17:25:20");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3678", "1233", "action started via WP Cron", "2026-01-09 22:25:20", "2026-01-09 17:25:20");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3679", "1233", "action complete via WP Cron", "2026-01-09 22:25:20", "2026-01-09 17:25:20");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3680", "1237", "action created", "2026-01-09 22:25:20", "2026-01-09 17:25:20");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3681", "1234", "action started via WP Cron", "2026-01-09 22:25:20", "2026-01-09 17:25:20");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3682", "1234", "action complete via WP Cron", "2026-01-09 22:25:20", "2026-01-09 17:25:20");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3683", "1238", "action created", "2026-01-09 22:25:20", "2026-01-09 17:25:20");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3684", "1210", "action started via WP Cron", "2026-01-10 12:10:54", "2026-01-10 07:10:54");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3685", "1210", "action complete via WP Cron", "2026-01-10 12:10:54", "2026-01-10 07:10:54");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3686", "1239", "action created", "2026-01-10 12:10:54", "2026-01-10 07:10:54");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3687", "1235", "action started via WP Cron", "2026-01-10 22:49:28", "2026-01-10 17:49:28");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3688", "1235", "action complete via WP Cron", "2026-01-10 22:49:28", "2026-01-10 17:49:28");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3689", "1240", "action created", "2026-01-10 22:49:28", "2026-01-10 17:49:28");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3690", "1236", "action started via WP Cron", "2026-01-10 22:49:28", "2026-01-10 17:49:28");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3691", "1236", "action complete via WP Cron", "2026-01-10 22:49:28", "2026-01-10 17:49:28");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3692", "1241", "action created", "2026-01-10 22:49:28", "2026-01-10 17:49:28");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3693", "1237", "action started via WP Cron", "2026-01-10 22:49:28", "2026-01-10 17:49:28");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3694", "1237", "action complete via WP Cron", "2026-01-10 22:49:28", "2026-01-10 17:49:28");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3695", "1242", "action created", "2026-01-10 22:49:28", "2026-01-10 17:49:28");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3696", "1238", "action started via WP Cron", "2026-01-10 22:49:28", "2026-01-10 17:49:28");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3697", "1238", "action complete via WP Cron", "2026-01-10 22:49:28", "2026-01-10 17:49:28");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3698", "1243", "action created", "2026-01-10 22:49:28", "2026-01-10 17:49:28");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3699", "1240", "action started via WP Cron", "2026-01-11 22:58:29", "2026-01-11 17:58:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3700", "1240", "action complete via WP Cron", "2026-01-11 22:58:29", "2026-01-11 17:58:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3701", "1244", "action created", "2026-01-11 22:58:29", "2026-01-11 17:58:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3702", "1241", "action started via WP Cron", "2026-01-11 22:58:29", "2026-01-11 17:58:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3703", "1241", "action complete via WP Cron", "2026-01-11 22:58:29", "2026-01-11 17:58:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3704", "1245", "action created", "2026-01-11 22:58:29", "2026-01-11 17:58:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3705", "1242", "action started via WP Cron", "2026-01-11 22:58:29", "2026-01-11 17:58:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3706", "1242", "action complete via WP Cron", "2026-01-11 22:58:29", "2026-01-11 17:58:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3707", "1246", "action created", "2026-01-11 22:58:29", "2026-01-11 17:58:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3708", "1243", "action started via WP Cron", "2026-01-11 22:58:29", "2026-01-11 17:58:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3709", "1243", "action complete via WP Cron", "2026-01-11 22:58:29", "2026-01-11 17:58:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3710", "1247", "action created", "2026-01-11 22:58:29", "2026-01-11 17:58:29");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3711", "1244", "action started via WP Cron", "2026-01-12 23:13:18", "2026-01-12 18:13:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3712", "1244", "action complete via WP Cron", "2026-01-12 23:13:18", "2026-01-12 18:13:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3713", "1248", "action created", "2026-01-12 23:13:18", "2026-01-12 18:13:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3714", "1245", "action started via WP Cron", "2026-01-12 23:13:18", "2026-01-12 18:13:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3715", "1245", "action complete via WP Cron", "2026-01-12 23:13:18", "2026-01-12 18:13:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3716", "1249", "action created", "2026-01-12 23:13:18", "2026-01-12 18:13:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3717", "1246", "action started via WP Cron", "2026-01-12 23:13:18", "2026-01-12 18:13:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3718", "1246", "action complete via WP Cron", "2026-01-12 23:13:18", "2026-01-12 18:13:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3719", "1250", "action created", "2026-01-12 23:13:18", "2026-01-12 18:13:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3720", "1247", "action started via WP Cron", "2026-01-12 23:13:18", "2026-01-12 18:13:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3721", "1247", "action complete via WP Cron", "2026-01-12 23:13:18", "2026-01-12 18:13:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3722", "1251", "action created", "2026-01-12 23:13:18", "2026-01-12 18:13:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3723", "1248", "action started via WP Cron", "2026-01-13 23:27:33", "2026-01-13 18:27:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3724", "1248", "action complete via WP Cron", "2026-01-13 23:27:33", "2026-01-13 18:27:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3725", "1252", "action created", "2026-01-13 23:27:33", "2026-01-13 18:27:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3726", "1249", "action started via WP Cron", "2026-01-13 23:27:33", "2026-01-13 18:27:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3727", "1249", "action complete via WP Cron", "2026-01-13 23:27:33", "2026-01-13 18:27:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3728", "1253", "action created", "2026-01-13 23:27:33", "2026-01-13 18:27:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3729", "1250", "action started via WP Cron", "2026-01-13 23:27:33", "2026-01-13 18:27:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3730", "1250", "action complete via WP Cron", "2026-01-13 23:27:33", "2026-01-13 18:27:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3731", "1254", "action created", "2026-01-13 23:27:33", "2026-01-13 18:27:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3732", "1251", "action started via WP Cron", "2026-01-13 23:27:33", "2026-01-13 18:27:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3733", "1251", "action complete via WP Cron", "2026-01-13 23:27:33", "2026-01-13 18:27:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3734", "1255", "action created", "2026-01-13 23:27:33", "2026-01-13 18:27:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3735", "1252", "action started via WP Cron", "2026-01-14 23:28:35", "2026-01-14 18:28:35");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3736", "1252", "action complete via WP Cron", "2026-01-14 23:28:35", "2026-01-14 18:28:35");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3737", "1256", "action created", "2026-01-14 23:28:35", "2026-01-14 18:28:35");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3738", "1253", "action started via WP Cron", "2026-01-14 23:28:35", "2026-01-14 18:28:35");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3739", "1253", "action complete via WP Cron", "2026-01-14 23:28:35", "2026-01-14 18:28:35");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3740", "1257", "action created", "2026-01-14 23:28:35", "2026-01-14 18:28:35");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3741", "1254", "action started via WP Cron", "2026-01-14 23:28:35", "2026-01-14 18:28:35");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3742", "1254", "action complete via WP Cron", "2026-01-14 23:28:35", "2026-01-14 18:28:35");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3743", "1258", "action created", "2026-01-14 23:28:35", "2026-01-14 18:28:35");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3744", "1255", "action started via WP Cron", "2026-01-14 23:28:35", "2026-01-14 18:28:35");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3745", "1255", "action complete via WP Cron", "2026-01-14 23:28:35", "2026-01-14 18:28:35");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3746", "1259", "action created", "2026-01-14 23:28:35", "2026-01-14 18:28:35");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3747", "1256", "action started via WP Cron", "2026-01-15 23:44:14", "2026-01-15 18:44:14");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3748", "1256", "action complete via WP Cron", "2026-01-15 23:44:14", "2026-01-15 18:44:14");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3749", "1260", "action created", "2026-01-15 23:44:14", "2026-01-15 18:44:14");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3750", "1257", "action started via WP Cron", "2026-01-15 23:44:14", "2026-01-15 18:44:14");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3751", "1257", "action complete via WP Cron", "2026-01-15 23:44:14", "2026-01-15 18:44:14");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3752", "1261", "action created", "2026-01-15 23:44:14", "2026-01-15 18:44:14");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3753", "1258", "action started via WP Cron", "2026-01-15 23:44:14", "2026-01-15 18:44:14");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3754", "1258", "action complete via WP Cron", "2026-01-15 23:44:14", "2026-01-15 18:44:14");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3755", "1262", "action created", "2026-01-15 23:44:14", "2026-01-15 18:44:14");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3756", "1259", "action started via WP Cron", "2026-01-15 23:44:14", "2026-01-15 18:44:14");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3757", "1259", "action complete via WP Cron", "2026-01-15 23:44:14", "2026-01-15 18:44:14");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3758", "1263", "action created", "2026-01-15 23:44:14", "2026-01-15 18:44:14");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3759", "1260", "action started via WP Cron", "2026-01-17 01:16:18", "2026-01-16 20:16:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3760", "1260", "action complete via WP Cron", "2026-01-17 01:16:18", "2026-01-16 20:16:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3761", "1264", "action created", "2026-01-17 01:16:18", "2026-01-16 20:16:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3762", "1261", "action started via WP Cron", "2026-01-17 01:16:18", "2026-01-16 20:16:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3763", "1261", "action complete via WP Cron", "2026-01-17 01:16:18", "2026-01-16 20:16:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3764", "1265", "action created", "2026-01-17 01:16:18", "2026-01-16 20:16:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3765", "1262", "action started via WP Cron", "2026-01-17 01:16:18", "2026-01-16 20:16:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3766", "1262", "action complete via WP Cron", "2026-01-17 01:16:18", "2026-01-16 20:16:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3767", "1266", "action created", "2026-01-17 01:16:18", "2026-01-16 20:16:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3768", "1263", "action started via WP Cron", "2026-01-17 01:16:18", "2026-01-16 20:16:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3769", "1263", "action complete via WP Cron", "2026-01-17 01:16:18", "2026-01-16 20:16:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3770", "1267", "action created", "2026-01-17 01:16:18", "2026-01-16 20:16:18");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3771", "1239", "action started via WP Cron", "2026-01-17 12:47:11", "2026-01-17 07:47:11");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3772", "1239", "action complete via WP Cron", "2026-01-17 12:47:11", "2026-01-17 07:47:11");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3773", "1268", "action created", "2026-01-17 12:47:11", "2026-01-17 07:47:11");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3774", "1264", "action started via WP Cron", "2026-01-18 01:28:02", "2026-01-17 20:28:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3775", "1264", "action complete via WP Cron", "2026-01-18 01:28:02", "2026-01-17 20:28:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3776", "1269", "action created", "2026-01-18 01:28:02", "2026-01-17 20:28:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3777", "1265", "action started via WP Cron", "2026-01-18 01:28:02", "2026-01-17 20:28:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3778", "1265", "action complete via WP Cron", "2026-01-18 01:28:02", "2026-01-17 20:28:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3779", "1270", "action created", "2026-01-18 01:28:02", "2026-01-17 20:28:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3780", "1266", "action started via WP Cron", "2026-01-18 01:28:02", "2026-01-17 20:28:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3781", "1266", "action complete via WP Cron", "2026-01-18 01:28:02", "2026-01-17 20:28:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3782", "1271", "action created", "2026-01-18 01:28:02", "2026-01-17 20:28:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3783", "1267", "action started via WP Cron", "2026-01-18 01:28:02", "2026-01-17 20:28:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3784", "1267", "action complete via WP Cron", "2026-01-18 01:28:02", "2026-01-17 20:28:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3785", "1272", "action created", "2026-01-18 01:28:02", "2026-01-17 20:28:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3786", "1269", "action started via WP Cron", "2026-01-19 01:31:02", "2026-01-18 20:31:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3787", "1269", "action complete via WP Cron", "2026-01-19 01:31:02", "2026-01-18 20:31:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3788", "1273", "action created", "2026-01-19 01:31:02", "2026-01-18 20:31:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3789", "1270", "action started via WP Cron", "2026-01-19 01:31:02", "2026-01-18 20:31:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3790", "1270", "action complete via WP Cron", "2026-01-19 01:31:02", "2026-01-18 20:31:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3791", "1274", "action created", "2026-01-19 01:31:02", "2026-01-18 20:31:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3792", "1271", "action started via WP Cron", "2026-01-19 01:31:02", "2026-01-18 20:31:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3793", "1271", "action complete via WP Cron", "2026-01-19 01:31:02", "2026-01-18 20:31:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3794", "1275", "action created", "2026-01-19 01:31:02", "2026-01-18 20:31:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3795", "1272", "action started via WP Cron", "2026-01-19 01:31:02", "2026-01-18 20:31:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3796", "1272", "action complete via WP Cron", "2026-01-19 01:31:02", "2026-01-18 20:31:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3797", "1276", "action created", "2026-01-19 01:31:02", "2026-01-18 20:31:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3798", "1273", "action started via WP Cron", "2026-01-20 01:51:41", "2026-01-19 20:51:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3799", "1273", "action complete via WP Cron", "2026-01-20 01:51:41", "2026-01-19 20:51:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3800", "1277", "action created", "2026-01-20 01:51:41", "2026-01-19 20:51:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3801", "1274", "action started via WP Cron", "2026-01-20 01:51:41", "2026-01-19 20:51:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3802", "1274", "action complete via WP Cron", "2026-01-20 01:51:41", "2026-01-19 20:51:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3803", "1278", "action created", "2026-01-20 01:51:41", "2026-01-19 20:51:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3804", "1275", "action started via WP Cron", "2026-01-20 01:51:41", "2026-01-19 20:51:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3805", "1275", "action complete via WP Cron", "2026-01-20 01:51:41", "2026-01-19 20:51:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3806", "1279", "action created", "2026-01-20 01:51:41", "2026-01-19 20:51:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3807", "1276", "action started via WP Cron", "2026-01-20 01:51:41", "2026-01-19 20:51:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3808", "1276", "action complete via WP Cron", "2026-01-20 01:51:41", "2026-01-19 20:51:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3809", "1280", "action created", "2026-01-20 01:51:41", "2026-01-19 20:51:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3810", "1277", "action started via WP Cron", "2026-01-21 02:00:50", "2026-01-20 21:00:50");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3811", "1277", "action complete via WP Cron", "2026-01-21 02:00:50", "2026-01-20 21:00:50");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3812", "1281", "action created", "2026-01-21 02:00:50", "2026-01-20 21:00:50");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3813", "1278", "action started via WP Cron", "2026-01-21 02:00:50", "2026-01-20 21:00:50");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3814", "1278", "action complete via WP Cron", "2026-01-21 02:00:50", "2026-01-20 21:00:50");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3815", "1282", "action created", "2026-01-21 02:00:50", "2026-01-20 21:00:50");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3816", "1279", "action started via WP Cron", "2026-01-21 02:00:50", "2026-01-20 21:00:50");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3817", "1279", "action complete via WP Cron", "2026-01-21 02:00:50", "2026-01-20 21:00:50");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3818", "1283", "action created", "2026-01-21 02:00:50", "2026-01-20 21:00:50");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3819", "1280", "action started via WP Cron", "2026-01-21 02:00:50", "2026-01-20 21:00:50");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3820", "1280", "action complete via WP Cron", "2026-01-21 02:00:50", "2026-01-20 21:00:50");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3821", "1284", "action created", "2026-01-21 02:00:50", "2026-01-20 21:00:50");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3822", "1281", "action started via WP Cron", "2026-01-22 02:19:41", "2026-01-21 21:19:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3823", "1281", "action complete via WP Cron", "2026-01-22 02:19:41", "2026-01-21 21:19:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3824", "1285", "action created", "2026-01-22 02:19:41", "2026-01-21 21:19:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3825", "1282", "action started via WP Cron", "2026-01-22 02:19:41", "2026-01-21 21:19:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3826", "1282", "action complete via WP Cron", "2026-01-22 02:19:41", "2026-01-21 21:19:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3827", "1286", "action created", "2026-01-22 02:19:41", "2026-01-21 21:19:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3828", "1283", "action started via WP Cron", "2026-01-22 02:19:41", "2026-01-21 21:19:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3829", "1283", "action complete via WP Cron", "2026-01-22 02:19:41", "2026-01-21 21:19:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3830", "1287", "action created", "2026-01-22 02:19:41", "2026-01-21 21:19:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3831", "1284", "action started via WP Cron", "2026-01-22 02:19:41", "2026-01-21 21:19:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3832", "1284", "action complete via WP Cron", "2026-01-22 02:19:41", "2026-01-21 21:19:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3833", "1288", "action created", "2026-01-22 02:19:41", "2026-01-21 21:19:41");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3834", "1289", "action created", "2026-01-22 11:52:02", "2026-01-22 06:52:02");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3835", "1289", "action started via WP Cron", "2026-01-22 11:54:33", "2026-01-22 06:54:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3836", "1289", "action complete via WP Cron", "2026-01-22 11:54:33", "2026-01-22 06:54:33");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3837", "1290", "action created", "2026-01-22 11:54:52", "2026-01-22 06:54:52");
INSERT INTO `j3nd_actionscheduler_logs` VALUES("3838", "1291", "action created", "2026-01-22 11:54:52", "2026-01-22 06:54:52");

/* INSERT TABLE DATA: j3nd_comments */
INSERT INTO `j3nd_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2025-01-30 03:37:54", "2025-01-30 03:37:54", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("2", "1", "Free Premium WordPress Themes &amp; Plugins Nulled", "info@t.me", "https://sigmaweb.online/Telegram", "41.248.108.70", "2025-01-30 12:24:45", "2025-01-30 17:24:45", "<a href=\"https://sigmaweb.online/Telegram\" rel=\"nofollow ugc\">🚀 Attention WordPress admins! Join our Telegram group for free premium themes and plugins nulled with the latest updates. Stay ahead with free exclusive tools for your website! 👉 https://t.me/+CH-Dy6wxFaszM2E8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("3", "1", "Ayoub Aouid (Sigmaweb.online)", "info@sigmaweb.online", "https://sigmaweb.online/Fiverr", "196.206.105.245", "2025-03-03 22:40:13", "2025-03-04 03:40:13", "<a href=\"https://sigmaweb.online/Fiverr\" rel=\"nofollow ugc\">Unlock the Potential of Your Online Presence!\r\n\r\nHave you purchased a domain and hosting but haven\'t found the time or resources to create your website? You\'re not alone! Many people face challenges when it comes to turning their ideas into a functional, attractive, and effective online presence.\r\n\r\n*That\'s where I come in! As a web development specialist, I help individuals and businesses like you to:\r\n-Bring your website vision to life\r\n-Overcome technical hurdles\r\n-Ensure your site is responsive, SEO-optimized, and fast\r\n-Attract more clients and grow your online presence\r\n\r\nDon\'t let your investment go to waste. Let\'s work together to create a stunning website that meets your needs and goals. Contact me today to get started!</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("4", "556", "Lynn4424", "Lynn4424@gmail.com", "", "70.50.135.226", "2025-04-14 21:51:57", "2025-04-15 02:51:57", "<a href=\"https://mazda-demio.ru/forums/index.php?autocom=gallery&amp;req=si&amp;img=6335\" rel=\"nofollow ugc\">https://mazda-demio.ru/forums/index.php?autocom=gallery&amp;req=si&amp;img=6335</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("5", "556", "Samantha4206", "Samantha4206@gmail.com", "", "186.28.213.212", "2025-04-21 22:26:57", "2025-04-22 03:26:57", "Very good <a href=\"https://is.gd/tpjNyL\" rel=\"nofollow ugc\">https://is.gd/tpjNyL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("6", "556", "Roland4899", "Roland4899@gmail.com", "", "70.81.241.16", "2025-04-22 11:28:22", "2025-04-22 16:28:22", "Very good <a href=\"https://is.gd/tpjNyL\" rel=\"nofollow ugc\">https://is.gd/tpjNyL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("7", "556", "Nevaeh418", "Nevaeh418@gmail.com", "", "70.226.100.178", "2025-04-22 14:32:16", "2025-04-22 19:32:16", "Awesome <a href=\"https://is.gd/tpjNyL\" rel=\"nofollow ugc\">https://is.gd/tpjNyL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("8", "556", "Jennifer454", "Jennifer454@gmail.com", "", "113.179.169.145", "2025-04-22 21:26:36", "2025-04-23 02:26:36", "Very good <a href=\"https://is.gd/tpjNyL\" rel=\"nofollow ugc\">https://is.gd/tpjNyL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("9", "556", "Cindy2322", "Cindy2322@gmail.com", "", "116.101.218.162", "2025-04-22 23:49:40", "2025-04-23 04:49:40", "Awesome <a href=\"https://is.gd/tpjNyL\" rel=\"nofollow ugc\">https://is.gd/tpjNyL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("10", "556", "Marissa4839", "Marissa4839@gmail.com", "", "200.92.235.223", "2025-04-23 00:38:32", "2025-04-23 05:38:32", "Very good <a href=\"https://is.gd/tpjNyL\" rel=\"nofollow ugc\">https://is.gd/tpjNyL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("11", "556", "Paul1451", "Paul1451@gmail.com", "", "190.210.251.53", "2025-04-23 08:14:35", "2025-04-23 13:14:35", "Very good <a href=\"https://shorturl.at/2breu\" rel=\"nofollow ugc\">https://shorturl.at/2breu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("12", "556", "Mackenzie1498", "Mackenzie1498@gmail.com", "", "116.101.219.101", "2025-04-23 11:00:26", "2025-04-23 16:00:26", "Awesome <a href=\"https://shorturl.at/2breu\" rel=\"nofollow ugc\">https://shorturl.at/2breu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("13", "556", "Enrique4861", "Enrique4861@gmail.com", "", "136.158.78.119", "2025-04-23 19:24:02", "2025-04-24 00:24:02", "Very good <a href=\"https://shorturl.at/2breu\" rel=\"nofollow ugc\">https://shorturl.at/2breu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("14", "556", "Lila713", "Lila713@gmail.com", "", "38.43.254.188", "2025-04-24 18:03:02", "2025-04-24 23:03:02", "Good <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("15", "551", "Linda682", "Linda682@gmail.com", "", "200.33.206.196", "2025-04-24 18:03:03", "2025-04-24 23:03:03", "Awesome <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("16", "556", "Lola2532", "Lola2532@gmail.com", "", "103.180.240.197", "2025-04-25 00:24:28", "2025-04-25 05:24:28", "Awesome <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("17", "556", "Eddie3239", "Eddie3239@gmail.com", "", "172.236.35.55", "2025-04-25 10:53:22", "2025-04-25 15:53:22", "Good <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("18", "551", "Bryant2368", "Bryant2368@gmail.com", "", "194.233.73.204", "2025-04-25 10:53:27", "2025-04-25 15:53:27", "Good <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("19", "531", "Marcus4330", "Marcus4330@gmail.com", "", "124.217.246.155", "2025-04-25 10:53:30", "2025-04-25 15:53:30", "Awesome <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("20", "1", "Drew414", "Drew414@gmail.com", "", "36.227.232.155", "2025-04-25 10:53:33", "2025-04-25 15:53:33", "Very good <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("21", "556", "Sarah3393", "Sarah3393@gmail.com", "", "181.94.81.36", "2025-04-25 16:34:30", "2025-04-25 21:34:30", "Awesome <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("22", "556", "Cynthia1624", "Cynthia1624@gmail.com", "", "58.136.168.223", "2025-04-25 19:16:59", "2025-04-26 00:16:59", "Very good <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("23", "556", "Jenny3687", "Jenny3687@gmail.com", "", "79.101.46.167", "2025-04-26 04:29:28", "2025-04-26 09:29:28", "Awesome <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("24", "556", "Kara2656", "Kara2656@gmail.com", "", "152.32.99.142", "2025-04-26 10:32:09", "2025-04-26 15:32:09", "Good <a href=\"https://t.ly/tndaA\" rel=\"nofollow ugc\">https://t.ly/tndaA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("25", "556", "Lynda4386", "Lynda4386@gmail.com", "", "124.123.191.157", "2025-04-27 05:12:17", "2025-04-27 10:12:17", "Awesome <a href=\"https://t.ly/tndaA\" rel=\"nofollow ugc\">https://t.ly/tndaA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("26", "556", "Mila364", "Mila364@gmail.com", "", "222.109.155.153", "2025-04-27 12:26:49", "2025-04-27 17:26:49", "Awesome <a href=\"https://urlr.me/zH3wE5\" rel=\"nofollow ugc\">https://urlr.me/zH3wE5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("27", "556", "Wesley3715", "Wesley3715@gmail.com", "", "110.14.191.124", "2025-04-28 07:07:27", "2025-04-28 12:07:27", "Good <a href=\"https://rb.gy/4gq2o4\" rel=\"nofollow ugc\">https://rb.gy/4gq2o4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("28", "556", "Ronald4028", "Ronald4028@gmail.com", "", "181.65.0.105", "2025-04-28 11:03:18", "2025-04-28 16:03:18", "Good <a href=\"https://rb.gy/4gq2o4\" rel=\"nofollow ugc\">https://rb.gy/4gq2o4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("29", "556", "Dylan184", "Dylan184@gmail.com", "", "179.6.17.167", "2025-04-28 13:08:22", "2025-04-28 18:08:22", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("30", "556", "Daniella2433", "Daniella2433@gmail.com", "", "103.227.24.153", "2025-04-28 20:00:48", "2025-04-29 01:00:48", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("31", "556", "Israel1072", "Israel1072@gmail.com", "", "167.86.135.97", "2025-04-29 04:53:24", "2025-04-29 09:53:24", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("32", "556", "Donna1764", "Donna1764@gmail.com", "", "113.211.214.64", "2025-04-29 05:20:47", "2025-04-29 10:20:47", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("33", "556", "Theresa2516", "Theresa2516@gmail.com", "", "1.52.155.166", "2025-04-29 07:02:39", "2025-04-29 12:02:39", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("34", "1", "Jacqueline3460", "Jacqueline3460@gmail.com", "", "1.52.155.166", "2025-04-29 07:02:55", "2025-04-29 12:02:55", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("35", "556", "Ronald3704", "Ronald3704@gmail.com", "", "98.46.29.186", "2025-04-29 11:28:48", "2025-04-29 16:28:48", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("36", "531", "Chris4766", "Chris4766@gmail.com", "", "98.46.29.186", "2025-04-29 11:29:07", "2025-04-29 16:29:07", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("37", "556", "Kiera2491", "Kiera2491@gmail.com", "", "123.50.123.49", "2025-04-29 14:58:57", "2025-04-29 19:58:57", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("38", "556", "Aubree3245", "Aubree3245@gmail.com", "", "49.150.194.167", "2025-04-29 19:46:45", "2025-04-30 00:46:45", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("39", "556", "Marvin3897", "Marvin3897@gmail.com", "", "177.222.113.201", "2025-04-29 20:25:04", "2025-04-30 01:25:04", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("40", "556", "Agnes74", "Agnes74@gmail.com", "", "14.170.35.142", "2025-04-29 21:31:10", "2025-04-30 02:31:10", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("41", "556", "Darwin3875", "Darwin3875@gmail.com", "", "43.153.18.174", "2025-04-30 00:22:09", "2025-04-30 05:22:09", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("42", "556", "Daphne4880", "Daphne4880@gmail.com", "", "115.134.210.5", "2025-04-30 01:15:49", "2025-04-30 06:15:49", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("43", "556", "Luke211", "Luke211@gmail.com", "", "85.105.233.98", "2025-04-30 03:19:48", "2025-04-30 08:19:48", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("44", "556", "Connie3111", "Connie3111@gmail.com", "", "38.253.80.173", "2025-04-30 04:25:17", "2025-04-30 09:25:17", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("45", "556", "Jed3336", "Jed3336@gmail.com", "", "171.4.235.217", "2025-04-30 04:32:03", "2025-04-30 09:32:03", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("46", "556", "Melanie2638", "Melanie2638@gmail.com", "", "149.113.70.36", "2025-04-30 07:53:16", "2025-04-30 12:53:16", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("47", "1", "Trinity1805", "Trinity1805@gmail.com", "", "149.113.70.36", "2025-04-30 07:53:33", "2025-04-30 12:53:33", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("48", "556", "Hailey2427", "Hailey2427@gmail.com", "", "126.29.244.23", "2025-04-30 08:12:03", "2025-04-30 13:12:03", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("49", "1", "Bianca193", "Bianca193@gmail.com", "", "126.29.244.23", "2025-04-30 08:12:22", "2025-04-30 13:12:22", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("50", "556", "Finn797", "Finn797@gmail.com", "", "38.183.8.155", "2025-04-30 11:56:46", "2025-04-30 16:56:46", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("51", "556", "Nora117", "Nora117@gmail.com", "", "179.14.5.36", "2025-04-30 12:33:15", "2025-04-30 17:33:15", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("52", "556", "Brenda2966", "Brenda2966@gmail.com", "", "171.250.17.122", "2025-04-30 12:34:12", "2025-04-30 17:34:12", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("53", "556", "Melissa450", "Melissa450@gmail.com", "", "163.120.63.194", "2025-04-30 13:29:34", "2025-04-30 18:29:34", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("54", "556", "Isaiah4024", "Isaiah4024@gmail.com", "", "200.100.43.187", "2025-04-30 14:51:36", "2025-04-30 19:51:36", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("55", "556", "Lilian4500", "Lilian4500@gmail.com", "", "186.96.148.115", "2025-04-30 15:30:36", "2025-04-30 20:30:36", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("56", "556", "Juan2207", "Juan2207@gmail.com", "", "49.37.219.254", "2025-04-30 15:44:16", "2025-04-30 20:44:16", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("57", "556", "Billy3876", "Billy3876@gmail.com", "", "114.41.212.134", "2025-04-30 16:19:26", "2025-04-30 21:19:26", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("58", "556", "Harmony3263", "Harmony3263@gmail.com", "", "212.33.205.55", "2025-04-30 22:08:32", "2025-05-01 03:08:32", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("59", "556", "Atticus929", "Atticus929@gmail.com", "", "116.102.104.114", "2025-04-30 22:51:27", "2025-05-01 03:51:27", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("60", "556", "Guillermo265", "Guillermo265@gmail.com", "", "125.87.81.223", "2025-05-01 03:12:20", "2025-05-01 08:12:20", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("61", "556", "Hugo1550", "Hugo1550@gmail.com", "", "182.53.22.189", "2025-05-01 03:14:40", "2025-05-01 08:14:40", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("62", "556", "Lola4119", "Lola4119@gmail.com", "", "120.29.89.117", "2025-05-01 06:25:26", "2025-05-01 11:25:26", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("63", "556", "Teagan4509", "Teagan4509@gmail.com", "", "174.93.132.44", "2025-05-01 07:44:44", "2025-05-01 12:44:44", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("64", "551", "Natasha4664", "Natasha4664@gmail.com", "", "49.43.33.155", "2025-05-23 11:46:56", "2025-05-23 16:46:56", "Best partnership <a href=\"https://shorturl.fm/A5ni8\" rel=\"nofollow ugc\">https://shorturl.fm/A5ni8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("65", "1", "Carson4396", "Carson4396@gmail.com", "", "49.43.33.155", "2025-05-23 11:47:14", "2025-05-23 16:47:14", "Very good partnership <a href=\"https://shorturl.fm/9fnIC\" rel=\"nofollow ugc\">https://shorturl.fm/9fnIC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("66", "556", "Alejandra2080", "Alejandra2080@gmail.com", "", "42.191.125.195", "2025-05-23 11:55:40", "2025-05-23 16:55:40", "Top <a href=\"https://shorturl.fm/YvSxU\" rel=\"nofollow ugc\">https://shorturl.fm/YvSxU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("67", "1", "Margaret2178", "Margaret2178@gmail.com", "", "42.191.125.195", "2025-05-23 11:55:55", "2025-05-23 16:55:55", "Very good partnership <a href=\"https://shorturl.fm/9fnIC\" rel=\"nofollow ugc\">https://shorturl.fm/9fnIC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("68", "556", "Cleo3127", "Cleo3127@gmail.com", "", "191.6.126.115", "2025-05-23 14:15:37", "2025-05-23 19:15:37", "Very good partnership <a href=\"https://shorturl.fm/9fnIC\" rel=\"nofollow ugc\">https://shorturl.fm/9fnIC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("69", "556", "Darren581", "Darren581@gmail.com", "", "190.200.41.87", "2025-05-23 18:53:21", "2025-05-23 23:53:21", "Cool partnership <a href=\"https://shorturl.fm/a0B2m\" rel=\"nofollow ugc\">https://shorturl.fm/a0B2m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("70", "556", "Camryn3330", "Camryn3330@gmail.com", "", "171.38.30.101", "2025-05-23 19:50:04", "2025-05-24 00:50:04", "Awesome <a href=\"https://shorturl.fm/oYjg5\" rel=\"nofollow ugc\">https://shorturl.fm/oYjg5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("71", "556", "Taylor2759", "Taylor2759@gmail.com", "", "27.79.139.108", "2025-05-23 22:00:07", "2025-05-24 03:00:07", "Very good partnership <a href=\"https://shorturl.fm/68Y8V\" rel=\"nofollow ugc\">https://shorturl.fm/68Y8V</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("72", "556", "Carol4180", "Carol4180@gmail.com", "", "42.60.210.237", "2025-05-23 23:01:18", "2025-05-24 04:01:18", "Good partner program <a href=\"https://shorturl.fm/m8ueY\" rel=\"nofollow ugc\">https://shorturl.fm/m8ueY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("73", "556", "Alayna331", "Alayna331@gmail.com", "", "49.228.127.234", "2025-05-24 00:08:30", "2025-05-24 05:08:30", "Very good <a href=\"https://shorturl.fm/bODKa\" rel=\"nofollow ugc\">https://shorturl.fm/bODKa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("74", "556", "Pedro2988", "Pedro2988@gmail.com", "", "103.176.70.37", "2025-05-24 01:54:20", "2025-05-24 06:54:20", "Good partner program <a href=\"https://shorturl.fm/N6nl1\" rel=\"nofollow ugc\">https://shorturl.fm/N6nl1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("75", "556", "Abbie2187", "Abbie2187@gmail.com", "", "81.70.56.134", "2025-05-24 06:14:36", "2025-05-24 11:14:36", "Awesome <a href=\"https://shorturl.fm/5JO3e\" rel=\"nofollow ugc\">https://shorturl.fm/5JO3e</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("76", "556", "Alondra210", "Alondra210@gmail.com", "", "112.208.184.153", "2025-05-24 07:04:03", "2025-05-24 12:04:03", "Cool partnership <a href=\"https://shorturl.fm/FIJkD\" rel=\"nofollow ugc\">https://shorturl.fm/FIJkD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("77", "556", "Randall445", "Randall445@gmail.com", "", "115.74.11.212", "2025-05-24 09:13:56", "2025-05-24 14:13:56", "Very good <a href=\"https://shorturl.fm/bODKa\" rel=\"nofollow ugc\">https://shorturl.fm/bODKa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("78", "556", "Cheryl4313", "Cheryl4313@gmail.com", "", "170.247.123.143", "2025-05-24 10:03:52", "2025-05-24 15:03:52", "Get your bonus — sign up as an affiliate today! <a href=\"https://shorturl.fm/a0B2m\" rel=\"nofollow ugc\">https://shorturl.fm/a0B2m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("79", "556", "Sheila3424", "Sheila3424@gmail.com", "", "142.118.146.40", "2025-05-24 20:36:31", "2025-05-25 01:36:31", "<a href=\"https://shorturl.fm/N6nl1\" rel=\"nofollow ugc\">https://shorturl.fm/N6nl1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("80", "551", "Clint1457", "Clint1457@gmail.com", "", "142.118.146.40", "2025-05-24 20:37:03", "2025-05-25 01:37:03", "<a href=\"https://shorturl.fm/j3kEj\" rel=\"nofollow ugc\">https://shorturl.fm/j3kEj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("81", "531", "Eden2978", "Eden2978@gmail.com", "", "142.118.146.40", "2025-05-24 20:37:31", "2025-05-25 01:37:31", "<a href=\"https://shorturl.fm/XIZGD\" rel=\"nofollow ugc\">https://shorturl.fm/XIZGD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("82", "1", "Leia1629", "Leia1629@gmail.com", "", "142.118.146.40", "2025-05-24 20:38:00", "2025-05-25 01:38:00", "<a href=\"https://shorturl.fm/YvSxU\" rel=\"nofollow ugc\">https://shorturl.fm/YvSxU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("83", "556", "Collin1876", "Collin1876@gmail.com", "", "123.111.72.59", "2025-05-25 04:32:58", "2025-05-25 09:32:58", "<a href=\"https://shorturl.fm/bODKa\" rel=\"nofollow ugc\">https://shorturl.fm/bODKa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("84", "551", "Kathy3813", "Kathy3813@gmail.com", "", "123.111.72.59", "2025-05-25 04:33:27", "2025-05-25 09:33:27", "<a href=\"https://shorturl.fm/bODKa\" rel=\"nofollow ugc\">https://shorturl.fm/bODKa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("85", "531", "Mason3564", "Mason3564@gmail.com", "", "123.111.72.59", "2025-05-25 04:33:54", "2025-05-25 09:33:54", "<a href=\"https://shorturl.fm/68Y8V\" rel=\"nofollow ugc\">https://shorturl.fm/68Y8V</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("86", "1", "Russell1565", "Russell1565@gmail.com", "", "123.111.72.59", "2025-05-25 04:34:22", "2025-05-25 09:34:22", "<a href=\"https://shorturl.fm/6539m\" rel=\"nofollow ugc\">https://shorturl.fm/6539m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("87", "556", "Londyn885", "Londyn885@gmail.com", "", "171.7.43.245", "2025-05-25 07:58:42", "2025-05-25 12:58:42", "<a href=\"https://shorturl.fm/N6nl1\" rel=\"nofollow ugc\">https://shorturl.fm/N6nl1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("88", "551", "Ken2655", "Ken2655@gmail.com", "", "171.7.43.245", "2025-05-25 07:59:12", "2025-05-25 12:59:12", "<a href=\"https://shorturl.fm/m8ueY\" rel=\"nofollow ugc\">https://shorturl.fm/m8ueY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("89", "531", "Helena1048", "Helena1048@gmail.com", "", "171.7.43.245", "2025-05-25 07:59:41", "2025-05-25 12:59:41", "<a href=\"https://shorturl.fm/5JO3e\" rel=\"nofollow ugc\">https://shorturl.fm/5JO3e</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("90", "1", "Helena338", "Helena338@gmail.com", "", "171.7.43.245", "2025-05-25 08:00:12", "2025-05-25 13:00:12", "<a href=\"https://shorturl.fm/XIZGD\" rel=\"nofollow ugc\">https://shorturl.fm/XIZGD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("91", "556", "Alivia4620", "Alivia4620@gmail.com", "", "101.109.60.31", "2025-05-25 12:59:59", "2025-05-25 17:59:59", "<a href=\"https://shorturl.fm/FIJkD\" rel=\"nofollow ugc\">https://shorturl.fm/FIJkD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("92", "551", "Bonnie3198", "Bonnie3198@gmail.com", "", "101.109.60.31", "2025-05-25 13:00:29", "2025-05-25 18:00:29", "<a href=\"https://shorturl.fm/m8ueY\" rel=\"nofollow ugc\">https://shorturl.fm/m8ueY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("93", "1", "Alana2588", "Alana2588@gmail.com", "", "101.109.60.31", "2025-05-25 13:01:08", "2025-05-25 18:01:08", "<a href=\"https://shorturl.fm/j3kEj\" rel=\"nofollow ugc\">https://shorturl.fm/j3kEj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("94", "556", "Gabrielle4344", "Gabrielle4344@gmail.com", "", "207.102.235.64", "2025-05-25 14:26:37", "2025-05-25 19:26:37", "<a href=\"https://shorturl.fm/68Y8V\" rel=\"nofollow ugc\">https://shorturl.fm/68Y8V</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("95", "551", "Tina4928", "Tina4928@gmail.com", "", "207.102.235.64", "2025-05-25 14:27:04", "2025-05-25 19:27:04", "<a href=\"https://shorturl.fm/a0B2m\" rel=\"nofollow ugc\">https://shorturl.fm/a0B2m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("96", "531", "Emma4163", "Emma4163@gmail.com", "", "207.102.235.64", "2025-05-25 14:27:33", "2025-05-25 19:27:33", "<a href=\"https://shorturl.fm/FIJkD\" rel=\"nofollow ugc\">https://shorturl.fm/FIJkD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("97", "1", "Alonzo1069", "Alonzo1069@gmail.com", "", "207.102.235.64", "2025-05-25 14:28:00", "2025-05-25 19:28:00", "<a href=\"https://shorturl.fm/TbTre\" rel=\"nofollow ugc\">https://shorturl.fm/TbTre</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("98", "556", "Rodney1003", "Rodney1003@gmail.com", "", "112.135.70.203", "2025-05-26 04:24:13", "2025-05-26 09:24:13", "<a href=\"https://shorturl.fm/FIJkD\" rel=\"nofollow ugc\">https://shorturl.fm/FIJkD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("99", "551", "Ana1029", "Ana1029@gmail.com", "", "112.135.70.203", "2025-05-26 04:24:48", "2025-05-26 09:24:48", "<a href=\"https://shorturl.fm/j3kEj\" rel=\"nofollow ugc\">https://shorturl.fm/j3kEj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("100", "531", "Bradley476", "Bradley476@gmail.com", "", "112.135.70.203", "2025-05-26 04:25:20", "2025-05-26 09:25:20", "<a href=\"https://shorturl.fm/FIJkD\" rel=\"nofollow ugc\">https://shorturl.fm/FIJkD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("101", "1", "Ronald3293", "Ronald3293@gmail.com", "", "112.135.70.203", "2025-05-26 04:25:52", "2025-05-26 09:25:52", "<a href=\"https://shorturl.fm/j3kEj\" rel=\"nofollow ugc\">https://shorturl.fm/j3kEj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("102", "556", "Brooks287", "Brooks287@gmail.com", "", "103.84.5.202", "2025-05-26 12:53:05", "2025-05-26 17:53:05", "<a href=\"https://shorturl.fm/FIJkD\" rel=\"nofollow ugc\">https://shorturl.fm/FIJkD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("103", "551", "Lincoln1717", "Lincoln1717@gmail.com", "", "103.84.5.202", "2025-05-26 12:53:33", "2025-05-26 17:53:33", "<a href=\"https://shorturl.fm/j3kEj\" rel=\"nofollow ugc\">https://shorturl.fm/j3kEj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("104", "531", "Celeste1051", "Celeste1051@gmail.com", "", "103.84.5.202", "2025-05-26 12:54:05", "2025-05-26 17:54:05", "<a href=\"https://shorturl.fm/oYjg5\" rel=\"nofollow ugc\">https://shorturl.fm/oYjg5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("105", "1", "Ramona2664", "Ramona2664@gmail.com", "", "103.84.5.202", "2025-05-26 12:54:37", "2025-05-26 17:54:37", "<a href=\"https://shorturl.fm/bODKa\" rel=\"nofollow ugc\">https://shorturl.fm/bODKa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("106", "556", "Camila4472", "Camila4472@gmail.com", "", "68.183.87.124", "2025-05-26 13:03:49", "2025-05-26 18:03:49", "<a href=\"https://shorturl.fm/bODKa\" rel=\"nofollow ugc\">https://shorturl.fm/bODKa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("107", "551", "Lewis4240", "Lewis4240@gmail.com", "", "68.183.87.124", "2025-05-26 13:04:18", "2025-05-26 18:04:18", "<a href=\"https://shorturl.fm/68Y8V\" rel=\"nofollow ugc\">https://shorturl.fm/68Y8V</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("108", "531", "Dennis3517", "Dennis3517@gmail.com", "", "68.183.87.124", "2025-05-26 13:04:48", "2025-05-26 18:04:48", "<a href=\"https://shorturl.fm/bODKa\" rel=\"nofollow ugc\">https://shorturl.fm/bODKa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("109", "1", "Lauren3030", "Lauren3030@gmail.com", "", "68.183.87.124", "2025-05-26 13:05:17", "2025-05-26 18:05:17", "<a href=\"https://shorturl.fm/N6nl1\" rel=\"nofollow ugc\">https://shorturl.fm/N6nl1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("110", "556", "Bianca61", "Bianca61@gmail.com", "", "99.218.44.109", "2025-05-27 05:33:31", "2025-05-27 10:33:31", "<a href=\"https://shorturl.fm/TbTre\" rel=\"nofollow ugc\">https://shorturl.fm/TbTre</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("111", "551", "Julie368", "Julie368@gmail.com", "", "99.218.44.109", "2025-05-27 05:34:01", "2025-05-27 10:34:01", "<a href=\"https://shorturl.fm/XIZGD\" rel=\"nofollow ugc\">https://shorturl.fm/XIZGD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("112", "531", "Simon789", "Simon789@gmail.com", "", "99.218.44.109", "2025-05-27 05:34:32", "2025-05-27 10:34:32", "<a href=\"https://shorturl.fm/FIJkD\" rel=\"nofollow ugc\">https://shorturl.fm/FIJkD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("113", "1", "Aspen212", "Aspen212@gmail.com", "", "99.218.44.109", "2025-05-27 05:35:02", "2025-05-27 10:35:02", "<a href=\"https://shorturl.fm/9fnIC\" rel=\"nofollow ugc\">https://shorturl.fm/9fnIC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("114", "556", "Alex4934", "Alex4934@gmail.com", "", "143.0.243.78", "2025-05-27 10:43:04", "2025-05-27 15:43:04", "<a href=\"https://shorturl.fm/FIJkD\" rel=\"nofollow ugc\">https://shorturl.fm/FIJkD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("115", "551", "Daphne4866", "Daphne4866@gmail.com", "", "143.0.243.78", "2025-05-27 10:43:34", "2025-05-27 15:43:34", "<a href=\"https://shorturl.fm/68Y8V\" rel=\"nofollow ugc\">https://shorturl.fm/68Y8V</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("116", "531", "Allan4251", "Allan4251@gmail.com", "", "143.0.243.78", "2025-05-27 10:44:04", "2025-05-27 15:44:04", "<a href=\"https://shorturl.fm/6539m\" rel=\"nofollow ugc\">https://shorturl.fm/6539m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("117", "1", "Cornelius4575", "Cornelius4575@gmail.com", "", "143.0.243.78", "2025-05-27 10:44:34", "2025-05-27 15:44:34", "<a href=\"https://shorturl.fm/68Y8V\" rel=\"nofollow ugc\">https://shorturl.fm/68Y8V</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("118", "556", "Doris3305", "Doris3305@gmail.com", "", "49.43.115.90", "2025-05-27 15:00:20", "2025-05-27 20:00:20", "<a href=\"https://shorturl.fm/a0B2m\" rel=\"nofollow ugc\">https://shorturl.fm/a0B2m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("119", "551", "Jorge2416", "Jorge2416@gmail.com", "", "49.43.115.90", "2025-05-27 15:00:55", "2025-05-27 20:00:55", "<a href=\"https://shorturl.fm/6539m\" rel=\"nofollow ugc\">https://shorturl.fm/6539m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("120", "531", "Makayla1578", "Makayla1578@gmail.com", "", "49.43.115.90", "2025-05-27 15:01:24", "2025-05-27 20:01:24", "<a href=\"https://shorturl.fm/oYjg5\" rel=\"nofollow ugc\">https://shorturl.fm/oYjg5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("121", "1", "Vanessa439", "Vanessa439@gmail.com", "", "49.43.115.90", "2025-05-27 15:01:58", "2025-05-27 20:01:58", "<a href=\"https://shorturl.fm/6539m\" rel=\"nofollow ugc\">https://shorturl.fm/6539m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("122", "556", "Erin2427", "Erin2427@gmail.com", "", "184.82.34.221", "2025-05-27 15:05:55", "2025-05-27 20:05:55", "<a href=\"https://shorturl.fm/j3kEj\" rel=\"nofollow ugc\">https://shorturl.fm/j3kEj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("123", "551", "Leslie924", "Leslie924@gmail.com", "", "184.82.34.221", "2025-05-27 15:06:19", "2025-05-27 20:06:19", "<a href=\"https://shorturl.fm/6539m\" rel=\"nofollow ugc\">https://shorturl.fm/6539m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("124", "531", "Kevin4503", "Kevin4503@gmail.com", "", "184.82.34.221", "2025-05-27 15:06:45", "2025-05-27 20:06:45", "<a href=\"https://shorturl.fm/5JO3e\" rel=\"nofollow ugc\">https://shorturl.fm/5JO3e</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("125", "1", "Elvira1320", "Elvira1320@gmail.com", "", "184.82.34.221", "2025-05-27 15:07:14", "2025-05-27 20:07:14", "<a href=\"https://shorturl.fm/j3kEj\" rel=\"nofollow ugc\">https://shorturl.fm/j3kEj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("126", "556", "Cameron1542", "Cameron1542@gmail.com", "", "142.112.209.169", "2025-05-27 20:01:40", "2025-05-28 01:01:40", "<a href=\"https://shorturl.fm/5JO3e\" rel=\"nofollow ugc\">https://shorturl.fm/5JO3e</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("127", "551", "Emerson1117", "Emerson1117@gmail.com", "", "142.112.209.169", "2025-05-27 20:02:10", "2025-05-28 01:02:10", "<a href=\"https://shorturl.fm/oYjg5\" rel=\"nofollow ugc\">https://shorturl.fm/oYjg5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("128", "531", "Cadence2317", "Cadence2317@gmail.com", "", "142.112.209.169", "2025-05-27 20:02:42", "2025-05-28 01:02:42", "<a href=\"https://shorturl.fm/6539m\" rel=\"nofollow ugc\">https://shorturl.fm/6539m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("129", "1", "Emory4457", "Emory4457@gmail.com", "", "142.112.209.169", "2025-05-27 20:03:11", "2025-05-28 01:03:11", "<a href=\"https://shorturl.fm/YvSxU\" rel=\"nofollow ugc\">https://shorturl.fm/YvSxU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("130", "556", "Amber4161", "Amber4161@gmail.com", "", "183.83.159.158", "2025-05-28 08:26:46", "2025-05-28 13:26:46", "<a href=\"https://shorturl.fm/A5ni8\" rel=\"nofollow ugc\">https://shorturl.fm/A5ni8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("131", "551", "Roger3347", "Roger3347@gmail.com", "", "183.83.159.158", "2025-05-28 08:27:14", "2025-05-28 13:27:14", "<a href=\"https://shorturl.fm/68Y8V\" rel=\"nofollow ugc\">https://shorturl.fm/68Y8V</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("132", "531", "Lilly3734", "Lilly3734@gmail.com", "", "183.83.159.158", "2025-05-28 08:27:44", "2025-05-28 13:27:44", "<a href=\"https://shorturl.fm/A5ni8\" rel=\"nofollow ugc\">https://shorturl.fm/A5ni8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("133", "1", "Martha4139", "Martha4139@gmail.com", "", "183.83.159.158", "2025-05-28 08:28:13", "2025-05-28 13:28:13", "<a href=\"https://shorturl.fm/XIZGD\" rel=\"nofollow ugc\">https://shorturl.fm/XIZGD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("134", "556", "Devin4463", "Devin4463@gmail.com", "", "103.112.227.97", "2025-05-29 00:28:09", "2025-05-29 05:28:09", "<a href=\"https://shorturl.fm/FIJkD\" rel=\"nofollow ugc\">https://shorturl.fm/FIJkD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("135", "551", "Ana321", "Ana321@gmail.com", "", "103.112.227.97", "2025-05-29 00:28:36", "2025-05-29 05:28:36", "<a href=\"https://shorturl.fm/A5ni8\" rel=\"nofollow ugc\">https://shorturl.fm/A5ni8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("136", "531", "Martin4315", "Martin4315@gmail.com", "", "103.112.227.97", "2025-05-29 00:29:05", "2025-05-29 05:29:05", "<a href=\"https://shorturl.fm/FIJkD\" rel=\"nofollow ugc\">https://shorturl.fm/FIJkD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("137", "1", "William1630", "William1630@gmail.com", "", "103.112.227.97", "2025-05-29 00:29:32", "2025-05-29 05:29:32", "<a href=\"https://shorturl.fm/XIZGD\" rel=\"nofollow ugc\">https://shorturl.fm/XIZGD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("138", "531", "Sydney3902", "Sydney3902@gmail.com", "", "158.140.182.66", "2025-05-29 03:06:38", "2025-05-29 08:06:38", "<a href=\"https://shorturl.fm/N6nl1\" rel=\"nofollow ugc\">https://shorturl.fm/N6nl1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("139", "1", "Adalyn4532", "Adalyn4532@gmail.com", "", "158.140.182.66", "2025-05-29 03:07:07", "2025-05-29 08:07:07", "<a href=\"https://shorturl.fm/TbTre\" rel=\"nofollow ugc\">https://shorturl.fm/TbTre</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("140", "556", "Tori1116", "Tori1116@gmail.com", "", "46.217.139.73", "2025-05-29 05:00:04", "2025-05-29 10:00:04", "<a href=\"https://shorturl.fm/A5ni8\" rel=\"nofollow ugc\">https://shorturl.fm/A5ni8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("141", "551", "Mia1231", "Mia1231@gmail.com", "", "46.217.139.73", "2025-05-29 05:00:34", "2025-05-29 10:00:34", "<a href=\"https://shorturl.fm/j3kEj\" rel=\"nofollow ugc\">https://shorturl.fm/j3kEj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("142", "531", "Christina4127", "Christina4127@gmail.com", "", "46.217.139.73", "2025-05-29 05:01:02", "2025-05-29 10:01:02", "<a href=\"https://shorturl.fm/a0B2m\" rel=\"nofollow ugc\">https://shorturl.fm/a0B2m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("143", "1", "Payton1076", "Payton1076@gmail.com", "", "46.217.139.73", "2025-05-29 05:01:30", "2025-05-29 10:01:30", "<a href=\"https://shorturl.fm/YvSxU\" rel=\"nofollow ugc\">https://shorturl.fm/YvSxU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("144", "556", "Hector3459", "Hector3459@gmail.com", "", "104.28.245.128", "2025-05-29 22:43:32", "2025-05-30 03:43:32", "<a href=\"https://shorturl.fm/TbTre\" rel=\"nofollow ugc\">https://shorturl.fm/TbTre</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("145", "551", "Noelle3708", "Noelle3708@gmail.com", "", "104.28.245.128", "2025-05-29 22:44:09", "2025-05-30 03:44:09", "<a href=\"https://shorturl.fm/YvSxU\" rel=\"nofollow ugc\">https://shorturl.fm/YvSxU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("146", "1", "Kyle3382", "Kyle3382@gmail.com", "", "104.28.245.128", "2025-05-29 22:44:29", "2025-05-30 03:44:29", "<a href=\"https://shorturl.fm/TbTre\" rel=\"nofollow ugc\">https://shorturl.fm/TbTre</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("147", "556", "Toby1054", "Toby1054@gmail.com", "", "94.103.83.90", "2025-05-30 03:07:54", "2025-05-30 08:07:54", "<a href=\"https://shorturl.fm/YvSxU\" rel=\"nofollow ugc\">https://shorturl.fm/YvSxU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("148", "531", "Colette1198", "Colette1198@gmail.com", "", "94.103.83.90", "2025-05-30 03:08:31", "2025-05-30 08:08:31", "<a href=\"https://shorturl.fm/bODKa\" rel=\"nofollow ugc\">https://shorturl.fm/bODKa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("149", "1", "Keegan2401", "Keegan2401@gmail.com", "", "94.103.83.90", "2025-05-30 03:08:57", "2025-05-30 08:08:57", "<a href=\"https://shorturl.fm/XIZGD\" rel=\"nofollow ugc\">https://shorturl.fm/XIZGD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("150", "551", "Hailee4656", "Hailee4656@gmail.com", "", "204.199.7.213", "2025-05-30 13:29:42", "2025-05-30 18:29:42", "<a href=\"https://shorturl.fm/hQjgP\" rel=\"nofollow ugc\">https://shorturl.fm/hQjgP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("151", "1", "Connor4899", "Connor4899@gmail.com", "", "204.199.7.213", "2025-05-30 13:30:22", "2025-05-30 18:30:22", "<a href=\"https://shorturl.fm/uyMvT\" rel=\"nofollow ugc\">https://shorturl.fm/uyMvT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("152", "556", "Irene3349", "Irene3349@gmail.com", "", "113.53.155.180", "2025-05-31 07:40:15", "2025-05-31 12:40:15", "<a href=\"https://shorturl.fm/xlGWd\" rel=\"nofollow ugc\">https://shorturl.fm/xlGWd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("153", "551", "Miriam3361", "Miriam3361@gmail.com", "", "113.53.155.180", "2025-05-31 07:40:46", "2025-05-31 12:40:46", "<a href=\"https://shorturl.fm/Kp34g\" rel=\"nofollow ugc\">https://shorturl.fm/Kp34g</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("154", "531", "Marilyn4677", "Marilyn4677@gmail.com", "", "113.53.155.180", "2025-05-31 07:41:16", "2025-05-31 12:41:16", "<a href=\"https://shorturl.fm/0EtO1\" rel=\"nofollow ugc\">https://shorturl.fm/0EtO1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("155", "1", "Luca2105", "Luca2105@gmail.com", "", "113.53.155.180", "2025-05-31 07:41:46", "2025-05-31 12:41:46", "<a href=\"https://shorturl.fm/0EtO1\" rel=\"nofollow ugc\">https://shorturl.fm/0EtO1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("156", "556", "Cara1157", "Cara1157@gmail.com", "", "3.7.69.206", "2025-05-31 11:39:35", "2025-05-31 16:39:35", "<a href=\"https://shorturl.fm/I3T8M\" rel=\"nofollow ugc\">https://shorturl.fm/I3T8M</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("157", "551", "Dana1030", "Dana1030@gmail.com", "", "3.7.69.206", "2025-05-31 11:40:05", "2025-05-31 16:40:05", "<a href=\"https://shorturl.fm/IPXDm\" rel=\"nofollow ugc\">https://shorturl.fm/IPXDm</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("158", "531", "Donovan1050", "Donovan1050@gmail.com", "", "3.7.69.206", "2025-05-31 11:40:36", "2025-05-31 16:40:36", "<a href=\"https://shorturl.fm/fSv4z\" rel=\"nofollow ugc\">https://shorturl.fm/fSv4z</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("159", "1", "Max4993", "Max4993@gmail.com", "", "3.7.69.206", "2025-05-31 11:41:06", "2025-05-31 16:41:06", "<a href=\"https://shorturl.fm/TDuGJ\" rel=\"nofollow ugc\">https://shorturl.fm/TDuGJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("160", "556", "Joseph1152", "Joseph1152@gmail.com", "", "54.215.78.243", "2025-05-31 15:56:24", "2025-05-31 20:56:24", "<a href=\"https://shorturl.fm/DA3HU\" rel=\"nofollow ugc\">https://shorturl.fm/DA3HU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("161", "551", "Geoff4233", "Geoff4233@gmail.com", "", "54.215.78.243", "2025-05-31 15:56:53", "2025-05-31 20:56:53", "<a href=\"https://shorturl.fm/nqe5E\" rel=\"nofollow ugc\">https://shorturl.fm/nqe5E</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("162", "531", "Hailey3853", "Hailey3853@gmail.com", "", "54.215.78.243", "2025-05-31 15:57:21", "2025-05-31 20:57:21", "<a href=\"https://shorturl.fm/TDuGJ\" rel=\"nofollow ugc\">https://shorturl.fm/TDuGJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("163", "1", "Wyatt1802", "Wyatt1802@gmail.com", "", "54.215.78.243", "2025-05-31 15:57:50", "2025-05-31 20:57:50", "<a href=\"https://shorturl.fm/PFOiP\" rel=\"nofollow ugc\">https://shorturl.fm/PFOiP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("164", "556", "Weston969", "Weston969@gmail.com", "", "103.203.255.85", "2025-06-01 02:03:26", "2025-06-01 07:03:26", "<a href=\"https://shorturl.fm/0EtO1\" rel=\"nofollow ugc\">https://shorturl.fm/0EtO1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("165", "551", "Ayden3099", "Ayden3099@gmail.com", "", "103.203.255.85", "2025-06-01 02:03:55", "2025-06-01 07:03:55", "<a href=\"https://shorturl.fm/retLL\" rel=\"nofollow ugc\">https://shorturl.fm/retLL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("166", "531", "Margaret1528", "Margaret1528@gmail.com", "", "103.203.255.85", "2025-06-01 02:04:25", "2025-06-01 07:04:25", "<a href=\"https://shorturl.fm/uyMvT\" rel=\"nofollow ugc\">https://shorturl.fm/uyMvT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("167", "1", "Nevaeh101", "Nevaeh101@gmail.com", "", "103.203.255.85", "2025-06-01 02:04:51", "2025-06-01 07:04:51", "<a href=\"https://shorturl.fm/f4TEQ\" rel=\"nofollow ugc\">https://shorturl.fm/f4TEQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("168", "556", "Alejandra4442", "Alejandra4442@gmail.com", "", "36.72.213.33", "2025-06-01 03:07:02", "2025-06-01 08:07:02", "<a href=\"https://shorturl.fm/47rLb\" rel=\"nofollow ugc\">https://shorturl.fm/47rLb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("169", "551", "Bridget305", "Bridget305@gmail.com", "", "36.72.213.33", "2025-06-01 03:07:35", "2025-06-01 08:07:35", "<a href=\"https://shorturl.fm/ypgnt\" rel=\"nofollow ugc\">https://shorturl.fm/ypgnt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("170", "531", "Dominic3784", "Dominic3784@gmail.com", "", "36.72.213.33", "2025-06-01 03:08:07", "2025-06-01 08:08:07", "<a href=\"https://shorturl.fm/0oNbA\" rel=\"nofollow ugc\">https://shorturl.fm/0oNbA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("171", "1", "Effie3399", "Effie3399@gmail.com", "", "36.72.213.33", "2025-06-01 03:08:40", "2025-06-01 08:08:40", "<a href=\"https://shorturl.fm/nqe5E\" rel=\"nofollow ugc\">https://shorturl.fm/nqe5E</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("172", "556", "Renee3829", "Renee3829@gmail.com", "", "34.221.113.107", "2025-06-01 07:06:37", "2025-06-01 12:06:37", "<a href=\"https://shorturl.fm/MVjF1\" rel=\"nofollow ugc\">https://shorturl.fm/MVjF1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("173", "551", "Terry3033", "Terry3033@gmail.com", "", "34.221.113.107", "2025-06-01 07:07:07", "2025-06-01 12:07:07", "<a href=\"https://shorturl.fm/xlGWd\" rel=\"nofollow ugc\">https://shorturl.fm/xlGWd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("174", "531", "Lucia2016", "Lucia2016@gmail.com", "", "34.221.113.107", "2025-06-01 07:07:36", "2025-06-01 12:07:36", "<a href=\"https://shorturl.fm/LdPUr\" rel=\"nofollow ugc\">https://shorturl.fm/LdPUr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("175", "1", "Marion3757", "Marion3757@gmail.com", "", "34.221.113.107", "2025-06-01 07:08:06", "2025-06-01 12:08:06", "<a href=\"https://shorturl.fm/0oNbA\" rel=\"nofollow ugc\">https://shorturl.fm/0oNbA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("176", "556", "Jake4619", "Jake4619@gmail.com", "", "187.38.38.71", "2025-06-01 13:15:32", "2025-06-01 18:15:32", "<a href=\"https://shorturl.fm/eAlmd\" rel=\"nofollow ugc\">https://shorturl.fm/eAlmd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("177", "551", "Lucy3985", "Lucy3985@gmail.com", "", "187.38.38.71", "2025-06-01 13:15:58", "2025-06-01 18:15:58", "<a href=\"https://shorturl.fm/fSv4z\" rel=\"nofollow ugc\">https://shorturl.fm/fSv4z</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("178", "531", "Andres2265", "Andres2265@gmail.com", "", "187.38.38.71", "2025-06-01 13:16:26", "2025-06-01 18:16:26", "<a href=\"https://shorturl.fm/Xect5\" rel=\"nofollow ugc\">https://shorturl.fm/Xect5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("179", "1", "Percy4169", "Percy4169@gmail.com", "", "187.38.38.71", "2025-06-01 13:16:53", "2025-06-01 18:16:53", "<a href=\"https://shorturl.fm/hQjgP\" rel=\"nofollow ugc\">https://shorturl.fm/hQjgP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("180", "556", "Donovan3663", "Donovan3663@gmail.com", "", "180.245.129.130", "2025-06-01 15:51:15", "2025-06-01 20:51:15", "<a href=\"https://shorturl.fm/retLL\" rel=\"nofollow ugc\">https://shorturl.fm/retLL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("181", "551", "Sergio4442", "Sergio4442@gmail.com", "", "180.245.129.130", "2025-06-01 15:51:48", "2025-06-01 20:51:48", "<a href=\"https://shorturl.fm/eAlmd\" rel=\"nofollow ugc\">https://shorturl.fm/eAlmd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("182", "531", "Kenny1266", "Kenny1266@gmail.com", "", "180.245.129.130", "2025-06-01 15:52:24", "2025-06-01 20:52:24", "<a href=\"https://shorturl.fm/0EtO1\" rel=\"nofollow ugc\">https://shorturl.fm/0EtO1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("183", "1", "Evelyn1695", "Evelyn1695@gmail.com", "", "180.245.129.130", "2025-06-01 15:52:55", "2025-06-01 20:52:55", "<a href=\"https://shorturl.fm/VeYJe\" rel=\"nofollow ugc\">https://shorturl.fm/VeYJe</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("184", "556", "Valerie2009", "Valerie2009@gmail.com", "", "104.28.197.13", "2025-06-01 23:48:34", "2025-06-02 04:48:34", "<a href=\"https://shorturl.fm/Kp34g\" rel=\"nofollow ugc\">https://shorturl.fm/Kp34g</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("185", "551", "Gilbert4393", "Gilbert4393@gmail.com", "", "104.28.197.13", "2025-06-01 23:49:05", "2025-06-02 04:49:05", "<a href=\"https://shorturl.fm/fSv4z\" rel=\"nofollow ugc\">https://shorturl.fm/fSv4z</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("186", "531", "Nova4571", "Nova4571@gmail.com", "", "104.28.197.13", "2025-06-01 23:49:35", "2025-06-02 04:49:35", "<a href=\"https://shorturl.fm/hQjgP\" rel=\"nofollow ugc\">https://shorturl.fm/hQjgP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("187", "1", "Britney2801", "Britney2801@gmail.com", "", "104.28.197.13", "2025-06-01 23:50:06", "2025-06-02 04:50:06", "<a href=\"https://shorturl.fm/JtG9d\" rel=\"nofollow ugc\">https://shorturl.fm/JtG9d</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("188", "556", "Megan3166", "Megan3166@gmail.com", "", "123.20.65.4", "2025-07-08 20:01:34", "2025-07-09 01:01:34", "Tap into a new revenue stream—become an affiliate partner! <a href=\"https://shorturl.fm/BrwAC\" rel=\"nofollow ugc\">https://shorturl.fm/BrwAC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("189", "551", "Trinity3534", "Trinity3534@gmail.com", "", "123.20.65.4", "2025-07-08 20:02:02", "2025-07-09 01:02:02", "Join our affiliate community and maximize your profits—sign up now! <a href=\"https://shorturl.fm/cS8V8\" rel=\"nofollow ugc\">https://shorturl.fm/cS8V8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("190", "531", "Blanca2617", "Blanca2617@gmail.com", "", "123.20.65.4", "2025-07-08 20:02:33", "2025-07-09 01:02:33", "Start earning every time someone clicks—join now! <a href=\"https://shorturl.fm/F4gGP\" rel=\"nofollow ugc\">https://shorturl.fm/F4gGP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("191", "556", "Harry4762", "Harry4762@gmail.com", "", "1.54.172.235", "2025-07-08 22:43:51", "2025-07-09 03:43:51", "Grow your income stream—apply to our affiliate program today! <a href=\"https://shorturl.fm/rCRMi\" rel=\"nofollow ugc\">https://shorturl.fm/rCRMi</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("192", "551", "Curtis4251", "Curtis4251@gmail.com", "", "1.54.172.235", "2025-07-08 22:44:25", "2025-07-09 03:44:25", "Earn passive income this month—become an affiliate partner and get paid! <a href=\"https://shorturl.fm/CRTaG\" rel=\"nofollow ugc\">https://shorturl.fm/CRTaG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("193", "556", "Natasha1239", "Natasha1239@gmail.com", "", "122.144.7.137", "2025-07-09 02:46:37", "2025-07-09 07:46:37", "Start sharing our link and start earning today! <a href=\"https://shorturl.fm/yX23d\" rel=\"nofollow ugc\">https://shorturl.fm/yX23d</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("194", "551", "Lola305", "Lola305@gmail.com", "", "122.144.7.137", "2025-07-09 02:47:07", "2025-07-09 07:47:07", "Drive sales, earn big—enroll in our affiliate program! <a href=\"https://shorturl.fm/z90pT\" rel=\"nofollow ugc\">https://shorturl.fm/z90pT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("195", "1", "Giovanni2808", "Giovanni2808@gmail.com", "", "122.144.7.137", "2025-07-09 02:47:47", "2025-07-09 07:47:47", "Become our affiliate and watch your wallet grow—apply now! <a href=\"https://shorturl.fm/FCR9Q\" rel=\"nofollow ugc\">https://shorturl.fm/FCR9Q</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("196", "556", "Kristina2911", "Kristina2911@gmail.com", "", "103.184.99.194", "2025-07-09 03:07:39", "2025-07-09 08:07:39", "Become our affiliate and watch your wallet grow—apply now! <a href=\"https://shorturl.fm/s2OEE\" rel=\"nofollow ugc\">https://shorturl.fm/s2OEE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("197", "551", "Gwen4624", "Gwen4624@gmail.com", "", "103.184.99.194", "2025-07-09 03:08:09", "2025-07-09 08:08:09", "Drive sales, collect commissions—join our affiliate team! <a href=\"https://shorturl.fm/IfhrA\" rel=\"nofollow ugc\">https://shorturl.fm/IfhrA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("198", "531", "Gemma3673", "Gemma3673@gmail.com", "", "103.184.99.194", "2025-07-09 03:08:38", "2025-07-09 08:08:38", "Start earning every time someone clicks—join now! <a href=\"https://shorturl.fm/r9gQ0\" rel=\"nofollow ugc\">https://shorturl.fm/r9gQ0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("199", "1", "Britney3834", "Britney3834@gmail.com", "", "103.184.99.194", "2025-07-09 03:09:09", "2025-07-09 08:09:09", "Become our affiliate and watch your wallet grow—apply now! <a href=\"https://shorturl.fm/qWWf1\" rel=\"nofollow ugc\">https://shorturl.fm/qWWf1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("200", "556", "Leanne3890", "Leanne3890@gmail.com", "", "109.62.200.169", "2025-07-09 06:21:57", "2025-07-09 11:21:57", "Promote our products and earn real money—apply today! <a href=\"https://shorturl.fm/A66zG\" rel=\"nofollow ugc\">https://shorturl.fm/A66zG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("201", "551", "Jeff4989", "Jeff4989@gmail.com", "", "109.62.200.169", "2025-07-09 06:22:26", "2025-07-09 11:22:26", "Refer friends and colleagues—get paid for every signup! <a href=\"https://shorturl.fm/Rb1B4\" rel=\"nofollow ugc\">https://shorturl.fm/Rb1B4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("202", "531", "Bernadette2874", "Bernadette2874@gmail.com", "", "109.62.200.169", "2025-07-09 06:22:54", "2025-07-09 11:22:54", "Drive sales, earn big—enroll in our affiliate program! <a href=\"https://shorturl.fm/R6XOL\" rel=\"nofollow ugc\">https://shorturl.fm/R6XOL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("203", "1", "Zane2520", "Zane2520@gmail.com", "", "109.62.200.169", "2025-07-09 06:23:23", "2025-07-09 11:23:23", "Unlock exclusive affiliate perks—register now! <a href=\"https://shorturl.fm/k9gcK\" rel=\"nofollow ugc\">https://shorturl.fm/k9gcK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("204", "551", "Ada4081", "Ada4081@gmail.com", "", "194.124.36.245", "2025-07-09 11:06:17", "2025-07-09 16:06:17", "Apply now and receive dedicated support for affiliates! <a href=\"https://shorturl.fm/XxXWQ\" rel=\"nofollow ugc\">https://shorturl.fm/XxXWQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("205", "556", "Darren2803", "Darren2803@gmail.com", "", "1.55.170.33", "2025-07-09 12:27:44", "2025-07-09 17:27:44", "Partner with us and enjoy recurring commission payouts! <a href=\"https://shorturl.fm/BWlfX\" rel=\"nofollow ugc\">https://shorturl.fm/BWlfX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("206", "556", "Edgar1357", "Edgar1357@gmail.com", "", "106.107.183.19", "2025-07-09 13:52:02", "2025-07-09 18:52:02", "Become our partner and turn referrals into revenue—join now! <a href=\"https://shorturl.fm/n6Gkb\" rel=\"nofollow ugc\">https://shorturl.fm/n6Gkb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("207", "556", "Joseph216", "Joseph216@gmail.com", "", "27.79.250.93", "2025-07-09 15:15:05", "2025-07-09 20:15:05", "Sign up for our affiliate program and watch your earnings grow! <a href=\"https://shorturl.fm/2bgBu\" rel=\"nofollow ugc\">https://shorturl.fm/2bgBu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("208", "551", "Marilyn165", "Marilyn165@gmail.com", "", "27.79.250.93", "2025-07-09 15:15:30", "2025-07-09 20:15:30", "Earn passive income this month—become an affiliate partner and get paid! <a href=\"https://shorturl.fm/4BRcc\" rel=\"nofollow ugc\">https://shorturl.fm/4BRcc</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("209", "531", "Camryn2344", "Camryn2344@gmail.com", "", "27.79.250.93", "2025-07-09 15:15:54", "2025-07-09 20:15:54", "Get started instantly—earn on every referral you make! <a href=\"https://shorturl.fm/VIVcm\" rel=\"nofollow ugc\">https://shorturl.fm/VIVcm</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("210", "1", "Melinda522", "Melinda522@gmail.com", "", "27.79.250.93", "2025-07-09 15:16:19", "2025-07-09 20:16:19", "Monetize your influence—become an affiliate today! <a href=\"https://shorturl.fm/EYr8e\" rel=\"nofollow ugc\">https://shorturl.fm/EYr8e</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("211", "531", "Christine3018", "Christine3018@gmail.com", "", "195.62.50.247", "2025-07-10 03:52:58", "2025-07-10 08:52:58", "Start earning on autopilot—become our affiliate partner! <a href=\"https://shorturl.fm/kU6ao\" rel=\"nofollow ugc\">https://shorturl.fm/kU6ao</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("212", "551", "Adele3936", "Adele3936@gmail.com", "", "122.252.180.190", "2025-07-10 06:25:48", "2025-07-10 11:25:48", "Partner with us for generous payouts—sign up today! <a href=\"https://shorturl.fm/yysT6\" rel=\"nofollow ugc\">https://shorturl.fm/yysT6</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("213", "531", "Finn1611", "Finn1611@gmail.com", "", "122.252.180.190", "2025-07-10 06:26:15", "2025-07-10 11:26:15", "Drive sales, collect commissions—join our affiliate team! <a href=\"https://shorturl.fm/Z40Aa\" rel=\"nofollow ugc\">https://shorturl.fm/Z40Aa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("214", "1", "Maxwell3507", "Maxwell3507@gmail.com", "", "122.252.180.190", "2025-07-10 06:26:40", "2025-07-10 11:26:40", "Partner with us for generous payouts—sign up today! <a href=\"https://shorturl.fm/fUMrx\" rel=\"nofollow ugc\">https://shorturl.fm/fUMrx</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("215", "556", "Keegan591", "Keegan591@gmail.com", "", "27.79.135.172", "2025-07-11 02:55:30", "2025-07-11 07:55:30", "Join forces with us and profit from every click! <a href=\"https://shorturl.fm/sO605\" rel=\"nofollow ugc\">https://shorturl.fm/sO605</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("216", "551", "Aniya4335", "Aniya4335@gmail.com", "", "27.79.135.172", "2025-07-11 02:55:59", "2025-07-11 07:55:59", "Join our affiliate community and start earning instantly! <a href=\"https://shorturl.fm/9MyMa\" rel=\"nofollow ugc\">https://shorturl.fm/9MyMa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("217", "531", "Maxwell2342", "Maxwell2342@gmail.com", "", "27.79.135.172", "2025-07-11 02:56:28", "2025-07-11 07:56:28", "Promote our products and earn real money—apply today! <a href=\"https://shorturl.fm/6iIxb\" rel=\"nofollow ugc\">https://shorturl.fm/6iIxb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("218", "1", "Katherine3052", "Katherine3052@gmail.com", "", "27.79.135.172", "2025-07-11 02:56:58", "2025-07-11 07:56:58", "Start profiting from your network—sign up today! <a href=\"https://shorturl.fm/Hfr2z\" rel=\"nofollow ugc\">https://shorturl.fm/Hfr2z</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("219", "556", "King2980", "King2980@gmail.com", "", "27.79.134.39", "2025-07-11 08:00:54", "2025-07-11 13:00:54", "Join our affiliate program and start earning today—sign up now! <a href=\"https://shorturl.fm/caVf4\" rel=\"nofollow ugc\">https://shorturl.fm/caVf4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("220", "551", "Jessie2737", "Jessie2737@gmail.com", "", "27.79.134.39", "2025-07-11 08:01:23", "2025-07-11 13:01:23", "Boost your earnings effortlessly—become our affiliate! <a href=\"https://shorturl.fm/c0YDm\" rel=\"nofollow ugc\">https://shorturl.fm/c0YDm</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("221", "531", "Peter1683", "Peter1683@gmail.com", "", "27.79.134.39", "2025-07-11 08:01:51", "2025-07-11 13:01:51", "Refer friends, earn cash—sign up now! <a href=\"https://shorturl.fm/ny1Ma\" rel=\"nofollow ugc\">https://shorturl.fm/ny1Ma</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("222", "1", "Drake678", "Drake678@gmail.com", "", "27.79.134.39", "2025-07-11 08:02:19", "2025-07-11 13:02:19", "Unlock exclusive affiliate perks—register now! <a href=\"https://shorturl.fm/GD6sg\" rel=\"nofollow ugc\">https://shorturl.fm/GD6sg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("223", "556", "Edward4162", "Edward4162@gmail.com", "", "103.252.6.162", "2025-07-11 09:46:11", "2025-07-11 14:46:11", "Tap into unlimited earnings—sign up for our affiliate program! <a href=\"https://shorturl.fm/HWvus\" rel=\"nofollow ugc\">https://shorturl.fm/HWvus</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("224", "551", "Summer4992", "Summer4992@gmail.com", "", "103.252.6.162", "2025-07-11 09:46:37", "2025-07-11 14:46:37", "Join our affiliate community and maximize your profits! <a href=\"https://shorturl.fm/tWW6p\" rel=\"nofollow ugc\">https://shorturl.fm/tWW6p</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("225", "531", "Clinton1733", "Clinton1733@gmail.com", "", "103.252.6.162", "2025-07-11 09:47:04", "2025-07-11 14:47:04", "Unlock exclusive rewards with every referral—apply to our affiliate program now! <a href=\"https://shorturl.fm/Jq0gX\" rel=\"nofollow ugc\">https://shorturl.fm/Jq0gX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("226", "1", "Garrett1024", "Garrett1024@gmail.com", "", "103.252.6.162", "2025-07-11 09:47:32", "2025-07-11 14:47:32", "Join our affiliate family and watch your profits soar—sign up today! <a href=\"https://shorturl.fm/XmTkt\" rel=\"nofollow ugc\">https://shorturl.fm/XmTkt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("227", "556", "Demi961", "Demi961@gmail.com", "", "58.187.180.207", "2025-07-11 12:43:40", "2025-07-11 17:43:40", "Turn traffic into cash—apply to our affiliate program today! <a href=\"https://shorturl.fm/Xp84F\" rel=\"nofollow ugc\">https://shorturl.fm/Xp84F</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("228", "551", "Lori2406", "Lori2406@gmail.com", "", "58.187.180.207", "2025-07-11 12:44:08", "2025-07-11 17:44:08", "Share our link, earn real money—signup for our affiliate program! <a href=\"https://shorturl.fm/av0Rs\" rel=\"nofollow ugc\">https://shorturl.fm/av0Rs</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("229", "531", "Eileen3940", "Eileen3940@gmail.com", "", "58.187.180.207", "2025-07-11 12:44:35", "2025-07-11 17:44:35", "Turn traffic into cash—apply to our affiliate program today! <a href=\"https://shorturl.fm/Xp84F\" rel=\"nofollow ugc\">https://shorturl.fm/Xp84F</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("230", "1", "Emma4900", "Emma4900@gmail.com", "", "58.187.180.207", "2025-07-11 12:45:04", "2025-07-11 17:45:04", "Join our affiliate program and start earning today—sign up now! <a href=\"https://shorturl.fm/yw3yu\" rel=\"nofollow ugc\">https://shorturl.fm/yw3yu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("231", "556", "Nia1999", "Nia1999@gmail.com", "", "1.10.239.143", "2025-07-11 14:47:14", "2025-07-11 19:47:14", "Monetize your audience with our high-converting offers—apply today! <a href=\"https://shorturl.fm/hkbtS\" rel=\"nofollow ugc\">https://shorturl.fm/hkbtS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("232", "556", "Bill4766", "Bill4766@gmail.com", "", "27.71.139.33", "2025-07-12 07:02:21", "2025-07-12 12:02:21", "Turn your traffic into cash—join our affiliate program! <a href=\"https://shorturl.fm/31aB4\" rel=\"nofollow ugc\">https://shorturl.fm/31aB4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("233", "1", "Irma3248", "Irma3248@gmail.com", "", "27.71.139.33", "2025-07-12 07:03:04", "2025-07-12 12:03:04", "Start sharing, start earning—become our affiliate today! <a href=\"https://shorturl.fm/vSBVo\" rel=\"nofollow ugc\">https://shorturl.fm/vSBVo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("234", "556", "Angie1974", "Angie1974@gmail.com", "", "223.205.136.80", "2025-07-12 13:16:29", "2025-07-12 18:16:29", "Tap into unlimited earning potential—become our affiliate partner! <a href=\"https://shorturl.fm/u5cBK\" rel=\"nofollow ugc\">https://shorturl.fm/u5cBK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("235", "551", "Igor2460", "Igor2460@gmail.com", "", "223.205.136.80", "2025-07-12 13:16:59", "2025-07-12 18:16:59", "Become our affiliate—tap into unlimited earning potential! <a href=\"https://shorturl.fm/tYJY6\" rel=\"nofollow ugc\">https://shorturl.fm/tYJY6</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("236", "531", "Dominic1726", "Dominic1726@gmail.com", "", "223.205.136.80", "2025-07-12 13:17:29", "2025-07-12 18:17:29", "Tap into unlimited earning potential—become our affiliate partner! <a href=\"https://shorturl.fm/u5cBK\" rel=\"nofollow ugc\">https://shorturl.fm/u5cBK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("237", "1", "Jasmine3773", "Jasmine3773@gmail.com", "", "223.205.136.80", "2025-07-12 13:17:59", "2025-07-12 18:17:59", "Start sharing our link and start earning today! <a href=\"https://shorturl.fm/hBQVr\" rel=\"nofollow ugc\">https://shorturl.fm/hBQVr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("238", "556", "Gabriela4136", "Gabriela4136@gmail.com", "", "118.68.67.189", "2025-07-12 16:54:16", "2025-07-12 21:54:16", "Monetize your traffic instantly—enroll in our affiliate network! <a href=\"https://shorturl.fm/RqFJY\" rel=\"nofollow ugc\">https://shorturl.fm/RqFJY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("239", "551", "Jeremy1335", "Jeremy1335@gmail.com", "", "118.68.67.189", "2025-07-12 16:54:43", "2025-07-12 21:54:43", "Tap into a new revenue stream—become an affiliate partner! <a href=\"https://shorturl.fm/wWY3s\" rel=\"nofollow ugc\">https://shorturl.fm/wWY3s</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("240", "531", "Reed2077", "Reed2077@gmail.com", "", "118.68.67.189", "2025-07-12 16:55:07", "2025-07-12 21:55:07", "Promote our brand and watch your income grow—join today! <a href=\"https://shorturl.fm/2bjz5\" rel=\"nofollow ugc\">https://shorturl.fm/2bjz5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("241", "1", "Leila4078", "Leila4078@gmail.com", "", "118.68.67.189", "2025-07-12 16:55:33", "2025-07-12 21:55:33", "Monetize your audience—become an affiliate partner now! <a href=\"https://shorturl.fm/otSrY\" rel=\"nofollow ugc\">https://shorturl.fm/otSrY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("242", "556", "Leah2988", "Leah2988@gmail.com", "", "49.48.53.226", "2025-07-13 00:48:55", "2025-07-13 05:48:55", "Refer and earn up to 50% commission—join now! <a href=\"https://shorturl.fm/jpCMr\" rel=\"nofollow ugc\">https://shorturl.fm/jpCMr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("243", "551", "Elsie4045", "Elsie4045@gmail.com", "", "49.48.53.226", "2025-07-13 00:49:23", "2025-07-13 05:49:23", "Share our products, earn up to 40% per sale—apply today! <a href=\"https://shorturl.fm/HopOf\" rel=\"nofollow ugc\">https://shorturl.fm/HopOf</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("244", "531", "Rory1681", "Rory1681@gmail.com", "", "49.48.53.226", "2025-07-13 00:49:52", "2025-07-13 05:49:52", "Tap into a new revenue stream—become an affiliate partner! <a href=\"https://shorturl.fm/kAZ33\" rel=\"nofollow ugc\">https://shorturl.fm/kAZ33</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("245", "1", "Mathew3296", "Mathew3296@gmail.com", "", "49.48.53.226", "2025-07-13 00:50:20", "2025-07-13 05:50:20", "Share our link, earn real money—signup for our affiliate program! <a href=\"https://shorturl.fm/JExEr\" rel=\"nofollow ugc\">https://shorturl.fm/JExEr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("246", "556", "Katherine434", "Katherine434@gmail.com", "", "43.159.146.191", "2025-07-13 00:56:20", "2025-07-13 05:56:20", "Start earning on autopilot—become our affiliate partner! <a href=\"https://shorturl.fm/3Rra4\" rel=\"nofollow ugc\">https://shorturl.fm/3Rra4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("247", "551", "Ellen2229", "Ellen2229@gmail.com", "", "43.159.146.191", "2025-07-13 00:56:50", "2025-07-13 05:56:50", "Monetize your traffic with our affiliate program—sign up now! <a href=\"https://shorturl.fm/XNTFA\" rel=\"nofollow ugc\">https://shorturl.fm/XNTFA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("248", "531", "Diane1952", "Diane1952@gmail.com", "", "43.159.146.191", "2025-07-13 00:57:21", "2025-07-13 05:57:21", "Partner with us and enjoy high payouts—apply now! <a href=\"https://shorturl.fm/BNjmE\" rel=\"nofollow ugc\">https://shorturl.fm/BNjmE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("249", "1", "Alaina1971", "Alaina1971@gmail.com", "", "43.159.146.191", "2025-07-13 00:57:48", "2025-07-13 05:57:48", "Become our affiliate—tap into unlimited earning potential! <a href=\"https://shorturl.fm/eQ29X\" rel=\"nofollow ugc\">https://shorturl.fm/eQ29X</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("250", "556", "Robert4339", "Robert4339@gmail.com", "", "103.167.170.244", "2025-07-13 04:23:24", "2025-07-13 09:23:24", "Become our partner and turn referrals into revenue—join now! <a href=\"https://shorturl.fm/NbYml\" rel=\"nofollow ugc\">https://shorturl.fm/NbYml</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("251", "556", "Devon3733", "Devon3733@gmail.com", "", "171.228.115.150", "2025-07-13 09:46:24", "2025-07-13 14:46:24", "Share your link, earn rewards—sign up for our affiliate program! <a href=\"https://shorturl.fm/VvSHy\" rel=\"nofollow ugc\">https://shorturl.fm/VvSHy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("252", "551", "Emory4152", "Emory4152@gmail.com", "", "171.228.115.150", "2025-07-13 09:46:49", "2025-07-13 14:46:49", "Start earning passive income—join our affiliate network today! <a href=\"https://shorturl.fm/oY85c\" rel=\"nofollow ugc\">https://shorturl.fm/oY85c</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("253", "531", "Shane2417", "Shane2417@gmail.com", "", "171.228.115.150", "2025-07-13 09:47:19", "2025-07-13 14:47:19", "Join our affiliate family and watch your profits soar—sign up today! <a href=\"https://shorturl.fm/9Ehzy\" rel=\"nofollow ugc\">https://shorturl.fm/9Ehzy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("254", "1", "Julian1088", "Julian1088@gmail.com", "", "171.228.115.150", "2025-07-13 09:47:44", "2025-07-13 14:47:44", "Boost your profits with our affiliate program—apply today! <a href=\"https://shorturl.fm/A83B6\" rel=\"nofollow ugc\">https://shorturl.fm/A83B6</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("255", "556", "Jerry1961", "Jerry1961@gmail.com", "", "117.201.136.27", "2025-07-13 10:58:17", "2025-07-13 15:58:17", "Promote our brand and watch your income grow—join today! <a href=\"https://shorturl.fm/k6wer\" rel=\"nofollow ugc\">https://shorturl.fm/k6wer</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("256", "551", "Ayla3565", "Ayla3565@gmail.com", "", "117.201.136.27", "2025-07-13 10:58:45", "2025-07-13 15:58:45", "Unlock exclusive rewards with every referral—enroll now! <a href=\"https://shorturl.fm/x91vK\" rel=\"nofollow ugc\">https://shorturl.fm/x91vK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("257", "531", "Courtney2840", "Courtney2840@gmail.com", "", "117.201.136.27", "2025-07-13 10:59:12", "2025-07-13 15:59:12", "Join our affiliate family and watch your profits soar—sign up today! <a href=\"https://shorturl.fm/PAOD3\" rel=\"nofollow ugc\">https://shorturl.fm/PAOD3</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("258", "1", "Alec639", "Alec639@gmail.com", "", "117.201.136.27", "2025-07-13 10:59:39", "2025-07-13 15:59:39", "Partner with us and enjoy recurring commission payouts! <a href=\"https://shorturl.fm/9NjiH\" rel=\"nofollow ugc\">https://shorturl.fm/9NjiH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("259", "556", "Nigel1318", "Nigel1318@gmail.com", "", "8.134.35.3", "2025-07-13 17:23:21", "2025-07-13 22:23:21", "Monetize your traffic instantly—enroll in our affiliate network! <a href=\"https://shorturl.fm/TVAvY\" rel=\"nofollow ugc\">https://shorturl.fm/TVAvY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("260", "551", "Bob3736", "Bob3736@gmail.com", "", "8.134.35.3", "2025-07-13 17:23:40", "2025-07-13 22:23:40", "Drive sales and watch your affiliate earnings soar! <a href=\"https://shorturl.fm/uCRFi\" rel=\"nofollow ugc\">https://shorturl.fm/uCRFi</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("261", "531", "Melinda2448", "Melinda2448@gmail.com", "", "8.134.35.3", "2025-07-13 17:24:02", "2025-07-13 22:24:02", "Join our affiliate community and start earning instantly! <a href=\"https://shorturl.fm/d5SmR\" rel=\"nofollow ugc\">https://shorturl.fm/d5SmR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("262", "1", "Ashton4899", "Ashton4899@gmail.com", "", "8.134.35.3", "2025-07-13 17:24:26", "2025-07-13 22:24:26", "Join our affiliate program and start earning today—sign up now! <a href=\"https://shorturl.fm/gu5Ik\" rel=\"nofollow ugc\">https://shorturl.fm/gu5Ik</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("263", "556", "Phyllis2239", "Phyllis2239@gmail.com", "", "115.72.3.234", "2025-07-13 18:46:38", "2025-07-13 23:46:38", "Partner with us and earn recurring commissions—join the affiliate program! <a href=\"https://shorturl.fm/4L1rI\" rel=\"nofollow ugc\">https://shorturl.fm/4L1rI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("264", "551", "Sarah743", "Sarah743@gmail.com", "", "115.72.3.234", "2025-07-13 18:47:06", "2025-07-13 23:47:06", "Apply now and receive dedicated support for affiliates! <a href=\"https://shorturl.fm/69jjw\" rel=\"nofollow ugc\">https://shorturl.fm/69jjw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("265", "531", "Daniel348", "Daniel348@gmail.com", "", "115.72.3.234", "2025-07-13 18:47:38", "2025-07-13 23:47:38", "Start sharing our link and start earning today! <a href=\"https://shorturl.fm/kmawa\" rel=\"nofollow ugc\">https://shorturl.fm/kmawa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("266", "1", "Kiera2746", "Kiera2746@gmail.com", "", "115.72.3.234", "2025-07-13 18:48:07", "2025-07-13 23:48:07", "Earn passive income on autopilot—become our affiliate! <a href=\"https://shorturl.fm/cXuaD\" rel=\"nofollow ugc\">https://shorturl.fm/cXuaD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("267", "556", "Hope4398", "Hope4398@gmail.com", "", "106.111.209.10", "2025-07-13 21:55:44", "2025-07-14 02:55:44", "Start sharing, start earning—become our affiliate today! <a href=\"https://shorturl.fm/QFqEQ\" rel=\"nofollow ugc\">https://shorturl.fm/QFqEQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("268", "556", "Carlos1908", "Carlos1908@gmail.com", "", "202.65.239.111", "2025-07-14 10:54:53", "2025-07-14 15:54:53", "Join our affiliate program today and start earning up to 30% commission—sign up now! <a href=\"https://shorturl.fm/egS9p\" rel=\"nofollow ugc\">https://shorturl.fm/egS9p</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("269", "551", "Hadley1334", "Hadley1334@gmail.com", "", "202.65.239.111", "2025-07-14 10:55:21", "2025-07-14 15:55:21", "Start sharing our link and start earning today! <a href=\"https://shorturl.fm/3c1uX\" rel=\"nofollow ugc\">https://shorturl.fm/3c1uX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("270", "531", "Jessica2790", "Jessica2790@gmail.com", "", "202.65.239.111", "2025-07-14 10:55:47", "2025-07-14 15:55:47", "Your network, your earnings—apply to our affiliate program now! <a href=\"https://shorturl.fm/wzHL8\" rel=\"nofollow ugc\">https://shorturl.fm/wzHL8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("271", "1", "Marian1778", "Marian1778@gmail.com", "", "202.65.239.111", "2025-07-14 10:56:15", "2025-07-14 15:56:15", "Sign up for our affiliate program and watch your earnings grow! <a href=\"https://shorturl.fm/8enPc\" rel=\"nofollow ugc\">https://shorturl.fm/8enPc</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("272", "556", "Susan3988", "Susan3988@gmail.com", "", "115.74.5.11", "2025-07-15 15:56:33", "2025-07-15 20:56:33", "Refer friends and colleagues—get paid for every signup! <a href=\"https://shorturl.fm/c6Prg\" rel=\"nofollow ugc\">https://shorturl.fm/c6Prg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("273", "551", "Sofia2004", "Sofia2004@gmail.com", "", "115.74.5.11", "2025-07-15 15:57:03", "2025-07-15 20:57:03", "Promote our products—get paid for every sale you generate! <a href=\"https://shorturl.fm/6glKB\" rel=\"nofollow ugc\">https://shorturl.fm/6glKB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("274", "531", "Frank3422", "Frank3422@gmail.com", "", "115.74.5.11", "2025-07-15 15:57:31", "2025-07-15 20:57:31", "Share our products and watch your earnings grow—join our affiliate program! <a href=\"https://shorturl.fm/k2fYe\" rel=\"nofollow ugc\">https://shorturl.fm/k2fYe</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("275", "1", "Ignacio2477", "Ignacio2477@gmail.com", "", "115.74.5.11", "2025-07-15 15:57:59", "2025-07-15 20:57:59", "Refer friends and colleagues—get paid for every signup! <a href=\"https://shorturl.fm/c6Prg\" rel=\"nofollow ugc\">https://shorturl.fm/c6Prg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("276", "556", "Luca4570", "Luca4570@gmail.com", "", "207.166.178.218", "2025-07-15 16:33:06", "2025-07-15 21:33:06", "Join our affiliate community and maximize your profits—sign up now! <a href=\"https://shorturl.fm/F3In8\" rel=\"nofollow ugc\">https://shorturl.fm/F3In8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("277", "551", "Michelle1172", "Michelle1172@gmail.com", "", "207.166.178.218", "2025-07-15 16:33:37", "2025-07-15 21:33:37", "Promote our products—get paid for every sale you generate! <a href=\"https://shorturl.fm/6glKB\" rel=\"nofollow ugc\">https://shorturl.fm/6glKB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("278", "531", "Corey1421", "Corey1421@gmail.com", "", "207.166.178.218", "2025-07-15 16:34:07", "2025-07-15 21:34:07", "Unlock exclusive rewards with every referral—enroll now! <a href=\"https://shorturl.fm/DRLj4\" rel=\"nofollow ugc\">https://shorturl.fm/DRLj4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("279", "1", "Trevor1600", "Trevor1600@gmail.com", "", "207.166.178.218", "2025-07-15 16:34:38", "2025-07-15 21:34:38", "Share our offers and watch your wallet grow—become an affiliate! <a href=\"https://shorturl.fm/M44tE\" rel=\"nofollow ugc\">https://shorturl.fm/M44tE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("280", "556", "Isaac2897", "Isaac2897@gmail.com", "", "34.131.51.72", "2025-07-15 17:27:44", "2025-07-15 22:27:44", "Invite your network, boost your income—sign up for our affiliate program now! <a href=\"https://shorturl.fm/qclIo\" rel=\"nofollow ugc\">https://shorturl.fm/qclIo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("281", "551", "Juliet4699", "Juliet4699@gmail.com", "", "34.131.51.72", "2025-07-15 17:28:13", "2025-07-15 22:28:13", "Join our affiliate community and maximize your profits—sign up now! <a href=\"https://shorturl.fm/F3In8\" rel=\"nofollow ugc\">https://shorturl.fm/F3In8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("282", "531", "Luke944", "Luke944@gmail.com", "", "34.131.51.72", "2025-07-15 17:28:42", "2025-07-15 22:28:42", "Join our affiliate program and start earning commissions today—sign up now! <a href=\"https://shorturl.fm/1igaI\" rel=\"nofollow ugc\">https://shorturl.fm/1igaI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("283", "1", "Adelyn2221", "Adelyn2221@gmail.com", "", "34.131.51.72", "2025-07-15 17:29:12", "2025-07-15 22:29:12", "Join our affiliate community and maximize your profits! <a href=\"https://shorturl.fm/DHBlg\" rel=\"nofollow ugc\">https://shorturl.fm/DHBlg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("284", "556", "Ayla2750", "Ayla2750@gmail.com", "", "75.119.130.35", "2025-07-15 20:37:44", "2025-07-16 01:37:44", "Your audience, your profits—become an affiliate today! <a href=\"https://shorturl.fm/1psgs\" rel=\"nofollow ugc\">https://shorturl.fm/1psgs</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("285", "551", "Gabriela2076", "Gabriela2076@gmail.com", "", "75.119.130.35", "2025-07-15 20:38:13", "2025-07-16 01:38:13", "Partner with us and earn recurring commissions—join the affiliate program! <a href=\"https://shorturl.fm/bscvc\" rel=\"nofollow ugc\">https://shorturl.fm/bscvc</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("286", "531", "Doris806", "Doris806@gmail.com", "", "75.119.130.35", "2025-07-15 20:38:42", "2025-07-16 01:38:42", "Share our products, reap the rewards—apply to our affiliate program! <a href=\"https://shorturl.fm/7kF8n\" rel=\"nofollow ugc\">https://shorturl.fm/7kF8n</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("287", "1", "Carol783", "Carol783@gmail.com", "", "75.119.130.35", "2025-07-15 20:39:13", "2025-07-16 01:39:13", "Partner with us for high-paying affiliate deals—join now! <a href=\"https://shorturl.fm/tVWhp\" rel=\"nofollow ugc\">https://shorturl.fm/tVWhp</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("288", "556", "Philip157", "Philip157@gmail.com", "", "85.9.209.195", "2025-07-16 05:49:02", "2025-07-16 10:49:02", "Monetize your traffic with our affiliate program—sign up now! <a href=\"https://shorturl.fm/HHSpr\" rel=\"nofollow ugc\">https://shorturl.fm/HHSpr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("289", "551", "Joe3825", "Joe3825@gmail.com", "", "85.9.209.195", "2025-07-16 05:49:31", "2025-07-16 10:49:31", "Promote our brand and watch your income grow—join today! <a href=\"https://shorturl.fm/arXsB\" rel=\"nofollow ugc\">https://shorturl.fm/arXsB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("290", "1", "Tony2526", "Tony2526@gmail.com", "", "85.9.209.195", "2025-07-16 05:50:11", "2025-07-16 10:50:11", "Promote our products and earn real money—apply today! <a href=\"https://shorturl.fm/fnkwL\" rel=\"nofollow ugc\">https://shorturl.fm/fnkwL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("291", "556", "Maureen1561", "Maureen1561@gmail.com", "", "117.201.136.32", "2025-07-16 08:08:30", "2025-07-16 13:08:30", "Join our affiliate family and watch your profits soar—sign up today! <a href=\"https://shorturl.fm/qdwlc\" rel=\"nofollow ugc\">https://shorturl.fm/qdwlc</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("292", "551", "Audrey2315", "Audrey2315@gmail.com", "", "117.201.136.32", "2025-07-16 08:08:58", "2025-07-16 13:08:58", "Partner with us and earn recurring commissions—join the affiliate program! <a href=\"https://shorturl.fm/V3Mn6\" rel=\"nofollow ugc\">https://shorturl.fm/V3Mn6</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("293", "531", "Kim2262", "Kim2262@gmail.com", "", "117.201.136.32", "2025-07-16 08:09:30", "2025-07-16 13:09:30", "Sign up now and access top-converting affiliate offers! <a href=\"https://shorturl.fm/6xenk\" rel=\"nofollow ugc\">https://shorturl.fm/6xenk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("294", "1", "Carla3268", "Carla3268@gmail.com", "", "117.201.136.32", "2025-07-16 08:09:59", "2025-07-16 13:09:59", "Share our offers and watch your wallet grow—become an affiliate! <a href=\"https://shorturl.fm/8eDk7\" rel=\"nofollow ugc\">https://shorturl.fm/8eDk7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("295", "556", "Coraline4319", "Coraline4319@gmail.com", "", "118.173.90.239", "2025-07-16 16:58:19", "2025-07-16 21:58:19", "Get started instantly—earn on every referral you make! <a href=\"https://shorturl.fm/9sYsJ\" rel=\"nofollow ugc\">https://shorturl.fm/9sYsJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("296", "551", "Emilia1585", "Emilia1585@gmail.com", "", "118.173.90.239", "2025-07-16 16:58:53", "2025-07-16 21:58:53", "Join our affiliate program and start earning commissions today—sign up now! <a href=\"https://shorturl.fm/ZEPtw\" rel=\"nofollow ugc\">https://shorturl.fm/ZEPtw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("297", "531", "Payton1020", "Payton1020@gmail.com", "", "118.173.90.239", "2025-07-16 17:01:04", "2025-07-16 22:01:04", "Tap into unlimited earning potential—become our affiliate partner! <a href=\"https://shorturl.fm/x1Lil\" rel=\"nofollow ugc\">https://shorturl.fm/x1Lil</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("298", "1", "Carrie769", "Carrie769@gmail.com", "", "118.173.90.239", "2025-07-16 17:01:45", "2025-07-16 22:01:45", "Earn passive income on autopilot—become our affiliate! <a href=\"https://shorturl.fm/H8gN1\" rel=\"nofollow ugc\">https://shorturl.fm/H8gN1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("299", "556", "Corey2588", "Corey2588@gmail.com", "", "35.209.133.197", "2025-07-16 21:07:45", "2025-07-17 02:07:45", "Earn big by sharing our offers—become an affiliate today! <a href=\"https://shorturl.fm/nX1eK\" rel=\"nofollow ugc\">https://shorturl.fm/nX1eK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("300", "531", "Esther4951", "Esther4951@gmail.com", "", "35.209.133.197", "2025-07-16 21:08:22", "2025-07-17 02:08:22", "Your influence, your income—join our affiliate network today! <a href=\"https://shorturl.fm/uiB4G\" rel=\"nofollow ugc\">https://shorturl.fm/uiB4G</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("301", "1", "Morgan620", "Morgan620@gmail.com", "", "35.209.133.197", "2025-07-16 21:08:50", "2025-07-17 02:08:50", "Join our affiliate program today and earn generous commissions! <a href=\"https://shorturl.fm/K9KpE\" rel=\"nofollow ugc\">https://shorturl.fm/K9KpE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("302", "556", "Kendall2994", "Kendall2994@gmail.com", "", "182.253.232.83", "2025-07-17 00:56:15", "2025-07-17 05:56:15", "Your audience, your profits—become an affiliate today! <a href=\"https://shorturl.fm/LfWsk\" rel=\"nofollow ugc\">https://shorturl.fm/LfWsk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("303", "551", "Amelia508", "Amelia508@gmail.com", "", "182.253.232.83", "2025-07-17 00:56:45", "2025-07-17 05:56:45", "Your audience, your profits—become an affiliate today! <a href=\"https://shorturl.fm/LfWsk\" rel=\"nofollow ugc\">https://shorturl.fm/LfWsk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("304", "531", "Colt780", "Colt780@gmail.com", "", "182.253.232.83", "2025-07-17 00:57:14", "2025-07-17 05:57:14", "Apply now and receive dedicated support for affiliates! <a href=\"https://shorturl.fm/naxbL\" rel=\"nofollow ugc\">https://shorturl.fm/naxbL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("305", "1", "Lillian4920", "Lillian4920@gmail.com", "", "182.253.232.83", "2025-07-17 00:57:43", "2025-07-17 05:57:43", "Start earning instantly—become our affiliate and earn on every sale! <a href=\"https://shorturl.fm/V6Rsy\" rel=\"nofollow ugc\">https://shorturl.fm/V6Rsy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("306", "556", "Jesse1573", "Jesse1573@gmail.com", "", "27.79.231.133", "2025-07-17 02:07:16", "2025-07-17 07:07:16", "Join our affiliate community and start earning instantly! <a href=\"https://shorturl.fm/RMTMn\" rel=\"nofollow ugc\">https://shorturl.fm/RMTMn</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("307", "551", "Kristin4736", "Kristin4736@gmail.com", "", "27.79.231.133", "2025-07-17 02:07:48", "2025-07-17 07:07:48", "Start earning passive income—join our affiliate network today! <a href=\"https://shorturl.fm/mZWTg\" rel=\"nofollow ugc\">https://shorturl.fm/mZWTg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("308", "556", "Karl1809", "Karl1809@gmail.com", "", "118.68.173.14", "2025-07-17 08:19:48", "2025-07-17 13:19:48", "Turn your network into income—apply to our affiliate program! <a href=\"https://shorturl.fm/rRjoE\" rel=\"nofollow ugc\">https://shorturl.fm/rRjoE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("309", "551", "Natalie4506", "Natalie4506@gmail.com", "", "118.68.173.14", "2025-07-17 08:20:14", "2025-07-17 13:20:14", "Join our affiliate community and maximize your profits—sign up now! <a href=\"https://shorturl.fm/QvgwE\" rel=\"nofollow ugc\">https://shorturl.fm/QvgwE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("310", "531", "Donald1404", "Donald1404@gmail.com", "", "118.68.173.14", "2025-07-17 08:20:41", "2025-07-17 13:20:41", "Join our affiliate community and maximize your profits—sign up now! <a href=\"https://shorturl.fm/QvgwE\" rel=\"nofollow ugc\">https://shorturl.fm/QvgwE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("311", "1", "Ivy1388", "Ivy1388@gmail.com", "", "118.68.173.14", "2025-07-17 08:21:07", "2025-07-17 13:21:07", "Drive sales and watch your affiliate earnings soar! <a href=\"https://shorturl.fm/i0Aer\" rel=\"nofollow ugc\">https://shorturl.fm/i0Aer</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("312", "556", "Vincent3091", "Vincent3091@gmail.com", "", "223.206.59.224", "2025-07-17 16:32:09", "2025-07-17 21:32:09", "Unlock top-tier commissions—become our affiliate partner now! <a href=\"https://shorturl.fm/rnYfx\" rel=\"nofollow ugc\">https://shorturl.fm/rnYfx</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("313", "551", "Gretchen754", "Gretchen754@gmail.com", "", "223.206.59.224", "2025-07-17 16:32:37", "2025-07-17 21:32:37", "Join our affiliate community and earn more—register now! <a href=\"https://shorturl.fm/MQ80E\" rel=\"nofollow ugc\">https://shorturl.fm/MQ80E</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("314", "531", "Frida2488", "Frida2488@gmail.com", "", "223.206.59.224", "2025-07-17 16:33:06", "2025-07-17 21:33:06", "Refer and earn up to 50% commission—join now! <a href=\"https://shorturl.fm/woU0p\" rel=\"nofollow ugc\">https://shorturl.fm/woU0p</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("315", "1", "Virginia1114", "Virginia1114@gmail.com", "", "223.206.59.224", "2025-07-17 16:33:35", "2025-07-17 21:33:35", "Refer friends, collect commissions—sign up now! <a href=\"https://shorturl.fm/m8F9c\" rel=\"nofollow ugc\">https://shorturl.fm/m8F9c</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("316", "556", "Peyton2705", "Peyton2705@gmail.com", "", "1.55.192.45", "2025-07-17 18:51:30", "2025-07-17 23:51:30", "Maximize your income with our high-converting offers—join as an affiliate! <a href=\"https://shorturl.fm/8gctp\" rel=\"nofollow ugc\">https://shorturl.fm/8gctp</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("317", "551", "Aubree428", "Aubree428@gmail.com", "", "1.55.192.45", "2025-07-17 18:52:04", "2025-07-17 23:52:04", "Partner with us and enjoy high payouts—apply now! <a href=\"https://shorturl.fm/gLYfE\" rel=\"nofollow ugc\">https://shorturl.fm/gLYfE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("318", "556", "Danny4070", "Danny4070@gmail.com", "", "34.93.145.116", "2025-07-18 00:12:49", "2025-07-18 05:12:49", "Partner with us and earn recurring commissions—join the affiliate program! <a href=\"https://shorturl.fm/RdpMV\" rel=\"nofollow ugc\">https://shorturl.fm/RdpMV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("319", "551", "Roy1249", "Roy1249@gmail.com", "", "34.93.145.116", "2025-07-18 00:13:14", "2025-07-18 05:13:14", "Share your link, earn rewards—sign up for our affiliate program! <a href=\"https://shorturl.fm/PEfz7\" rel=\"nofollow ugc\">https://shorturl.fm/PEfz7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("320", "531", "Israel4536", "Israel4536@gmail.com", "", "34.93.145.116", "2025-07-18 00:13:40", "2025-07-18 05:13:40", "Invite your network, boost your income—sign up for our affiliate program now! <a href=\"https://shorturl.fm/fz9mz\" rel=\"nofollow ugc\">https://shorturl.fm/fz9mz</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("321", "1", "Garrett3799", "Garrett3799@gmail.com", "", "34.93.145.116", "2025-07-18 00:14:06", "2025-07-18 05:14:06", "Join our affiliate family and watch your profits soar—sign up today! <a href=\"https://shorturl.fm/4yI7x\" rel=\"nofollow ugc\">https://shorturl.fm/4yI7x</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("322", "556", "Alison2670", "Alison2670@gmail.com", "", "103.183.10.188", "2025-07-18 01:04:05", "2025-07-18 06:04:05", "Earn recurring commissions with each referral—enroll today! <a href=\"https://shorturl.fm/MQZ15\" rel=\"nofollow ugc\">https://shorturl.fm/MQZ15</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("323", "551", "Maya4143", "Maya4143@gmail.com", "", "103.183.10.188", "2025-07-18 01:04:36", "2025-07-18 06:04:36", "Share your link, earn rewards—sign up for our affiliate program! <a href=\"https://shorturl.fm/RdCtp\" rel=\"nofollow ugc\">https://shorturl.fm/RdCtp</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("324", "1", "Lucia4674", "Lucia4674@gmail.com", "", "103.183.10.188", "2025-07-18 01:05:15", "2025-07-18 06:05:15", "Partner with us and enjoy high payouts—apply now! <a href=\"https://shorturl.fm/fQQ5d\" rel=\"nofollow ugc\">https://shorturl.fm/fQQ5d</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("325", "556", "Pedro3648", "Pedro3648@gmail.com", "", "110.164.197.82", "2025-07-18 09:16:53", "2025-07-18 14:16:53", "Get paid for every click—join our affiliate network now! <a href=\"https://shorturl.fm/vOfZO\" rel=\"nofollow ugc\">https://shorturl.fm/vOfZO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("326", "556", "Dina3081", "Dina3081@gmail.com", "", "134.236.40.121", "2025-07-18 14:13:05", "2025-07-18 19:13:05", "Your audience, your profits—become an affiliate today! <a href=\"https://shorturl.fm/WFMXa\" rel=\"nofollow ugc\">https://shorturl.fm/WFMXa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("327", "551", "Katie4158", "Katie4158@gmail.com", "", "134.236.40.121", "2025-07-18 14:13:35", "2025-07-18 19:13:35", "Tap into unlimited earnings—sign up for our affiliate program! <a href=\"https://shorturl.fm/1Yvdd\" rel=\"nofollow ugc\">https://shorturl.fm/1Yvdd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("328", "531", "Marvin3458", "Marvin3458@gmail.com", "", "134.236.40.121", "2025-07-18 14:14:06", "2025-07-18 19:14:06", "Your audience, your profits—become an affiliate today! <a href=\"https://shorturl.fm/WFMXa\" rel=\"nofollow ugc\">https://shorturl.fm/WFMXa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("329", "1", "Daniel3916", "Daniel3916@gmail.com", "", "134.236.40.121", "2025-07-18 14:14:37", "2025-07-18 19:14:37", "Partner with us for generous payouts—sign up today! <a href=\"https://shorturl.fm/bSI5Z\" rel=\"nofollow ugc\">https://shorturl.fm/bSI5Z</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("330", "556", "Grace4331", "Grace4331@gmail.com", "", "159.75.113.2", "2025-07-18 16:31:55", "2025-07-18 21:31:55", "Join our affiliate family and watch your profits soar—sign up today! <a href=\"https://shorturl.fm/Nk8Rh\" rel=\"nofollow ugc\">https://shorturl.fm/Nk8Rh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("331", "551", "Veronica4209", "Veronica4209@gmail.com", "", "159.75.113.2", "2025-07-18 16:32:24", "2025-07-18 21:32:24", "Join our affiliate program and watch your earnings skyrocket—sign up now! <a href=\"https://shorturl.fm/0TeeJ\" rel=\"nofollow ugc\">https://shorturl.fm/0TeeJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("332", "531", "Hazel4485", "Hazel4485@gmail.com", "", "159.75.113.2", "2025-07-18 16:32:51", "2025-07-18 21:32:51", "Start profiting from your network—sign up today! <a href=\"https://shorturl.fm/DZsqK\" rel=\"nofollow ugc\">https://shorturl.fm/DZsqK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("333", "1", "Bernadette1793", "Bernadette1793@gmail.com", "", "159.75.113.2", "2025-07-18 16:33:19", "2025-07-18 21:33:19", "Sign up now and access top-converting affiliate offers! <a href=\"https://shorturl.fm/9j7Gh\" rel=\"nofollow ugc\">https://shorturl.fm/9j7Gh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("334", "556", "Dean818", "Dean818@gmail.com", "", "171.249.209.64", "2025-07-19 01:42:11", "2025-07-19 06:42:11", "Unlock top-tier commissions—become our affiliate partner now! <a href=\"https://shorturl.fm/GPoVg\" rel=\"nofollow ugc\">https://shorturl.fm/GPoVg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("335", "551", "Brooks1389", "Brooks1389@gmail.com", "", "171.249.209.64", "2025-07-19 01:42:41", "2025-07-19 06:42:41", "Partner with us for high-paying affiliate deals—join now! <a href=\"https://shorturl.fm/E4a4x\" rel=\"nofollow ugc\">https://shorturl.fm/E4a4x</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("336", "531", "Michael3910", "Michael3910@gmail.com", "", "171.249.209.64", "2025-07-19 01:43:10", "2025-07-19 06:43:10", "Start earning on autopilot—become our affiliate partner! <a href=\"https://shorturl.fm/TRTin\" rel=\"nofollow ugc\">https://shorturl.fm/TRTin</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("337", "1", "Brooke433", "Brooke433@gmail.com", "", "171.249.209.64", "2025-07-19 01:43:39", "2025-07-19 06:43:39", "Become our partner and turn clicks into cash—join the affiliate program today! <a href=\"https://shorturl.fm/X51YP\" rel=\"nofollow ugc\">https://shorturl.fm/X51YP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("338", "556", "Lillian1167", "Lillian1167@gmail.com", "", "115.72.1.211", "2025-07-19 04:20:37", "2025-07-19 09:20:37", "Invite your network, boost your income—sign up for our affiliate program now! <a href=\"https://shorturl.fm/QPqjv\" rel=\"nofollow ugc\">https://shorturl.fm/QPqjv</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("339", "551", "Troy1515", "Troy1515@gmail.com", "", "115.72.1.211", "2025-07-19 04:21:05", "2025-07-19 09:21:05", "Partner with us and enjoy recurring commission payouts! <a href=\"https://shorturl.fm/YebfT\" rel=\"nofollow ugc\">https://shorturl.fm/YebfT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("340", "531", "Timothy3417", "Timothy3417@gmail.com", "", "115.72.1.211", "2025-07-19 04:21:34", "2025-07-19 09:21:34", "Unlock exclusive rewards with every referral—enroll now! <a href=\"https://shorturl.fm/vdSfI\" rel=\"nofollow ugc\">https://shorturl.fm/vdSfI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("341", "1", "Asia592", "Asia592@gmail.com", "", "115.72.1.211", "2025-07-19 04:22:04", "2025-07-19 09:22:04", "Earn big by sharing our offers—become an affiliate today! <a href=\"https://shorturl.fm/5OmQK\" rel=\"nofollow ugc\">https://shorturl.fm/5OmQK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("342", "556", "Mike436", "Mike436@gmail.com", "", "101.109.69.152", "2025-07-19 06:12:56", "2025-07-19 11:12:56", "Get rewarded for every recommendation—join our affiliate network! <a href=\"https://shorturl.fm/O6f4J\" rel=\"nofollow ugc\">https://shorturl.fm/O6f4J</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("343", "551", "Anna2267", "Anna2267@gmail.com", "", "101.109.69.152", "2025-07-19 06:13:26", "2025-07-19 11:13:26", "Maximize your income with our high-converting offers—join as an affiliate! <a href=\"https://shorturl.fm/pNrQA\" rel=\"nofollow ugc\">https://shorturl.fm/pNrQA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("344", "531", "Ariana4443", "Ariana4443@gmail.com", "", "101.109.69.152", "2025-07-19 06:13:56", "2025-07-19 11:13:56", "Promote our products—get paid for every sale you generate! <a href=\"https://shorturl.fm/AiA52\" rel=\"nofollow ugc\">https://shorturl.fm/AiA52</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("345", "1", "Madeline2730", "Madeline2730@gmail.com", "", "101.109.69.152", "2025-07-19 06:14:26", "2025-07-19 11:14:26", "Promote our products—get paid for every sale you generate! <a href=\"https://shorturl.fm/7k1tO\" rel=\"nofollow ugc\">https://shorturl.fm/7k1tO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("346", "556", "Cecilia778", "Cecilia778@gmail.com", "", "171.249.175.182", "2025-07-19 06:57:26", "2025-07-19 11:57:26", "Share our products and watch your earnings grow—join our affiliate program! <a href=\"https://shorturl.fm/DLbrJ\" rel=\"nofollow ugc\">https://shorturl.fm/DLbrJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("347", "551", "Alexia1365", "Alexia1365@gmail.com", "", "171.249.175.182", "2025-07-19 06:57:54", "2025-07-19 11:57:54", "Grow your income stream—apply to our affiliate program today! <a href=\"https://shorturl.fm/roWq8\" rel=\"nofollow ugc\">https://shorturl.fm/roWq8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("348", "531", "Ivan2313", "Ivan2313@gmail.com", "", "171.249.175.182", "2025-07-19 06:58:23", "2025-07-19 11:58:23", "Join our affiliate program today and start earning up to 30% commission—sign up now! <a href=\"https://shorturl.fm/oTWDr\" rel=\"nofollow ugc\">https://shorturl.fm/oTWDr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("349", "1", "Carl37", "Carl37@gmail.com", "", "171.249.175.182", "2025-07-19 06:58:54", "2025-07-19 11:58:54", "Promote our products—get paid for every sale you generate! <a href=\"https://shorturl.fm/7k1tO\" rel=\"nofollow ugc\">https://shorturl.fm/7k1tO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("350", "556", "Haleigh323", "Haleigh323@gmail.com", "", "115.77.173.54", "2025-07-20 04:54:14", "2025-07-20 09:54:14", "Boost your income—enroll in our affiliate program today! <a href=\"https://shorturl.fm/JIRe7\" rel=\"nofollow ugc\">https://shorturl.fm/JIRe7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("351", "551", "Preston2224", "Preston2224@gmail.com", "", "115.77.173.54", "2025-07-20 04:54:45", "2025-07-20 09:54:45", "Be rewarded for every click—join our affiliate program today! <a href=\"https://shorturl.fm/k1Uco\" rel=\"nofollow ugc\">https://shorturl.fm/k1Uco</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("352", "531", "Aliyah2647", "Aliyah2647@gmail.com", "", "115.77.173.54", "2025-07-20 04:55:14", "2025-07-20 09:55:14", "Monetize your audience with our high-converting offers—apply today! <a href=\"https://shorturl.fm/zi2hE\" rel=\"nofollow ugc\">https://shorturl.fm/zi2hE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("353", "1", "Emery726", "Emery726@gmail.com", "", "115.77.173.54", "2025-07-20 04:55:43", "2025-07-20 09:55:43", "Share our products, reap the rewards—apply to our affiliate program! <a href=\"https://shorturl.fm/Fgy1A\" rel=\"nofollow ugc\">https://shorturl.fm/Fgy1A</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("354", "556", "Johnny1331", "Johnny1331@gmail.com", "", "134.35.22.204", "2025-07-20 07:36:14", "2025-07-20 12:36:14", "Earn passive income this month—become an affiliate partner and get paid! <a href=\"https://shorturl.fm/HDwFa\" rel=\"nofollow ugc\">https://shorturl.fm/HDwFa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("355", "551", "Amelia272", "Amelia272@gmail.com", "", "134.35.22.204", "2025-07-20 07:36:43", "2025-07-20 12:36:43", "Unlock exclusive rewards with every referral—apply to our affiliate program now! <a href=\"https://shorturl.fm/6cTb9\" rel=\"nofollow ugc\">https://shorturl.fm/6cTb9</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("356", "1", "Hendrix2424", "Hendrix2424@gmail.com", "", "134.35.22.204", "2025-07-20 07:37:23", "2025-07-20 12:37:23", "Earn passive income on autopilot—become our affiliate! <a href=\"https://shorturl.fm/LKMZS\" rel=\"nofollow ugc\">https://shorturl.fm/LKMZS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("357", "556", "Kira3019", "Kira3019@gmail.com", "", "42.119.98.220", "2025-07-20 20:24:16", "2025-07-21 01:24:16", "<a href=\"https://shorturl.fm/DCQgy\" rel=\"nofollow ugc\">https://shorturl.fm/DCQgy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("358", "556", "Adelyn4952", "Adelyn4952@gmail.com", "", "113.22.48.9", "2025-07-21 04:41:47", "2025-07-21 09:41:47", "<a href=\"https://shorturl.fm/PzSIr\" rel=\"nofollow ugc\">https://shorturl.fm/PzSIr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("359", "551", "Annie2171", "Annie2171@gmail.com", "", "113.22.48.9", "2025-07-21 04:42:15", "2025-07-21 09:42:15", "<a href=\"https://shorturl.fm/iDogH\" rel=\"nofollow ugc\">https://shorturl.fm/iDogH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("360", "531", "Felix1758", "Felix1758@gmail.com", "", "113.22.48.9", "2025-07-21 04:42:44", "2025-07-21 09:42:44", "<a href=\"https://shorturl.fm/UP2rx\" rel=\"nofollow ugc\">https://shorturl.fm/UP2rx</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("361", "1", "Paige780", "Paige780@gmail.com", "", "113.22.48.9", "2025-07-21 04:43:12", "2025-07-21 09:43:12", "<a href=\"https://shorturl.fm/U2WYN\" rel=\"nofollow ugc\">https://shorturl.fm/U2WYN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("362", "556", "Clyde1979", "Clyde1979@gmail.com", "", "171.228.170.149", "2025-07-21 05:32:26", "2025-07-21 10:32:26", "<a href=\"https://shorturl.fm/8rAQd\" rel=\"nofollow ugc\">https://shorturl.fm/8rAQd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("363", "531", "Dwight1058", "Dwight1058@gmail.com", "", "171.228.170.149", "2025-07-21 05:32:55", "2025-07-21 10:32:55", "<a href=\"https://shorturl.fm/beCzE\" rel=\"nofollow ugc\">https://shorturl.fm/beCzE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("364", "556", "Adelyn1465", "Adelyn1465@gmail.com", "", "101.51.165.50", "2025-07-21 06:46:34", "2025-07-21 11:46:34", "<a href=\"https://shorturl.fm/iWDlT\" rel=\"nofollow ugc\">https://shorturl.fm/iWDlT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("365", "551", "Steve268", "Steve268@gmail.com", "", "101.51.165.50", "2025-07-21 06:47:03", "2025-07-21 11:47:03", "<a href=\"https://shorturl.fm/Z5GwS\" rel=\"nofollow ugc\">https://shorturl.fm/Z5GwS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("366", "531", "Ellie4416", "Ellie4416@gmail.com", "", "101.51.165.50", "2025-07-21 06:47:32", "2025-07-21 11:47:32", "<a href=\"https://shorturl.fm/Y3vOR\" rel=\"nofollow ugc\">https://shorturl.fm/Y3vOR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("367", "1", "Norman1645", "Norman1645@gmail.com", "", "101.51.165.50", "2025-07-21 06:48:00", "2025-07-21 11:48:00", "<a href=\"https://shorturl.fm/sKezm\" rel=\"nofollow ugc\">https://shorturl.fm/sKezm</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("368", "556", "Celia5000", "Celia5000@gmail.com", "", "171.241.137.200", "2025-07-21 21:05:39", "2025-07-22 02:05:39", "<a href=\"https://shorturl.fm/BLICy\" rel=\"nofollow ugc\">https://shorturl.fm/BLICy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("369", "551", "Antonio1144", "Antonio1144@gmail.com", "", "171.241.137.200", "2025-07-21 21:06:05", "2025-07-22 02:06:05", "<a href=\"https://shorturl.fm/AQJ6q\" rel=\"nofollow ugc\">https://shorturl.fm/AQJ6q</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("370", "531", "Dylan1815", "Dylan1815@gmail.com", "", "171.241.137.200", "2025-07-21 21:06:31", "2025-07-22 02:06:31", "<a href=\"https://shorturl.fm/r9CRL\" rel=\"nofollow ugc\">https://shorturl.fm/r9CRL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("371", "1", "Lee1416", "Lee1416@gmail.com", "", "171.241.137.200", "2025-07-21 21:06:56", "2025-07-22 02:06:56", "<a href=\"https://shorturl.fm/Y1mnF\" rel=\"nofollow ugc\">https://shorturl.fm/Y1mnF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("372", "556", "Anna4185", "Anna4185@gmail.com", "", "42.112.96.61", "2025-07-21 21:26:26", "2025-07-22 02:26:26", "<a href=\"https://shorturl.fm/bvYkw\" rel=\"nofollow ugc\">https://shorturl.fm/bvYkw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("373", "551", "Harlan158", "Harlan158@gmail.com", "", "42.112.96.61", "2025-07-21 21:26:55", "2025-07-22 02:26:55", "<a href=\"https://shorturl.fm/SA4ju\" rel=\"nofollow ugc\">https://shorturl.fm/SA4ju</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("374", "531", "Lindsey2477", "Lindsey2477@gmail.com", "", "42.112.96.61", "2025-07-21 21:27:19", "2025-07-22 02:27:19", "<a href=\"https://shorturl.fm/PBwUA\" rel=\"nofollow ugc\">https://shorturl.fm/PBwUA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("375", "1", "Jayla101", "Jayla101@gmail.com", "", "42.112.96.61", "2025-07-21 21:27:47", "2025-07-22 02:27:47", "<a href=\"https://shorturl.fm/AsVKX\" rel=\"nofollow ugc\">https://shorturl.fm/AsVKX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("376", "556", "Jenna915", "Jenna915@gmail.com", "", "27.79.229.27", "2025-07-21 21:33:45", "2025-07-22 02:33:45", "<a href=\"https://shorturl.fm/BLICy\" rel=\"nofollow ugc\">https://shorturl.fm/BLICy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("377", "551", "Aileen3772", "Aileen3772@gmail.com", "", "27.79.229.27", "2025-07-21 21:34:13", "2025-07-22 02:34:13", "<a href=\"https://shorturl.fm/PBwUA\" rel=\"nofollow ugc\">https://shorturl.fm/PBwUA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("378", "531", "Don4914", "Don4914@gmail.com", "", "27.79.229.27", "2025-07-21 21:34:51", "2025-07-22 02:34:51", "<a href=\"https://shorturl.fm/SaASH\" rel=\"nofollow ugc\">https://shorturl.fm/SaASH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("379", "1", "Valentina2539", "Valentina2539@gmail.com", "", "27.79.229.27", "2025-07-21 21:35:06", "2025-07-22 02:35:06", "<a href=\"https://shorturl.fm/DGE7c\" rel=\"nofollow ugc\">https://shorturl.fm/DGE7c</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("380", "1", "Jenna4951", "Jenna4951@gmail.com", "", "197.164.101.10", "2025-07-22 01:26:04", "2025-07-22 06:26:04", "<a href=\"https://shorturl.fm/kPolq\" rel=\"nofollow ugc\">https://shorturl.fm/kPolq</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("381", "556", "Kim4009", "Kim4009@gmail.com", "", "186.225.231.9", "2025-07-22 02:05:26", "2025-07-22 07:05:26", "<a href=\"https://shorturl.fm/JyUpt\" rel=\"nofollow ugc\">https://shorturl.fm/JyUpt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("382", "551", "Marian3030", "Marian3030@gmail.com", "", "186.225.231.9", "2025-07-22 02:05:50", "2025-07-22 07:05:50", "<a href=\"https://shorturl.fm/dctKr\" rel=\"nofollow ugc\">https://shorturl.fm/dctKr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("383", "531", "Alejandro2596", "Alejandro2596@gmail.com", "", "186.225.231.9", "2025-07-22 02:06:14", "2025-07-22 07:06:14", "<a href=\"https://shorturl.fm/opkse\" rel=\"nofollow ugc\">https://shorturl.fm/opkse</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("384", "1", "Esperanza3274", "Esperanza3274@gmail.com", "", "186.225.231.9", "2025-07-22 02:06:38", "2025-07-22 07:06:38", "<a href=\"https://shorturl.fm/qbowY\" rel=\"nofollow ugc\">https://shorturl.fm/qbowY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("385", "556", "Steve2983", "Steve2983@gmail.com", "", "124.222.42.171", "2025-07-22 05:19:10", "2025-07-22 10:19:10", "<a href=\"https://shorturl.fm/TF4Kg\" rel=\"nofollow ugc\">https://shorturl.fm/TF4Kg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("386", "556", "Kathy4697", "Kathy4697@gmail.com", "", "1.54.175.230", "2025-07-22 19:40:36", "2025-07-23 00:40:36", "<a href=\"https://shorturl.fm/kNXNF\" rel=\"nofollow ugc\">https://shorturl.fm/kNXNF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("387", "556", "Jesse4576", "Jesse4576@gmail.com", "", "124.222.42.171", "2025-07-22 20:43:21", "2025-07-23 01:43:21", "<a href=\"https://shorturl.fm/OyI5y\" rel=\"nofollow ugc\">https://shorturl.fm/OyI5y</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("388", "556", "Jenna971", "Jenna971@gmail.com", "", "95.38.78.208", "2025-07-23 01:05:12", "2025-07-23 06:05:12", "<a href=\"https://shorturl.fm/r21ML\" rel=\"nofollow ugc\">https://shorturl.fm/r21ML</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("389", "1", "Celeste3807", "Celeste3807@gmail.com", "", "95.38.78.208", "2025-07-23 01:05:56", "2025-07-23 06:05:56", "<a href=\"https://shorturl.fm/mkEur\" rel=\"nofollow ugc\">https://shorturl.fm/mkEur</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("390", "556", "Martha3101", "Martha3101@gmail.com", "", "222.127.70.8", "2025-07-23 05:52:06", "2025-07-23 10:52:06", "<a href=\"https://shorturl.fm/27ZAE\" rel=\"nofollow ugc\">https://shorturl.fm/27ZAE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("391", "551", "Eliza352", "Eliza352@gmail.com", "", "222.127.70.8", "2025-07-23 05:52:32", "2025-07-23 10:52:32", "<a href=\"https://shorturl.fm/wBQSD\" rel=\"nofollow ugc\">https://shorturl.fm/wBQSD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("392", "531", "Brady2744", "Brady2744@gmail.com", "", "222.127.70.8", "2025-07-23 05:52:58", "2025-07-23 10:52:58", "<a href=\"https://shorturl.fm/mMUY0\" rel=\"nofollow ugc\">https://shorturl.fm/mMUY0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("393", "1", "Colt2585", "Colt2585@gmail.com", "", "222.127.70.8", "2025-07-23 05:53:24", "2025-07-23 10:53:24", "<a href=\"https://shorturl.fm/PPXVG\" rel=\"nofollow ugc\">https://shorturl.fm/PPXVG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("394", "556", "Douglas3797", "Douglas3797@gmail.com", "", "138.199.58.36", "2025-07-23 07:15:37", "2025-07-23 12:15:37", "<a href=\"https://shorturl.fm/rsOm6\" rel=\"nofollow ugc\">https://shorturl.fm/rsOm6</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("395", "551", "Olivia1412", "Olivia1412@gmail.com", "", "138.199.58.36", "2025-07-23 07:15:59", "2025-07-23 12:15:59", "<a href=\"https://shorturl.fm/ycMqz\" rel=\"nofollow ugc\">https://shorturl.fm/ycMqz</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("396", "531", "Lillian2451", "Lillian2451@gmail.com", "", "138.199.58.36", "2025-07-23 07:16:23", "2025-07-23 12:16:23", "<a href=\"https://shorturl.fm/WEK6e\" rel=\"nofollow ugc\">https://shorturl.fm/WEK6e</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("397", "1", "Marcel869", "Marcel869@gmail.com", "", "138.199.58.36", "2025-07-23 07:16:48", "2025-07-23 12:16:48", "<a href=\"https://shorturl.fm/r9O4W\" rel=\"nofollow ugc\">https://shorturl.fm/r9O4W</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("398", "551", "Allan644", "Allan644@gmail.com", "", "1.179.239.64", "2025-07-23 13:07:56", "2025-07-23 18:07:56", "<a href=\"https://shorturl.fm/2t6s9\" rel=\"nofollow ugc\">https://shorturl.fm/2t6s9</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("399", "531", "Eduardo3310", "Eduardo3310@gmail.com", "", "1.179.239.64", "2025-07-23 13:08:20", "2025-07-23 18:08:20", "<a href=\"https://shorturl.fm/S1ooU\" rel=\"nofollow ugc\">https://shorturl.fm/S1ooU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("400", "1", "Adele969", "Adele969@gmail.com", "", "1.179.239.64", "2025-07-23 13:08:47", "2025-07-23 18:08:47", "<a href=\"https://shorturl.fm/FwCWL\" rel=\"nofollow ugc\">https://shorturl.fm/FwCWL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("401", "556", "Leah3405", "Leah3405@gmail.com", "", "115.72.162.219", "2025-07-23 16:33:58", "2025-07-23 21:33:58", "<a href=\"https://shorturl.fm/7DPVt\" rel=\"nofollow ugc\">https://shorturl.fm/7DPVt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("402", "551", "Carson2904", "Carson2904@gmail.com", "", "115.72.162.219", "2025-07-23 16:34:22", "2025-07-23 21:34:22", "<a href=\"https://shorturl.fm/qPzi3\" rel=\"nofollow ugc\">https://shorturl.fm/qPzi3</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("403", "531", "Jack280", "Jack280@gmail.com", "", "115.72.162.219", "2025-07-23 16:34:46", "2025-07-23 21:34:46", "<a href=\"https://shorturl.fm/7DPVt\" rel=\"nofollow ugc\">https://shorturl.fm/7DPVt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("404", "1", "Lincoln1846", "Lincoln1846@gmail.com", "", "115.72.162.219", "2025-07-23 16:35:09", "2025-07-23 21:35:09", "<a href=\"https://shorturl.fm/qPzi3\" rel=\"nofollow ugc\">https://shorturl.fm/qPzi3</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("405", "556", "Pamela1526", "Pamela1526@gmail.com", "", "219.140.150.244", "2025-07-24 00:24:16", "2025-07-24 05:24:16", "<a href=\"https://shorturl.fm/quVAq\" rel=\"nofollow ugc\">https://shorturl.fm/quVAq</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("406", "551", "Enrique4373", "Enrique4373@gmail.com", "", "219.140.150.244", "2025-07-24 00:24:44", "2025-07-24 05:24:44", "<a href=\"https://shorturl.fm/4QILb\" rel=\"nofollow ugc\">https://shorturl.fm/4QILb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("407", "531", "Angelo1866", "Angelo1866@gmail.com", "", "219.140.150.244", "2025-07-24 00:25:13", "2025-07-24 05:25:13", "<a href=\"https://shorturl.fm/gL8wm\" rel=\"nofollow ugc\">https://shorturl.fm/gL8wm</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("408", "1", "Kathryn1567", "Kathryn1567@gmail.com", "", "219.140.150.244", "2025-07-24 00:25:41", "2025-07-24 05:25:41", "<a href=\"https://shorturl.fm/quVAq\" rel=\"nofollow ugc\">https://shorturl.fm/quVAq</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("409", "556", "Edwin3469", "Edwin3469@gmail.com", "", "1.53.67.90", "2025-07-24 16:34:08", "2025-07-24 21:34:08", "<a href=\"https://shorturl.fm/8z1AV\" rel=\"nofollow ugc\">https://shorturl.fm/8z1AV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("410", "531", "Alonzo4982", "Alonzo4982@gmail.com", "", "1.53.67.90", "2025-07-24 16:34:46", "2025-07-24 21:34:46", "<a href=\"https://shorturl.fm/EqAcC\" rel=\"nofollow ugc\">https://shorturl.fm/EqAcC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("411", "1", "Mara2700", "Mara2700@gmail.com", "", "1.53.67.90", "2025-07-24 16:35:15", "2025-07-24 21:35:15", "<a href=\"https://shorturl.fm/FJgZA\" rel=\"nofollow ugc\">https://shorturl.fm/FJgZA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("412", "556", "Dave4930", "Dave4930@gmail.com", "", "134.35.19.231", "2025-07-24 19:49:08", "2025-07-25 00:49:08", "<a href=\"https://shorturl.fm/Tdjho\" rel=\"nofollow ugc\">https://shorturl.fm/Tdjho</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("413", "551", "Genesis3286", "Genesis3286@gmail.com", "", "134.35.19.231", "2025-07-24 19:49:37", "2025-07-25 00:49:37", "<a href=\"https://shorturl.fm/RmpwU\" rel=\"nofollow ugc\">https://shorturl.fm/RmpwU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("414", "531", "Erica3750", "Erica3750@gmail.com", "", "134.35.19.231", "2025-07-24 19:50:06", "2025-07-25 00:50:06", "<a href=\"https://shorturl.fm/P8Yiq\" rel=\"nofollow ugc\">https://shorturl.fm/P8Yiq</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("415", "1", "Kenneth4244", "Kenneth4244@gmail.com", "", "134.35.19.231", "2025-07-24 19:50:34", "2025-07-25 00:50:34", "<a href=\"https://shorturl.fm/fCKOg\" rel=\"nofollow ugc\">https://shorturl.fm/fCKOg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("416", "556", "Ignacio1478", "Ignacio1478@gmail.com", "", "171.237.118.226", "2025-07-25 01:37:59", "2025-07-25 06:37:59", "<a href=\"https://shorturl.fm/bqe3q\" rel=\"nofollow ugc\">https://shorturl.fm/bqe3q</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("417", "551", "Adelyn4572", "Adelyn4572@gmail.com", "", "171.237.118.226", "2025-07-25 01:38:27", "2025-07-25 06:38:27", "<a href=\"https://shorturl.fm/Z5rPW\" rel=\"nofollow ugc\">https://shorturl.fm/Z5rPW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("418", "531", "Oscar1447", "Oscar1447@gmail.com", "", "171.237.118.226", "2025-07-25 01:38:54", "2025-07-25 06:38:54", "<a href=\"https://shorturl.fm/Sn5f7\" rel=\"nofollow ugc\">https://shorturl.fm/Sn5f7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("419", "1", "Trinity4574", "Trinity4574@gmail.com", "", "171.237.118.226", "2025-07-25 01:39:23", "2025-07-25 06:39:23", "<a href=\"https://shorturl.fm/G74qJ\" rel=\"nofollow ugc\">https://shorturl.fm/G74qJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("420", "556", "Easton1144", "Easton1144@gmail.com", "", "223.206.90.19", "2025-07-25 04:12:12", "2025-07-25 09:12:12", "<a href=\"https://shorturl.fm/F3S5m\" rel=\"nofollow ugc\">https://shorturl.fm/F3S5m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("421", "551", "Aline2577", "Aline2577@gmail.com", "", "223.206.90.19", "2025-07-25 04:12:40", "2025-07-25 09:12:40", "<a href=\"https://shorturl.fm/o6Pa2\" rel=\"nofollow ugc\">https://shorturl.fm/o6Pa2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("422", "531", "Steven1116", "Steven1116@gmail.com", "", "223.206.90.19", "2025-07-25 04:13:06", "2025-07-25 09:13:06", "<a href=\"https://shorturl.fm/wo5dj\" rel=\"nofollow ugc\">https://shorturl.fm/wo5dj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("423", "1", "Troy3060", "Troy3060@gmail.com", "", "223.206.90.19", "2025-07-25 04:13:32", "2025-07-25 09:13:32", "<a href=\"https://shorturl.fm/A1YZ0\" rel=\"nofollow ugc\">https://shorturl.fm/A1YZ0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("424", "556", "Darwin2875", "Darwin2875@gmail.com", "", "173.212.204.225", "2025-07-25 05:28:42", "2025-07-25 10:28:42", "<a href=\"https://shorturl.fm/a037O\" rel=\"nofollow ugc\">https://shorturl.fm/a037O</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("425", "551", "Gianna4435", "Gianna4435@gmail.com", "", "173.212.204.225", "2025-07-25 05:29:06", "2025-07-25 10:29:06", "<a href=\"https://shorturl.fm/F3S5m\" rel=\"nofollow ugc\">https://shorturl.fm/F3S5m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("426", "531", "Hilda3413", "Hilda3413@gmail.com", "", "173.212.204.225", "2025-07-25 05:29:32", "2025-07-25 10:29:32", "<a href=\"https://shorturl.fm/wo5dj\" rel=\"nofollow ugc\">https://shorturl.fm/wo5dj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("427", "1", "Harlan1629", "Harlan1629@gmail.com", "", "173.212.204.225", "2025-07-25 05:29:59", "2025-07-25 10:29:59", "<a href=\"https://shorturl.fm/t9MT9\" rel=\"nofollow ugc\">https://shorturl.fm/t9MT9</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("428", "556", "Gabriela4270", "Gabriela4270@gmail.com", "", "222.118.12.150", "2025-07-25 07:47:31", "2025-07-25 12:47:31", "<a href=\"https://shorturl.fm/CPlHL\" rel=\"nofollow ugc\">https://shorturl.fm/CPlHL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("429", "551", "Bruce2602", "Bruce2602@gmail.com", "", "222.118.12.150", "2025-07-25 07:47:57", "2025-07-25 12:47:57", "<a href=\"https://shorturl.fm/W8CvZ\" rel=\"nofollow ugc\">https://shorturl.fm/W8CvZ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("430", "531", "Lola1821", "Lola1821@gmail.com", "", "222.118.12.150", "2025-07-25 07:48:24", "2025-07-25 12:48:24", "<a href=\"https://shorturl.fm/cqK1o\" rel=\"nofollow ugc\">https://shorturl.fm/cqK1o</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("431", "1", "Shawn3041", "Shawn3041@gmail.com", "", "222.118.12.150", "2025-07-25 07:48:50", "2025-07-25 12:48:50", "<a href=\"https://shorturl.fm/7NlED\" rel=\"nofollow ugc\">https://shorturl.fm/7NlED</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("432", "556", "Hailee45", "Hailee45@gmail.com", "", "179.1.192.137", "2025-07-25 11:00:36", "2025-07-25 16:00:36", "<a href=\"https://shorturl.fm/CL8CP\" rel=\"nofollow ugc\">https://shorturl.fm/CL8CP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("433", "551", "Daria1994", "Daria1994@gmail.com", "", "179.1.192.137", "2025-07-25 11:01:06", "2025-07-25 16:01:06", "<a href=\"https://shorturl.fm/AAzWR\" rel=\"nofollow ugc\">https://shorturl.fm/AAzWR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("434", "531", "Theo739", "Theo739@gmail.com", "", "179.1.192.137", "2025-07-25 11:01:40", "2025-07-25 16:01:40", "<a href=\"https://shorturl.fm/XkbiO\" rel=\"nofollow ugc\">https://shorturl.fm/XkbiO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("435", "556", "Maddison1690", "Maddison1690@gmail.com", "", "103.125.173.5", "2025-07-26 00:21:21", "2025-07-26 05:21:21", "<a href=\"https://shorturl.fm/msyDn\" rel=\"nofollow ugc\">https://shorturl.fm/msyDn</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("436", "551", "Daphne4676", "Daphne4676@gmail.com", "", "103.125.173.5", "2025-07-26 00:21:46", "2025-07-26 05:21:46", "<a href=\"https://shorturl.fm/0wbS1\" rel=\"nofollow ugc\">https://shorturl.fm/0wbS1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("437", "531", "Derek4306", "Derek4306@gmail.com", "", "103.125.173.5", "2025-07-26 00:22:13", "2025-07-26 05:22:13", "<a href=\"https://shorturl.fm/cVnkg\" rel=\"nofollow ugc\">https://shorturl.fm/cVnkg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("438", "1", "Rose148", "Rose148@gmail.com", "", "103.125.173.5", "2025-07-26 00:22:40", "2025-07-26 05:22:40", "<a href=\"https://shorturl.fm/lKzRm\" rel=\"nofollow ugc\">https://shorturl.fm/lKzRm</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("439", "556", "Daria1178", "Daria1178@gmail.com", "", "49.48.41.113", "2025-07-26 06:39:00", "2025-07-26 11:39:00", "<a href=\"https://shorturl.fm/toX2k\" rel=\"nofollow ugc\">https://shorturl.fm/toX2k</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("440", "531", "Evelyn594", "Evelyn594@gmail.com", "", "49.48.41.113", "2025-07-26 06:39:37", "2025-07-26 11:39:37", "<a href=\"https://shorturl.fm/umMJj\" rel=\"nofollow ugc\">https://shorturl.fm/umMJj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("441", "1", "Simon3760", "Simon3760@gmail.com", "", "49.48.41.113", "2025-07-26 06:40:04", "2025-07-26 11:40:04", "<a href=\"https://shorturl.fm/eACfZ\" rel=\"nofollow ugc\">https://shorturl.fm/eACfZ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("442", "556", "Troy4784", "Troy4784@gmail.com", "", "103.60.175.72", "2025-07-26 07:38:34", "2025-07-26 12:38:34", "<a href=\"https://shorturl.fm/ajcMh\" rel=\"nofollow ugc\">https://shorturl.fm/ajcMh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("443", "551", "Lee3826", "Lee3826@gmail.com", "", "103.60.175.72", "2025-07-26 07:39:06", "2025-07-26 12:39:06", "<a href=\"https://shorturl.fm/DcMGY\" rel=\"nofollow ugc\">https://shorturl.fm/DcMGY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("444", "531", "Taylor2490", "Taylor2490@gmail.com", "", "103.60.175.72", "2025-07-26 07:39:35", "2025-07-26 12:39:35", "<a href=\"https://shorturl.fm/kgu1a\" rel=\"nofollow ugc\">https://shorturl.fm/kgu1a</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("445", "1", "Parker2684", "Parker2684@gmail.com", "", "103.60.175.72", "2025-07-26 07:40:04", "2025-07-26 12:40:04", "<a href=\"https://shorturl.fm/3Rnur\" rel=\"nofollow ugc\">https://shorturl.fm/3Rnur</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("446", "556", "Douglas952", "Douglas952@gmail.com", "", "124.83.105.209", "2025-07-26 10:13:27", "2025-07-26 15:13:27", "<a href=\"https://shorturl.fm/iFCvl\" rel=\"nofollow ugc\">https://shorturl.fm/iFCvl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("447", "551", "Amalia4670", "Amalia4670@gmail.com", "", "124.83.105.209", "2025-07-26 10:13:56", "2025-07-26 15:13:56", "<a href=\"https://shorturl.fm/ProZr\" rel=\"nofollow ugc\">https://shorturl.fm/ProZr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("448", "531", "Roy93", "Roy93@gmail.com", "", "124.83.105.209", "2025-07-26 10:14:24", "2025-07-26 15:14:24", "<a href=\"https://shorturl.fm/IfN0l\" rel=\"nofollow ugc\">https://shorturl.fm/IfN0l</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("449", "1", "Kyle1628", "Kyle1628@gmail.com", "", "124.83.105.209", "2025-07-26 10:14:52", "2025-07-26 15:14:52", "<a href=\"https://shorturl.fm/FYDDR\" rel=\"nofollow ugc\">https://shorturl.fm/FYDDR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("450", "556", "Tara1536", "Tara1536@gmail.com", "", "123.16.59.185", "2025-07-27 06:20:57", "2025-07-27 11:20:57", "<a href=\"https://shorturl.fm/jC0LZ\" rel=\"nofollow ugc\">https://shorturl.fm/jC0LZ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("451", "551", "Jose4669", "Jose4669@gmail.com", "", "123.16.59.185", "2025-07-27 06:21:25", "2025-07-27 11:21:25", "<a href=\"https://shorturl.fm/ZWYHN\" rel=\"nofollow ugc\">https://shorturl.fm/ZWYHN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("452", "531", "Giovanni138", "Giovanni138@gmail.com", "", "123.16.59.185", "2025-07-27 06:21:55", "2025-07-27 11:21:55", "<a href=\"https://shorturl.fm/TcHFF\" rel=\"nofollow ugc\">https://shorturl.fm/TcHFF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("453", "1", "Gracie4772", "Gracie4772@gmail.com", "", "123.16.59.185", "2025-07-27 06:22:25", "2025-07-27 11:22:25", "<a href=\"https://shorturl.fm/7bA6F\" rel=\"nofollow ugc\">https://shorturl.fm/7bA6F</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("454", "556", "Krystal3887", "Krystal3887@gmail.com", "", "112.202.52.157", "2025-07-27 07:55:29", "2025-07-27 12:55:29", "<a href=\"https://shorturl.fm/79Jwv\" rel=\"nofollow ugc\">https://shorturl.fm/79Jwv</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("455", "531", "Abbie2121", "Abbie2121@gmail.com", "", "112.202.52.157", "2025-07-27 07:56:10", "2025-07-27 12:56:10", "<a href=\"https://shorturl.fm/jC0LZ\" rel=\"nofollow ugc\">https://shorturl.fm/jC0LZ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("456", "556", "Camryn1414", "Camryn1414@gmail.com", "", "91.231.252.221", "2025-07-27 16:57:54", "2025-07-27 21:57:54", "<a href=\"https://shorturl.fm/F5m1C\" rel=\"nofollow ugc\">https://shorturl.fm/F5m1C</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("457", "551", "Hermione1934", "Hermione1934@gmail.com", "", "91.231.252.221", "2025-07-27 16:58:25", "2025-07-27 21:58:25", "<a href=\"https://shorturl.fm/n5bNh\" rel=\"nofollow ugc\">https://shorturl.fm/n5bNh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("458", "531", "Sebastian3206", "Sebastian3206@gmail.com", "", "91.231.252.221", "2025-07-27 16:58:56", "2025-07-27 21:58:56", "<a href=\"https://shorturl.fm/lfJdP\" rel=\"nofollow ugc\">https://shorturl.fm/lfJdP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("459", "1", "Desirae3843", "Desirae3843@gmail.com", "", "91.231.252.221", "2025-07-27 16:59:23", "2025-07-27 21:59:23", "<a href=\"https://shorturl.fm/TM1il\" rel=\"nofollow ugc\">https://shorturl.fm/TM1il</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("460", "556", "Seth3738", "Seth3738@gmail.com", "", "27.3.119.203", "2025-07-28 01:55:06", "2025-07-28 06:55:06", "<a href=\"https://shorturl.fm/fW42d\" rel=\"nofollow ugc\">https://shorturl.fm/fW42d</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("461", "551", "Marley4996", "Marley4996@gmail.com", "", "27.3.119.203", "2025-07-28 01:55:42", "2025-07-28 06:55:42", "<a href=\"https://shorturl.fm/KrXO4\" rel=\"nofollow ugc\">https://shorturl.fm/KrXO4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("462", "556", "Felix1300", "Felix1300@gmail.com", "", "113.53.48.16", "2025-07-28 06:13:15", "2025-07-28 11:13:15", "<a href=\"https://shorturl.fm/KhnyT\" rel=\"nofollow ugc\">https://shorturl.fm/KhnyT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("463", "556", "Ivan4932", "Ivan4932@gmail.com", "", "138.118.236.70", "2025-07-28 11:25:53", "2025-07-28 16:25:53", "<a href=\"https://shorturl.fm/uSfJc\" rel=\"nofollow ugc\">https://shorturl.fm/uSfJc</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("464", "551", "Rex461", "Rex461@gmail.com", "", "138.118.236.70", "2025-07-28 11:26:20", "2025-07-28 16:26:20", "<a href=\"https://shorturl.fm/dKpC3\" rel=\"nofollow ugc\">https://shorturl.fm/dKpC3</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("465", "531", "Marco3809", "Marco3809@gmail.com", "", "138.118.236.70", "2025-07-28 11:26:51", "2025-07-28 16:26:51", "<a href=\"https://shorturl.fm/HYHX5\" rel=\"nofollow ugc\">https://shorturl.fm/HYHX5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("466", "1", "Anton3587", "Anton3587@gmail.com", "", "138.118.236.70", "2025-07-28 11:27:18", "2025-07-28 16:27:18", "<a href=\"https://shorturl.fm/tikJd\" rel=\"nofollow ugc\">https://shorturl.fm/tikJd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("467", "556", "Josh387", "Josh387@gmail.com", "", "201.127.63.186", "2025-07-28 13:26:34", "2025-07-28 18:26:34", "<a href=\"https://shorturl.fm/RA169\" rel=\"nofollow ugc\">https://shorturl.fm/RA169</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("468", "551", "Juliet1382", "Juliet1382@gmail.com", "", "201.127.63.186", "2025-07-28 13:26:53", "2025-07-28 18:26:53", "<a href=\"https://shorturl.fm/uPtwg\" rel=\"nofollow ugc\">https://shorturl.fm/uPtwg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("469", "531", "Gregory278", "Gregory278@gmail.com", "", "201.127.63.186", "2025-07-28 13:27:15", "2025-07-28 18:27:15", "<a href=\"https://shorturl.fm/OcDdc\" rel=\"nofollow ugc\">https://shorturl.fm/OcDdc</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("470", "1", "Genesis2689", "Genesis2689@gmail.com", "", "201.127.63.186", "2025-07-28 13:27:36", "2025-07-28 18:27:36", "<a href=\"https://shorturl.fm/76Dzd\" rel=\"nofollow ugc\">https://shorturl.fm/76Dzd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("471", "556", "Janelle43", "Janelle43@gmail.com", "", "223.206.63.86", "2025-07-28 18:36:18", "2025-07-28 23:36:18", "<a href=\"https://shorturl.fm/fEb6q\" rel=\"nofollow ugc\">https://shorturl.fm/fEb6q</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("472", "551", "Mara4993", "Mara4993@gmail.com", "", "223.206.63.86", "2025-07-28 18:36:44", "2025-07-28 23:36:44", "<a href=\"https://shorturl.fm/aUsU6\" rel=\"nofollow ugc\">https://shorturl.fm/aUsU6</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("473", "531", "Lara4116", "Lara4116@gmail.com", "", "223.206.63.86", "2025-07-28 18:37:11", "2025-07-28 23:37:11", "<a href=\"https://shorturl.fm/wGToL\" rel=\"nofollow ugc\">https://shorturl.fm/wGToL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("474", "1", "Emery4101", "Emery4101@gmail.com", "", "223.206.63.86", "2025-07-28 18:37:33", "2025-07-28 23:37:33", "<a href=\"https://shorturl.fm/pXXPu\" rel=\"nofollow ugc\">https://shorturl.fm/pXXPu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("475", "556", "Coraline2554", "Coraline2554@gmail.com", "", "177.254.138.50", "2025-07-28 19:57:00", "2025-07-29 00:57:00", "<a href=\"https://shorturl.fm/MfxeW\" rel=\"nofollow ugc\">https://shorturl.fm/MfxeW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("476", "551", "Evangeline3089", "Evangeline3089@gmail.com", "", "177.254.138.50", "2025-07-28 19:57:28", "2025-07-29 00:57:28", "<a href=\"https://shorturl.fm/pXXPu\" rel=\"nofollow ugc\">https://shorturl.fm/pXXPu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("477", "531", "Amber3361", "Amber3361@gmail.com", "", "177.254.138.50", "2025-07-28 19:57:57", "2025-07-29 00:57:57", "<a href=\"https://shorturl.fm/yxl1W\" rel=\"nofollow ugc\">https://shorturl.fm/yxl1W</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("478", "1", "Beatrice1007", "Beatrice1007@gmail.com", "", "177.254.138.50", "2025-07-28 19:58:29", "2025-07-29 00:58:29", "<a href=\"https://shorturl.fm/WlPEl\" rel=\"nofollow ugc\">https://shorturl.fm/WlPEl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("479", "556", "Anderson44", "Anderson44@gmail.com", "", "113.190.135.119", "2025-07-28 20:03:00", "2025-07-29 01:03:00", "<a href=\"https://shorturl.fm/S6QFK\" rel=\"nofollow ugc\">https://shorturl.fm/S6QFK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("480", "551", "Elsie1359", "Elsie1359@gmail.com", "", "113.190.135.119", "2025-07-28 20:03:30", "2025-07-29 01:03:30", "<a href=\"https://shorturl.fm/efgyl\" rel=\"nofollow ugc\">https://shorturl.fm/efgyl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("481", "531", "Elsie4666", "Elsie4666@gmail.com", "", "113.190.135.119", "2025-07-28 20:03:55", "2025-07-29 01:03:55", "<a href=\"https://shorturl.fm/yAaQ4\" rel=\"nofollow ugc\">https://shorturl.fm/yAaQ4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("482", "1", "Lara1847", "Lara1847@gmail.com", "", "113.190.135.119", "2025-07-28 20:04:21", "2025-07-29 01:04:21", "<a href=\"https://shorturl.fm/NUggB\" rel=\"nofollow ugc\">https://shorturl.fm/NUggB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("483", "556", "Marshall2575", "Marshall2575@gmail.com", "", "36.72.209.215", "2025-07-29 02:38:51", "2025-07-29 07:38:51", "<a href=\"https://shorturl.fm/KfUnS\" rel=\"nofollow ugc\">https://shorturl.fm/KfUnS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("484", "551", "Danielle763", "Danielle763@gmail.com", "", "36.72.209.215", "2025-07-29 02:39:23", "2025-07-29 07:39:23", "<a href=\"https://shorturl.fm/dxrf1\" rel=\"nofollow ugc\">https://shorturl.fm/dxrf1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("485", "556", "Victor277", "Victor277@gmail.com", "", "124.83.122.31", "2025-07-29 04:40:49", "2025-07-29 09:40:49", "<a href=\"https://shorturl.fm/KzTry\" rel=\"nofollow ugc\">https://shorturl.fm/KzTry</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("486", "551", "Maddison75", "Maddison75@gmail.com", "", "124.83.122.31", "2025-07-29 04:41:13", "2025-07-29 09:41:13", "<a href=\"https://shorturl.fm/7Zx8l\" rel=\"nofollow ugc\">https://shorturl.fm/7Zx8l</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("487", "1", "Jorge1474", "Jorge1474@gmail.com", "", "124.83.122.31", "2025-07-29 04:41:47", "2025-07-29 09:41:47", "<a href=\"https://shorturl.fm/EU3Cs\" rel=\"nofollow ugc\">https://shorturl.fm/EU3Cs</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("488", "556", "Scott214", "Scott214@gmail.com", "", "39.42.133.130", "2025-07-29 05:59:04", "2025-07-29 10:59:04", "<a href=\"https://shorturl.fm/Kcgsz\" rel=\"nofollow ugc\">https://shorturl.fm/Kcgsz</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("489", "551", "Sergio3139", "Sergio3139@gmail.com", "", "39.42.133.130", "2025-07-29 05:59:32", "2025-07-29 10:59:32", "<a href=\"https://shorturl.fm/AG6RN\" rel=\"nofollow ugc\">https://shorturl.fm/AG6RN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("490", "531", "Lucy2205", "Lucy2205@gmail.com", "", "39.42.133.130", "2025-07-29 05:59:59", "2025-07-29 10:59:59", "<a href=\"https://shorturl.fm/C82tE\" rel=\"nofollow ugc\">https://shorturl.fm/C82tE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("491", "1", "Jenny1849", "Jenny1849@gmail.com", "", "39.42.133.130", "2025-07-29 06:00:47", "2025-07-29 11:00:47", "<a href=\"https://shorturl.fm/lES5k\" rel=\"nofollow ugc\">https://shorturl.fm/lES5k</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("492", "556", "Melissa3810", "Melissa3810@gmail.com", "", "49.48.102.227", "2025-07-29 08:46:03", "2025-07-29 13:46:03", "<a href=\"https://shorturl.fm/NACf1\" rel=\"nofollow ugc\">https://shorturl.fm/NACf1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("493", "551", "Eva2719", "Eva2719@gmail.com", "", "49.48.102.227", "2025-07-29 08:46:32", "2025-07-29 13:46:32", "<a href=\"https://shorturl.fm/jIuu2\" rel=\"nofollow ugc\">https://shorturl.fm/jIuu2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("494", "531", "Benjamin863", "Benjamin863@gmail.com", "", "49.48.102.227", "2025-07-29 08:47:00", "2025-07-29 13:47:00", "<a href=\"https://shorturl.fm/dgUlf\" rel=\"nofollow ugc\">https://shorturl.fm/dgUlf</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("495", "556", "Fiona399", "Fiona399@gmail.com", "", "115.245.96.230", "2025-07-30 03:30:25", "2025-07-30 08:30:25", "<a href=\"https://shorturl.fm/krlKm\" rel=\"nofollow ugc\">https://shorturl.fm/krlKm</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("496", "551", "Carter1942", "Carter1942@gmail.com", "", "115.245.96.230", "2025-07-30 03:30:53", "2025-07-30 08:30:53", "<a href=\"https://shorturl.fm/Ge97Y\" rel=\"nofollow ugc\">https://shorturl.fm/Ge97Y</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("497", "531", "Ellie2561", "Ellie2561@gmail.com", "", "115.245.96.230", "2025-07-30 03:31:20", "2025-07-30 08:31:20", "<a href=\"https://shorturl.fm/kXPub\" rel=\"nofollow ugc\">https://shorturl.fm/kXPub</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("498", "1", "Marvin257", "Marvin257@gmail.com", "", "115.245.96.230", "2025-07-30 03:31:47", "2025-07-30 08:31:47", "<a href=\"https://shorturl.fm/vCYsz\" rel=\"nofollow ugc\">https://shorturl.fm/vCYsz</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("499", "556", "Maggie3731", "Maggie3731@gmail.com", "", "118.68.64.87", "2025-07-30 12:54:07", "2025-07-30 17:54:07", "<a href=\"https://shorturl.fm/O98lo\" rel=\"nofollow ugc\">https://shorturl.fm/O98lo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("500", "551", "Darryl2369", "Darryl2369@gmail.com", "", "118.68.64.87", "2025-07-30 12:54:37", "2025-07-30 17:54:37", "<a href=\"https://shorturl.fm/ueAxo\" rel=\"nofollow ugc\">https://shorturl.fm/ueAxo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("501", "531", "Peyton1499", "Peyton1499@gmail.com", "", "118.68.64.87", "2025-07-30 12:55:06", "2025-07-30 17:55:06", "<a href=\"https://shorturl.fm/8P8xV\" rel=\"nofollow ugc\">https://shorturl.fm/8P8xV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("502", "1", "Randall3863", "Randall3863@gmail.com", "", "118.68.64.87", "2025-07-30 12:55:38", "2025-07-30 17:55:38", "<a href=\"https://shorturl.fm/a73HH\" rel=\"nofollow ugc\">https://shorturl.fm/a73HH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("503", "556", "Angela4477", "Angela4477@gmail.com", "", "171.228.181.238", "2025-07-30 17:56:51", "2025-07-30 22:56:51", "<a href=\"https://shorturl.fm/yzKQy\" rel=\"nofollow ugc\">https://shorturl.fm/yzKQy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("504", "551", "Kaitlyn4618", "Kaitlyn4618@gmail.com", "", "171.228.181.238", "2025-07-30 17:57:19", "2025-07-30 22:57:19", "<a href=\"https://shorturl.fm/OBGIo\" rel=\"nofollow ugc\">https://shorturl.fm/OBGIo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("505", "1", "Clayton3694", "Clayton3694@gmail.com", "", "171.228.181.238", "2025-07-30 17:57:48", "2025-07-30 22:57:48", "<a href=\"https://shorturl.fm/CWJ4t\" rel=\"nofollow ugc\">https://shorturl.fm/CWJ4t</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("506", "551", "Teresa2456", "Teresa2456@gmail.com", "", "42.113.162.230", "2025-07-31 08:10:37", "2025-07-31 13:10:37", "<a href=\"https://shorturl.fm/vvxAi\" rel=\"nofollow ugc\">https://shorturl.fm/vvxAi</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("507", "531", "Junior3383", "Junior3383@gmail.com", "", "42.113.162.230", "2025-07-31 08:11:00", "2025-07-31 13:11:00", "<a href=\"https://shorturl.fm/vHrRo\" rel=\"nofollow ugc\">https://shorturl.fm/vHrRo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("508", "1", "Naomi401", "Naomi401@gmail.com", "", "42.113.162.230", "2025-07-31 08:11:24", "2025-07-31 13:11:24", "<a href=\"https://shorturl.fm/LIRR1\" rel=\"nofollow ugc\">https://shorturl.fm/LIRR1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("509", "556", "Abram755", "Abram755@gmail.com", "", "134.35.6.101", "2025-07-31 10:55:17", "2025-07-31 15:55:17", "<a href=\"https://shorturl.fm/zqqh2\" rel=\"nofollow ugc\">https://shorturl.fm/zqqh2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("510", "551", "Owen426", "Owen426@gmail.com", "", "134.35.6.101", "2025-07-31 10:55:43", "2025-07-31 15:55:43", "<a href=\"https://shorturl.fm/TiOk5\" rel=\"nofollow ugc\">https://shorturl.fm/TiOk5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("511", "531", "Ruth488", "Ruth488@gmail.com", "", "134.35.6.101", "2025-07-31 10:56:10", "2025-07-31 15:56:10", "<a href=\"https://shorturl.fm/HfQhH\" rel=\"nofollow ugc\">https://shorturl.fm/HfQhH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("512", "1", "Haiden264", "Haiden264@gmail.com", "", "134.35.6.101", "2025-07-31 10:56:36", "2025-07-31 15:56:36", "<a href=\"https://shorturl.fm/tglD0\" rel=\"nofollow ugc\">https://shorturl.fm/tglD0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("513", "556", "Brian765", "Brian765@gmail.com", "", "123.18.140.231", "2025-07-31 11:43:27", "2025-07-31 16:43:27", "<a href=\"https://shorturl.fm/6mBmm\" rel=\"nofollow ugc\">https://shorturl.fm/6mBmm</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("514", "551", "Faith2885", "Faith2885@gmail.com", "", "123.18.140.231", "2025-07-31 11:43:53", "2025-07-31 16:43:53", "<a href=\"https://shorturl.fm/CtnoH\" rel=\"nofollow ugc\">https://shorturl.fm/CtnoH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("515", "531", "Dillon3490", "Dillon3490@gmail.com", "", "123.18.140.231", "2025-07-31 11:44:20", "2025-07-31 16:44:20", "<a href=\"https://shorturl.fm/3UQTR\" rel=\"nofollow ugc\">https://shorturl.fm/3UQTR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("516", "1", "Chance2120", "Chance2120@gmail.com", "", "123.18.140.231", "2025-07-31 11:44:46", "2025-07-31 16:44:46", "<a href=\"https://shorturl.fm/Os806\" rel=\"nofollow ugc\">https://shorturl.fm/Os806</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("517", "556", "Wyatt624", "Wyatt624@gmail.com", "", "134.35.6.96", "2025-07-31 12:55:06", "2025-07-31 17:55:06", "<a href=\"https://shorturl.fm/w6j2V\" rel=\"nofollow ugc\">https://shorturl.fm/w6j2V</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("518", "551", "Lauryn3489", "Lauryn3489@gmail.com", "", "134.35.6.96", "2025-07-31 12:55:34", "2025-07-31 17:55:34", "<a href=\"https://shorturl.fm/k2jDY\" rel=\"nofollow ugc\">https://shorturl.fm/k2jDY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("519", "531", "Jorge2180", "Jorge2180@gmail.com", "", "134.35.6.96", "2025-07-31 12:55:53", "2025-07-31 17:55:53", "<a href=\"https://shorturl.fm/eBEOj\" rel=\"nofollow ugc\">https://shorturl.fm/eBEOj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("520", "1", "Sandra354", "Sandra354@gmail.com", "", "134.35.6.96", "2025-07-31 12:56:16", "2025-07-31 17:56:16", "<a href=\"https://shorturl.fm/bgX6C\" rel=\"nofollow ugc\">https://shorturl.fm/bgX6C</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("521", "556", "Diana4972", "Diana4972@gmail.com", "", "46.101.104.251", "2025-07-31 13:02:17", "2025-07-31 18:02:17", "<a href=\"https://shorturl.fm/ePrRc\" rel=\"nofollow ugc\">https://shorturl.fm/ePrRc</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("522", "551", "Roy1078", "Roy1078@gmail.com", "", "46.101.104.251", "2025-07-31 13:02:45", "2025-07-31 18:02:45", "<a href=\"https://shorturl.fm/Eyulq\" rel=\"nofollow ugc\">https://shorturl.fm/Eyulq</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("523", "531", "Elias4350", "Elias4350@gmail.com", "", "46.101.104.251", "2025-07-31 13:03:12", "2025-07-31 18:03:12", "<a href=\"https://shorturl.fm/MtnUB\" rel=\"nofollow ugc\">https://shorturl.fm/MtnUB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("524", "1", "Leia1440", "Leia1440@gmail.com", "", "46.101.104.251", "2025-07-31 13:03:40", "2025-07-31 18:03:40", "<a href=\"https://shorturl.fm/n2uF4\" rel=\"nofollow ugc\">https://shorturl.fm/n2uF4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("525", "556", "Alan4846", "Alan4846@gmail.com", "", "200.88.192.172", "2025-07-31 17:14:47", "2025-07-31 22:14:47", "<a href=\"https://shorturl.fm/0rEk7\" rel=\"nofollow ugc\">https://shorturl.fm/0rEk7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("526", "551", "Chad4793", "Chad4793@gmail.com", "", "200.88.192.172", "2025-07-31 17:15:15", "2025-07-31 22:15:15", "<a href=\"https://shorturl.fm/GhSxH\" rel=\"nofollow ugc\">https://shorturl.fm/GhSxH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("527", "531", "Felix4208", "Felix4208@gmail.com", "", "200.88.192.172", "2025-07-31 17:15:43", "2025-07-31 22:15:43", "<a href=\"https://shorturl.fm/3zonM\" rel=\"nofollow ugc\">https://shorturl.fm/3zonM</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("528", "1", "Ellie3573", "Ellie3573@gmail.com", "", "200.88.192.172", "2025-07-31 17:16:10", "2025-07-31 22:16:10", "<a href=\"https://shorturl.fm/NIRLS\" rel=\"nofollow ugc\">https://shorturl.fm/NIRLS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("529", "556", "Gloria1613", "Gloria1613@gmail.com", "", "2.49.93.222", "2025-08-01 01:47:55", "2025-08-01 06:47:55", "<a href=\"https://shorturl.fm/Sbdp7\" rel=\"nofollow ugc\">https://shorturl.fm/Sbdp7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("530", "551", "Henry3823", "Henry3823@gmail.com", "", "2.49.93.222", "2025-08-01 01:48:23", "2025-08-01 06:48:23", "<a href=\"https://shorturl.fm/DtDBv\" rel=\"nofollow ugc\">https://shorturl.fm/DtDBv</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("531", "531", "Elizabeth958", "Elizabeth958@gmail.com", "", "2.49.93.222", "2025-08-01 01:48:53", "2025-08-01 06:48:53", "<a href=\"https://shorturl.fm/2tdHX\" rel=\"nofollow ugc\">https://shorturl.fm/2tdHX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("532", "1", "Clarissa270", "Clarissa270@gmail.com", "", "2.49.93.222", "2025-08-01 01:49:21", "2025-08-01 06:49:21", "<a href=\"https://shorturl.fm/fmEVE\" rel=\"nofollow ugc\">https://shorturl.fm/fmEVE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("533", "556", "Sandra2175", "Sandra2175@gmail.com", "", "39.105.6.136", "2025-08-01 08:25:56", "2025-08-01 13:25:56", "<a href=\"https://shorturl.fm/w42jA\" rel=\"nofollow ugc\">https://shorturl.fm/w42jA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("534", "556", "Jesse4174", "Jesse4174@gmail.com", "", "181.55.12.217", "2025-08-01 10:52:00", "2025-08-01 15:52:00", "<a href=\"https://shorturl.fm/yxnUe\" rel=\"nofollow ugc\">https://shorturl.fm/yxnUe</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("535", "551", "Greta4213", "Greta4213@gmail.com", "", "181.55.12.217", "2025-08-01 10:52:26", "2025-08-01 15:52:26", "<a href=\"https://shorturl.fm/Qw3RE\" rel=\"nofollow ugc\">https://shorturl.fm/Qw3RE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("536", "531", "Clyde38", "Clyde38@gmail.com", "", "181.55.12.217", "2025-08-01 10:52:53", "2025-08-01 15:52:53", "<a href=\"https://shorturl.fm/Cl57y\" rel=\"nofollow ugc\">https://shorturl.fm/Cl57y</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("537", "1", "Lila1211", "Lila1211@gmail.com", "", "181.55.12.217", "2025-08-01 10:53:17", "2025-08-01 15:53:17", "<a href=\"https://shorturl.fm/HYHcl\" rel=\"nofollow ugc\">https://shorturl.fm/HYHcl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("538", "556", "Harry3880", "Harry3880@gmail.com", "", "42.2.254.146", "2025-08-01 12:59:09", "2025-08-01 17:59:09", "<a href=\"https://shorturl.fm/0Tm4L\" rel=\"nofollow ugc\">https://shorturl.fm/0Tm4L</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("539", "556", "Devon2373", "Devon2373@gmail.com", "", "167.58.188.3", "2025-08-01 12:59:26", "2025-08-01 17:59:26", "<a href=\"https://shorturl.fm/5NBs5\" rel=\"nofollow ugc\">https://shorturl.fm/5NBs5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("540", "551", "Angelo163", "Angelo163@gmail.com", "", "42.2.254.146", "2025-08-01 12:59:37", "2025-08-01 17:59:37", "<a href=\"https://shorturl.fm/5NBs5\" rel=\"nofollow ugc\">https://shorturl.fm/5NBs5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("541", "531", "Jasmine453", "Jasmine453@gmail.com", "", "167.58.188.3", "2025-08-01 13:00:05", "2025-08-01 18:00:05", "<a href=\"https://shorturl.fm/cxAJd\" rel=\"nofollow ugc\">https://shorturl.fm/cxAJd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("542", "1", "Seth487", "Seth487@gmail.com", "", "42.2.254.146", "2025-08-01 13:00:16", "2025-08-01 18:00:16", "<a href=\"https://shorturl.fm/loVEH\" rel=\"nofollow ugc\">https://shorturl.fm/loVEH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("543", "1", "Moses1893", "Moses1893@gmail.com", "", "167.58.188.3", "2025-08-01 13:00:35", "2025-08-01 18:00:35", "<a href=\"https://shorturl.fm/YQRC0\" rel=\"nofollow ugc\">https://shorturl.fm/YQRC0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("544", "556", "Damon1693", "Damon1693@gmail.com", "", "167.250.23.186", "2025-08-01 23:00:41", "2025-08-02 04:00:41", "<a href=\"https://shorturl.fm/NL3t4\" rel=\"nofollow ugc\">https://shorturl.fm/NL3t4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("545", "551", "Amy2841", "Amy2841@gmail.com", "", "167.250.23.186", "2025-08-01 23:01:09", "2025-08-02 04:01:09", "<a href=\"https://shorturl.fm/SFSQN\" rel=\"nofollow ugc\">https://shorturl.fm/SFSQN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("546", "531", "Elias475", "Elias475@gmail.com", "", "167.250.23.186", "2025-08-01 23:01:36", "2025-08-02 04:01:36", "<a href=\"https://shorturl.fm/QTuQt\" rel=\"nofollow ugc\">https://shorturl.fm/QTuQt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("547", "1", "Nelson749", "Nelson749@gmail.com", "", "167.250.23.186", "2025-08-01 23:02:03", "2025-08-02 04:02:03", "<a href=\"https://shorturl.fm/Vg3dr\" rel=\"nofollow ugc\">https://shorturl.fm/Vg3dr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("548", "556", "Lachlan276", "Lachlan276@gmail.com", "", "103.229.121.75", "2025-08-02 08:07:13", "2025-08-02 13:07:13", "<a href=\"https://shorturl.fm/kFo3U\" rel=\"nofollow ugc\">https://shorturl.fm/kFo3U</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("549", "551", "Aspen1285", "Aspen1285@gmail.com", "", "103.229.121.75", "2025-08-02 08:07:40", "2025-08-02 13:07:40", "<a href=\"https://shorturl.fm/gxtui\" rel=\"nofollow ugc\">https://shorturl.fm/gxtui</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("550", "531", "Leon91", "Leon91@gmail.com", "", "103.229.121.75", "2025-08-02 08:08:09", "2025-08-02 13:08:09", "<a href=\"https://shorturl.fm/3Jz7P\" rel=\"nofollow ugc\">https://shorturl.fm/3Jz7P</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("551", "1", "Kevin3524", "Kevin3524@gmail.com", "", "103.229.121.75", "2025-08-02 08:08:38", "2025-08-02 13:08:38", "<a href=\"https://shorturl.fm/3DoxB\" rel=\"nofollow ugc\">https://shorturl.fm/3DoxB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("552", "556", "Linda1018", "Linda1018@gmail.com", "", "114.10.41.196", "2025-08-02 16:35:41", "2025-08-02 21:35:41", "<a href=\"https://shorturl.fm/CIPJQ\" rel=\"nofollow ugc\">https://shorturl.fm/CIPJQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("553", "551", "Joyce642", "Joyce642@gmail.com", "", "114.10.41.196", "2025-08-02 16:36:12", "2025-08-02 21:36:12", "<a href=\"https://shorturl.fm/x9ekB\" rel=\"nofollow ugc\">https://shorturl.fm/x9ekB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("554", "531", "Austin4240", "Austin4240@gmail.com", "", "114.10.41.196", "2025-08-02 16:36:42", "2025-08-02 21:36:42", "<a href=\"https://shorturl.fm/jnzUD\" rel=\"nofollow ugc\">https://shorturl.fm/jnzUD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("555", "1", "Cara2601", "Cara2601@gmail.com", "", "114.10.41.196", "2025-08-02 16:37:13", "2025-08-02 21:37:13", "<a href=\"https://shorturl.fm/jqVUe\" rel=\"nofollow ugc\">https://shorturl.fm/jqVUe</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("556", "556", "Elaine409", "Elaine409@gmail.com", "", "179.214.68.245", "2025-08-02 22:54:03", "2025-08-03 03:54:03", "<a href=\"https://shorturl.fm/OKvAI\" rel=\"nofollow ugc\">https://shorturl.fm/OKvAI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("557", "551", "Ernest403", "Ernest403@gmail.com", "", "179.214.68.245", "2025-08-02 22:54:34", "2025-08-03 03:54:34", "<a href=\"https://shorturl.fm/OKvAI\" rel=\"nofollow ugc\">https://shorturl.fm/OKvAI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("558", "531", "Steven3180", "Steven3180@gmail.com", "", "179.214.68.245", "2025-08-02 22:55:05", "2025-08-03 03:55:05", "<a href=\"https://shorturl.fm/t9x9P\" rel=\"nofollow ugc\">https://shorturl.fm/t9x9P</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("559", "1", "Elijah671", "Elijah671@gmail.com", "", "179.214.68.245", "2025-08-02 22:55:35", "2025-08-03 03:55:35", "<a href=\"https://shorturl.fm/sZsAl\" rel=\"nofollow ugc\">https://shorturl.fm/sZsAl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("560", "556", "Angie4235", "Angie4235@gmail.com", "", "124.83.120.155", "2025-08-03 00:49:34", "2025-08-03 05:49:34", "<a href=\"https://shorturl.fm/Rrfct\" rel=\"nofollow ugc\">https://shorturl.fm/Rrfct</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("561", "551", "Easton4958", "Easton4958@gmail.com", "", "180.191.32.22", "2025-08-03 00:50:05", "2025-08-03 05:50:05", "<a href=\"https://shorturl.fm/Vrz9C\" rel=\"nofollow ugc\">https://shorturl.fm/Vrz9C</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("562", "531", "Briana4653", "Briana4653@gmail.com", "", "180.191.32.22", "2025-08-03 00:50:35", "2025-08-03 05:50:35", "<a href=\"https://shorturl.fm/vPbtb\" rel=\"nofollow ugc\">https://shorturl.fm/vPbtb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("563", "556", "Rick370", "Rick370@gmail.com", "", "61.71.150.180", "2025-08-03 08:59:51", "2025-08-03 13:59:51", "<a href=\"https://shorturl.fm/hnlkS\" rel=\"nofollow ugc\">https://shorturl.fm/hnlkS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("564", "551", "Andre1219", "Andre1219@gmail.com", "", "61.71.150.180", "2025-08-03 09:01:38", "2025-08-03 14:01:38", "<a href=\"https://shorturl.fm/mfI4Q\" rel=\"nofollow ugc\">https://shorturl.fm/mfI4Q</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("565", "556", "Drake99", "Drake99@gmail.com", "", "45.238.55.117", "2025-08-03 15:23:10", "2025-08-03 20:23:10", "<a href=\"https://shorturl.fm/vvS5W\" rel=\"nofollow ugc\">https://shorturl.fm/vvS5W</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("566", "551", "Alexandria1615", "Alexandria1615@gmail.com", "", "45.238.55.117", "2025-08-03 15:23:41", "2025-08-03 20:23:41", "<a href=\"https://shorturl.fm/qXHBl\" rel=\"nofollow ugc\">https://shorturl.fm/qXHBl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("567", "531", "Clark1637", "Clark1637@gmail.com", "", "45.238.55.117", "2025-08-03 15:24:12", "2025-08-03 20:24:12", "<a href=\"https://shorturl.fm/gUIWJ\" rel=\"nofollow ugc\">https://shorturl.fm/gUIWJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("568", "1", "Keith3117", "Keith3117@gmail.com", "", "45.238.55.117", "2025-08-03 15:24:44", "2025-08-03 20:24:44", "<a href=\"https://shorturl.fm/vvS5W\" rel=\"nofollow ugc\">https://shorturl.fm/vvS5W</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("569", "556", "Graham1220", "Graham1220@gmail.com", "", "116.98.229.134", "2025-08-03 23:13:57", "2025-08-04 04:13:57", "<a href=\"https://shorturl.fm/3wki7\" rel=\"nofollow ugc\">https://shorturl.fm/3wki7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("570", "551", "Sean875", "Sean875@gmail.com", "", "116.98.229.134", "2025-08-03 23:14:26", "2025-08-04 04:14:26", "<a href=\"https://shorturl.fm/QORHV\" rel=\"nofollow ugc\">https://shorturl.fm/QORHV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("571", "556", "Jamie4891", "Jamie4891@gmail.com", "", "122.118.107.169", "2025-08-04 01:58:32", "2025-08-04 06:58:32", "<a href=\"https://shorturl.fm/vtvKk\" rel=\"nofollow ugc\">https://shorturl.fm/vtvKk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("572", "551", "Jayden1879", "Jayden1879@gmail.com", "", "122.118.107.169", "2025-08-04 01:59:04", "2025-08-04 06:59:04", "<a href=\"https://shorturl.fm/DF8OI\" rel=\"nofollow ugc\">https://shorturl.fm/DF8OI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("573", "531", "Hanna1687", "Hanna1687@gmail.com", "", "122.118.107.169", "2025-08-04 01:59:36", "2025-08-04 06:59:36", "<a href=\"https://shorturl.fm/k2xsp\" rel=\"nofollow ugc\">https://shorturl.fm/k2xsp</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("574", "556", "Bill3207", "Bill3207@gmail.com", "", "27.34.64.41", "2025-08-04 01:59:54", "2025-08-04 06:59:54", "<a href=\"https://shorturl.fm/clVsk\" rel=\"nofollow ugc\">https://shorturl.fm/clVsk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("575", "1", "Annabelle4125", "Annabelle4125@gmail.com", "", "122.118.107.169", "2025-08-04 02:00:09", "2025-08-04 07:00:09", "<a href=\"https://shorturl.fm/gtPX7\" rel=\"nofollow ugc\">https://shorturl.fm/gtPX7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("576", "551", "Carl1946", "Carl1946@gmail.com", "", "27.34.64.41", "2025-08-04 02:00:27", "2025-08-04 07:00:27", "<a href=\"https://shorturl.fm/sNDnU\" rel=\"nofollow ugc\">https://shorturl.fm/sNDnU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("577", "531", "Carl366", "Carl366@gmail.com", "", "27.34.64.41", "2025-08-04 02:00:59", "2025-08-04 07:00:59", "<a href=\"https://shorturl.fm/sNDnU\" rel=\"nofollow ugc\">https://shorturl.fm/sNDnU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("578", "1", "Grace1194", "Grace1194@gmail.com", "", "27.34.64.41", "2025-08-04 02:01:31", "2025-08-04 07:01:31", "<a href=\"https://shorturl.fm/bmRRB\" rel=\"nofollow ugc\">https://shorturl.fm/bmRRB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("579", "556", "Chuck2917", "Chuck2917@gmail.com", "", "125.27.111.223", "2025-08-04 17:15:53", "2025-08-04 22:15:53", "<a href=\"https://shorturl.fm/N4LH4\" rel=\"nofollow ugc\">https://shorturl.fm/N4LH4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("580", "556", "Gwen2555", "Gwen2555@gmail.com", "", "36.65.208.92", "2025-08-04 19:41:14", "2025-08-05 00:41:14", "<a href=\"https://shorturl.fm/pJpcb\" rel=\"nofollow ugc\">https://shorturl.fm/pJpcb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("581", "556", "Gracie4329", "Gracie4329@gmail.com", "", "183.237.195.130", "2025-08-04 22:45:57", "2025-08-05 03:45:57", "<a href=\"https://shorturl.fm/PU11h\" rel=\"nofollow ugc\">https://shorturl.fm/PU11h</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("582", "556", "Joseph15", "Joseph15@gmail.com", "", "158.140.175.199", "2025-08-05 12:55:23", "2025-08-05 17:55:23", "<a href=\"https://shorturl.fm/bS0RK\" rel=\"nofollow ugc\">https://shorturl.fm/bS0RK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("583", "556", "Albert4477", "Albert4477@gmail.com", "", "103.232.219.137", "2025-08-06 04:21:32", "2025-08-06 09:21:32", "<a href=\"https://shorturl.fm/tGgMj\" rel=\"nofollow ugc\">https://shorturl.fm/tGgMj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("584", "556", "Charles4783", "Charles4783@gmail.com", "", "184.22.191.228", "2025-08-06 07:09:38", "2025-08-06 12:09:38", "<a href=\"https://shorturl.fm/iMqyj\" rel=\"nofollow ugc\">https://shorturl.fm/iMqyj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("585", "556", "Nikita2325", "Nikita2325@gmail.com", "", "27.71.134.202", "2025-08-06 17:01:33", "2025-08-06 22:01:33", "<a href=\"https://shorturl.fm/tzhCD\" rel=\"nofollow ugc\">https://shorturl.fm/tzhCD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("586", "556", "Fernando2585", "Fernando2585@gmail.com", "", "178.51.161.146", "2025-08-07 02:14:48", "2025-08-07 07:14:48", "<a href=\"https://shorturl.fm/q4vQM\" rel=\"nofollow ugc\">https://shorturl.fm/q4vQM</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("587", "551", "Marc1396", "Marc1396@gmail.com", "", "94.225.222.2", "2025-08-07 02:14:51", "2025-08-07 07:14:51", "<a href=\"https://shorturl.fm/UscIR\" rel=\"nofollow ugc\">https://shorturl.fm/UscIR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("588", "531", "Phyllis3837", "Phyllis3837@gmail.com", "", "91.178.200.130", "2025-08-07 02:14:56", "2025-08-07 07:14:56", "<a href=\"https://shorturl.fm/f7NaI\" rel=\"nofollow ugc\">https://shorturl.fm/f7NaI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("589", "1", "Toby1142", "Toby1142@gmail.com", "", "91.183.92.185", "2025-08-07 02:15:03", "2025-08-07 07:15:03", "<a href=\"https://shorturl.fm/XSaPr\" rel=\"nofollow ugc\">https://shorturl.fm/XSaPr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("590", "556", "Beatrice2913", "Beatrice2913@gmail.com", "", "46.34.192.105", "2025-08-07 03:22:56", "2025-08-07 08:22:56", "<a href=\"https://shorturl.fm/JY8xH\" rel=\"nofollow ugc\">https://shorturl.fm/JY8xH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("591", "551", "Timothy1810", "Timothy1810@gmail.com", "", "147.30.220.137", "2025-08-07 03:22:59", "2025-08-07 08:22:59", "<a href=\"https://shorturl.fm/V1mLb\" rel=\"nofollow ugc\">https://shorturl.fm/V1mLb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("592", "531", "Charlotte3452", "Charlotte3452@gmail.com", "", "46.36.153.3", "2025-08-07 03:23:02", "2025-08-07 08:23:02", "<a href=\"https://shorturl.fm/rnzha\" rel=\"nofollow ugc\">https://shorturl.fm/rnzha</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("593", "1", "Colton3520", "Colton3520@gmail.com", "", "45.140.25.111", "2025-08-07 03:23:17", "2025-08-07 08:23:17", "<a href=\"https://shorturl.fm/jXCJn\" rel=\"nofollow ugc\">https://shorturl.fm/jXCJn</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("594", "556", "Katherine4062", "Katherine4062@gmail.com", "", "1.53.53.57", "2025-08-07 03:47:34", "2025-08-07 08:47:34", "<a href=\"https://shorturl.fm/8nq5a\" rel=\"nofollow ugc\">https://shorturl.fm/8nq5a</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("595", "556", "Jayden3510", "Jayden3510@gmail.com", "", "107.115.90.226", "2025-08-07 12:35:59", "2025-08-07 17:35:59", "<a href=\"https://shorturl.fm/EVukv\" rel=\"nofollow ugc\">https://shorturl.fm/EVukv</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("596", "551", "Ruth3219", "Ruth3219@gmail.com", "", "172.56.211.186", "2025-08-07 12:36:03", "2025-08-07 17:36:03", "<a href=\"https://shorturl.fm/ybmu6\" rel=\"nofollow ugc\">https://shorturl.fm/ybmu6</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("597", "531", "Nolan4232", "Nolan4232@gmail.com", "", "71.199.180.117", "2025-08-07 12:36:11", "2025-08-07 17:36:11", "<a href=\"https://shorturl.fm/izQMt\" rel=\"nofollow ugc\">https://shorturl.fm/izQMt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("598", "1", "Clifford2577", "Clifford2577@gmail.com", "", "98.101.49.55", "2025-08-07 12:36:13", "2025-08-07 17:36:13", "<a href=\"https://shorturl.fm/CEshU\" rel=\"nofollow ugc\">https://shorturl.fm/CEshU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("599", "556", "Kenneth1069", "Kenneth1069@gmail.com", "", "171.5.209.217", "2025-08-07 13:40:19", "2025-08-07 18:40:19", "<a href=\"https://shorturl.fm/dGxfh\" rel=\"nofollow ugc\">https://shorturl.fm/dGxfh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("600", "556", "Jayden3309", "Jayden3309@gmail.com", "", "42.96.16.158", "2025-08-07 16:40:00", "2025-08-07 21:40:00", "<a href=\"https://shorturl.fm/5tawY\" rel=\"nofollow ugc\">https://shorturl.fm/5tawY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("601", "556", "Cora3457", "Cora3457@gmail.com", "", "200.75.154.138", "2025-08-08 08:01:08", "2025-08-08 13:01:08", "<a href=\"https://shorturl.fm/zlzbf\" rel=\"nofollow ugc\">https://shorturl.fm/zlzbf</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("602", "551", "Emilie4221", "Emilie4221@gmail.com", "", "170.254.173.106", "2025-08-08 08:01:11", "2025-08-08 13:01:11", "<a href=\"https://shorturl.fm/USgln\" rel=\"nofollow ugc\">https://shorturl.fm/USgln</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("603", "531", "Aubrey3917", "Aubrey3917@gmail.com", "", "190.120.249.144", "2025-08-08 08:01:14", "2025-08-08 13:01:14", "<a href=\"https://shorturl.fm/KcgxL\" rel=\"nofollow ugc\">https://shorturl.fm/KcgxL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("604", "1", "Corinne2280", "Corinne2280@gmail.com", "", "38.51.177.6", "2025-08-08 08:01:18", "2025-08-08 13:01:18", "<a href=\"https://shorturl.fm/3lIkW\" rel=\"nofollow ugc\">https://shorturl.fm/3lIkW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("605", "556", "Lauryn3547", "Lauryn3547@gmail.com", "", "136.37.194.159", "2025-08-08 14:31:59", "2025-08-08 19:31:59", "<a href=\"https://shorturl.fm/YFhrH\" rel=\"nofollow ugc\">https://shorturl.fm/YFhrH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("606", "556", "Ayla753", "Ayla753@gmail.com", "", "76.170.224.180", "2025-08-08 20:15:46", "2025-08-09 01:15:46", "<a href=\"https://shorturl.fm/sBmOc\" rel=\"nofollow ugc\">https://shorturl.fm/sBmOc</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("607", "551", "Chance2970", "Chance2970@gmail.com", "", "67.187.123.115", "2025-08-08 20:15:48", "2025-08-09 01:15:48", "<a href=\"https://shorturl.fm/odrog\" rel=\"nofollow ugc\">https://shorturl.fm/odrog</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("608", "531", "Alissa1014", "Alissa1014@gmail.com", "", "64.31.25.182", "2025-08-08 20:15:50", "2025-08-09 01:15:50", "<a href=\"https://shorturl.fm/odrog\" rel=\"nofollow ugc\">https://shorturl.fm/odrog</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("609", "1", "Lincoln1145", "Lincoln1145@gmail.com", "", "98.186.197.124", "2025-08-08 20:15:51", "2025-08-09 01:15:51", "<a href=\"https://shorturl.fm/trCpN\" rel=\"nofollow ugc\">https://shorturl.fm/trCpN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("610", "556", "Lilly2452", "Lilly2452@gmail.com", "", "36.83.137.24", "2025-08-08 21:36:16", "2025-08-09 02:36:16", "<a href=\"https://shorturl.fm/FmIX1\" rel=\"nofollow ugc\">https://shorturl.fm/FmIX1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("611", "556", "Nicole4162", "Nicole4162@gmail.com", "", "162.226.173.50", "2025-08-09 01:54:23", "2025-08-09 06:54:23", "<a href=\"https://shorturl.fm/CrZOn\" rel=\"nofollow ugc\">https://shorturl.fm/CrZOn</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("612", "556", "Spencer9", "Spencer9@gmail.com", "", "116.98.237.103", "2025-08-09 02:46:24", "2025-08-09 07:46:24", "<a href=\"https://shorturl.fm/xjPFK\" rel=\"nofollow ugc\">https://shorturl.fm/xjPFK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("613", "556", "Curtis4403", "Curtis4403@gmail.com", "", "102.218.195.238", "2025-08-09 20:20:51", "2025-08-10 01:20:51", "<a href=\"https://shorturl.fm/yh2H2\" rel=\"nofollow ugc\">https://shorturl.fm/yh2H2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("614", "556", "Krystal4274", "Krystal4274@gmail.com", "", "1.174.175.67", "2025-08-09 21:47:46", "2025-08-10 02:47:46", "<a href=\"https://shorturl.fm/UIfDi\" rel=\"nofollow ugc\">https://shorturl.fm/UIfDi</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("615", "556", "Jay4109", "Jay4109@gmail.com", "", "186.65.19.243", "2025-08-10 00:10:20", "2025-08-10 05:10:20", "<a href=\"https://shorturl.fm/lBlQQ\" rel=\"nofollow ugc\">https://shorturl.fm/lBlQQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("616", "556", "Amber1963", "Amber1963@gmail.com", "", "142.117.72.244", "2025-08-10 10:49:09", "2025-08-10 15:49:09", "<a href=\"https://shorturl.fm/JwcwH\" rel=\"nofollow ugc\">https://shorturl.fm/JwcwH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("617", "556", "Josiah3354", "Josiah3354@gmail.com", "", "180.251.234.129", "2025-08-10 18:51:20", "2025-08-10 23:51:20", "<a href=\"https://shorturl.fm/dlyzK\" rel=\"nofollow ugc\">https://shorturl.fm/dlyzK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("618", "556", "Antonio719", "Antonio719@gmail.com", "", "162.234.114.42", "2025-08-11 10:46:24", "2025-08-11 15:46:24", "<a href=\"https://shorturl.fm/DxCAC\" rel=\"nofollow ugc\">https://shorturl.fm/DxCAC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("619", "551", "Cameron3144", "Cameron3144@gmail.com", "", "162.234.114.42", "2025-08-11 10:46:40", "2025-08-11 15:46:40", "<a href=\"https://shorturl.fm/dbTYA\" rel=\"nofollow ugc\">https://shorturl.fm/dbTYA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("620", "531", "Melissa3653", "Melissa3653@gmail.com", "", "162.234.114.42", "2025-08-11 10:46:55", "2025-08-11 15:46:55", "<a href=\"https://shorturl.fm/qIgXo\" rel=\"nofollow ugc\">https://shorturl.fm/qIgXo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("621", "1", "Iris170", "Iris170@gmail.com", "", "162.234.114.42", "2025-08-11 10:47:14", "2025-08-11 15:47:14", "<a href=\"https://shorturl.fm/CTBNB\" rel=\"nofollow ugc\">https://shorturl.fm/CTBNB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("622", "556", "Camille652", "Camille652@gmail.com", "", "86.99.140.136", "2025-08-11 10:58:29", "2025-08-11 15:58:29", "<a href=\"https://shorturl.fm/PGrl8\" rel=\"nofollow ugc\">https://shorturl.fm/PGrl8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("623", "551", "Josh817", "Josh817@gmail.com", "", "86.99.140.136", "2025-08-11 10:58:54", "2025-08-11 15:58:54", "<a href=\"https://shorturl.fm/vSKuf\" rel=\"nofollow ugc\">https://shorturl.fm/vSKuf</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("624", "531", "Kourtney4872", "Kourtney4872@gmail.com", "", "86.99.140.136", "2025-08-11 10:59:20", "2025-08-11 15:59:20", "<a href=\"https://shorturl.fm/upEfy\" rel=\"nofollow ugc\">https://shorturl.fm/upEfy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("625", "1", "Maxwell4310", "Maxwell4310@gmail.com", "", "86.99.140.136", "2025-08-11 10:59:47", "2025-08-11 15:59:47", "<a href=\"https://shorturl.fm/CIQI0\" rel=\"nofollow ugc\">https://shorturl.fm/CIQI0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("626", "556", "Quinn2139", "Quinn2139@gmail.com", "", "103.217.111.140", "2025-08-11 11:03:09", "2025-08-11 16:03:09", "<a href=\"https://shorturl.fm/KF4jN\" rel=\"nofollow ugc\">https://shorturl.fm/KF4jN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("627", "551", "Juan1648", "Juan1648@gmail.com", "", "103.217.111.140", "2025-08-11 11:03:34", "2025-08-11 16:03:34", "<a href=\"https://shorturl.fm/KFtcm\" rel=\"nofollow ugc\">https://shorturl.fm/KFtcm</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("628", "531", "Marie4369", "Marie4369@gmail.com", "", "103.217.111.140", "2025-08-11 11:03:58", "2025-08-11 16:03:58", "<a href=\"https://shorturl.fm/UGXRV\" rel=\"nofollow ugc\">https://shorturl.fm/UGXRV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("629", "1", "Loren4107", "Loren4107@gmail.com", "", "103.217.111.134", "2025-08-11 11:04:23", "2025-08-11 16:04:23", "<a href=\"https://shorturl.fm/JEYnp\" rel=\"nofollow ugc\">https://shorturl.fm/JEYnp</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("630", "556", "Chad3829", "Chad3829@gmail.com", "", "187.190.21.169", "2025-08-11 12:05:28", "2025-08-11 17:05:28", "<a href=\"https://shorturl.fm/ALS1W\" rel=\"nofollow ugc\">https://shorturl.fm/ALS1W</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("631", "531", "Taylor2109", "Taylor2109@gmail.com", "", "187.190.21.35", "2025-08-11 12:05:35", "2025-08-11 17:05:35", "<a href=\"https://shorturl.fm/D6PF5\" rel=\"nofollow ugc\">https://shorturl.fm/D6PF5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("632", "556", "Braxton1555", "Braxton1555@gmail.com", "", "181.115.119.45", "2025-08-11 12:49:57", "2025-08-11 17:49:57", "<a href=\"https://shorturl.fm/oXmf8\" rel=\"nofollow ugc\">https://shorturl.fm/oXmf8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("633", "556", "Debbie4317", "Debbie4317@gmail.com", "", "180.242.96.177", "2025-08-11 13:23:37", "2025-08-11 18:23:37", "<a href=\"https://shorturl.fm/MBzIQ\" rel=\"nofollow ugc\">https://shorturl.fm/MBzIQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("634", "551", "Evelyn1969", "Evelyn1969@gmail.com", "", "180.242.96.177", "2025-08-11 13:24:03", "2025-08-11 18:24:03", "<a href=\"https://shorturl.fm/MBzIQ\" rel=\"nofollow ugc\">https://shorturl.fm/MBzIQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("635", "531", "Madeline1978", "Madeline1978@gmail.com", "", "180.242.96.177", "2025-08-11 13:24:27", "2025-08-11 18:24:27", "<a href=\"https://shorturl.fm/KP4TD\" rel=\"nofollow ugc\">https://shorturl.fm/KP4TD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("636", "556", "Evie1882", "Evie1882@gmail.com", "", "118.174.92.61", "2025-08-12 13:15:20", "2025-08-12 18:15:20", "<a href=\"https://shorturl.fm/E1aeX\" rel=\"nofollow ugc\">https://shorturl.fm/E1aeX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("637", "556", "McKenzie2589", "McKenzie2589@gmail.com", "", "177.93.4.185", "2025-08-13 02:20:19", "2025-08-13 07:20:19", "<a href=\"https://shorturl.fm/pYmRl\" rel=\"nofollow ugc\">https://shorturl.fm/pYmRl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("638", "556", "Roy4893", "Roy4893@gmail.com", "", "12.55.139.158", "2025-08-13 20:45:17", "2025-08-14 01:45:17", "<a href=\"https://shorturl.fm/yzAai\" rel=\"nofollow ugc\">https://shorturl.fm/yzAai</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("639", "556", "Ashley648", "Ashley648@gmail.com", "", "208.87.242.105", "2025-08-13 20:53:14", "2025-08-14 01:53:14", "<a href=\"https://shorturl.fm/zjekS\" rel=\"nofollow ugc\">https://shorturl.fm/zjekS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("640", "556", "Kenneth1115", "Kenneth1115@gmail.com", "", "158.62.92.203", "2025-08-14 00:06:03", "2025-08-14 05:06:03", "<a href=\"https://shorturl.fm/Va46x\" rel=\"nofollow ugc\">https://shorturl.fm/Va46x</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("641", "556", "Desirae1958", "Desirae1958@gmail.com", "", "181.66.150.70", "2025-08-14 00:21:42", "2025-08-14 05:21:42", "<a href=\"https://shorturl.fm/bwkxK\" rel=\"nofollow ugc\">https://shorturl.fm/bwkxK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("642", "556", "Greg4948", "Greg4948@gmail.com", "", "1.53.92.114", "2025-08-14 03:33:36", "2025-08-14 08:33:36", "<a href=\"https://shorturl.fm/1Zxzw\" rel=\"nofollow ugc\">https://shorturl.fm/1Zxzw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("643", "556", "Jared4543", "Jared4543@gmail.com", "", "36.239.202.123", "2025-08-14 04:09:47", "2025-08-14 09:09:47", "<a href=\"https://shorturl.fm/L3954\" rel=\"nofollow ugc\">https://shorturl.fm/L3954</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("644", "556", "Jude831", "Jude831@gmail.com", "", "176.108.243.174", "2025-08-14 11:02:23", "2025-08-14 16:02:23", "<a href=\"https://shorturl.fm/VaWrH\" rel=\"nofollow ugc\">https://shorturl.fm/VaWrH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("645", "556", "Darryl3070", "Darryl3070@gmail.com", "", "27.79.239.112", "2025-08-14 12:50:45", "2025-08-14 17:50:45", "<a href=\"https://shorturl.fm/Auxfp\" rel=\"nofollow ugc\">https://shorturl.fm/Auxfp</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("646", "556", "Barbara4322", "Barbara4322@gmail.com", "", "116.105.103.19", "2025-08-14 14:33:03", "2025-08-14 19:33:03", "<a href=\"https://shorturl.fm/vDwAj\" rel=\"nofollow ugc\">https://shorturl.fm/vDwAj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("647", "556", "Ruth736", "Ruth736@gmail.com", "", "184.82.136.114", "2025-08-14 19:36:51", "2025-08-15 00:36:51", "<a href=\"https://shorturl.fm/t3Oim\" rel=\"nofollow ugc\">https://shorturl.fm/t3Oim</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("648", "556", "Louis4454", "Louis4454@gmail.com", "", "119.235.218.56", "2025-08-14 23:05:28", "2025-08-15 04:05:28", "<a href=\"https://shorturl.fm/ShDJv\" rel=\"nofollow ugc\">https://shorturl.fm/ShDJv</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("649", "556", "Desirae1916", "Desirae1916@gmail.com", "", "209.53.155.82", "2025-08-15 09:01:36", "2025-08-15 14:01:36", "<a href=\"https://shorturl.fm/bq936\" rel=\"nofollow ugc\">https://shorturl.fm/bq936</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("650", "556", "Vera27", "Vera27@gmail.com", "", "94.74.91.27", "2025-08-15 20:09:05", "2025-08-16 01:09:05", "<a href=\"https://shorturl.fm/ciIFV\" rel=\"nofollow ugc\">https://shorturl.fm/ciIFV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("651", "556", "Pearl3913", "Pearl3913@gmail.com", "", "128.199.188.66", "2025-08-16 00:35:01", "2025-08-16 05:35:01", "<a href=\"https://shorturl.fm/1S7VP\" rel=\"nofollow ugc\">https://shorturl.fm/1S7VP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("652", "556", "Savannah1198", "Savannah1198@gmail.com", "", "223.185.26.65", "2025-08-16 01:58:58", "2025-08-16 06:58:58", "<a href=\"https://shorturl.fm/oCvCG\" rel=\"nofollow ugc\">https://shorturl.fm/oCvCG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("653", "556", "Dawn2199", "Dawn2199@gmail.com", "", "180.105.65.101", "2025-08-16 11:17:05", "2025-08-16 16:17:05", "<a href=\"https://shorturl.fm/CujVw\" rel=\"nofollow ugc\">https://shorturl.fm/CujVw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("654", "556", "Nolan3973", "Nolan3973@gmail.com", "", "179.225.150.172", "2025-08-16 11:25:19", "2025-08-16 16:25:19", "<a href=\"https://shorturl.fm/emQhU\" rel=\"nofollow ugc\">https://shorturl.fm/emQhU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("655", "556", "Clara134", "Clara134@gmail.com", "", "37.231.218.184", "2025-08-16 13:17:00", "2025-08-16 18:17:00", "<a href=\"https://shorturl.fm/cy5u0\" rel=\"nofollow ugc\">https://shorturl.fm/cy5u0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("656", "551", "Clarence739", "Clarence739@gmail.com", "", "171.213.206.236", "2025-08-16 20:00:17", "2025-08-17 01:00:17", "<a href=\"https://shorturl.fm/YWeay\" rel=\"nofollow ugc\">https://shorturl.fm/YWeay</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("657", "556", "Elena2656", "Elena2656@gmail.com", "", "58.65.221.104", "2025-08-17 08:39:57", "2025-08-17 13:39:57", "<a href=\"https://shorturl.fm/52M1g\" rel=\"nofollow ugc\">https://shorturl.fm/52M1g</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("658", "556", "Agnes4447", "Agnes4447@gmail.com", "", "99.247.16.178", "2025-08-17 17:42:50", "2025-08-17 22:42:50", "<a href=\"https://shorturl.fm/lLAmn\" rel=\"nofollow ugc\">https://shorturl.fm/lLAmn</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("659", "556", "Briley3659", "Briley3659@gmail.com", "", "124.217.46.225", "2025-08-18 01:11:02", "2025-08-18 06:11:02", "<a href=\"https://shorturl.fm/F9M8I\" rel=\"nofollow ugc\">https://shorturl.fm/F9M8I</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("660", "551", "Scott2468", "Scott2468@gmail.com", "", "171.4.21.241", "2025-08-18 01:48:18", "2025-08-18 06:48:18", "<a href=\"https://shorturl.fm/gUKql\" rel=\"nofollow ugc\">https://shorturl.fm/gUKql</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("661", "556", "Kingston3346", "Kingston3346@gmail.com", "", "58.186.162.58", "2025-08-18 11:24:19", "2025-08-18 16:24:19", "<a href=\"https://shorturl.fm/4St9x\" rel=\"nofollow ugc\">https://shorturl.fm/4St9x</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("662", "556", "Vera4444", "Vera4444@gmail.com", "", "36.81.166.177", "2025-08-18 19:17:09", "2025-08-19 00:17:09", "<a href=\"https://shorturl.fm/m4QUU\" rel=\"nofollow ugc\">https://shorturl.fm/m4QUU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("663", "531", "Florence1030", "Florence1030@gmail.com", "", "36.81.166.177", "2025-08-18 19:17:26", "2025-08-19 00:17:26", "<a href=\"https://shorturl.fm/Y3zyG\" rel=\"nofollow ugc\">https://shorturl.fm/Y3zyG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("664", "556", "Zoe784", "Zoe784@gmail.com", "", "175.37.142.26", "2025-08-18 20:45:57", "2025-08-19 01:45:57", "<a href=\"https://shorturl.fm/fj3re\" rel=\"nofollow ugc\">https://shorturl.fm/fj3re</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("665", "556", "Mae2998", "Mae2998@gmail.com", "", "124.217.46.225", "2025-08-19 12:35:41", "2025-08-19 17:35:41", "<a href=\"https://shorturl.fm/Fdghr\" rel=\"nofollow ugc\">https://shorturl.fm/Fdghr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("666", "556", "Alexandra1607", "Alexandra1607@gmail.com", "", "160.238.226.84", "2025-08-19 16:11:19", "2025-08-19 21:11:19", "<a href=\"https://shorturl.fm/x6NTT\" rel=\"nofollow ugc\">https://shorturl.fm/x6NTT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("667", "556", "Heath2331", "Heath2331@gmail.com", "", "212.252.73.60", "2025-08-19 18:56:15", "2025-08-19 23:56:15", "<a href=\"https://shorturl.fm/pIwxM\" rel=\"nofollow ugc\">https://shorturl.fm/pIwxM</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("668", "556", "Natasha1100", "Natasha1100@gmail.com", "", "42.114.11.32", "2025-08-19 21:48:16", "2025-08-20 02:48:16", "<a href=\"https://shorturl.fm/R0IQg\" rel=\"nofollow ugc\">https://shorturl.fm/R0IQg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("669", "556", "Atticus855", "Atticus855@gmail.com", "", "42.119.2.248", "2025-08-20 01:26:59", "2025-08-20 06:26:59", "<a href=\"https://shorturl.fm/hcEkP\" rel=\"nofollow ugc\">https://shorturl.fm/hcEkP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("670", "556", "Genevieve4290", "Genevieve4290@gmail.com", "", "181.29.172.32", "2025-08-20 12:00:25", "2025-08-20 17:00:25", "<a href=\"https://shorturl.fm/bNPao\" rel=\"nofollow ugc\">https://shorturl.fm/bNPao</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("671", "556", "Arabella1461", "Arabella1461@gmail.com", "", "124.13.211.55", "2025-08-20 17:42:05", "2025-08-20 22:42:05", "<a href=\"https://shorturl.fm/iUwZ7\" rel=\"nofollow ugc\">https://shorturl.fm/iUwZ7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("672", "556", "Sally2441", "Sally2441@gmail.com", "", "125.161.54.204", "2025-08-20 20:51:31", "2025-08-21 01:51:31", "<a href=\"https://shorturl.fm/cChNa\" rel=\"nofollow ugc\">https://shorturl.fm/cChNa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("673", "556", "Jeff1168", "Jeff1168@gmail.com", "", "58.186.48.34", "2025-08-20 21:56:29", "2025-08-21 02:56:29", "<a href=\"https://shorturl.fm/UUshc\" rel=\"nofollow ugc\">https://shorturl.fm/UUshc</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("674", "556", "Rachel4269", "Rachel4269@gmail.com", "", "116.103.249.24", "2025-08-21 00:30:51", "2025-08-21 05:30:51", "<a href=\"https://shorturl.fm/jtcnG\" rel=\"nofollow ugc\">https://shorturl.fm/jtcnG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("675", "556", "Julius2855", "Julius2855@gmail.com", "", "103.30.30.5", "2025-08-21 19:25:18", "2025-08-22 00:25:18", "<a href=\"https://shorturl.fm/C8L4f\" rel=\"nofollow ugc\">https://shorturl.fm/C8L4f</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("676", "531", "Alissa2746", "Alissa2746@gmail.com", "", "103.30.30.5", "2025-08-21 19:25:33", "2025-08-22 00:25:33", "<a href=\"https://shorturl.fm/0lcIo\" rel=\"nofollow ugc\">https://shorturl.fm/0lcIo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("677", "556", "Ally2163", "Ally2163@gmail.com", "", "103.158.97.83", "2025-08-21 20:17:24", "2025-08-22 01:17:24", "<a href=\"https://shorturl.fm/rqE4v\" rel=\"nofollow ugc\">https://shorturl.fm/rqE4v</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("678", "531", "Liam2532", "Liam2532@gmail.com", "", "103.158.97.83", "2025-08-21 20:17:43", "2025-08-22 01:17:43", "<a href=\"https://shorturl.fm/umfQA\" rel=\"nofollow ugc\">https://shorturl.fm/umfQA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("679", "556", "Kason576", "Kason576@gmail.com", "", "103.187.162.39", "2025-08-21 20:28:43", "2025-08-22 01:28:43", "<a href=\"https://shorturl.fm/UgbY1\" rel=\"nofollow ugc\">https://shorturl.fm/UgbY1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("680", "556", "Deborah195", "Deborah195@gmail.com", "", "82.86.134.205", "2025-08-22 05:58:21", "2025-08-22 10:58:21", "<a href=\"https://shorturl.fm/dIbFu\" rel=\"nofollow ugc\">https://shorturl.fm/dIbFu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("681", "556", "Casey3433", "Casey3433@gmail.com", "", "187.57.232.184", "2025-08-22 06:50:10", "2025-08-22 11:50:10", "<a href=\"https://shorturl.fm/U9miN\" rel=\"nofollow ugc\">https://shorturl.fm/U9miN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("682", "556", "Lillian1375", "Lillian1375@gmail.com", "", "118.174.126.157", "2025-08-22 21:03:52", "2025-08-23 02:03:52", "<a href=\"https://shorturl.fm/VSuCC\" rel=\"nofollow ugc\">https://shorturl.fm/VSuCC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("683", "531", "Tara578", "Tara578@gmail.com", "", "118.174.126.157", "2025-08-22 21:04:16", "2025-08-23 02:04:16", "<a href=\"https://shorturl.fm/gbjd1\" rel=\"nofollow ugc\">https://shorturl.fm/gbjd1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("684", "556", "Kaden4600", "Kaden4600@gmail.com", "", "175.198.46.59", "2025-08-23 03:06:08", "2025-08-23 08:06:08", "<a href=\"https://shorturl.fm/jFSda\" rel=\"nofollow ugc\">https://shorturl.fm/jFSda</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("685", "556", "Christine3684", "Christine3684@gmail.com", "", "172.56.95.134", "2025-08-23 04:23:06", "2025-08-23 09:23:06", "<a href=\"https://shorturl.fm/YaoQ9\" rel=\"nofollow ugc\">https://shorturl.fm/YaoQ9</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("686", "556", "Janelle414", "Janelle414@gmail.com", "", "61.92.181.45", "2025-08-23 10:29:58", "2025-08-23 15:29:58", "<a href=\"https://shorturl.fm/vGrBb\" rel=\"nofollow ugc\">https://shorturl.fm/vGrBb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("687", "556", "Aria1637", "Aria1637@gmail.com", "", "72.50.7.137", "2025-08-23 20:53:12", "2025-08-24 01:53:12", "<a href=\"https://shorturl.fm/WVGlt\" rel=\"nofollow ugc\">https://shorturl.fm/WVGlt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("688", "551", "Lane2861", "Lane2861@gmail.com", "", "72.50.4.94", "2025-08-23 20:53:13", "2025-08-24 01:53:13", "<a href=\"https://shorturl.fm/6yxkd\" rel=\"nofollow ugc\">https://shorturl.fm/6yxkd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("689", "531", "Noelle4130", "Noelle4130@gmail.com", "", "72.50.5.187", "2025-08-23 20:53:15", "2025-08-24 01:53:15", "<a href=\"https://shorturl.fm/KiEmw\" rel=\"nofollow ugc\">https://shorturl.fm/KiEmw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("690", "1", "Benjamin3463", "Benjamin3463@gmail.com", "", "72.50.4.34", "2025-08-23 20:53:16", "2025-08-24 01:53:16", "<a href=\"https://shorturl.fm/QgJ9E\" rel=\"nofollow ugc\">https://shorturl.fm/QgJ9E</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("691", "556", "Cale1518", "Cale1518@gmail.com", "", "61.5.149.83", "2025-08-24 02:45:58", "2025-08-24 07:45:58", "<a href=\"https://shorturl.fm/prArl\" rel=\"nofollow ugc\">https://shorturl.fm/prArl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("692", "556", "Zachary4123", "Zachary4123@gmail.com", "", "120.28.195.34", "2025-08-24 03:54:40", "2025-08-24 08:54:40", "<a href=\"https://shorturl.fm/FsDrR\" rel=\"nofollow ugc\">https://shorturl.fm/FsDrR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("693", "556", "Abram2263", "Abram2263@gmail.com", "", "46.114.242.180", "2025-08-24 04:36:29", "2025-08-24 09:36:29", "<a href=\"https://shorturl.fm/gitDF\" rel=\"nofollow ugc\">https://shorturl.fm/gitDF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("694", "556", "Annie4149", "Annie4149@gmail.com", "", "181.119.84.124", "2025-08-24 17:32:55", "2025-08-24 22:32:55", "<a href=\"https://shorturl.fm/j430W\" rel=\"nofollow ugc\">https://shorturl.fm/j430W</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("695", "556", "Brandy644", "Brandy644@gmail.com", "", "223.123.113.253", "2025-08-24 18:38:28", "2025-08-24 23:38:28", "<a href=\"https://shorturl.fm/vugAT\" rel=\"nofollow ugc\">https://shorturl.fm/vugAT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("696", "556", "Valerie2444", "Valerie2444@gmail.com", "", "125.24.199.56", "2025-08-25 06:22:49", "2025-08-25 11:22:49", "<a href=\"https://shorturl.fm/ZKKl2\" rel=\"nofollow ugc\">https://shorturl.fm/ZKKl2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("697", "556", "Damian548", "Damian548@gmail.com", "", "27.79.192.233", "2025-08-25 15:24:09", "2025-08-25 20:24:09", "<a href=\"https://shorturl.fm/4N8pw\" rel=\"nofollow ugc\">https://shorturl.fm/4N8pw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("698", "556", "Bonnie4526", "Bonnie4526@gmail.com", "", "103.162.178.198", "2025-08-26 06:43:05", "2025-08-26 11:43:05", "<a href=\"https://shorturl.fm/INHeH\" rel=\"nofollow ugc\">https://shorturl.fm/INHeH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("699", "556", "Travis3275", "Travis3275@gmail.com", "", "4.248.96.5", "2025-08-26 18:56:28", "2025-08-26 23:56:28", "<a href=\"https://shorturl.fm/8sPJe\" rel=\"nofollow ugc\">https://shorturl.fm/8sPJe</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("700", "556", "Bryant580", "Bryant580@gmail.com", "", "103.19.109.40", "2025-08-27 02:08:09", "2025-08-27 07:08:09", "<a href=\"https://shorturl.fm/A4OCk\" rel=\"nofollow ugc\">https://shorturl.fm/A4OCk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("701", "556", "Kim2667", "Kim2667@gmail.com", "", "186.23.2.98", "2025-08-27 07:44:29", "2025-08-27 12:44:29", "<a href=\"https://shorturl.fm/hIcCZ\" rel=\"nofollow ugc\">https://shorturl.fm/hIcCZ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("702", "531", "Christian92", "Christian92@gmail.com", "", "186.23.2.98", "2025-08-27 07:45:17", "2025-08-27 12:45:17", "<a href=\"https://shorturl.fm/8K87j\" rel=\"nofollow ugc\">https://shorturl.fm/8K87j</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("703", "556", "Ryder2334", "Ryder2334@gmail.com", "", "96.87.197.141", "2025-08-27 09:29:44", "2025-08-27 14:29:44", "<a href=\"https://shorturl.fm/VoDl8\" rel=\"nofollow ugc\">https://shorturl.fm/VoDl8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("704", "551", "Judith3453", "Judith3453@gmail.com", "", "96.87.197.141", "2025-08-27 09:30:17", "2025-08-27 14:30:17", "<a href=\"https://shorturl.fm/2P2N5\" rel=\"nofollow ugc\">https://shorturl.fm/2P2N5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("705", "1", "Mallory4507", "Mallory4507@gmail.com", "", "96.87.197.141", "2025-08-27 09:30:36", "2025-08-27 14:30:36", "<a href=\"https://shorturl.fm/A9k3n\" rel=\"nofollow ugc\">https://shorturl.fm/A9k3n</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("706", "556", "Ginger3593", "Ginger3593@gmail.com", "", "116.99.61.202", "2025-08-28 04:20:54", "2025-08-28 09:20:54", "<a href=\"https://shorturl.fm/PFs79\" rel=\"nofollow ugc\">https://shorturl.fm/PFs79</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("707", "556", "Ayla3104", "Ayla3104@gmail.com", "", "123.20.16.20", "2025-08-28 16:40:54", "2025-08-28 21:40:54", "<a href=\"https://shorturl.fm/CjWGN\" rel=\"nofollow ugc\">https://shorturl.fm/CjWGN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("708", "556", "Melanie1310", "Melanie1310@gmail.com", "", "101.108.194.82", "2025-08-28 18:32:37", "2025-08-28 23:32:37", "<a href=\"https://shorturl.fm/TeF9x\" rel=\"nofollow ugc\">https://shorturl.fm/TeF9x</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("709", "556", "Alastair4774", "Alastair4774@gmail.com", "", "200.105.247.50", "2025-08-28 20:06:50", "2025-08-29 01:06:50", "<a href=\"https://shorturl.fm/LWltN\" rel=\"nofollow ugc\">https://shorturl.fm/LWltN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("710", "556", "Denise2358", "Denise2358@gmail.com", "", "190.219.169.17", "2025-08-28 23:25:06", "2025-08-29 04:25:06", "<a href=\"https://shorturl.fm/mEsCh\" rel=\"nofollow ugc\">https://shorturl.fm/mEsCh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("711", "556", "Haley910", "Haley910@gmail.com", "", "27.79.214.188", "2025-08-29 00:31:09", "2025-08-29 05:31:09", "<a href=\"https://shorturl.fm/ZaoE8\" rel=\"nofollow ugc\">https://shorturl.fm/ZaoE8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("712", "556", "Hayden3142", "Hayden3142@gmail.com", "", "178.87.205.189", "2025-08-29 05:12:15", "2025-08-29 10:12:15", "<a href=\"https://shorturl.fm/rLjqw\" rel=\"nofollow ugc\">https://shorturl.fm/rLjqw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("713", "556", "Dennis3520", "Dennis3520@gmail.com", "", "136.227.221.148", "2025-08-29 10:40:28", "2025-08-29 15:40:28", "<a href=\"https://shorturl.fm/WqvaR\" rel=\"nofollow ugc\">https://shorturl.fm/WqvaR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("714", "556", "Marissa3691", "Marissa3691@gmail.com", "", "122.161.75.64", "2025-08-30 09:46:28", "2025-08-30 14:46:28", "<a href=\"https://shorturl.fm/BME7x\" rel=\"nofollow ugc\">https://shorturl.fm/BME7x</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("715", "556", "Cody2477", "Cody2477@gmail.com", "", "74.70.68.240", "2025-08-30 19:10:46", "2025-08-31 00:10:46", "<a href=\"https://shorturl.fm/LOCMM\" rel=\"nofollow ugc\">https://shorturl.fm/LOCMM</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("716", "556", "Easton3486", "Easton3486@gmail.com", "", "49.48.81.85", "2025-08-31 02:28:23", "2025-08-31 07:28:23", "<a href=\"https://shorturl.fm/BAdIH\" rel=\"nofollow ugc\">https://shorturl.fm/BAdIH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("717", "551", "Jeannette4713", "Jeannette4713@gmail.com", "", "103.217.111.86", "2025-08-31 23:25:17", "2025-09-01 04:25:17", "<a href=\"https://shorturl.fm/AYXEi\" rel=\"nofollow ugc\">https://shorturl.fm/AYXEi</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("718", "556", "Tomas4829", "Tomas4829@gmail.com", "", "187.94.111.211", "2025-09-01 00:48:34", "2025-09-01 05:48:34", "<a href=\"https://shorturl.fm/Qyq43\" rel=\"nofollow ugc\">https://shorturl.fm/Qyq43</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("719", "556", "Geoff3016", "Geoff3016@gmail.com", "", "27.71.129.229", "2025-09-01 04:47:10", "2025-09-01 09:47:10", "<a href=\"https://shorturl.fm/HxoIG\" rel=\"nofollow ugc\">https://shorturl.fm/HxoIG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("720", "556", "Julian4427", "Julian4427@gmail.com", "", "74.89.194.194", "2025-09-01 10:13:13", "2025-09-01 15:13:13", "<a href=\"https://shorturl.fm/tzJe7\" rel=\"nofollow ugc\">https://shorturl.fm/tzJe7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("721", "556", "Autumn825", "Autumn825@gmail.com", "", "73.76.70.78", "2025-09-01 16:49:40", "2025-09-01 21:49:40", "<a href=\"https://shorturl.fm/bl85z\" rel=\"nofollow ugc\">https://shorturl.fm/bl85z</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("722", "556", "Carl1454", "Carl1454@gmail.com", "", "171.241.228.209", "2025-09-02 01:18:07", "2025-09-02 06:18:07", "<a href=\"https://shorturl.fm/9zW9J\" rel=\"nofollow ugc\">https://shorturl.fm/9zW9J</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("723", "556", "Ignacio4803", "Ignacio4803@gmail.com", "", "194.110.13.86", "2025-09-02 09:58:56", "2025-09-02 14:58:56", "<a href=\"https://shorturl.fm/7WXdK\" rel=\"nofollow ugc\">https://shorturl.fm/7WXdK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("724", "556", "Gerard4570", "Gerard4570@gmail.com", "", "194.28.157.199", "2025-09-02 11:09:09", "2025-09-02 16:09:09", "<a href=\"https://shorturl.fm/7WXdK\" rel=\"nofollow ugc\">https://shorturl.fm/7WXdK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("725", "556", "Theresa2224", "Theresa2224@gmail.com", "", "171.252.107.139", "2025-09-02 19:33:22", "2025-09-03 00:33:22", "<a href=\"https://shorturl.fm/3eqyn\" rel=\"nofollow ugc\">https://shorturl.fm/3eqyn</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("726", "556", "Kirsten1952", "Kirsten1952@gmail.com", "", "27.71.139.184", "2025-09-02 20:48:30", "2025-09-03 01:48:30", "<a href=\"https://shorturl.fm/2bm9D\" rel=\"nofollow ugc\">https://shorturl.fm/2bm9D</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("727", "556", "Doug3538", "Doug3538@gmail.com", "", "92.58.181.171", "2025-09-03 20:25:06", "2025-09-04 01:25:06", "<a href=\"https://shorturl.fm/udziZ\" rel=\"nofollow ugc\">https://shorturl.fm/udziZ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("728", "556", "Jorge4618", "Jorge4618@gmail.com", "", "45.125.4.210", "2025-09-04 03:30:42", "2025-09-04 08:30:42", "<a href=\"https://shorturl.fm/xoMuG\" rel=\"nofollow ugc\">https://shorturl.fm/xoMuG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("729", "556", "William2317", "William2317@gmail.com", "", "161.142.191.28", "2025-09-04 10:09:32", "2025-09-04 15:09:32", "<a href=\"https://shorturl.fm/VnXVJ\" rel=\"nofollow ugc\">https://shorturl.fm/VnXVJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("730", "556", "Katie3035", "Katie3035@gmail.com", "", "113.211.215.226", "2025-09-04 13:03:34", "2025-09-04 18:03:34", "<a href=\"https://shorturl.fm/QvFrL\" rel=\"nofollow ugc\">https://shorturl.fm/QvFrL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("731", "556", "Natalie2995", "Natalie2995@gmail.com", "", "200.117.88.167", "2025-09-04 14:40:40", "2025-09-04 19:40:40", "<a href=\"https://shorturl.fm/spfw7\" rel=\"nofollow ugc\">https://shorturl.fm/spfw7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("732", "556", "Ethan1898", "Ethan1898@gmail.com", "", "136.158.102.129", "2025-09-04 21:40:26", "2025-09-05 02:40:26", "<a href=\"https://shorturl.fm/0hiqG\" rel=\"nofollow ugc\">https://shorturl.fm/0hiqG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("733", "551", "Hanna1639", "Hanna1639@gmail.com", "", "136.158.102.129", "2025-09-04 21:40:41", "2025-09-05 02:40:41", "<a href=\"https://shorturl.fm/jfNbK\" rel=\"nofollow ugc\">https://shorturl.fm/jfNbK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("734", "556", "Marley391", "Marley391@gmail.com", "", "116.107.95.129", "2025-09-05 00:34:10", "2025-09-05 05:34:10", "<a href=\"https://shorturl.fm/GTOro\" rel=\"nofollow ugc\">https://shorturl.fm/GTOro</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("735", "556", "Layla1137", "Layla1137@gmail.com", "", "182.253.143.178", "2025-09-05 01:22:07", "2025-09-05 06:22:07", "<a href=\"https://shorturl.fm/iIr0N\" rel=\"nofollow ugc\">https://shorturl.fm/iIr0N</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("736", "556", "Annabelle4332", "Annabelle4332@gmail.com", "", "86.98.218.44", "2025-09-05 01:47:00", "2025-09-05 06:47:00", "<a href=\"https://shorturl.fm/Gxv9K\" rel=\"nofollow ugc\">https://shorturl.fm/Gxv9K</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("737", "556", "Emma211", "Emma211@gmail.com", "", "86.96.88.5", "2025-09-05 14:23:54", "2025-09-05 19:23:54", "<a href=\"https://shorturl.fm/f3baW\" rel=\"nofollow ugc\">https://shorturl.fm/f3baW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("738", "556", "Bianca2415", "Bianca2415@gmail.com", "", "171.41.131.236", "2025-09-06 08:00:12", "2025-09-06 13:00:12", "<a href=\"https://shorturl.fm/Jb66m\" rel=\"nofollow ugc\">https://shorturl.fm/Jb66m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("739", "1", "1xbet_dsea", "oscpczgbcea@luck-and-magic.site", "https://1xbetapkegypt.com/", "62.113.116.213", "2025-09-06 23:13:16", "2025-09-07 04:13:16", "للاستمتاع بجميع الوظائف والمراهنات الرياضية، قم بما يلي <a href=\"https://1xbetapkegypt.com/\" / rel=\"nofollow ugc\">تحميل وان اكسبت</a> وقم بتثبيت التطبيق على جهازك. \r\nتشغيل التطبيق، ستحتاج", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("740", "551", "Alden1572", "Alden1572@gmail.com", "", "193.105.234.89", "2025-09-07 00:27:20", "2025-09-07 05:27:20", "<a href=\"https://shorturl.fm/kQnSf\" rel=\"nofollow ugc\">https://shorturl.fm/kQnSf</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("741", "556", "Sharon1928", "Sharon1928@gmail.com", "", "115.72.11.185", "2025-09-07 02:59:03", "2025-09-07 07:59:03", "<a href=\"https://shorturl.fm/CzDVO\" rel=\"nofollow ugc\">https://shorturl.fm/CzDVO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("742", "556", "Tanya735", "Tanya735@gmail.com", "", "1.20.169.147", "2025-09-07 11:00:05", "2025-09-07 16:00:05", "<a href=\"https://shorturl.fm/v1yGN\" rel=\"nofollow ugc\">https://shorturl.fm/v1yGN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("743", "556", "Wayne4136", "Wayne4136@gmail.com", "", "103.191.254.151", "2025-09-07 16:24:55", "2025-09-07 21:24:55", "<a href=\"https://shorturl.fm/hsxJ0\" rel=\"nofollow ugc\">https://shorturl.fm/hsxJ0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("744", "556", "Desirae4986", "Desirae4986@gmail.com", "", "223.206.140.211", "2025-09-07 21:02:51", "2025-09-08 02:02:51", "<a href=\"https://shorturl.fm/sVO58\" rel=\"nofollow ugc\">https://shorturl.fm/sVO58</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("745", "556", "Bernice1531", "Bernice1531@gmail.com", "", "105.157.170.210", "2025-09-08 10:10:09", "2025-09-08 15:10:09", "<a href=\"https://shorturl.fm/UMTeu\" rel=\"nofollow ugc\">https://shorturl.fm/UMTeu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("746", "556", "Austin813", "Austin813@gmail.com", "", "41.221.94.18", "2025-09-08 11:23:29", "2025-09-08 16:23:29", "<a href=\"https://shorturl.fm/WMqom\" rel=\"nofollow ugc\">https://shorturl.fm/WMqom</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("747", "556", "Jordan2538", "Jordan2538@gmail.com", "", "49.151.184.238", "2025-09-08 11:38:34", "2025-09-08 16:38:34", "<a href=\"https://shorturl.fm/Sbo3Z\" rel=\"nofollow ugc\">https://shorturl.fm/Sbo3Z</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("748", "556", "Aubree3566", "Aubree3566@gmail.com", "", "70.51.243.38", "2025-09-08 18:10:03", "2025-09-08 23:10:03", "<a href=\"https://shorturl.fm/xaQL1\" rel=\"nofollow ugc\">https://shorturl.fm/xaQL1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("749", "556", "Alana4576", "Alana4576@gmail.com", "", "175.118.246.102", "2025-09-09 02:03:08", "2025-09-09 07:03:08", "<a href=\"https://shorturl.fm/YQbdk\" rel=\"nofollow ugc\">https://shorturl.fm/YQbdk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("750", "556", "Alana2632", "Alana2632@gmail.com", "", "27.79.148.178", "2025-09-09 06:08:35", "2025-09-09 11:08:35", "<a href=\"https://shorturl.fm/ofvaJ\" rel=\"nofollow ugc\">https://shorturl.fm/ofvaJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("751", "556", "Nathan210", "Nathan210@gmail.com", "", "172.218.8.26", "2025-09-09 21:20:44", "2025-09-10 02:20:44", "<a href=\"https://shorturl.fm/pFGPY\" rel=\"nofollow ugc\">https://shorturl.fm/pFGPY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("752", "556", "Paris1764", "Paris1764@gmail.com", "", "38.51.120.86", "2025-09-10 03:15:29", "2025-09-10 08:15:29", "<a href=\"https://shorturl.fm/fpPrf\" rel=\"nofollow ugc\">https://shorturl.fm/fpPrf</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("753", "556", "Norman181", "Norman181@gmail.com", "", "45.119.83.172", "2025-09-10 05:32:39", "2025-09-10 10:32:39", "<a href=\"https://shorturl.fm/HejTt\" rel=\"nofollow ugc\">https://shorturl.fm/HejTt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("754", "556", "Frida3889", "Frida3889@gmail.com", "", "43.224.118.130", "2025-09-10 08:08:27", "2025-09-10 13:08:27", "<a href=\"https://shorturl.fm/B64kK\" rel=\"nofollow ugc\">https://shorturl.fm/B64kK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("755", "556", "Phyllis4803", "Phyllis4803@gmail.com", "", "190.85.2.170", "2025-09-10 09:32:11", "2025-09-10 14:32:11", "<a href=\"https://shorturl.fm/o1BEU\" rel=\"nofollow ugc\">https://shorturl.fm/o1BEU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("756", "556", "Barry3134", "Barry3134@gmail.com", "", "103.121.108.221", "2025-09-10 11:02:30", "2025-09-10 16:02:30", "<a href=\"https://shorturl.fm/myZlX\" rel=\"nofollow ugc\">https://shorturl.fm/myZlX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("757", "556", "Shirley2036", "Shirley2036@gmail.com", "", "176.126.103.194", "2025-09-11 08:30:47", "2025-09-11 13:30:47", "<a href=\"https://shorturl.fm/fG9td\" rel=\"nofollow ugc\">https://shorturl.fm/fG9td</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("758", "556", "Emory988", "Emory988@gmail.com", "", "213.152.161.10", "2025-09-11 14:47:45", "2025-09-11 19:47:45", "<a href=\"https://shorturl.fm/Eka5T\" rel=\"nofollow ugc\">https://shorturl.fm/Eka5T</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("759", "531", "Britney62", "Britney62@gmail.com", "", "213.152.161.10", "2025-09-11 14:48:02", "2025-09-11 19:48:02", "<a href=\"https://shorturl.fm/yJruN\" rel=\"nofollow ugc\">https://shorturl.fm/yJruN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("760", "556", "Harlan2772", "Harlan2772@gmail.com", "", "43.224.119.194", "2025-09-11 21:18:11", "2025-09-12 02:18:11", "<a href=\"https://shorturl.fm/319hR\" rel=\"nofollow ugc\">https://shorturl.fm/319hR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("761", "556", "Beryl1099", "Beryl1099@gmail.com", "", "131.216.14.89", "2025-09-11 22:22:07", "2025-09-12 03:22:07", "<a href=\"https://shorturl.fm/c9SrO\" rel=\"nofollow ugc\">https://shorturl.fm/c9SrO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("762", "551", "Ana1718", "Ana1718@gmail.com", "", "43.162.113.178", "2025-09-12 21:00:38", "2025-09-13 02:00:38", "<a href=\"https://shorturl.fm/ZCYOs\" rel=\"nofollow ugc\">https://shorturl.fm/ZCYOs</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("763", "556", "Greg534", "Greg534@gmail.com", "", "45.124.168.54", "2025-09-13 15:41:22", "2025-09-13 20:41:22", "<a href=\"https://shorturl.fm/Mbsa7\" rel=\"nofollow ugc\">https://shorturl.fm/Mbsa7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("764", "556", "Alastair3631", "Alastair3631@gmail.com", "", "119.73.97.209", "2025-09-13 19:13:18", "2025-09-14 00:13:18", "<a href=\"https://shorturl.fm/zuCK5\" rel=\"nofollow ugc\">https://shorturl.fm/zuCK5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("765", "556", "Colton2758", "Colton2758@gmail.com", "", "103.161.69.252", "2025-09-13 22:16:12", "2025-09-14 03:16:12", "<a href=\"https://shorturl.fm/AGsCb\" rel=\"nofollow ugc\">https://shorturl.fm/AGsCb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("766", "556", "Conner3528", "Conner3528@gmail.com", "", "43.156.226.40", "2025-09-14 00:17:58", "2025-09-14 05:17:58", "<a href=\"https://shorturl.fm/icQ2c\" rel=\"nofollow ugc\">https://shorturl.fm/icQ2c</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("767", "556", "Denise4360", "Denise4360@gmail.com", "", "223.204.194.252", "2025-09-14 02:08:37", "2025-09-14 07:08:37", "<a href=\"https://shorturl.fm/pyXs5\" rel=\"nofollow ugc\">https://shorturl.fm/pyXs5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("768", "556", "Sabrina4397", "Sabrina4397@gmail.com", "", "156.240.44.7", "2025-09-14 06:15:40", "2025-09-14 11:15:40", "<a href=\"https://shorturl.fm/xluFU\" rel=\"nofollow ugc\">https://shorturl.fm/xluFU</a>", "0", "0", "", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("769", "556", "Christina1152", "Christina1152@gmail.com", "", "43.224.116.65", "2025-09-14 12:37:37", "2025-09-14 17:37:37", "<a href=\"https://shorturl.fm/fchW5\" rel=\"nofollow ugc\">https://shorturl.fm/fchW5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("770", "556", "Layla1242", "Layla1242@gmail.com", "", "125.25.13.85", "2025-09-14 18:33:00", "2025-09-14 23:33:00", "<a href=\"https://shorturl.fm/Ed7kE\" rel=\"nofollow ugc\">https://shorturl.fm/Ed7kE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("771", "556", "Linda1415", "Linda1415@gmail.com", "", "171.6.154.185", "2025-09-15 01:26:51", "2025-09-15 06:26:51", "<a href=\"https://shorturl.fm/FWw1t\" rel=\"nofollow ugc\">https://shorturl.fm/FWw1t</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("772", "556", "Elliott4450", "Elliott4450@gmail.com", "", "103.87.215.65", "2025-09-15 03:59:23", "2025-09-15 08:59:23", "<a href=\"https://shorturl.fm/7lick\" rel=\"nofollow ugc\">https://shorturl.fm/7lick</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("773", "556", "Carlos4704", "Carlos4704@gmail.com", "", "115.72.3.142", "2025-09-15 09:29:20", "2025-09-15 14:29:20", "<a href=\"https://shorturl.fm/SKp8Y\" rel=\"nofollow ugc\">https://shorturl.fm/SKp8Y</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("774", "556", "Billie1055", "Billie1055@gmail.com", "", "190.112.107.180", "2025-09-15 15:21:26", "2025-09-15 20:21:26", "<a href=\"https://shorturl.fm/bs4nZ\" rel=\"nofollow ugc\">https://shorturl.fm/bs4nZ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("775", "556", "Luis4812", "Luis4812@gmail.com", "", "27.79.128.97", "2025-09-15 22:44:45", "2025-09-16 03:44:45", "<a href=\"https://shorturl.fm/H0Kn2\" rel=\"nofollow ugc\">https://shorturl.fm/H0Kn2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("776", "556", "Hank1872", "Hank1872@gmail.com", "", "92.97.67.87", "2025-09-16 03:15:40", "2025-09-16 08:15:40", "<a href=\"https://shorturl.fm/FpCCo\" rel=\"nofollow ugc\">https://shorturl.fm/FpCCo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("777", "556", "Bentley2304", "Bentley2304@gmail.com", "", "112.203.63.141", "2025-09-16 05:03:41", "2025-09-16 10:03:41", "<a href=\"https://shorturl.fm/HPnbf\" rel=\"nofollow ugc\">https://shorturl.fm/HPnbf</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("778", "556", "Brynn679", "Brynn679@gmail.com", "", "179.0.104.193", "2025-09-16 09:45:06", "2025-09-16 14:45:06", "<a href=\"https://shorturl.fm/vjhKy\" rel=\"nofollow ugc\">https://shorturl.fm/vjhKy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("779", "531", "Bonnie661", "Bonnie661@gmail.com", "", "168.231.75.7", "2025-09-17 02:31:13", "2025-09-17 07:31:13", "<a href=\"https://shorturl.fm/jTaPh\" rel=\"nofollow ugc\">https://shorturl.fm/jTaPh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("780", "556", "Landon3548", "Landon3548@gmail.com", "", "190.43.106.24", "2025-09-17 07:20:00", "2025-09-17 12:20:00", "<a href=\"https://shorturl.fm/XBLNV\" rel=\"nofollow ugc\">https://shorturl.fm/XBLNV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("781", "556", "Esperanza3750", "Esperanza3750@gmail.com", "", "201.224.191.130", "2025-09-17 14:22:25", "2025-09-17 19:22:25", "<a href=\"https://shorturl.fm/ZfUuT\" rel=\"nofollow ugc\">https://shorturl.fm/ZfUuT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("782", "1", "Ricardo4800", "Ricardo4800@gmail.com", "", "201.224.191.130", "2025-09-17 14:22:45", "2025-09-17 19:22:45", "<a href=\"https://shorturl.fm/YHRDk\" rel=\"nofollow ugc\">https://shorturl.fm/YHRDk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("783", "1", "888starz_isMt", "ljywwsqisMt@cosmicbridge.site", "https://888starz-uzbekistan.ru/", "62.113.116.213", "2025-09-17 14:48:49", "2025-09-17 19:48:49", "Ushbu platformada barcha tranzaksiyalar maxfiy holda amalga oshiriladi. \r\n \r\nOʻyinchilar turli sport tadbirlariga ham tikishlari mumkin. \r\n \r\nShuningdek, har bir birinchi tikish uchun maxsus sovgʻalar mavjud. \r\n \r\nRoʻyxatdan oʻtish uchun faqat telefon raqamini ham kiritish mumkin. \r\n \r\n888starz uzbekistan <a href=\"https://888starz-uzbekistan.ru/\" / rel=\"nofollow ugc\">https://888starz-uzbekistan.ru/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("784", "556", "Hazel427", "Hazel427@gmail.com", "", "190.159.96.214", "2025-09-17 17:27:30", "2025-09-17 22:27:30", "<a href=\"https://shorturl.fm/M8mvH\" rel=\"nofollow ugc\">https://shorturl.fm/M8mvH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("785", "556", "Eduardo898", "Eduardo898@gmail.com", "", "43.224.118.130", "2025-09-17 19:16:00", "2025-09-18 00:16:00", "<a href=\"https://shorturl.fm/iXZzN\" rel=\"nofollow ugc\">https://shorturl.fm/iXZzN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("786", "556", "Isabelle4601", "Isabelle4601@gmail.com", "", "103.140.87.181", "2025-09-17 22:33:51", "2025-09-18 03:33:51", "<a href=\"https://shorturl.fm/RZI0v\" rel=\"nofollow ugc\">https://shorturl.fm/RZI0v</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("787", "1", "888starz_mgMn", "uzbxegbwbMn@galaxygate.store", "https://888starz2.ru/", "89.110.99.186", "2025-09-18 11:40:16", "2025-09-18 16:40:16", "888starz – известных онлайн-казино, широкий выбор азартных игр. постоянно привлекает. для каждого клиента. \r\n \r\nИгроки в 888starz, предлагаемых на платформе. разработана и высококачественной графикой и увлекательным сюжетом. живую рулетку и с настоящими дилерами, чувство реального казино. \r\n \r\nбезопасность игроков. разнообразные методы депозита и вывода средств, что удобным и быстрым. защищены, что конфиденциальность информации. \r\n \r\nдля пользователей. команда профессионалов, в любое время суток. Вы можете связаться и на любые вопросы. Таким образом, комфорт. \r\n888 старс uzbekistan <a href=\"https://888starz2.ru/\" / rel=\"nofollow ugc\">https://888starz2.ru/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("788", "551", "Bradley2888", "Bradley2888@gmail.com", "", "103.230.62.102", "2025-09-18 12:57:25", "2025-09-18 17:57:25", "<a href=\"https://shorturl.fm/9VnyL\" rel=\"nofollow ugc\">https://shorturl.fm/9VnyL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("789", "556", "Dion401", "Dion401@gmail.com", "", "49.148.142.83", "2025-09-18 13:59:21", "2025-09-18 18:59:21", "<a href=\"https://shorturl.fm/DsEoy\" rel=\"nofollow ugc\">https://shorturl.fm/DsEoy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("790", "556", "Carol1886", "Carol1886@gmail.com", "", "144.124.228.87", "2025-09-18 14:24:09", "2025-09-18 19:24:09", "<a href=\"https://shorturl.fm/L9kBV\" rel=\"nofollow ugc\">https://shorturl.fm/L9kBV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("791", "1", "888starz_jmma", "wmjmkvwqjma@nebulanexus.site", "https://888starz-egypt-eg.com/", "178.20.42.76", "2025-09-18 17:37:17", "2025-09-18 22:37:17", "تتميز 888starz بشعبيتها في مجال القمار على الإنترنت. يقدم الموقع مجموعة متنوعة من الألعاب التي تلبي احتياجات جميع اللاعبين. تتضمن الألعاب المتاحة الرهانات الرياضية، وألعاب الكازينو. \r\n \r\nيوفر 888starz واجهة مستخدم بسيطة. يمتلك المستخدمون القدرة على التنقل بين الأقسام بصورة سلسة. هذا يجعل تجربة اللعب أكثر متعة. \r\n \r\nيستطيع المستخدمون الاستفادة من مجموعة متنوعة من المكافآت لجذب اللاعبين الجدد. تشمل هذه المكافآت مكافآت الترحيب بالإضافة إلى العروض الدورية. تعتبر هذه العروض حافزًا جيدًا لزيادة عدد اللاعبين. \r\n \r\nالأمان هو أحد أولويات 888starz. تعتمد المنصة على تقنيات متطورة لضمان حماية معلومات اللاعبين. يحقق ذلك مستوى عالٍ من الأمان أثناء اللعب. \r\n888starz iphone <a href=\"http://www.888starz-egypt-eg.com/apk\" rel=\"nofollow ugc\">https://888starz-egypt-eg.com/apk/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("792", "556", "Bryant4372", "Bryant4372@gmail.com", "", "115.74.3.161", "2025-09-19 04:09:14", "2025-09-19 09:09:14", "<a href=\"https://shorturl.fm/AKaj0\" rel=\"nofollow ugc\">https://shorturl.fm/AKaj0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("793", "556", "Josh4225", "Josh4225@gmail.com", "", "175.47.237.95", "2025-09-19 20:51:16", "2025-09-20 01:51:16", "<a href=\"https://shorturl.fm/XZgEU\" rel=\"nofollow ugc\">https://shorturl.fm/XZgEU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("794", "556", "Anton4236", "Anton4236@gmail.com", "", "38.248.133.255", "2025-09-20 06:50:20", "2025-09-20 11:50:20", "<a href=\"https://shorturl.fm/n3bAX\" rel=\"nofollow ugc\">https://shorturl.fm/n3bAX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("795", "556", "Nigel3790", "Nigel3790@gmail.com", "", "115.72.28.153", "2025-09-20 08:34:19", "2025-09-20 13:34:19", "<a href=\"https://shorturl.fm/jXaIe\" rel=\"nofollow ugc\">https://shorturl.fm/jXaIe</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("796", "531", "Julius2240", "Julius2240@gmail.com", "", "115.72.28.153", "2025-09-20 08:34:34", "2025-09-20 13:34:34", "<a href=\"https://shorturl.fm/LU8HA\" rel=\"nofollow ugc\">https://shorturl.fm/LU8HA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("797", "556", "Mona325", "Mona325@gmail.com", "", "180.191.214.238", "2025-09-21 02:15:03", "2025-09-21 07:15:03", "<a href=\"https://shorturl.fm/EgsbW\" rel=\"nofollow ugc\">https://shorturl.fm/EgsbW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("798", "1", "888starz_ixma", "agivcamdkma@nebulanexus.site", "https://888starz-egypt-eg.com/", "178.20.42.76", "2025-09-21 03:22:36", "2025-09-21 08:22:36", "تعتبر 888starz منصة معروفة في صناعة الألعاب الإلكترونية. يقدم الموقع مجموعة متنوعة من الألعاب التي تلبي احتياجات جميع اللاعبين. تشمل الألعاب المتوفرة الرهانات الرياضية وألعاب الكازينو. \r\n \r\nتتميز 888starz بتصميم سهل الاستخدام. يمكن للمستخدمين التنقل بين الأقسام بسهولة. يؤدي ذلك إلى تحسين تجربة اللعب. \r\n \r\nتقدم 888starz مجموعة من العروض الترويجية لجذب اللاعبين الجدد. يشمل ذلك مكافآت الترحيب والمكافآت الدورية. تعتبر هذه العروض حافزًا جيدًا لزيادة عدد اللاعبين. \r\n \r\nتعد الأمان من أبرز أولويات 888starz. تستخدم المنصة تقنيات حديثة لحماية بيانات المستخدمين. هذا يضمن تجربة لعب آمنة. \r\nرمز ترويجي 888starz <a href=\"https://www.888starz-africa.com/promo-code/\" / rel=\"nofollow ugc\">https://888starz-africa.com/promo-code/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("799", "556", "Alfredo3799", "Alfredo3799@gmail.com", "", "115.72.37.31", "2025-09-21 04:57:21", "2025-09-21 09:57:21", "<a href=\"https://shorturl.fm/GjW4B\" rel=\"nofollow ugc\">https://shorturl.fm/GjW4B</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("800", "556", "Aria965", "Aria965@gmail.com", "", "115.72.168.62", "2025-09-21 05:39:07", "2025-09-21 10:39:07", "<a href=\"https://shorturl.fm/GjW4B\" rel=\"nofollow ugc\">https://shorturl.fm/GjW4B</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("801", "551", "Freddie772", "Freddie772@gmail.com", "", "103.157.79.166", "2025-09-21 06:33:56", "2025-09-21 11:33:56", "<a href=\"https://shorturl.fm/6drVd\" rel=\"nofollow ugc\">https://shorturl.fm/6drVd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("802", "556", "Marisa920", "Marisa920@gmail.com", "", "45.119.83.172", "2025-09-21 10:10:13", "2025-09-21 15:10:13", "<a href=\"https://shorturl.fm/SCnVB\" rel=\"nofollow ugc\">https://shorturl.fm/SCnVB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("803", "556", "Elias2508", "Elias2508@gmail.com", "", "180.104.208.76", "2025-09-21 19:44:55", "2025-09-22 00:44:55", "<a href=\"https://shorturl.fm/mAO9y\" rel=\"nofollow ugc\">https://shorturl.fm/mAO9y</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("804", "556", "Emerson4559", "Emerson4559@gmail.com", "", "49.49.149.62", "2025-09-21 23:23:58", "2025-09-22 04:23:58", "<a href=\"https://shorturl.fm/0SUSk\" rel=\"nofollow ugc\">https://shorturl.fm/0SUSk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("805", "556", "Abby3846", "Abby3846@gmail.com", "", "154.47.16.83", "2025-09-22 01:29:58", "2025-09-22 06:29:58", "<a href=\"https://shorturl.fm/HfueS\" rel=\"nofollow ugc\">https://shorturl.fm/HfueS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("806", "556", "Herbert3595", "Herbert3595@gmail.com", "", "49.49.10.108", "2025-09-22 07:05:02", "2025-09-22 12:05:02", "<a href=\"https://shorturl.fm/4Rtyb\" rel=\"nofollow ugc\">https://shorturl.fm/4Rtyb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("807", "1", "Turoperato_hpEl", "lkaujukreEl@2-construction.store", "https://bluebirdtravel.ru", "45.86.0.38", "2025-09-22 07:39:34", "2025-09-22 12:39:34", "Sun Fun — ваш надежный проводник в мир туров в Турцию из Москвы. \r\n<a href=\"https://bluebirdtravel.ru\" rel=\"nofollow ugc\">Туроператор Fun Sun туры в Турции из Москвы</a> \r\nПрисоединяйтесь к нашим довольным клиентам и путешествуйте с Sun Fun!", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("808", "556", "Isla3252", "Isla3252@gmail.com", "", "103.62.155.87", "2025-09-22 09:35:13", "2025-09-22 14:35:13", "<a href=\"https://shorturl.fm/ibNlc\" rel=\"nofollow ugc\">https://shorturl.fm/ibNlc</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("809", "556", "Chloe806", "Chloe806@gmail.com", "", "153.165.150.117", "2025-09-22 09:48:13", "2025-09-22 14:48:13", "<a href=\"https://shorturl.fm/MEjWj\" rel=\"nofollow ugc\">https://shorturl.fm/MEjWj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("810", "556", "Juliana2199", "Juliana2199@gmail.com", "", "117.1.181.241", "2025-09-22 11:30:46", "2025-09-22 16:30:46", "<a href=\"https://shorturl.fm/XFs90\" rel=\"nofollow ugc\">https://shorturl.fm/XFs90</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("811", "556", "Gideon4518", "Gideon4518@gmail.com", "", "190.104.126.148", "2025-09-23 10:05:53", "2025-09-23 15:05:53", "<a href=\"https://shorturl.fm/rsd5t\" rel=\"nofollow ugc\">https://shorturl.fm/rsd5t</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("812", "556", "Jeffrey4111", "Jeffrey4111@gmail.com", "", "186.179.123.189", "2025-09-23 14:17:31", "2025-09-23 19:17:31", "<a href=\"https://shorturl.fm/Yvkee\" rel=\"nofollow ugc\">https://shorturl.fm/Yvkee</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("813", "556", "Gianna2587", "Gianna2587@gmail.com", "", "163.227.238.217", "2025-09-23 18:13:29", "2025-09-23 23:13:29", "<a href=\"https://shorturl.fm/2SFUz\" rel=\"nofollow ugc\">https://shorturl.fm/2SFUz</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("814", "556", "Janice2495", "Janice2495@gmail.com", "", "113.11.64.18", "2025-09-23 20:45:28", "2025-09-24 01:45:28", "<a href=\"https://shorturl.fm/otalC\" rel=\"nofollow ugc\">https://shorturl.fm/otalC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("815", "551", "Blanca2701", "Blanca2701@gmail.com", "", "87.201.89.249", "2025-09-24 02:00:42", "2025-09-24 07:00:42", "<a href=\"https://shorturl.fm/DFVtG\" rel=\"nofollow ugc\">https://shorturl.fm/DFVtG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("816", "556", "Ryan756", "Ryan756@gmail.com", "", "218.146.39.26", "2025-09-24 09:47:36", "2025-09-24 14:47:36", "<a href=\"https://shorturl.fm/uVuHk\" rel=\"nofollow ugc\">https://shorturl.fm/uVuHk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("817", "556", "Karina272", "Karina272@gmail.com", "", "189.124.230.160", "2025-09-24 23:31:09", "2025-09-25 04:31:09", "<a href=\"https://shorturl.fm/EBMLI\" rel=\"nofollow ugc\">https://shorturl.fm/EBMLI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("818", "551", "Meagan4344", "Meagan4344@gmail.com", "", "143.44.165.61", "2025-09-25 00:24:55", "2025-09-25 05:24:55", "<a href=\"https://shorturl.fm/VVCUR\" rel=\"nofollow ugc\">https://shorturl.fm/VVCUR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("819", "556", "Mary3643", "Mary3643@gmail.com", "", "113.11.64.18", "2025-09-25 20:52:11", "2025-09-26 01:52:11", "<a href=\"https://shorturl.fm/Ducan\" rel=\"nofollow ugc\">https://shorturl.fm/Ducan</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("820", "551", "Clifford1909", "Clifford1909@gmail.com", "", "163.227.238.4", "2025-09-26 00:54:52", "2025-09-26 05:54:52", "<a href=\"https://shorturl.fm/Rar4H\" rel=\"nofollow ugc\">https://shorturl.fm/Rar4H</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("821", "556", "Donna2487", "Donna2487@gmail.com", "", "5.193.223.69", "2025-09-26 12:20:20", "2025-09-26 17:20:20", "<a href=\"https://shorturl.fm/aI1Dy\" rel=\"nofollow ugc\">https://shorturl.fm/aI1Dy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("822", "556", "Abbie2395", "Abbie2395@gmail.com", "", "129.80.248.33", "2025-09-26 22:40:16", "2025-09-27 03:40:16", "<a href=\"https://shorturl.fm/gjplX\" rel=\"nofollow ugc\">https://shorturl.fm/gjplX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("823", "556", "Donna4159", "Donna4159@gmail.com", "", "70.50.13.192", "2025-09-26 23:26:25", "2025-09-27 04:26:25", "<a href=\"https://shorturl.fm/1Coe9\" rel=\"nofollow ugc\">https://shorturl.fm/1Coe9</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("824", "556", "Carlos4152", "Carlos4152@gmail.com", "", "124.217.99.91", "2025-09-27 03:44:13", "2025-09-27 08:44:13", "<a href=\"https://shorturl.fm/221Bl\" rel=\"nofollow ugc\">https://shorturl.fm/221Bl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("825", "556", "Gwen894", "Gwen894@gmail.com", "", "181.115.171.205", "2025-09-27 09:13:04", "2025-09-27 14:13:04", "<a href=\"https://shorturl.fm/pgT16\" rel=\"nofollow ugc\">https://shorturl.fm/pgT16</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("826", "556", "Abram2621", "Abram2621@gmail.com", "", "190.210.192.130", "2025-09-27 10:32:54", "2025-09-27 15:32:54", "<a href=\"https://shorturl.fm/HtsBP\" rel=\"nofollow ugc\">https://shorturl.fm/HtsBP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("827", "1", "suchtthera_raka", "akpxdxyuvka@skachat-melbet.info", "https://entzugsklinik.pro/", "178.20.42.76", "2025-09-27 14:23:59", "2025-09-27 19:23:59", "Eine Suchttherapie stellt einen entscheidenden Schritt auf dem Weg zur Heilung dar. \r\nambulante suchttherapie <a href=\"https://entzugsklinik.pro/\" / rel=\"nofollow ugc\">https://entzugsklinik.pro/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("828", "556", "Joe3968", "Joe3968@gmail.com", "", "41.223.119.156", "2025-09-27 14:40:47", "2025-09-27 19:40:47", "<a href=\"https://shorturl.fm/ZiLNl\" rel=\"nofollow ugc\">https://shorturl.fm/ZiLNl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("829", "1", "888starz_fzEr", "yvobkyjssEr@888starz.tech", "https://888starz-bet-casino.com/", "88.210.35.166", "2025-09-27 22:57:04", "2025-09-28 03:57:04", "888starz features a user-friendly design that allows players to explore with ease. \r\n888starz зеркало узбекистан <a href=\"888starz-bet-casino.com/ru\" rel=\"nofollow ugc\">https://888starz-bet-casino.com/ru/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("830", "551", "Florence3827", "Florence3827@gmail.com", "", "180.252.200.109", "2025-09-28 06:12:18", "2025-09-28 11:12:18", "<a href=\"https://shorturl.fm/80LJ6\" rel=\"nofollow ugc\">https://shorturl.fm/80LJ6</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("831", "556", "Luca1884", "Luca1884@gmail.com", "", "184.22.34.28", "2025-09-28 09:28:42", "2025-09-28 14:28:42", "<a href=\"https://shorturl.fm/HDClH\" rel=\"nofollow ugc\">https://shorturl.fm/HDClH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("832", "556", "Carl1598", "Carl1598@gmail.com", "", "114.44.24.175", "2025-09-29 07:15:32", "2025-09-29 12:15:32", "<a href=\"https://shorturl.fm/EpN9E\" rel=\"nofollow ugc\">https://shorturl.fm/EpN9E</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("833", "556", "Christine851", "Christine851@gmail.com", "", "52.80.11.51", "2025-09-29 09:23:07", "2025-09-29 14:23:07", "<a href=\"https://shorturl.fm/LdDeC\" rel=\"nofollow ugc\">https://shorturl.fm/LdDeC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("834", "556", "Marley736", "Marley736@gmail.com", "", "58.187.71.24", "2025-09-29 12:39:00", "2025-09-29 17:39:00", "<a href=\"https://shorturl.fm/P2dfh\" rel=\"nofollow ugc\">https://shorturl.fm/P2dfh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("835", "556", "Quinn3382", "Quinn3382@gmail.com", "", "1.53.99.219", "2025-09-29 13:08:16", "2025-09-29 18:08:16", "<a href=\"https://shorturl.fm/t3IrD\" rel=\"nofollow ugc\">https://shorturl.fm/t3IrD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("836", "556", "Bill2478", "Bill2478@gmail.com", "", "112.203.51.44", "2025-09-30 02:59:49", "2025-09-30 07:59:49", "<a href=\"https://shorturl.fm/wPVe5\" rel=\"nofollow ugc\">https://shorturl.fm/wPVe5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("837", "1", "Tori1594", "Tori1594@gmail.com", "", "112.203.51.44", "2025-09-30 03:00:11", "2025-09-30 08:00:11", "<a href=\"https://shorturl.fm/aszAw\" rel=\"nofollow ugc\">https://shorturl.fm/aszAw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("838", "551", "Autumn2952", "Autumn2952@gmail.com", "", "202.5.56.118", "2025-09-30 06:07:22", "2025-09-30 11:07:22", "<a href=\"https://shorturl.fm/vB5eu\" rel=\"nofollow ugc\">https://shorturl.fm/vB5eu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("839", "556", "Elise4161", "Elise4161@gmail.com", "", "38.32.228.27", "2025-09-30 14:34:25", "2025-09-30 19:34:25", "<a href=\"https://shorturl.fm/BXSc1\" rel=\"nofollow ugc\">https://shorturl.fm/BXSc1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("840", "556", "Braxton1152", "Braxton1152@gmail.com", "", "171.232.24.196", "2025-09-30 15:52:28", "2025-09-30 20:52:28", "<a href=\"https://shorturl.fm/LsqFR\" rel=\"nofollow ugc\">https://shorturl.fm/LsqFR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("841", "531", "Austin15", "Austin15@gmail.com", "", "171.232.24.196", "2025-09-30 15:52:45", "2025-09-30 20:52:45", "<a href=\"https://shorturl.fm/SBbTg\" rel=\"nofollow ugc\">https://shorturl.fm/SBbTg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("842", "551", "Hank4874", "Hank4874@gmail.com", "", "115.72.15.46", "2025-09-30 19:00:37", "2025-10-01 00:00:37", "<a href=\"https://shorturl.fm/RubiZ\" rel=\"nofollow ugc\">https://shorturl.fm/RubiZ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("843", "556", "Alonzo1974", "Alonzo1974@gmail.com", "", "177.81.75.215", "2025-09-30 20:03:07", "2025-10-01 01:03:07", "<a href=\"https://shorturl.fm/4MJDb\" rel=\"nofollow ugc\">https://shorturl.fm/4MJDb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("844", "556", "Clarence617", "Clarence617@gmail.com", "", "42.113.20.160", "2025-09-30 23:10:09", "2025-10-01 04:10:09", "<a href=\"https://shorturl.fm/vPeYd\" rel=\"nofollow ugc\">https://shorturl.fm/vPeYd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("845", "556", "Joyce1117", "Joyce1117@gmail.com", "", "180.246.196.3", "2025-10-02 03:20:06", "2025-10-02 08:20:06", "<a href=\"https://shorturl.fm/agdaT\" rel=\"nofollow ugc\">https://shorturl.fm/agdaT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("846", "1", "Abbie4804", "Abbie4804@gmail.com", "", "180.246.196.3", "2025-10-02 03:20:21", "2025-10-02 08:20:21", "<a href=\"https://shorturl.fm/pkEk1\" rel=\"nofollow ugc\">https://shorturl.fm/pkEk1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("847", "556", "Piper1024", "Piper1024@gmail.com", "", "45.230.254.91", "2025-10-02 05:50:40", "2025-10-02 10:50:40", "<a href=\"https://shorturl.fm/16C7N\" rel=\"nofollow ugc\">https://shorturl.fm/16C7N</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("848", "556", "Teresa3347", "Teresa3347@gmail.com", "", "103.171.163.143", "2025-10-02 06:40:14", "2025-10-02 11:40:14", "<a href=\"https://shorturl.fm/cGW8i\" rel=\"nofollow ugc\">https://shorturl.fm/cGW8i</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("849", "551", "Anaya1453", "Anaya1453@gmail.com", "", "103.171.163.129", "2025-10-02 06:40:16", "2025-10-02 11:40:16", "<a href=\"https://shorturl.fm/GQVQn\" rel=\"nofollow ugc\">https://shorturl.fm/GQVQn</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("850", "556", "Duane1042", "Duane1042@gmail.com", "", "118.68.159.30", "2025-10-02 12:22:00", "2025-10-02 17:22:00", "<a href=\"https://shorturl.fm/7D3nz\" rel=\"nofollow ugc\">https://shorturl.fm/7D3nz</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("851", "556", "Adriana4297", "Adriana4297@gmail.com", "", "167.57.41.180", "2025-10-02 16:30:04", "2025-10-02 21:30:04", "<a href=\"https://shorturl.fm/D1kw4\" rel=\"nofollow ugc\">https://shorturl.fm/D1kw4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("852", "556", "Nolan4267", "Nolan4267@gmail.com", "", "115.74.6.232", "2025-10-02 18:02:13", "2025-10-02 23:02:13", "<a href=\"https://shorturl.fm/YYvpG\" rel=\"nofollow ugc\">https://shorturl.fm/YYvpG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("853", "1", "1win_ygKl", "elrcwfpojKl@casino-kent.pro", "https://1win-app.bet", "62.113.116.213", "2025-10-03 01:07:39", "2025-10-03 06:07:39", "Its user-friendly design and ample features make it a top choice among betting applications.  \r\n1win app android <a href=\"1win-app.bet\" rel=\"nofollow ugc\">https://1win-app.bet/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("854", "556", "Katelyn1991", "Katelyn1991@gmail.com", "", "172.13.126.202", "2025-10-03 04:52:33", "2025-10-03 09:52:33", "<a href=\"https://shorturl.fm/rgfV3\" rel=\"nofollow ugc\">https://shorturl.fm/rgfV3</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("855", "556", "Lillian619", "Lillian619@gmail.com", "", "182.53.181.210", "2025-10-03 20:20:18", "2025-10-04 01:20:18", "<a href=\"https://shorturl.fm/pp8GY\" rel=\"nofollow ugc\">https://shorturl.fm/pp8GY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("856", "556", "Anderson3772", "Anderson3772@gmail.com", "", "165.101.102.223", "2025-10-03 21:10:56", "2025-10-04 02:10:56", "<a href=\"https://shorturl.fm/6rrPl\" rel=\"nofollow ugc\">https://shorturl.fm/6rrPl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("857", "556", "Carrie1369", "Carrie1369@gmail.com", "", "128.199.188.252", "2025-10-03 23:30:27", "2025-10-04 04:30:27", "<a href=\"https://shorturl.fm/5MthT\" rel=\"nofollow ugc\">https://shorturl.fm/5MthT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("858", "1", "888starz_onOt", "yigeogvmjOt@skachat-melbet.info", "https://888starz-egypts.com", "178.20.42.76", "2025-10-04 05:37:25", "2025-10-04 10:37:25", "تقدم هذه المنصة العديد من الألعاب التي تناسب جميع أنواع اللاعبين. \r\n888starz تسجيل الدخول <a href=\"http://www.888starz-egypts.com\" rel=\"nofollow ugc\">https://888starz-egypts.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("859", "556", "Bryant380", "Bryant380@gmail.com", "", "88.247.215.249", "2025-10-04 09:20:03", "2025-10-04 14:20:03", "<a href=\"https://shorturl.fm/E7avx\" rel=\"nofollow ugc\">https://shorturl.fm/E7avx</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("860", "556", "Daniel2353", "Daniel2353@gmail.com", "", "84.239.25.140", "2025-10-04 14:05:41", "2025-10-04 19:05:41", "<a href=\"https://shorturl.fm/spBTk\" rel=\"nofollow ugc\">https://shorturl.fm/spBTk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("861", "556", "Adrian495", "Adrian495@gmail.com", "", "191.107.237.199", "2025-10-04 16:39:16", "2025-10-04 21:39:16", "<a href=\"https://shorturl.fm/A5lj1\" rel=\"nofollow ugc\">https://shorturl.fm/A5lj1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("862", "556", "Kelsey2503", "Kelsey2503@gmail.com", "", "170.238.160.236", "2025-10-04 17:08:01", "2025-10-04 22:08:01", "<a href=\"https://shorturl.fm/nE80q\" rel=\"nofollow ugc\">https://shorturl.fm/nE80q</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("863", "531", "Aylin1364", "Aylin1364@gmail.com", "", "77.242.21.133", "2025-10-04 17:39:28", "2025-10-04 22:39:28", "<a href=\"https://shorturl.fm/m8HEO\" rel=\"nofollow ugc\">https://shorturl.fm/m8HEO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("864", "556", "Athena4453", "Athena4453@gmail.com", "", "99.225.193.31", "2025-10-05 15:50:19", "2025-10-05 20:50:19", "<a href=\"https://shorturl.fm/938It\" rel=\"nofollow ugc\">https://shorturl.fm/938It</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("865", "556", "Leon1804", "Leon1804@gmail.com", "", "186.158.200.76", "2025-10-05 17:45:53", "2025-10-05 22:45:53", "<a href=\"https://shorturl.fm/joovt\" rel=\"nofollow ugc\">https://shorturl.fm/joovt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("866", "551", "Chase162", "Chase162@gmail.com", "", "90.16.24.20", "2025-10-05 19:33:38", "2025-10-06 00:33:38", "<a href=\"https://shorturl.fm/sws9d\" rel=\"nofollow ugc\">https://shorturl.fm/sws9d</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("867", "556", "Cadence3233", "Cadence3233@gmail.com", "", "116.80.59.172", "2025-10-05 20:25:56", "2025-10-06 01:25:56", "<a href=\"https://shorturl.fm/t4lum\" rel=\"nofollow ugc\">https://shorturl.fm/t4lum</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("868", "556", "Jessica4078", "Jessica4078@gmail.com", "", "190.150.66.205", "2025-10-06 02:20:20", "2025-10-06 07:20:20", "<a href=\"https://shorturl.fm/QmYwh\" rel=\"nofollow ugc\">https://shorturl.fm/QmYwh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("869", "556", "Brantley794", "Brantley794@gmail.com", "", "115.72.6.124", "2025-10-06 18:24:34", "2025-10-06 23:24:34", "<a href=\"https://shorturl.fm/Z2LHq\" rel=\"nofollow ugc\">https://shorturl.fm/Z2LHq</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("870", "1", "Camden758", "Camden758@gmail.com", "", "115.72.6.124", "2025-10-06 18:24:51", "2025-10-06 23:24:51", "<a href=\"https://shorturl.fm/yjKFv\" rel=\"nofollow ugc\">https://shorturl.fm/yjKFv</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("871", "556", "Gwen153", "Gwen153@gmail.com", "", "160.22.205.91", "2025-10-06 20:39:52", "2025-10-07 01:39:52", "<a href=\"https://shorturl.fm/68z9f\" rel=\"nofollow ugc\">https://shorturl.fm/68z9f</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("872", "556", "Aurora4337", "Aurora4337@gmail.com", "", "103.184.94.238", "2025-10-07 00:37:41", "2025-10-07 05:37:41", "<a href=\"https://shorturl.fm/DuYZm\" rel=\"nofollow ugc\">https://shorturl.fm/DuYZm</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("873", "1", "razdel_gqOr", "gtcbiphkyOr@razdel-imushchestva33.ru", "https://razdel-imushchestva33.ru", "212.34.138.196", "2025-10-07 12:39:27", "2025-10-07 17:39:27", "Для получения квалифицированной помощи в вопросах раздела имущества, обратитесь к специалистам на <a href=\"https://razdel-imushchestva33.ru\" rel=\"nofollow ugc\">иск по разделу имущества</a>. \r\nВ этом отношении помощь юристов может быть крайне важной.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("874", "556", "Kirk1558", "Kirk1558@gmail.com", "", "5.62.143.146", "2025-10-07 13:39:25", "2025-10-07 18:39:25", "<a href=\"https://shorturl.fm/fFe2K\" rel=\"nofollow ugc\">https://shorturl.fm/fFe2K</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("875", "556", "Henrietta2613", "Henrietta2613@gmail.com", "", "181.117.77.22", "2025-10-07 15:17:38", "2025-10-07 20:17:38", "<a href=\"https://shorturl.fm/GRIPj\" rel=\"nofollow ugc\">https://shorturl.fm/GRIPj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("876", "556", "Colton822", "Colton822@gmail.com", "", "202.5.51.181", "2025-10-07 15:23:05", "2025-10-07 20:23:05", "<a href=\"https://shorturl.fm/OsvZ2\" rel=\"nofollow ugc\">https://shorturl.fm/OsvZ2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("877", "1", "888starz_xkka", "axgvetschka@skachat-winline.pro", "https://888starzuzs.com/", "62.113.116.213", "2025-10-07 22:00:54", "2025-10-08 03:00:54", "tejamkor yondashuvlar orqali  muvaffaqiyatni  mumkin.  o\'yinchilar uchun  taqdim etadi. \r\n Pul tikish jarayoni.  Bu sayt orqali  mumkin. \r\n Mukofotlar  yordam beradi.  keng ko\'lamli ma\'lumotlar  joylashgan bloglar  mavjud. \r\neng yuqori darajadagi .  Foydalanuvchilarning .  qimor ixlosmandlari  mumkin. \r\nбк 888starz <a href=\"888starzuzs.com\" rel=\"nofollow ugc\">https://888starzuzs.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("878", "556", "Lachlan592", "Lachlan592@gmail.com", "", "103.155.64.55", "2025-10-07 22:15:43", "2025-10-08 03:15:43", "<a href=\"https://shorturl.fm/UGOPb\" rel=\"nofollow ugc\">https://shorturl.fm/UGOPb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("879", "556", "Elinor4118", "Elinor4118@gmail.com", "", "1.7.39.173", "2025-10-08 01:26:19", "2025-10-08 06:26:19", "<a href=\"https://shorturl.fm/n0fVa\" rel=\"nofollow ugc\">https://shorturl.fm/n0fVa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("880", "556", "Christine3528", "Christine3528@gmail.com", "", "200.8.139.3", "2025-10-08 08:47:23", "2025-10-08 13:47:23", "<a href=\"https://shorturl.fm/VxPVI\" rel=\"nofollow ugc\">https://shorturl.fm/VxPVI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("881", "556", "Emmett4632", "Emmett4632@gmail.com", "", "116.105.163.218", "2025-10-08 21:04:30", "2025-10-09 02:04:30", "<a href=\"https://shorturl.fm/vQuG3\" rel=\"nofollow ugc\">https://shorturl.fm/vQuG3</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("882", "556", "Reagan3691", "Reagan3691@gmail.com", "", "156.218.202.197", "2025-10-09 09:51:55", "2025-10-09 14:51:55", "<a href=\"https://shorturl.fm/ckM7d\" rel=\"nofollow ugc\">https://shorturl.fm/ckM7d</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("883", "1", "vykup_hcsa", "mxkfbghkjsa@888starz.tech", "https://vykup-bityh-avto-posle-dtp.ru", "88.210.35.166", "2025-10-09 10:19:15", "2025-10-09 15:19:15", "Привлекательный способ справиться с автомобилем – это выкуп таких машин. Многие автолюбители столкнулись с реставрации своего поврежденного автомобиля. немало времени и денег. \r\n \r\nОрганизации, занимающиеся выкупом битых авто, предлагают варианты продажи. содействуют. доступные условия впечатляют, и они с удовольствием свои машины. \r\n \r\nПеред тем услугами выкупа, рыночные в данной области. конкурентной цене, есть и другие преимущества, подтолкнуть к сотрудничеству. В рамках таких аргументов – высококачественная оценка технического состояния. \r\n \r\nОпытные специалисты оценивают и предлагают наилучший решение. Это, чтобы аварийный автомобиль сразу. Обращайтесь к услугам покупки битых авто неприятностей. \r\nвыкуп разбитых авто <a href=\"https://vykup-bityh-avto-posle-dtp.ru/\" / rel=\"nofollow ugc\">https://vykup-bityh-avto-posle-dtp.ru/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("884", "556", "Silas4653", "Silas4653@gmail.com", "", "203.69.6.49", "2025-10-09 20:35:19", "2025-10-10 01:35:19", "<a href=\"https://shorturl.fm/F0Egl\" rel=\"nofollow ugc\">https://shorturl.fm/F0Egl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("885", "556", "Cadence2433", "Cadence2433@gmail.com", "", "77.37.102.95", "2025-10-10 04:16:22", "2025-10-10 09:16:22", "<a href=\"https://shorturl.fm/oE8oh\" rel=\"nofollow ugc\">https://shorturl.fm/oE8oh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("886", "556", "Fiona2199", "Fiona2199@gmail.com", "", "117.210.186.199", "2025-10-10 09:30:46", "2025-10-10 14:30:46", "<a href=\"https://shorturl.fm/ntd7Q\" rel=\"nofollow ugc\">https://shorturl.fm/ntd7Q</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("887", "556", "Estelle189", "Estelle189@gmail.com", "", "190.148.126.129", "2025-10-10 11:54:49", "2025-10-10 16:54:49", "<a href=\"https://shorturl.fm/2lCY2\" rel=\"nofollow ugc\">https://shorturl.fm/2lCY2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("888", "556", "Kendra1475", "Kendra1475@gmail.com", "", "4.206.212.39", "2025-10-10 20:20:45", "2025-10-11 01:20:45", "<a href=\"https://shorturl.fm/Atln1\" rel=\"nofollow ugc\">https://shorturl.fm/Atln1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("889", "531", "Micah3010", "Micah3010@gmail.com", "", "4.206.212.39", "2025-10-10 20:21:04", "2025-10-11 01:21:04", "<a href=\"https://shorturl.fm/Atln1\" rel=\"nofollow ugc\">https://shorturl.fm/Atln1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("890", "556", "Wesley2291", "Wesley2291@gmail.com", "", "202.130.218.193", "2025-10-10 21:19:51", "2025-10-11 02:19:51", "<a href=\"https://shorturl.fm/14nOJ\" rel=\"nofollow ugc\">https://shorturl.fm/14nOJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("891", "556", "Lincoln3044", "Lincoln3044@gmail.com", "", "103.155.64.55", "2025-10-11 02:37:19", "2025-10-11 07:37:19", "<a href=\"https://shorturl.fm/uP7dR\" rel=\"nofollow ugc\">https://shorturl.fm/uP7dR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("892", "556", "Kristen468", "Kristen468@gmail.com", "", "103.241.62.162", "2025-10-11 04:30:10", "2025-10-11 09:30:10", "<a href=\"https://shorturl.fm/pex7J\" rel=\"nofollow ugc\">https://shorturl.fm/pex7J</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("893", "556", "Vivian676", "Vivian676@gmail.com", "", "103.117.31.218", "2025-10-11 09:43:26", "2025-10-11 14:43:26", "<a href=\"https://shorturl.fm/6UCKo\" rel=\"nofollow ugc\">https://shorturl.fm/6UCKo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("894", "556", "Albert2014", "Albert2014@gmail.com", "", "113.11.183.113", "2025-10-11 14:05:38", "2025-10-11 19:05:38", "<a href=\"https://shorturl.fm/CnI1V\" rel=\"nofollow ugc\">https://shorturl.fm/CnI1V</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("895", "556", "Johnny2877", "Johnny2877@gmail.com", "", "182.53.202.208", "2025-10-11 18:37:58", "2025-10-11 23:37:58", "<a href=\"https://shorturl.fm/Fo6kj\" rel=\"nofollow ugc\">https://shorturl.fm/Fo6kj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("896", "1", "888starz_wppa", "yjineouwdpa@ugaritopari.site", "https://888starz-888stars.com", "62.113.116.213", "2025-10-11 23:03:56", "2025-10-12 04:03:56", "These incentives help boost players\' bankrolls and enhance their gaming experience. \r\n888starz promo code today <a href=\"888starz-888stars.com/promocode\" rel=\"nofollow ugc\">https://888starz-888stars.com/promocode/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("897", "556", "June2547", "June2547@gmail.com", "", "103.154.230.94", "2025-10-12 13:02:58", "2025-10-12 18:02:58", "<a href=\"https://shorturl.fm/KPFYU\" rel=\"nofollow ugc\">https://shorturl.fm/KPFYU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("898", "556", "Russell4574", "Russell4574@gmail.com", "", "184.82.18.51", "2025-10-13 11:47:34", "2025-10-13 16:47:34", "<a href=\"https://shorturl.fm/wcdB9\" rel=\"nofollow ugc\">https://shorturl.fm/wcdB9</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("899", "556", "Jill420", "Jill420@gmail.com", "", "116.111.255.226", "2025-10-13 14:06:46", "2025-10-13 19:06:46", "<a href=\"https://shorturl.fm/cYwuQ\" rel=\"nofollow ugc\">https://shorturl.fm/cYwuQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("900", "1", "Justin4942", "Justin4942@gmail.com", "", "116.111.255.226", "2025-10-13 14:07:02", "2025-10-13 19:07:02", "<a href=\"https://shorturl.fm/MTlGH\" rel=\"nofollow ugc\">https://shorturl.fm/MTlGH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("901", "556", "Carrie814", "Carrie814@gmail.com", "", "49.48.64.108", "2025-10-13 14:37:04", "2025-10-13 19:37:04", "<a href=\"https://shorturl.fm/OPq3J\" rel=\"nofollow ugc\">https://shorturl.fm/OPq3J</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("902", "556", "Caitlin4287", "Caitlin4287@gmail.com", "", "115.72.168.40", "2025-10-13 23:48:21", "2025-10-14 04:48:21", "<a href=\"https://shorturl.fm/NclgT\" rel=\"nofollow ugc\">https://shorturl.fm/NclgT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("903", "556", "Anabel2910", "Anabel2910@gmail.com", "", "116.105.35.83", "2025-10-14 01:22:24", "2025-10-14 06:22:24", "<a href=\"https://shorturl.fm/HpCZe\" rel=\"nofollow ugc\">https://shorturl.fm/HpCZe</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("904", "556", "Jeannette1923", "Jeannette1923@gmail.com", "", "160.25.21.163", "2025-10-14 02:40:14", "2025-10-14 07:40:14", "<a href=\"https://shorturl.fm/OMR2r\" rel=\"nofollow ugc\">https://shorturl.fm/OMR2r</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("905", "556", "Ava598", "Ava598@gmail.com", "", "181.133.78.167", "2025-10-14 19:02:38", "2025-10-15 00:02:38", "<a href=\"https://shorturl.fm/R9LFb\" rel=\"nofollow ugc\">https://shorturl.fm/R9LFb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("906", "1", "888starz_ogKi", "jfaaagwpvKi@888starz.tech", "https://888-starz-eg.com", "88.210.35.166", "2025-10-14 21:38:45", "2025-10-15 02:38:45", "تتميز 888starz بكونها منصة رائدة في عالم ألعاب القمار والتسلية. تجمع هذه المنصة بين مختلف أنواع الألعاب مثل الرهانات الرياضية، ألعاب الكازينو، وغيرها. \r\nتتميز واجهة 888starz بتصميم بسيط وسهل، مما يسهل على المستخدمين التفاعل معها. تعد 888starz متعددة اللغات، مما يسهل الوصول إليها من قبل المستخدمين من مختلف البلدان. \r\nتتبع 888starz معايير أمان عالية لضمان حماية معلومات اللاعبين. بالإضافة إلى ذلك، تقدم المنصة دعمًا فنيًا ممتازًا متاحًا على مدار الساعة. \r\nتعتبر مكافآت 888starz من بين الأكثر جذبًا في السوق. تعتبر المكافآت التي تقدمها 888starz جزءًا أساسيًا من استراتيجيتها لجذب اللاعبين والحفاظ عليهم. \r\n888starz مراهنات <a href=\"https://888-starz-eg.com\" rel=\"nofollow ugc\">https://888-starz-eg.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("907", "556", "James4476", "James4476@gmail.com", "", "116.80.93.114", "2025-10-15 01:37:13", "2025-10-15 06:37:13", "<a href=\"https://shorturl.fm/08Lk4\" rel=\"nofollow ugc\">https://shorturl.fm/08Lk4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("908", "1", "razdeldvMr", "nmwhcbxcbMr@razdel-imushchestva6.ru", "https://razdel-imushchestva6.ru", "212.34.138.196", "2025-10-15 10:33:38", "2025-10-15 15:33:38", "Получите профессиональную <a href=\"https://razdel-imushchestva6.ru\" rel=\"nofollow ugc\">заявление на раздел имущества</a> услугами. \r\n \r\nДалее стоит определить, какие объекты подлежат разделу, а какие — нет.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("909", "556", "Hanna596", "Hanna596@gmail.com", "", "49.48.88.90", "2025-10-15 13:30:06", "2025-10-15 18:30:06", "<a href=\"https://shorturl.fm/hqlgT\" rel=\"nofollow ugc\">https://shorturl.fm/hqlgT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("910", "1", "kupit_lzor", "plaasclfzor@ugaritopari.site", "https://kupit-uggi-moskva.ru/", "62.113.116.213", "2025-10-15 14:43:41", "2025-10-15 19:43:41", "Существует несколько популярных брендов, которые производят угги.  \r\nугги купить москва <a href=\"kupit-uggi-moskva.ru\" rel=\"nofollow ugc\">https://kupit-uggi-moskva.ru/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("911", "556", "Elvira4522", "Elvira4522@gmail.com", "", "136.32.21.118", "2025-10-15 22:45:39", "2025-10-16 03:45:39", "<a href=\"https://shorturl.fm/D7oYq\" rel=\"nofollow ugc\">https://shorturl.fm/D7oYq</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("912", "1", "Lane1867", "Lane1867@gmail.com", "", "136.32.21.118", "2025-10-15 22:46:00", "2025-10-16 03:46:00", "<a href=\"https://shorturl.fm/1WL0p\" rel=\"nofollow ugc\">https://shorturl.fm/1WL0p</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("913", "556", "Kira3007", "Kira3007@gmail.com", "", "177.37.45.237", "2025-10-16 03:55:55", "2025-10-16 08:55:55", "<a href=\"https://shorturl.fm/jAfO9\" rel=\"nofollow ugc\">https://shorturl.fm/jAfO9</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("914", "556", "Serenity1990", "Serenity1990@gmail.com", "", "60.108.8.253", "2025-10-16 09:55:44", "2025-10-16 14:55:44", "<a href=\"https://shorturl.fm/Z8gv8\" rel=\"nofollow ugc\">https://shorturl.fm/Z8gv8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("915", "556", "Kaleb103", "Kaleb103@gmail.com", "", "125.24.186.25", "2025-10-16 20:02:46", "2025-10-17 01:02:46", "<a href=\"https://shorturl.fm/umrIi\" rel=\"nofollow ugc\">https://shorturl.fm/umrIi</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("916", "556", "Kate1418", "Kate1418@gmail.com", "", "177.214.154.178", "2025-10-16 23:21:45", "2025-10-17 04:21:45", "<a href=\"https://shorturl.fm/TL2IP\" rel=\"nofollow ugc\">https://shorturl.fm/TL2IP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("917", "556", "Alexia547", "Alexia547@gmail.com", "", "102.164.215.184", "2025-10-17 07:22:20", "2025-10-17 12:22:20", "<a href=\"https://shorturl.fm/m1fhh\" rel=\"nofollow ugc\">https://shorturl.fm/m1fhh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("918", "556", "Londyn1842", "Londyn1842@gmail.com", "", "124.104.222.27", "2025-10-17 18:49:26", "2025-10-17 23:49:26", "<a href=\"https://shorturl.fm/1kWuW\" rel=\"nofollow ugc\">https://shorturl.fm/1kWuW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("919", "556", "Helena1036", "Helena1036@gmail.com", "", "103.252.201.169", "2025-10-18 08:32:45", "2025-10-18 13:32:45", "<a href=\"https://shorturl.fm/xjDEo\" rel=\"nofollow ugc\">https://shorturl.fm/xjDEo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("920", "1", "minecraft_wdkt", "muowyvgyzkt@ingushetdomaz.pro", "https://minecraftbedrock-apk.com/", "178.20.42.76", "2025-10-18 08:50:21", "2025-10-18 13:50:21", "These updates ensure that players always have something new to explore, keeping the game fresh and engaging. \r\nmcpe mods <a href=\"http://www.minecraftbedrock-apk.com/mods-minecraft-pe/\" / rel=\"nofollow ugc\">https://minecraftbedrock-apk.com/mods-minecraft-pe/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("921", "556", "Virginia4873", "Virginia4873@gmail.com", "", "149.22.82.56", "2025-10-18 15:36:24", "2025-10-18 20:36:24", "<a href=\"https://shorturl.fm/0nFBp\" rel=\"nofollow ugc\">https://shorturl.fm/0nFBp</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("922", "556", "Kristen1430", "Kristen1430@gmail.com", "", "109.177.101.160", "2025-10-18 17:22:23", "2025-10-18 22:22:23", "<a href=\"https://shorturl.fm/1XeRa\" rel=\"nofollow ugc\">https://shorturl.fm/1XeRa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("923", "1", "Richard4023", "Richard4023@gmail.com", "", "109.177.101.160", "2025-10-18 17:22:39", "2025-10-18 22:22:39", "<a href=\"https://shorturl.fm/8KrqS\" rel=\"nofollow ugc\">https://shorturl.fm/8KrqS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("924", "556", "Ada1352", "Ada1352@gmail.com", "", "138.84.34.71", "2025-10-18 20:35:21", "2025-10-19 01:35:21", "<a href=\"https://shorturl.fm/wpGda\" rel=\"nofollow ugc\">https://shorturl.fm/wpGda</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("925", "1", "1win_scei", "rygickzpuei@igurant1.online", "https://1win-app-apk.com", "88.210.35.166", "2025-10-19 05:27:29", "2025-10-19 10:27:29", "This allows users to place bets on ongoing events, enhancing the excitement of the game. \r\n1win online <a href=\"https://1win-app-apk.com/\" / rel=\"nofollow ugc\">1win online</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("926", "556", "Nadia2436", "Nadia2436@gmail.com", "", "103.133.25.99", "2025-10-19 07:27:22", "2025-10-19 12:27:22", "<a href=\"https://shorturl.fm/atxkR\" rel=\"nofollow ugc\">https://shorturl.fm/atxkR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("927", "556", "Mitchell4086", "Mitchell4086@gmail.com", "", "160.22.24.14", "2025-10-19 20:02:15", "2025-10-20 01:02:15", "<a href=\"https://shorturl.fm/b8L3Y\" rel=\"nofollow ugc\">https://shorturl.fm/b8L3Y</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("928", "556", "Evie626", "Evie626@gmail.com", "", "119.148.9.238", "2025-10-20 02:38:06", "2025-10-20 07:38:06", "<a href=\"https://shorturl.fm/oLzgk\" rel=\"nofollow ugc\">https://shorturl.fm/oLzgk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("929", "556", "Bill1816", "Bill1816@gmail.com", "", "120.29.87.121", "2025-10-20 08:36:13", "2025-10-20 13:36:13", "<a href=\"https://shorturl.fm/8PHto\" rel=\"nofollow ugc\">https://shorturl.fm/8PHto</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("930", "556", "Whitney3128", "Whitney3128@gmail.com", "", "86.106.74.119", "2025-10-20 10:38:33", "2025-10-20 15:38:33", "<a href=\"https://shorturl.fm/KLBFH\" rel=\"nofollow ugc\">https://shorturl.fm/KLBFH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("931", "556", "Camila3903", "Camila3903@gmail.com", "", "180.165.14.151", "2025-10-20 16:25:28", "2025-10-20 21:25:28", "<a href=\"https://shorturl.fm/tss25\" rel=\"nofollow ugc\">https://shorturl.fm/tss25</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("932", "556", "Dakota3152", "Dakota3152@gmail.com", "", "113.11.32.102", "2025-10-20 19:00:45", "2025-10-21 00:00:45", "<a href=\"https://shorturl.fm/3enUh\" rel=\"nofollow ugc\">https://shorturl.fm/3enUh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("933", "556", "Maliyah3322", "Maliyah3322@gmail.com", "", "116.80.44.31", "2025-10-21 01:07:30", "2025-10-21 06:07:30", "<a href=\"https://shorturl.fm/kiQnv\" rel=\"nofollow ugc\">https://shorturl.fm/kiQnv</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("934", "556", "Christina2648", "Christina2648@gmail.com", "", "173.168.196.42", "2025-10-21 11:18:51", "2025-10-21 16:18:51", "<a href=\"https://shorturl.fm/Oh3Sk\" rel=\"nofollow ugc\">https://shorturl.fm/Oh3Sk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("935", "556", "Alonzo1960", "Alonzo1960@gmail.com", "", "113.11.64.19", "2025-10-21 19:45:25", "2025-10-22 00:45:25", "<a href=\"https://shorturl.fm/gPZ7I\" rel=\"nofollow ugc\">https://shorturl.fm/gPZ7I</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("936", "556", "Gretchen4377", "Gretchen4377@gmail.com", "", "115.72.197.133", "2025-10-22 00:25:38", "2025-10-22 05:25:38", "<a href=\"https://shorturl.fm/JLwS7\" rel=\"nofollow ugc\">https://shorturl.fm/JLwS7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("937", "556", "Halle277", "Halle277@gmail.com", "", "157.100.63.146", "2025-10-22 08:11:55", "2025-10-22 13:11:55", "<a href=\"https://shorturl.fm/dhszi\" rel=\"nofollow ugc\">https://shorturl.fm/dhszi</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("938", "556", "Finn2835", "Finn2835@gmail.com", "", "196.191.77.242", "2025-10-22 09:26:40", "2025-10-22 14:26:40", "<a href=\"https://shorturl.fm/fHlZC\" rel=\"nofollow ugc\">https://shorturl.fm/fHlZC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("939", "1", "yurist_mrka", "dhlujatfxka@konsultaciya-yurista22.ru", "https://konsultaciya-yurista22.ru", "212.34.138.196", "2025-10-22 15:37:57", "2025-10-22 20:37:57", "Получите <a href=\"https://konsultaciya-yurista22.ru\" rel=\"nofollow ugc\">юридическую консультацию бесплатно</a> прямо сейчас! \r\nОбзор юридических услуг. Недостаток знаний в правовых вопросах может привести к серьезным последствиям. \r\n \r\nПервый пункт, который стоит обсудить — это доступность юридической помощи. Сегодня многие юристы предлагают услуги онлайн. Такой подход значительно облегчает получение правовой помощи. \r\n \r\nСледующий важный момент — это выбор юриста. Важно, чтобы юрист имел хорошие рекомендации и подходящий опыт. Игнорирование этих нюансов может обернуться значительными потерями. \r\n \r\nТретий важный фактор — это цены на юридические консультации. Стоимость может зависеть от многих факторов, включая опыт специалиста и специфику вопроса. Обсуждение условий и стоимости заранее крайне важно. \r\n \r\nВажно осознавать, что юрист несет ответственность за свои действия. Помните, что недостаточная профессиональность может привести к серьезным последствиям. Поэтому выбирайте юриста с умом, чтобы избежать проблем.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("940", "556", "Brock3559", "Brock3559@gmail.com", "", "103.184.67.115", "2025-10-22 20:20:29", "2025-10-23 01:20:29", "<a href=\"https://shorturl.fm/KKx4b\" rel=\"nofollow ugc\">https://shorturl.fm/KKx4b</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("941", "556", "Evangeline3854", "Evangeline3854@gmail.com", "", "41.254.63.16", "2025-10-23 00:57:38", "2025-10-23 05:57:38", "<a href=\"https://shorturl.fm/V4am8\" rel=\"nofollow ugc\">https://shorturl.fm/V4am8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("942", "556", "Davis2973", "Davis2973@gmail.com", "", "112.78.181.94", "2025-10-23 06:06:19", "2025-10-23 11:06:19", "<a href=\"https://shorturl.fm/cghUl\" rel=\"nofollow ugc\">https://shorturl.fm/cghUl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("943", "1", "advokat_okpr", "cwfshhcjnpr@konsultaciya-yurista20.store", "https://konsultaciya-advokata51.ru", "212.34.129.45", "2025-10-23 08:22:43", "2025-10-23 13:22:43", "На сайте konsultaciya-advokata51.ru вы можете найти множество полезных услуг. Получение юридической помощи – это необходимость для многих. На нашем сайте вы сможете получить профессиональные советы. \r\nПолучите бесплатную юридическую консультацию круглосуточно на <a href=\"https://konsultaciya-advokata51.ru\" rel=\"nofollow ugc\">номер бесплатной консультации юриста</a>. \r\nОн сможет дать вам рекомендации и советы по всем важным вопросам. \r\nПервое, что стоит учитывать – это квалификация адвокатов. Каждый адвокат на konsultaciya-advokata51.ru прошел тщательный отбор. Что бы вы ни выбрали, мы гарантируем качественное выполнение работы. \r\nВторой аспект – это доступность услуг. Вы сможете легко ознакомиться с нашими тарифами и предложениями. На нашем сайте есть предложения на любой вкус и бюджет. \r\nКроме того, мы предлагаем услуги онлайн. Сегодня возможность получить помощь через интернет очень важна. Вы можете задать свои вопросы в любое время.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("944", "1", "minecraft_drka", "jkiheiyrnka@ingushetdomaz.pro", "https://minecraft-bedrock-edition.com", "178.20.42.76", "2025-10-23 09:01:54", "2025-10-23 14:01:54", "The ability to use add-ons keeps the gameplay fresh and engaging, offering new challenges and fun experiences. \r\nmods for minecraft pe <a href=\"https://minecraft-bedrock-edition.com/mods/\" / rel=\"nofollow ugc\">https://minecraft-bedrock-edition.com/mods/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("945", "556", "Kara3660", "Kara3660@gmail.com", "", "36.81.171.192", "2025-10-23 09:14:11", "2025-10-23 14:14:11", "<a href=\"https://shorturl.fm/Eg1lX\" rel=\"nofollow ugc\">https://shorturl.fm/Eg1lX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("946", "556", "Edward1477", "Edward1477@gmail.com", "", "119.18.148.3", "2025-10-23 14:11:02", "2025-10-23 19:11:02", "<a href=\"https://shorturl.fm/6BWhA\" rel=\"nofollow ugc\">https://shorturl.fm/6BWhA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("947", "556", "Hugo652", "Hugo652@gmail.com", "", "41.128.72.132", "2025-10-23 16:50:13", "2025-10-23 21:50:13", "<a href=\"https://shorturl.fm/7Azrn\" rel=\"nofollow ugc\">https://shorturl.fm/7Azrn</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("948", "556", "Freddie3751", "Freddie3751@gmail.com", "", "3.229.236.229", "2025-10-23 18:34:21", "2025-10-23 23:34:21", "<a href=\"https://shorturl.fm/XiJpQ\" rel=\"nofollow ugc\">https://shorturl.fm/XiJpQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("949", "556", "Adalyn3011", "Adalyn3011@gmail.com", "", "37.27.95.118", "2025-10-23 18:57:16", "2025-10-23 23:57:16", "<a href=\"https://shorturl.fm/cN1M5\" rel=\"nofollow ugc\">https://shorturl.fm/cN1M5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("950", "556", "Kelsey4569", "Kelsey4569@gmail.com", "", "103.133.61.231", "2025-10-24 05:44:38", "2025-10-24 10:44:38", "<a href=\"https://shorturl.fm/Nv3zV\" rel=\"nofollow ugc\">https://shorturl.fm/Nv3zV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("951", "556", "Alejandra3506", "Alejandra3506@gmail.com", "", "134.236.19.89", "2025-10-24 07:43:20", "2025-10-24 12:43:20", "<a href=\"https://shorturl.fm/gOa44\" rel=\"nofollow ugc\">https://shorturl.fm/gOa44</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("952", "1", "888starz_pnkl", "qwffszivbkl@ugaritopari.site", "https://888starzuzb.com/", "62.113.116.213", "2025-10-25 01:49:45", "2025-10-25 06:49:45", "888starz uz, O\'zbekiston bo\'ylab qulay qimor xizmatlari taklif etuvchi sayt  qimor o\'ynash uchun ideal imkoniyatlar taqdim etadi.  Ushbu platformada o\'yinchilar uchun ko\'plab o\'yinlar, bonuslar va maxsus takliflar bor . \r\n 888starz uz ga kirishni juda qulay tarzda bajarish mumkin .  O\'yinchilar hech qanday muammosiz sayt orqali ro\'yxatdan o\'tishlari va o\'yinlarga kirishishlari mumkin . \r\nBonuslar va aktsiyalar har hafta o\'zgartiriladi .  Bu esa o\'yinchilarning qiziqishini yanada kuchaytirishga yordam beradi . \r\n 888starz uz saytida o\'yinchilarning xavfsizligini ta\'minlash juda muhim hisoblanadi.  Ular o\'z foydalanuvchilarining ma\'lumotlarini himoya qilish uchun zamonaviy usullarni qo\'llaydi . \r\n888starz bet официальный сайт <a href=\"888starzuzb.com\" rel=\"nofollow ugc\">https://888starzuzb.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("953", "556", "Darby3493", "Darby3493@gmail.com", "", "73.42.217.182", "2025-10-25 19:11:55", "2025-10-26 00:11:55", "<a href=\"https://shorturl.fm/EyByO\" rel=\"nofollow ugc\">https://shorturl.fm/EyByO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("954", "556", "Kaylee2405", "Kaylee2405@gmail.com", "", "103.232.20.66", "2025-10-25 20:34:50", "2025-10-26 01:34:50", "<a href=\"https://shorturl.fm/4sdvr\" rel=\"nofollow ugc\">https://shorturl.fm/4sdvr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("955", "556", "Rochelle1064", "Rochelle1064@gmail.com", "", "202.5.55.33", "2025-10-25 21:26:00", "2025-10-26 02:26:00", "<a href=\"https://shorturl.fm/aZDhy\" rel=\"nofollow ugc\">https://shorturl.fm/aZDhy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("956", "556", "Anna2512", "Anna2512@gmail.com", "", "47.99.94.153", "2025-10-26 01:05:40", "2025-10-26 06:05:40", "<a href=\"https://shorturl.fm/uHFWI\" rel=\"nofollow ugc\">https://shorturl.fm/uHFWI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("957", "1", "mcpedl_btKl", "sdxurawseKl@ingushetdomaz.pro", "https://mcpedl-minecraft.com/", "178.20.42.76", "2025-10-26 11:38:27", "2025-10-26 16:38:27", "To sum up, MCPEDL stands as a goldmine for enthusiasts of Minecraft. \r\nminecraft apk download <a href=\"https://www.mcpedl-minecraft.com/downloading\" rel=\"nofollow ugc\">https://mcpedl-minecraft.com/downloading/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("958", "556", "Greta2010", "Greta2010@gmail.com", "", "187.224.142.159", "2025-10-27 01:33:31", "2025-10-27 06:33:31", "<a href=\"https://shorturl.fm/9Ses2\" rel=\"nofollow ugc\">https://shorturl.fm/9Ses2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("959", "556", "Denise2235", "Denise2235@gmail.com", "", "110.136.125.164", "2025-10-27 14:52:25", "2025-10-27 19:52:25", "<a href=\"https://shorturl.fm/MS8Tn\" rel=\"nofollow ugc\">https://shorturl.fm/MS8Tn</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("960", "556", "Harry3122", "Harry3122@gmail.com", "", "119.18.148.3", "2025-10-27 15:52:38", "2025-10-27 20:52:38", "<a href=\"https://shorturl.fm/iAu8A\" rel=\"nofollow ugc\">https://shorturl.fm/iAu8A</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("961", "556", "Kendra4798", "Kendra4798@gmail.com", "", "49.150.59.243", "2025-10-27 19:37:32", "2025-10-28 00:37:32", "<a href=\"https://shorturl.fm/UQYgC\" rel=\"nofollow ugc\">https://shorturl.fm/UQYgC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("962", "556", "Nolan4959", "Nolan4959@gmail.com", "", "181.234.33.39", "2025-10-28 07:02:59", "2025-10-28 12:02:59", "<a href=\"https://shorturl.fm/hgbn0\" rel=\"nofollow ugc\">https://shorturl.fm/hgbn0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("963", "556", "Holden1452", "Holden1452@gmail.com", "", "139.155.243.8", "2025-10-28 12:18:17", "2025-10-28 17:18:17", "<a href=\"https://shorturl.fm/giYZg\" rel=\"nofollow ugc\">https://shorturl.fm/giYZg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("964", "556", "Donald3135", "Donald3135@gmail.com", "", "189.6.20.176", "2025-10-28 16:03:55", "2025-10-28 21:03:55", "<a href=\"https://shorturl.fm/H97EB\" rel=\"nofollow ugc\">https://shorturl.fm/H97EB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("965", "556", "Chandler869", "Chandler869@gmail.com", "", "152.42.247.107", "2025-10-29 02:48:53", "2025-10-29 07:48:53", "<a href=\"https://shorturl.fm/nrDZP\" rel=\"nofollow ugc\">https://shorturl.fm/nrDZP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("966", "1", "minecraft_puet", "qpnbxurdmet@ingushetdomaz.pro", "https://download-minecraft-apk.com", "178.20.42.76", "2025-10-29 16:33:53", "2025-10-29 21:33:53", "Download Minecraft apk and immerse yourself in a world of endless possibilities! \r\nThe immensely popular game Minecraft has attracted a massive following globally.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("967", "556", "Clifford4470", "Clifford4470@gmail.com", "", "118.174.115.163", "2025-10-29 18:52:55", "2025-10-29 23:52:55", "<a href=\"https://shorturl.fm/yVtQe\" rel=\"nofollow ugc\">https://shorturl.fm/yVtQe</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("968", "556", "Jace392", "Jace392@gmail.com", "", "85.112.80.27", "2025-10-29 23:05:00", "2025-10-30 04:05:00", "<a href=\"https://shorturl.fm/ql97z\" rel=\"nofollow ugc\">https://shorturl.fm/ql97z</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("969", "556", "Asher2393", "Asher2393@gmail.com", "", "199.127.60.117", "2025-10-30 05:24:44", "2025-10-30 10:24:44", "<a href=\"https://shorturl.fm/m1cQk\" rel=\"nofollow ugc\">https://shorturl.fm/m1cQk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("970", "556", "Rory2385", "Rory2385@gmail.com", "", "18.169.239.110", "2025-10-30 22:29:08", "2025-10-31 03:29:08", "<a href=\"https://shorturl.fm/TFSmK\" rel=\"nofollow ugc\">https://shorturl.fm/TFSmK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("971", "556", "Dennis1032", "Dennis1032@gmail.com", "", "124.123.183.217", "2025-10-30 22:32:43", "2025-10-31 03:32:43", "<a href=\"https://shorturl.fm/Oagbb\" rel=\"nofollow ugc\">https://shorturl.fm/Oagbb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("972", "1", "reyting_dwst", "ezbdvphtest@konsultaciya-yurista20.store", "https://vc.ru/legal/2237796-luchshie-yuristy-v-moskve-uslugi-tseny-i-reyting", "212.34.129.45", "2025-10-30 23:56:06", "2025-10-31 04:56:06", "<a href=\"https://vc.ru/legal/2237796-luchshie-yuristy-v-moskve-uslugi-tseny-i-reyting\" rel=\"nofollow ugc\">рейтинг юристов москвы</a> \r\n Успех в правовом вопросе зависит от того, насколько правильно выбран юрист.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("973", "1", "1xbet_afst", "zdvdqzmfmst@problemno.shop", "https://1xbetapkeg.com", "89.110.99.186", "2025-10-31 09:06:50", "2025-10-31 14:06:50", "يُعتبر تطبيق 1xbet. من. تجربته، يجب. \r\n \r\nالبرنامج، مساحة تخزين على جهازك. أيضًا، اتصالك. اتصال ضعيف، أثناء. \r\n \r\nبعد، يمكنك الشروع. الموقع الرسمي، بسهولة. عند، عملية. \r\n \r\nعند الانتهاء من عملية، في. واطبع. بعدها، ستكون جاهزًا.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("974", "556", "Juliana1072", "Juliana1072@gmail.com", "", "152.70.84.108", "2025-10-31 17:31:33", "2025-10-31 22:31:33", "<a href=\"https://shorturl.fm/tC7nm\" rel=\"nofollow ugc\">https://shorturl.fm/tC7nm</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("975", "556", "Veronica1665", "Veronica1665@gmail.com", "", "103.172.152.13", "2025-10-31 21:33:04", "2025-11-01 02:33:04", "<a href=\"https://shorturl.fm/yWn0L\" rel=\"nofollow ugc\">https://shorturl.fm/yWn0L</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("976", "556", "Maliyah3215", "Maliyah3215@gmail.com", "", "202.191.123.195", "2025-11-01 11:02:10", "2025-11-01 16:02:10", "<a href=\"https://shorturl.fm/7Oj8L\" rel=\"nofollow ugc\">https://shorturl.fm/7Oj8L</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("977", "1", "konsultaci_sppl", "skwdslfukpl@konsultaciya-yurista41.ru", "https://konsultaciya-yurista41.ru/", "212.34.138.196", "2025-11-01 14:11:56", "2025-11-01 19:11:56", "Получите качественную <a href=\"https://konsultaciya-yurista41.ru/\" / rel=\"nofollow ugc\">онлайн консультация бесплатно</a> бесплатно! \r\nКаждый человек, сталкиваясь с юридическими вопросами, нуждается в грамотной помощи. Помощь юриста может предотвратить множество неприятностей и обеспечить защиту ваших прав. \r\n \r\nСуществуют различные сферы права, в которых юрист может предоставить свою помощь. Сферы права, такие как уголовное, гражданское или семейное, требуют специальных знаний и опыта. \r\n \r\nПри выборе юриста важно обратить внимание на его опыт и квалификацию. Отзывы клиентов могут дать представление о профессионализме юриста и его способности решать задачи. \r\n \r\nКак правило, консультация юриста проходит в несколько этапов. Сначала происходит обсуждение ключевых моментов вашего дела, после чего юрист предлагает решения. Построение стратегии решения вопроса начинается с тщательного анализа вашей ситуации.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("978", "556", "Juliana163", "Juliana163@gmail.com", "", "121.173.130.237", "2025-11-01 14:18:25", "2025-11-01 19:18:25", "<a href=\"https://shorturl.fm/rOZLe\" rel=\"nofollow ugc\">https://shorturl.fm/rOZLe</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("979", "1", "888starz_oisr", "fniimmnrxsr@ugaritopari.site", "https://888starz-stars888.com/", "62.113.116.213", "2025-11-01 23:27:41", "2025-11-02 04:27:41", "888starz is an innovative online gaming platform that has rapidly gained popularity among players. \r\n888starz link <a href=\"https://www.888starz-stars888.com/pl/\" / rel=\"nofollow ugc\">https://888starz-stars888.com/pl/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("980", "556", "Douglas398", "Douglas398@gmail.com", "", "175.139.208.38", "2025-11-02 13:00:58", "2025-11-02 18:00:58", "<a href=\"https://shorturl.fm/FIt6L\" rel=\"nofollow ugc\">https://shorturl.fm/FIt6L</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("981", "1", "minecraft_eoOt", "hfbtfloohOt@ingushetdomaz.pro", "https://minecraft-bedrocks.com/", "178.20.42.76", "2025-11-02 15:44:12", "2025-11-02 20:44:12", "Участники могут объединяться в группы и вместе выполнять различные задачи.  \r\nкарты для майнкрафта <a href=\"https://www.minecraft-bedrocks.com/maps/\" / rel=\"nofollow ugc\">https://minecraft-bedrocks.com/maps/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("982", "556", "Amelia1835", "Amelia1835@gmail.com", "", "118.99.103.116", "2025-11-02 23:29:05", "2025-11-03 04:29:05", "<a href=\"https://shorturl.fm/fSt4x\" rel=\"nofollow ugc\">https://shorturl.fm/fSt4x</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("983", "556", "Nova4683", "Nova4683@gmail.com", "", "41.33.126.133", "2025-11-03 18:25:39", "2025-11-03 23:25:39", "<a href=\"https://shorturl.fm/pTYNV\" rel=\"nofollow ugc\">https://shorturl.fm/pTYNV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("984", "556", "Hudson1272", "Hudson1272@gmail.com", "", "176.117.105.123", "2025-11-03 19:39:52", "2025-11-04 00:39:52", "<a href=\"https://shorturl.fm/PYX9Z\" rel=\"nofollow ugc\">https://shorturl.fm/PYX9Z</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("985", "556", "Nova3849", "Nova3849@gmail.com", "", "202.5.58.29", "2025-11-04 03:11:58", "2025-11-04 08:11:58", "<a href=\"https://shorturl.fm/TRi5J\" rel=\"nofollow ugc\">https://shorturl.fm/TRi5J</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("986", "556", "Collin1779", "Collin1779@gmail.com", "", "116.58.240.27", "2025-11-04 03:44:11", "2025-11-04 08:44:11", "<a href=\"https://shorturl.fm/3yPuO\" rel=\"nofollow ugc\">https://shorturl.fm/3yPuO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("987", "556", "Ray1894", "Ray1894@gmail.com", "", "125.25.76.193", "2025-11-04 04:01:08", "2025-11-04 09:01:08", "<a href=\"https://shorturl.fm/tIzG1\" rel=\"nofollow ugc\">https://shorturl.fm/tIzG1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("988", "556", "Jasper4167", "Jasper4167@gmail.com", "", "36.83.80.180", "2025-11-04 10:25:06", "2025-11-04 15:25:06", "<a href=\"https://shorturl.fm/Tdvzo\" rel=\"nofollow ugc\">https://shorturl.fm/Tdvzo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("989", "556", "Pierce806", "Pierce806@gmail.com", "", "86.98.40.103", "2025-11-04 11:26:59", "2025-11-04 16:26:59", "<a href=\"https://shorturl.fm/Tdvzo\" rel=\"nofollow ugc\">https://shorturl.fm/Tdvzo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("990", "531", "Kate3004", "Kate3004@gmail.com", "", "86.98.84.142", "2025-11-04 11:27:06", "2025-11-04 16:27:06", "<a href=\"https://shorturl.fm/3m5bF\" rel=\"nofollow ugc\">https://shorturl.fm/3m5bF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("991", "1", "1win_ilMt", "txwixnsagMt@ugaritopari.site", "https://1win-download.org.in/", "62.113.116.213", "2025-11-04 16:24:49", "2025-11-04 21:24:49", "Advanced encryption methods are implemented to ensure the protection of user data. \r\napplication 1win <a href=\"https://www.1win-download.org.in/fr\" rel=\"nofollow ugc\">https://1win-download.org.in/fr/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("992", "1", "urist_bvSi", "nvhfldgorSi@konsultaciya-advokata81.ru", "https://konsultaciya-advokata81.ru", "212.34.129.45", "2025-11-04 16:37:03", "2025-11-04 21:37:03", "С получением профессиональной помощи в решении юридических вопросов вы можете обратиться к <a href=\"https://konsultaciya-advokata81.ru\" rel=\"nofollow ugc\">пенсионный юрист консультация онлайн</a>, где можно получить юридическую консультацию круглосуточно и бесплатно. \r\n \r\nКоманда специалистов обеспечивает высокое качество предоставляемых услуг.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("993", "556", "Freya2037", "Freya2037@gmail.com", "", "190.109.12.39", "2025-11-04 21:21:44", "2025-11-05 02:21:44", "<a href=\"https://shorturl.fm/GR5Rh\" rel=\"nofollow ugc\">https://shorturl.fm/GR5Rh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("994", "556", "Frederick4143", "Frederick4143@gmail.com", "", "103.61.17.242", "2025-11-05 04:52:34", "2025-11-05 09:52:34", "<a href=\"https://shorturl.fm/v0twT\" rel=\"nofollow ugc\">https://shorturl.fm/v0twT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("995", "556", "Ruben3110", "Ruben3110@gmail.com", "", "154.58.138.137", "2025-11-05 19:14:02", "2025-11-06 00:14:02", "<a href=\"https://shorturl.fm/ezprF\" rel=\"nofollow ugc\">https://shorturl.fm/ezprF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("996", "556", "Colleen3229", "Colleen3229@gmail.com", "", "159.223.62.245", "2025-11-06 00:46:34", "2025-11-06 05:46:34", "<a href=\"https://shorturl.fm/1mb8H\" rel=\"nofollow ugc\">https://shorturl.fm/1mb8H</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("997", "556", "Molly3767", "Molly3767@gmail.com", "", "160.19.19.101", "2025-11-06 03:09:31", "2025-11-06 08:09:31", "<a href=\"https://shorturl.fm/yRy8o\" rel=\"nofollow ugc\">https://shorturl.fm/yRy8o</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("998", "1", "minecraft_drkt", "hicqyzqgwkt@ingushetdomaz.pro", "https://minecraft-download-apk.com", "178.20.42.76", "2025-11-06 05:14:37", "2025-11-06 10:14:37", "If you\'re looking to download Minecraft, the APK version provides a handy alternative. \r\ndownload minecraft 1.21.130.26 <a href=\"https://minecraft-download-apk.com/downloads/minecraft-pe-1-21/1-21-130-26\" rel=\"nofollow ugc\">https://minecraft-download-apk.com/downloads/minecraft-pe-1-21/1-21-130-26/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("999", "556", "Brinley3617", "Brinley3617@gmail.com", "", "119.148.49.225", "2025-11-07 00:48:32", "2025-11-07 05:48:32", "<a href=\"https://shorturl.fm/ZItMi\" rel=\"nofollow ugc\">https://shorturl.fm/ZItMi</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1000", "1", "Mitchell2853", "Mitchell2853@gmail.com", "", "119.148.49.225", "2025-11-07 00:48:47", "2025-11-07 05:48:47", "<a href=\"https://shorturl.fm/mlBp4\" rel=\"nofollow ugc\">https://shorturl.fm/mlBp4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1001", "556", "Annie3862", "Annie3862@gmail.com", "", "223.206.191.39", "2025-11-07 03:34:11", "2025-11-07 08:34:11", "<a href=\"https://shorturl.fm/whWw4\" rel=\"nofollow ugc\">https://shorturl.fm/whWw4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1002", "556", "Wilson4104", "Wilson4104@gmail.com", "", "41.33.126.134", "2025-11-07 04:48:00", "2025-11-07 09:48:00", "<a href=\"https://shorturl.fm/cGrFK\" rel=\"nofollow ugc\">https://shorturl.fm/cGrFK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1003", "556", "Jason367", "Jason367@gmail.com", "", "45.173.12.149", "2025-11-07 05:39:45", "2025-11-07 10:39:45", "<a href=\"https://shorturl.fm/27RkF\" rel=\"nofollow ugc\">https://shorturl.fm/27RkF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1004", "556", "Malcolm2399", "Malcolm2399@gmail.com", "", "188.166.218.81", "2025-11-07 07:54:13", "2025-11-07 12:54:13", "<a href=\"https://shorturl.fm/Q8TFe\" rel=\"nofollow ugc\">https://shorturl.fm/Q8TFe</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1005", "556", "Alonzo3386", "Alonzo3386@gmail.com", "", "182.53.254.65", "2025-11-07 13:10:52", "2025-11-07 18:10:52", "<a href=\"https://shorturl.fm/R4CmI\" rel=\"nofollow ugc\">https://shorturl.fm/R4CmI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1006", "1", "888starz_zcsa", "ikpscblxjsa@ugaritopari.site", "https://888starzuzbekistan.net", "62.113.116.213", "2025-11-07 17:13:59", "2025-11-07 22:13:59", "888starz uz - yetakchi platformalardan biri. Bu platforma. yuqori sifatli xizmatlar. Bundan tashqari, ko\'plab o\'yin turlari, o\'yin o\'ynash imkonini. \r\n \r\nPlatformaning axborot xavfsizligi. va himoyalangan. Shuningdek, bir necha turdagi to\'lov usullari, bu esa. platformaga. \r\n \r\nva. harakatini. ushlab turishga. \r\n \r\nShu bilan birga, kutilmoqda. Har qanday savollarga. tez-tez. Bu platformaning afzalliklaridan biri. \r\n888starz registraciya <a href=\"888starzuzbekistan.net/registration\" rel=\"nofollow ugc\">https://888starzuzbekistan.net/registration/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1007", "1", "minecraft_liKr", "nzmdpfyciKr@igurant1.online", "https://download-minecraft-apk.com/", "88.210.35.166", "2025-11-07 20:04:33", "2025-11-08 01:04:33", "Complete the installation by adhering to the on-screen guidelines. \r\nminecraft latest apk download <a href=\"http://download-minecraft-apk.com/\" / rel=\"nofollow ugc\">https://download-minecraft-apk.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1008", "1", "konsultaci_liEn", "gmcpgzyxsEn@konsultaciya-yurista20.store", "https://konsultaciya-advokata91.ru", "212.34.129.45", "2025-11-08 12:17:06", "2025-11-08 17:17:06", "Получите <a href=\"https://konsultaciya-advokata91.ru\" rel=\"nofollow ugc\">бесплатную юридическую консультацию онлайн</a>, чтобы оперативно решить все ваши юридические вопросы! \r\n Мы предоставляем доступ к высококлассным юридическим услугам, которые помогут вам сохранить ваши интересы.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1009", "556", "Chloe3566", "Chloe3566@gmail.com", "", "27.147.137.90", "2025-11-09 08:57:29", "2025-11-09 13:57:29", "<a href=\"https://shorturl.fm/isqDH\" rel=\"nofollow ugc\">https://shorturl.fm/isqDH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1010", "556", "Ann2666", "Ann2666@gmail.com", "", "159.223.64.127", "2025-11-09 11:15:30", "2025-11-09 16:15:30", "<a href=\"https://shorturl.fm/3h83L\" rel=\"nofollow ugc\">https://shorturl.fm/3h83L</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1011", "556", "Dallas626", "Dallas626@gmail.com", "", "128.199.85.114", "2025-11-09 13:27:51", "2025-11-09 18:27:51", "<a href=\"https://shorturl.fm/mqmFu\" rel=\"nofollow ugc\">https://shorturl.fm/mqmFu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1012", "531", "Ava1531", "Ava1531@gmail.com", "", "123.25.104.105", "2025-11-09 15:38:18", "2025-11-09 20:38:18", "<a href=\"https://shorturl.fm/fC0gE\" rel=\"nofollow ugc\">https://shorturl.fm/fC0gE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1013", "556", "Janice3875", "Janice3875@gmail.com", "", "3.79.188.101", "2025-11-09 15:46:09", "2025-11-09 20:46:09", "<a href=\"https://shorturl.fm/nlIS0\" rel=\"nofollow ugc\">https://shorturl.fm/nlIS0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1014", "1", "minecraft_lbOt", "hdvvepwdjOt@ingushetdomaz.pro", "https://minecraft-downloadd.com", "178.20.42.76", "2025-11-09 16:03:19", "2025-11-09 21:03:19", "Here MCPE <a href=\"https://minecraft-downloadd.com\" rel=\"nofollow ugc\">minecraft god mod hack download apk</a>. \r\n Start by accessing the official Minecraft website to initiate your download.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1015", "551", "Madeline4122", "Madeline4122@gmail.com", "", "123.200.22.70", "2025-11-09 18:41:44", "2025-11-09 23:41:44", "<a href=\"https://shorturl.fm/u0C4W\" rel=\"nofollow ugc\">https://shorturl.fm/u0C4W</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1016", "556", "Isabel593", "Isabel593@gmail.com", "", "178.62.9.52", "2025-11-11 02:59:48", "2025-11-11 07:59:48", "<a href=\"https://shorturl.fm/u29N0\" rel=\"nofollow ugc\">https://shorturl.fm/u29N0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1017", "556", "Paul63", "Paul63@gmail.com", "", "159.89.204.66", "2025-11-11 05:43:34", "2025-11-11 10:43:34", "<a href=\"https://shorturl.fm/CKjcV\" rel=\"nofollow ugc\">https://shorturl.fm/CKjcV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1018", "556", "Jonah3882", "Jonah3882@gmail.com", "", "106.52.63.37", "2025-11-11 06:10:03", "2025-11-11 11:10:03", "<a href=\"https://shorturl.fm/T8sgV\" rel=\"nofollow ugc\">https://shorturl.fm/T8sgV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1019", "556", "Adeline1966", "Adeline1966@gmail.com", "", "196.188.126.66", "2025-11-11 07:06:38", "2025-11-11 12:06:38", "<a href=\"https://shorturl.fm/2P2nt\" rel=\"nofollow ugc\">https://shorturl.fm/2P2nt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1020", "556", "Jaxon15", "Jaxon15@gmail.com", "", "38.25.17.238", "2025-11-12 12:35:16", "2025-11-12 17:35:16", "<a href=\"https://shorturl.fm/BMR4Z\" rel=\"nofollow ugc\">https://shorturl.fm/BMR4Z</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1021", "556", "Isabella3729", "Isabella3729@gmail.com", "", "1.53.120.245", "2025-11-12 22:06:08", "2025-11-13 03:06:08", "<a href=\"https://shorturl.fm/x9yJo\" rel=\"nofollow ugc\">https://shorturl.fm/x9yJo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1022", "1", "konsultaci_bePt", "jqyjlgjryPt@konsultaciya-yurista20.store", "https://konsultaciya-yurista-msk01.ru", "212.34.129.45", "2025-11-13 00:34:19", "2025-11-13 05:34:19", "Получите бесплатную консультацию юриста онлайн <a href=\"https://konsultaciya-yurista-msk01.ru\" rel=\"nofollow ugc\">Телефон бесплатного юриста для связи</a>. \r\nВы сможете избежать возможных ошибок благодаря помощи специалиста.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1023", "556", "Manuel456", "Manuel456@gmail.com", "", "178.128.112.107", "2025-11-13 03:39:46", "2025-11-13 08:39:46", "<a href=\"https://shorturl.fm/4ILwY\" rel=\"nofollow ugc\">https://shorturl.fm/4ILwY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1024", "556", "Bryant2545", "Bryant2545@gmail.com", "", "125.26.166.243", "2025-11-13 06:15:33", "2025-11-13 11:15:33", "<a href=\"https://shorturl.fm/iZc90\" rel=\"nofollow ugc\">https://shorturl.fm/iZc90</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1025", "556", "Brandon2756", "Brandon2756@gmail.com", "", "45.183.137.26", "2025-11-13 11:08:26", "2025-11-13 16:08:26", "<a href=\"https://shorturl.fm/OfjuM\" rel=\"nofollow ugc\">https://shorturl.fm/OfjuM</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1026", "1", "bahigo_fgMt", "avhhguxerMt@ingushetdomaz.pro", "https://bahigooo.com", "178.20.42.76", "2025-11-13 19:43:23", "2025-11-14 00:43:23", "Wenn die Nutzer Hilfe benotigen, steht ihnen der Support jederzeit zur Verfugung. Langjahrige Spieler konnen von exklusiven Pramien und Treueboni profitieren. Das Casino arbeitet mit namhaften Softwareanbietern zusammen, um eine hohe Qualitat der Spiele zu gewahrleisten. Spieler konnen Bahigo bequem uber den Computer oder das Smartphone nutzen. Bei Fragen oder Problemen konnen sich Spieler jederzeit an den Kundendienst wenden. Das Casino arbeitet mit einer offiziellen Lizenz und entspricht den schweizerischen Glucksspielgesetzen. Alles in allem ist Bahigo eine ausgezeichnete Wahl fur Spieler in der Schweiz. \r\nbahigo com <a href=\"http://www.bahigooo.com/\" / rel=\"nofollow ugc\">https://bahigooo.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1027", "556", "Archie1569", "Archie1569@gmail.com", "", "115.72.37.140", "2025-11-14 07:57:08", "2025-11-14 12:57:08", "<a href=\"https://shorturl.fm/qjO6H\" rel=\"nofollow ugc\">https://shorturl.fm/qjO6H</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1028", "556", "Jesse3544", "Jesse3544@gmail.com", "", "120.78.85.167", "2025-11-14 08:13:54", "2025-11-14 13:13:54", "<a href=\"https://shorturl.fm/94aZF\" rel=\"nofollow ugc\">https://shorturl.fm/94aZF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1029", "556", "Daniella59", "Daniella59@gmail.com", "", "43.153.57.12", "2025-11-14 09:25:15", "2025-11-14 14:25:15", "<a href=\"https://shorturl.fm/WmuR0\" rel=\"nofollow ugc\">https://shorturl.fm/WmuR0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1030", "556", "Eloise256", "Eloise256@gmail.com", "", "24.199.100.60", "2025-11-14 13:04:37", "2025-11-14 18:04:37", "<a href=\"https://shorturl.fm/CoFM5\" rel=\"nofollow ugc\">https://shorturl.fm/CoFM5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1031", "551", "Jay3259", "Jay3259@gmail.com", "", "24.199.100.60", "2025-11-14 13:04:56", "2025-11-14 18:04:56", "<a href=\"https://shorturl.fm/jpsmM\" rel=\"nofollow ugc\">https://shorturl.fm/jpsmM</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1032", "1", "Heidi4621", "Heidi4621@gmail.com", "", "24.199.100.60", "2025-11-14 13:05:11", "2025-11-14 18:05:11", "<a href=\"https://shorturl.fm/WOR3d\" rel=\"nofollow ugc\">https://shorturl.fm/WOR3d</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1033", "1", "mafia_uasl", "xedjczlgesl@ugaritopari.site", "https://mafiacasinoo.com", "62.113.116.213", "2025-11-14 17:08:48", "2025-11-14 22:08:48", "<a href=\"https://mafiacasinoo.com\" rel=\"nofollow ugc\">slot mafia casino</a>— is the perfect place for gambling enthusiasts, where you can enjoy a unique mafia atmosphere and the chance to win. \r\nCependant, la lutte contre la mafia est complexe et necessite des efforts concertes.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1034", "1", "minecraft_mrKn", "qaejtzkafKn@problemno.shop", "https://minecraft-download1.com", "89.110.99.186", "2025-11-15 01:24:52", "2025-11-15 06:24:52", "Download <a href=\"https://minecraft-download1.com\" rel=\"nofollow ugc\">minecraft apk download 2025</a> and immerse yourself in the exciting world of creativity! \r\nOnce you finish downloading, the installation process is fast and straightforward.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1035", "556", "Finn1931", "Finn1931@gmail.com", "", "45.43.79.120", "2025-11-15 04:35:27", "2025-11-15 09:35:27", "<a href=\"https://shorturl.fm/SKwWU\" rel=\"nofollow ugc\">https://shorturl.fm/SKwWU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1036", "551", "Mae223", "Mae223@gmail.com", "", "103.38.101.194", "2025-11-15 14:16:11", "2025-11-15 19:16:11", "<a href=\"https://shorturl.fm/9Qv77\" rel=\"nofollow ugc\">https://shorturl.fm/9Qv77</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1037", "556", "Emma1601", "Emma1601@gmail.com", "", "202.73.27.100", "2025-11-16 02:44:49", "2025-11-16 07:44:49", "<a href=\"https://shorturl.fm/d5EEu\" rel=\"nofollow ugc\">https://shorturl.fm/d5EEu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1038", "556", "Brielle3938", "Brielle3938@gmail.com", "", "103.76.148.222", "2025-11-16 22:33:02", "2025-11-17 03:33:02", "<a href=\"https://shorturl.fm/gSyKQ\" rel=\"nofollow ugc\">https://shorturl.fm/gSyKQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1039", "556", "Christina4543", "Christina4543@gmail.com", "", "184.82.52.255", "2025-11-17 01:36:18", "2025-11-17 06:36:18", "<a href=\"https://shorturl.fm/YAG9N\" rel=\"nofollow ugc\">https://shorturl.fm/YAG9N</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1040", "556", "Jackson2996", "Jackson2996@gmail.com", "", "139.59.224.59", "2025-11-17 02:28:42", "2025-11-17 07:28:42", "<a href=\"https://shorturl.fm/FDVwF\" rel=\"nofollow ugc\">https://shorturl.fm/FDVwF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1041", "556", "Leonardo4754", "Leonardo4754@gmail.com", "", "167.172.64.49", "2025-11-17 04:09:10", "2025-11-17 09:09:10", "<a href=\"https://shorturl.fm/3XONh\" rel=\"nofollow ugc\">https://shorturl.fm/3XONh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1042", "556", "Ellen4130", "Ellen4130@gmail.com", "", "144.126.236.218", "2025-11-17 04:52:26", "2025-11-17 09:52:26", "<a href=\"https://shorturl.fm/op5dD\" rel=\"nofollow ugc\">https://shorturl.fm/op5dD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1043", "556", "Leonardo1226", "Leonardo1226@gmail.com", "", "49.36.34.192", "2025-11-17 23:10:08", "2025-11-18 04:10:08", "<a href=\"https://shorturl.fm/7TwFN\" rel=\"nofollow ugc\">https://shorturl.fm/7TwFN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1044", "531", "Payton4035", "Payton4035@gmail.com", "", "49.36.34.192", "2025-11-17 23:10:26", "2025-11-18 04:10:26", "<a href=\"https://shorturl.fm/BBFly\" rel=\"nofollow ugc\">https://shorturl.fm/BBFly</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1045", "556", "Gary1099", "Gary1099@gmail.com", "", "42.119.229.151", "2025-11-18 07:53:57", "2025-11-18 12:53:57", "<a href=\"https://shorturl.fm/gUZTP\" rel=\"nofollow ugc\">https://shorturl.fm/gUZTP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1046", "1", "yurist_dnsi", "zgkhgyapcsi@yuridicheskaya-konsultaciya23.ru", "https://yuridicheskaya-konsultaciya23.ru", "212.34.129.45", "2025-11-18 11:14:02", "2025-11-18 16:14:02", "Получите квалифицированную <a href=\"https://yuridicheskaya-konsultaciya23.ru\" rel=\"nofollow ugc\">задать вопрос юристу</a>. \r\n \r\nНа сайте также можно найти полезные статьи и материалы, которые помогут вам разобраться в юридических вопросах.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1047", "556", "Brennan919", "Brennan919@gmail.com", "", "75.197.187.199", "2025-11-18 23:47:10", "2025-11-19 04:47:10", "<a href=\"https://shorturl.fm/xE6Gu\" rel=\"nofollow ugc\">https://shorturl.fm/xE6Gu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1048", "1", "betfinal_isPa", "fgbguphwyPa@problemno.shop", "https://betfinalafrica.com", "88.210.35.166", "2025-11-19 01:03:38", "2025-11-19 06:03:38", "????????  ?? ?????  ????? ???  ???? ??????? .  ??????  ???  ??????? ?? ????  ??????? ?????? ??????? .  ??? ??? ? ??? ??  ?????? ??????  ???????? ???????? ???. \r\n \r\n?? ????  ?????????? ???? ?????? ?? ???????? .  ??????  ?? ?????  ???????? ????????  ??  ????? ????. ?????  ??? ??????????  ????? ??????  ???  ?? ?????. \r\n \r\n ?? ???????  ??  ?????  ????? ????? ?????  ?????  ????????? ???? ??  ???? ????? ????????? .  ??? ??????? ???????  ?? ???????? ??????. \r\n \r\n???????  ????? ???? ?????? ??  ????  ???????? , ????? ??  ????? ???????  ????? ??.  ????  ??  ?????? ???????? ???  ?? ?????  ?????? ???? ?????? ?????. \r\nbetfinal bonus <a href=\"http://www.betfinalafrica.com/promo-code\" rel=\"nofollow ugc\">https://betfinalafrica.com/promo-code/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1049", "556", "Flora4954", "Flora4954@gmail.com", "", "202.5.57.193", "2025-11-19 05:24:46", "2025-11-19 10:24:46", "<a href=\"https://shorturl.fm/vOjd8\" rel=\"nofollow ugc\">https://shorturl.fm/vOjd8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1050", "556", "Sally3377", "Sally3377@gmail.com", "", "38.211.24.70", "2025-11-19 15:48:48", "2025-11-19 20:48:48", "<a href=\"https://shorturl.fm/Hv5O6\" rel=\"nofollow ugc\">https://shorturl.fm/Hv5O6</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1051", "556", "Mitchell565", "Mitchell565@gmail.com", "", "189.51.170.58", "2025-11-20 08:49:04", "2025-11-20 13:49:04", "<a href=\"https://shorturl.fm/TRys2\" rel=\"nofollow ugc\">https://shorturl.fm/TRys2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1052", "531", "Brooks1269", "Brooks1269@gmail.com", "", "42.113.171.217", "2025-11-20 12:41:24", "2025-11-20 17:41:24", "<a href=\"https://shorturl.fm/ZhkTY\" rel=\"nofollow ugc\">https://shorturl.fm/ZhkTY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1053", "556", "Jared2603", "Jared2603@gmail.com", "", "124.83.118.172", "2025-11-20 14:09:11", "2025-11-20 19:09:11", "<a href=\"https://shorturl.fm/5nNL6\" rel=\"nofollow ugc\">https://shorturl.fm/5nNL6</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1054", "1", "eu9_ysKi", "nryowipquKi@problemno.shop", "https://eu9-myy.com", "89.110.99.186", "2025-11-21 01:29:54", "2025-11-21 06:29:54", "<a href=\"https://eu9-myy.com\" rel=\"nofollow ugc\">eu9 promo code</a> offers unique opportunities for gambling and entertainment in the heart of the online casino. \r\nSecurity is a top priority for the eu9 casino, providing players peace of mind.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1055", "556", "Dustin4957", "Dustin4957@gmail.com", "", "124.217.64.49", "2025-11-21 12:04:16", "2025-11-21 17:04:16", "<a href=\"https://shorturl.fm/UrXdk\" rel=\"nofollow ugc\">https://shorturl.fm/UrXdk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1056", "556", "Clyde2729", "Clyde2729@gmail.com", "", "182.53.68.45", "2025-11-21 22:53:15", "2025-11-22 03:53:15", "<a href=\"https://shorturl.fm/Y9Dgo\" rel=\"nofollow ugc\">https://shorturl.fm/Y9Dgo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1057", "1", "100_jvpl", "vdtaonhvrpl@igurant1.online", "https://100-super-hots.com", "88.210.35.166", "2025-11-21 23:41:52", "2025-11-22 04:41:52", "100 super hot slot online <a href=\"http://www.100-super-hots.com/\" / rel=\"nofollow ugc\">https://100-super-hots.com/</a> awaits you with exciting moments and the chance to win big! \r\nIn today\'s world, staying fashionable is essential for many.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1058", "1", "konsultaci_sdPa", "mheadythmPa@konsultaciya-yurista121.ru", "https://konsultaciya-yurista121.ru", "212.34.129.45", "2025-11-22 01:04:54", "2025-11-22 06:04:54", "Если вам нужна <a href=\"https://konsultaciya-yurista121.ru\" rel=\"nofollow ugc\">бесплатная консультация юриста по телефону горячая линия|адвокат|бесплатные консультации юриста по телефону в москве|помощь юриста бесплатно по телефону|юридическая консультация бесплатно по телефону круглосуточно|консультация юриста бесплатно по телефону|бесплатные юридические консультации|бесплатные юристы в москве|юрист онлайн бесплатно|бесплатные консультации юриста онлайн без регистрации</a>, не стесняйтесь обратиться к нам! \r\n Опытные адвокаты  из  нашей юридической компании  готовы помочь вам в решении различных правовых вопросов.  У нас есть множество направлений работы , включая консультации, представительство в суде и помощь в составлении документов. \r\n \r\nПри обращении к  нашей команде , вы можете рассчитывать на  высококачественное обслуживание. Каждый клиент для нас важен, и мы стремимся  удовлетворить все ваши потребности. Наша цель –  помочь вам разобраться в сложной ситуации . \r\n \r\nНа  нашей платформе вы можете  получить информацию о различных юридических услугах. Мы  всегда стремимся предложить актуальные решения . Также у нас есть разделы с полезными статьями , которые помогут вам быть в курсе последних изменений в законодательстве. \r\n \r\nСвязываясь с  нашими специалистами , вы можете задать все интересующие вас вопросы.  Чем быстрее вы обратитесь, тем больше шансов на положительный результат . Ваше спокойствие и доверие — наш приоритет .", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1059", "1", "yurist_fgMi", "gyzqnflbgMi@konsultaciya-yurista42.ru", "https://konsultaciya-yurista42.ru", "212.34.138.196", "2025-11-22 03:03:07", "2025-11-22 08:03:07", "Получите профессиональную <a href=\"https://konsultaciya-yurista42.ru\" rel=\"nofollow ugc\">юрист консультация|бесплатную консультацию юриста|онлайн консультацию юриста|юридическую консультацию бесплатно|консультацию юриста бесплатно</a> и разрешите свои юридические вопросы с уверенностью! \r\nЮридические консультации играют важную роль в нашей повседневной жизни.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1060", "556", "Hailee4482", "Hailee4482@gmail.com", "", "68.183.232.85", "2025-11-22 03:22:34", "2025-11-22 08:22:34", "<a href=\"https://shorturl.fm/uYilp\" rel=\"nofollow ugc\">https://shorturl.fm/uYilp</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1061", "1", "betfinal_fxmn", "pcfdivpynmn@ugaritopari.site", "https://betfinalafrica.com", "62.113.116.213", "2025-11-22 16:36:57", "2025-11-22 21:36:57", "بيت فاينل البحرين <a href=\"https://cursodeveranobusinesskids.com/betfinal-%d9%8a%d9%82%d8%af%d9%85-%d8%b3%d9%84%d9%88%d8%aa%d8%b3-%d8%ab%d9%84%d8%a7%d8%ab%d9%8a%d8%a9-%d9%88%d8%ae%d9%85%d8%a7%d8%b3%d9%8a%d8%a9-%d8%a7%d9%84%d8%a8%d9%83%d8%b1%d8%a7%d8%aa-%d9%85%d9%85\" rel=\"nofollow ugc\">https://cursodeveranobusinesskids.com/betfinal-%d9%8a%d9%82%d8%af%d9%85-%d8%b3%d9%84%d9%88%d8%aa%d8%b3-%d8%ab%d9%84%d8%a7%d8%ab%d9%8a%d8%a9-%d9%88%d8%ae%d9%85%d8%a7%d8%b3%d9%8a%d8%a9-%d8%a7%d9%84%d8%a8%d9%83%d8%b1%d8%a7%d8%aa-%d9%85%d9%85/</a> \r\nيُعدُّ منصّة بت فاينال واحدةً من أفضل مواقع الكازينو في الخليج العربي. \r\nيقدم betfinal casino تجربة لعب آمنة وسريعة مع دعم طرق الدفع المناسبة للاعبين العرب. \r\n \r\nيتميز betfinal بمجموعة ضخمة من الألعاب: رهانات مباشرة مع مزايا رائعة للاعبين في بيت فاينل المغرب.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1062", "556", "Landon1191", "Landon1191@gmail.com", "", "110.9.74.211", "2025-11-22 18:01:46", "2025-11-22 23:01:46", "<a href=\"https://shorturl.fm/MuDBB\" rel=\"nofollow ugc\">https://shorturl.fm/MuDBB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1063", "556", "Felicity297", "Felicity297@gmail.com", "", "159.223.46.180", "2025-11-22 22:20:29", "2025-11-23 03:20:29", "<a href=\"https://shorturl.fm/feodi\" rel=\"nofollow ugc\">https://shorturl.fm/feodi</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1064", "556", "King2441", "King2441@gmail.com", "", "36.94.120.23", "2025-11-23 06:13:51", "2025-11-23 11:13:51", "<a href=\"https://shorturl.fm/ak6eu\" rel=\"nofollow ugc\">https://shorturl.fm/ak6eu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1065", "531", "Jeffrey2860", "Jeffrey2860@gmail.com", "", "94.41.213.218", "2025-11-23 18:48:18", "2025-11-23 23:48:18", "<a href=\"https://shorturl.fm/p5rsZ\" rel=\"nofollow ugc\">https://shorturl.fm/p5rsZ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1066", "556", "Kiley4900", "Kiley4900@gmail.com", "", "124.83.34.83", "2025-11-24 12:39:49", "2025-11-24 17:39:49", "<a href=\"https://shorturl.fm/q9Ney\" rel=\"nofollow ugc\">https://shorturl.fm/q9Ney</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1067", "1", "40_ttkt", "sswsmlujrkt@ingushetdomaz.pro", "https://40superhott.com", "178.20.42.76", "2025-11-24 13:34:15", "2025-11-24 18:34:15", "<a href=\"https://40superhott.com\" rel=\"nofollow ugc\">40 super hot slot casino</a> offers incredible chances to win and an exciting gaming experience! \r\nThis term encapsulates a cultural trend worthy of discussion.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1068", "556", "Kendra3628", "Kendra3628@gmail.com", "", "180.240.216.139", "2025-11-24 18:46:16", "2025-11-24 23:46:16", "<a href=\"https://shorturl.fm/njCDK\" rel=\"nofollow ugc\">https://shorturl.fm/njCDK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1069", "556", "Lucas1280", "Lucas1280@gmail.com", "", "58.8.74.55", "2025-11-24 19:50:36", "2025-11-25 00:50:36", "<a href=\"https://shorturl.fm/RnEeZ\" rel=\"nofollow ugc\">https://shorturl.fm/RnEeZ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1070", "1", "monopoly_zvSt", "pladsrknySt@problemno.shop", "https://monopoly-live-bd.com", "89.110.99.186", "2025-11-25 00:05:43", "2025-11-25 05:05:43", "Immerse yourself in the exciting world <a href=\"https://monopoly-live-bd.com\" rel=\"nofollow ugc\">monopoly big baller live stream</a>, where every spin can be a turning point in your game! \r\nThe game features a large money wheel that players spin to discover their next move.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1071", "1", "888starz_hbEi", "pxleuorllEi@igurant1.online", "https://888starzuzbets.com", "88.210.35.166", "2025-11-25 01:09:00", "2025-11-25 06:09:00", "888starz uz — yangi imkoniyatlar taqdim etadi. sinab ko\'rish imkonini beradi. Har kim. yaqinda o\'z sevimli sportiga tikish imkoniyatini beradi. \r\n888 starz registration <a href=\"https://www.888starzuzbets.com/registration/\" / rel=\"nofollow ugc\">https://888starzuzbets.com/registration/</a> \r\n888starz uz. har qanday vaqt ichida. tezda o\'z hisobini yaratishi. foydalanuvchilarga. \r\nBonuslar va aktsiyalar. Ushbu platforma. maxsus bonuslar bilan taqdirlanishi mumkin. bir qator bonuslar. \r\nTakliflar va xizmatlar. Foydalanuvchilar. bu to\'lov tizimlarining xilma-xilligi.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1072", "556", "Dwight4268", "Dwight4268@gmail.com", "", "103.23.196.22", "2025-11-25 01:25:13", "2025-11-25 06:25:13", "<a href=\"https://shorturl.fm/sEHFf\" rel=\"nofollow ugc\">https://shorturl.fm/sEHFf</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1073", "531", "Garrett233", "Garrett233@gmail.com", "", "103.23.196.22", "2025-11-25 01:25:33", "2025-11-25 06:25:33", "<a href=\"https://shorturl.fm/MsfpN\" rel=\"nofollow ugc\">https://shorturl.fm/MsfpN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1074", "1", "konsultaci_avPa", "oltggkmmzPa@konsultaciya-yurista121.ru", "https://konsultaciya-yurista121.ru", "212.34.129.45", "2025-11-25 02:13:24", "2025-11-25 07:13:24", "Если вам нужна <a href=\"https://konsultaciya-yurista121.ru\" rel=\"nofollow ugc\">бесплатная консультация юриста по телефону горячая линия|адвокат|бесплатные консультации юриста по телефону в москве|помощь юриста бесплатно по телефону|юридическая консультация бесплатно по телефону круглосуточно|консультация юриста бесплатно по телефону|бесплатные юридические консультации|бесплатные юристы в москве|юрист онлайн бесплатно|бесплатные консультации юриста онлайн без регистрации</a>, не стесняйтесь обратиться к нам! \r\n Профессиональные специалисты из  нашей юридической компании  готовы помочь вам в решении различных правовых вопросов. Мы предлагаем широкий спектр услуг , включая консультации, представительство в суде и помощь в составлении документов. \r\n \r\nПри обращении к  нашей команде , вы можете рассчитывать на  внимательное отношение . Каждый клиент для нас важен, и мы стремимся найти оптимальное решение . Наша цель –  сделать процессы максимально прозрачными и понятными. \r\n \r\nНа  нашем сайте  вы можете  получить информацию о различных юридических услугах. Мы регулярно обновляем информацию . Также у нас есть  блоги с юридическими новостями , которые помогут вам быть в курсе последних изменений в законодательстве. \r\n \r\nСвязываясь с  нашими специалистами , вы можете задать все интересующие вас вопросы.  Чем быстрее вы обратитесь, тем больше шансов на положительный результат .  Ваши права и интересы должны быть защищены .", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1075", "556", "Joyce2732", "Joyce2732@gmail.com", "", "159.89.199.220", "2025-11-25 06:09:57", "2025-11-25 11:09:57", "<a href=\"https://shorturl.fm/kMrBx\" rel=\"nofollow ugc\">https://shorturl.fm/kMrBx</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1076", "556", "Abram3154", "Abram3154@gmail.com", "", "146.190.99.101", "2025-11-25 11:31:35", "2025-11-25 16:31:35", "<a href=\"https://shorturl.fm/MhL5o\" rel=\"nofollow ugc\">https://shorturl.fm/MhL5o</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1077", "1", "betfinal_aoSt", "whetawzhySt@ugaritopari.site", "https://betfinalafrica.com", "62.113.116.213", "2025-11-25 16:07:36", "2025-11-25 21:07:36", "????? ??? betfinal ?? ???? ????? ??????. ??? ???? ?? ????? ?? ???? ?????????. ???? ?????? ?? ???????? ???????? ???????. \r\n??? ?? ????? ?? ????? ??????? ??????? ?? betfinal. ???? betfinal ?????? ????? ?? ???????. ???? ?? ??? ?? ??????? ?????????? ??? ??????? ???????. \r\nbetfinal iraq <a href=\"sheardeals.com/betfinal-saudi-arabia-%d9%8a%d9%82%d8%af%d9%85-%d8%aa%d8%ac%d8%b1%d8%a8%d8%a9-%d9%84%d8%b9%d8%a8-%d8%b1%d8%b3%d9%85%d9%8a%d8%a9-%d9%84%d9%84%d8%b3%d8%b9%d9%88%d8%af%d9%8a%d9%8a%d9%86\" rel=\"nofollow ugc\">https://sheardeals.com/betfinal-saudi-arabia-%d9%8a%d9%82%d8%af%d9%85-%d8%aa%d8%ac%d8%b1%d8%a8%d8%a9-%d9%84%d8%b9%d8%a8-%d8%b1%d8%b3%d9%85%d9%8a%d8%a9-%d9%84%d9%84%d8%b3%d8%b9%d9%88%d8%af%d9%8a%d9%8a%d9%86/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1078", "556", "Bryant3870", "Bryant3870@gmail.com", "", "211.167.76.169", "2025-11-25 19:33:29", "2025-11-26 00:33:29", "<a href=\"https://shorturl.fm/1WV8L\" rel=\"nofollow ugc\">https://shorturl.fm/1WV8L</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1079", "556", "Douglas3019", "Douglas3019@gmail.com", "", "49.48.185.105", "2025-11-25 23:51:28", "2025-11-26 04:51:28", "<a href=\"https://shorturl.fm/YzCuM\" rel=\"nofollow ugc\">https://shorturl.fm/YzCuM</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1080", "556", "Anastasia1425", "Anastasia1425@gmail.com", "", "89.43.132.80", "2025-11-26 21:09:54", "2025-11-27 02:09:54", "<a href=\"https://shorturl.fm/1NAeC\" rel=\"nofollow ugc\">https://shorturl.fm/1NAeC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1081", "531", "Alfred3087", "Alfred3087@gmail.com", "", "89.43.132.80", "2025-11-26 21:10:15", "2025-11-27 02:10:15", "<a href=\"https://shorturl.fm/BLMyq\" rel=\"nofollow ugc\">https://shorturl.fm/BLMyq</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1082", "556", "Halle2046", "Halle2046@gmail.com", "", "43.155.138.148", "2025-11-26 21:10:32", "2025-11-27 02:10:32", "<a href=\"https://shorturl.fm/1NAeC\" rel=\"nofollow ugc\">https://shorturl.fm/1NAeC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1083", "556", "Brent3000", "Brent3000@gmail.com", "", "209.97.171.181", "2025-11-26 21:30:06", "2025-11-27 02:30:06", "<a href=\"https://shorturl.fm/MvgeA\" rel=\"nofollow ugc\">https://shorturl.fm/MvgeA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1084", "556", "Catherine606", "Catherine606@gmail.com", "", "194.156.230.148", "2025-11-27 02:15:19", "2025-11-27 07:15:19", "<a href=\"https://shorturl.fm/qSnYA\" rel=\"nofollow ugc\">https://shorturl.fm/qSnYA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1085", "1", "ivibet_jkmt", "mrnlwrzwwmt@ugaritopari.site", "https://ivibets-casino.com", "62.113.116.213", "2025-11-27 23:00:27", "2025-11-28 04:00:27", "Open the doors to the world of gambling entertainment and enjoy the game <a href=\"https://ivibets-casino.com\" rel=\"nofollow ugc\">ivibet .com</a>! \r\n ivibet focuses on providing a smooth and enjoyable user experience.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1086", "556", "Eugene857", "Eugene857@gmail.com", "", "117.235.128.208", "2025-11-28 01:23:05", "2025-11-28 06:23:05", "<a href=\"https://shorturl.fm/5lYWD\" rel=\"nofollow ugc\">https://shorturl.fm/5lYWD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1087", "1", "Deirdre1819", "Deirdre1819@gmail.com", "", "117.235.128.208", "2025-11-28 01:23:21", "2025-11-28 06:23:21", "<a href=\"https://shorturl.fm/a1Rcp\" rel=\"nofollow ugc\">https://shorturl.fm/a1Rcp</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1088", "1", "konsultaci_pbPt", "xofpnicdnPt@konsultaciya-yurista20.store", "https://konsultaciya-yurista-msk01.ru", "212.34.129.45", "2025-11-28 02:01:02", "2025-11-28 07:01:02", "Получите бесплатную консультацию юриста онлайн <a href=\"https://konsultaciya-yurista-msk01.ru\" rel=\"nofollow ugc\">Консультант-юрист онлайн бесплатно</a>. \r\nЮридическая консультация — важный этап в решении многих вопросов.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1089", "556", "Archie1622", "Archie1622@gmail.com", "", "118.173.6.230", "2025-11-28 06:06:35", "2025-11-28 11:06:35", "<a href=\"https://shorturl.fm/mEunQ\" rel=\"nofollow ugc\">https://shorturl.fm/mEunQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1090", "1", "boomerang_crkl", "pvqvlkvlwkl@ingushetdomaz.pro", "https://boomerang-switzerland.com", "178.20.42.76", "2025-11-28 14:19:55", "2025-11-28 19:19:55", "Entdecken Sie die Welt der Glucksspielunterhaltung mit <a href=\"https://boomerang-switzerland.com\" rel=\"nofollow ugc\">boomerang casino casini</a> – Ihre ideale Wahl fur Wetten! \r\nBoomerang-Wetten ziehen viele Wettbegeisterte an, weil sie das Wett-Erlebnis auf eine neue Ebene heben.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1091", "556", "Fallon245", "Fallon245@gmail.com", "", "83.110.96.228", "2025-11-28 15:01:21", "2025-11-28 20:01:21", "<a href=\"https://shorturl.fm/AftO3\" rel=\"nofollow ugc\">https://shorturl.fm/AftO3</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1092", "556", "Bryant2512", "Bryant2512@gmail.com", "", "171.6.5.1", "2025-11-28 18:29:24", "2025-11-28 23:29:24", "<a href=\"https://shorturl.fm/yox3i\" rel=\"nofollow ugc\">https://shorturl.fm/yox3i</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1093", "556", "Bruce4521", "Bruce4521@gmail.com", "", "110.77.241.195", "2025-11-29 01:01:13", "2025-11-29 06:01:13", "<a href=\"https://shorturl.fm/ejIzu\" rel=\"nofollow ugc\">https://shorturl.fm/ejIzu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1094", "1", "1win_pmMt", "biougklytMt@problemno.shop", "https://1win-download.org.in", "89.110.99.186", "2025-11-29 01:16:47", "2025-11-29 06:16:47", "Such bonuses are aimed at not only attracting newcomers but also keeping loyal players engaged.  \r\naviator 1win download <a href=\"https://1win-download.org.in/\" / rel=\"nofollow ugc\">https://1win-download.org.in/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1095", "556", "Ellen129", "Ellen129@gmail.com", "", "118.25.77.23", "2025-11-30 02:39:14", "2025-11-30 07:39:14", "<a href=\"https://shorturl.fm/6i6hQ\" rel=\"nofollow ugc\">https://shorturl.fm/6i6hQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1096", "551", "Sierra4187", "Sierra4187@gmail.com", "", "105.157.171.113", "2025-11-30 02:39:47", "2025-11-30 07:39:47", "<a href=\"https://shorturl.fm/onqgT\" rel=\"nofollow ugc\">https://shorturl.fm/onqgT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1097", "1", "Dizaynersk_qeka", "fkmnmgecvka@2-construction.store", "https://byfurniture.ry", "212.115.49.151", "2025-11-30 09:17:18", "2025-11-30 14:17:18", "<a href=\"byfurniture.ry\" rel=\"nofollow ugc\">Дизайнерская мебель премиум класса</a> — это воплощение изысканного стиля и безукоризненного качества. \r\nПремиум мебель — это выгодная инвестиция в стиль и комфорт вашего пространства.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1098", "556", "Grant4190", "Grant4190@gmail.com", "", "193.188.113.155", "2025-11-30 12:13:08", "2025-11-30 17:13:08", "<a href=\"https://shorturl.fm/0IHlV\" rel=\"nofollow ugc\">https://shorturl.fm/0IHlV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1099", "1", "888starz_joPi", "edxnbuqkkPi@ugaritopari.site", "https://888starz-uzbekistan.ru", "62.113.116.213", "2025-11-30 15:45:32", "2025-11-30 20:45:32", "Пользователи могут наслаждаться разными видами азартных игр, начиная от слотов и заканчивая спортивными событиями. \r\n888 старс узбекистан <a href=\"http://888starz-casino.com.ru/\" / rel=\"nofollow ugc\">https://888starz-casino.com.ru/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1100", "556", "Eden3829", "Eden3829@gmail.com", "", "164.92.150.21", "2025-11-30 22:58:35", "2025-12-01 03:58:35", "<a href=\"https://shorturl.fm/7er6F\" rel=\"nofollow ugc\">https://shorturl.fm/7er6F</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1101", "556", "Edgar1532", "Edgar1532@gmail.com", "", "116.68.204.74", "2025-12-01 13:46:32", "2025-12-01 18:46:32", "<a href=\"https://shorturl.fm/q68nK\" rel=\"nofollow ugc\">https://shorturl.fm/q68nK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1102", "556", "Ashley3583", "Ashley3583@gmail.com", "", "43.224.119.98", "2025-12-01 19:22:03", "2025-12-02 00:22:03", "<a href=\"https://shorturl.fm/CO71i\" rel=\"nofollow ugc\">https://shorturl.fm/CO71i</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1103", "556", "Mckenzie3978", "Mckenzie3978@gmail.com", "", "103.156.14.157", "2025-12-01 20:08:48", "2025-12-02 01:08:48", "<a href=\"https://shorturl.fm/l6xgD\" rel=\"nofollow ugc\">https://shorturl.fm/l6xgD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1104", "556", "Michelle4450", "Michelle4450@gmail.com", "", "89.109.16.66", "2025-12-01 23:37:25", "2025-12-02 04:37:25", "<a href=\"https://shorturl.fm/OE5XL\" rel=\"nofollow ugc\">https://shorturl.fm/OE5XL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1105", "556", "Karl3191", "Karl3191@gmail.com", "", "180.248.27.166", "2025-12-02 04:59:06", "2025-12-02 09:59:06", "<a href=\"https://shorturl.fm/mfPeG\" rel=\"nofollow ugc\">https://shorturl.fm/mfPeG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1106", "556", "Eileen1371", "Eileen1371@gmail.com", "", "116.15.193.236", "2025-12-02 05:18:55", "2025-12-02 10:18:55", "<a href=\"https://shorturl.fm/swrtL\" rel=\"nofollow ugc\">https://shorturl.fm/swrtL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1107", "556", "Jade1739", "Jade1739@gmail.com", "", "203.2.151.18", "2025-12-02 11:20:21", "2025-12-02 16:20:21", "<a href=\"https://shorturl.fm/Z2ggy\" rel=\"nofollow ugc\">https://shorturl.fm/Z2ggy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1108", "1", "true_leer", "tdiechfhver@ingushetdomaz.pro", "https://true-fortune-casino.uk", "178.20.42.76", "2025-12-02 15:03:39", "2025-12-02 20:03:39", "Discover a world of excitement and entertainment <a href=\"https://true-fortune-casino.uk\" rel=\"nofollow ugc\">true fortune login</a>! \r\nAt True Fortune Casino is a popular destination for players looking for an exciting gaming experience. Offering a diverse selection of games, it caters to both casual players and high rollers. Ranging from slots to classic table games, there is something for everyone.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1109", "1", "888starz_soOl", "gdefjzjskOl@problemno.shop", "https://xn--888----5nfbabb2ca7axy8cdu1amheti2k1f.xn--p1ai/zerkalo/", "89.110.99.186", "2025-12-02 22:46:22", "2025-12-03 03:46:22", "<a href=\"https://xn--888----5nfbabb2ca7axy8cdu1amheti2k1f.xn--p1ai/zerkalo/\" / rel=\"nofollow ugc\">888 старз зеркало</a>  - это надежный способ получить доступ к любимым играм даже в случае блокировок. \r\n Высокое качество графики и звука делает игры на платформе незабываемыми.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1110", "1", "888starz_shEt", "dwjmawvhhEt@igurant1.online", "https://888starz-casino-egypt.com", "88.210.35.166", "2025-12-02 22:46:35", "2025-12-03 03:46:35", "تقدم هذه المنصة مجموعة واسعة من الألعاب التي تناسب جميع الأذواق. \r\n888starz bet <a href=\"https://www.888starz-casino-egypt.com/\" / rel=\"nofollow ugc\">https://888starz-casino-egypt.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1111", "1", "yurist_qwsi", "srdaeryxtsi@yuridicheskaya-konsultaciya23.ru", "https://yuridicheskaya-konsultaciya23.ru", "212.34.129.45", "2025-12-03 02:23:52", "2025-12-03 07:23:52", "Получите квалифицированную <a href=\"https://yuridicheskaya-konsultaciya23.ru\" rel=\"nofollow ugc\">онлайн консультацию юриста</a>. \r\n \r\nНаши юристы гарантируют, что каждый вопрос будет решен с учетом ваших интересов.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1112", "556", "Theodore2820", "Theodore2820@gmail.com", "", "223.204.126.73", "2025-12-03 08:56:38", "2025-12-03 13:56:38", "<a href=\"https://shorturl.fm/nzG1m\" rel=\"nofollow ugc\">https://shorturl.fm/nzG1m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1113", "556", "Lynn1106", "Lynn1106@gmail.com", "", "103.244.107.129", "2025-12-03 23:30:42", "2025-12-04 04:30:42", "<a href=\"https://shorturl.fm/afyg9\" rel=\"nofollow ugc\">https://shorturl.fm/afyg9</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1114", "1", "888starz_vxer", "posilbjiter@ugaritopari.site", "https://888starz-bettings.com", "62.113.116.213", "2025-12-04 00:18:55", "2025-12-04 05:18:55", "In addition, 888starz casino. This incentive and experience everything available. carry considerable weight for a promising beginning in the world of online gambling. \r\nis another advantage of this gaming site. by using, online correspondence, or telephonic communication. The speed of their responses, allowing players to solve issues swiftly. Such support. \r\nFinally, is dedicated to. With, users can be assured of their safety while enjoying their gaming experience. The use of Random Number Generators (RNGs) in the entire game selection, trust and reliability in the gaming sector. \r\n888starz bonus codes <a href=\"http://www.888starz-bettings.com/promocode\" rel=\"nofollow ugc\">https://888starz-bettings.com/promocode/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1115", "556", "Jaiden2302", "Jaiden2302@gmail.com", "", "49.144.126.12", "2025-12-04 00:58:26", "2025-12-04 05:58:26", "<a href=\"https://shorturl.fm/lr7dA\" rel=\"nofollow ugc\">https://shorturl.fm/lr7dA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1116", "556", "Benjamin3399", "Benjamin3399@gmail.com", "", "157.245.201.16", "2025-12-04 04:02:20", "2025-12-04 09:02:20", "<a href=\"https://shorturl.fm/gj6ES\" rel=\"nofollow ugc\">https://shorturl.fm/gj6ES</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1117", "556", "Delaney2094", "Delaney2094@gmail.com", "", "174.138.18.10", "2025-12-04 12:53:16", "2025-12-04 17:53:16", "<a href=\"https://shorturl.fm/K6gOf\" rel=\"nofollow ugc\">https://shorturl.fm/K6gOf</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1118", "556", "Derek2458", "Derek2458@gmail.com", "", "103.49.171.33", "2025-12-04 14:12:05", "2025-12-04 19:12:05", "<a href=\"https://shorturl.fm/MtgLV\" rel=\"nofollow ugc\">https://shorturl.fm/MtgLV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1119", "556", "Jaxon3692", "Jaxon3692@gmail.com", "", "156.208.64.183", "2025-12-05 05:51:59", "2025-12-05 10:51:59", "<a href=\"https://shorturl.fm/36bez\" rel=\"nofollow ugc\">https://shorturl.fm/36bez</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1120", "556", "Gilbert2052", "Gilbert2052@gmail.com", "", "171.238.88.218", "2025-12-05 05:52:44", "2025-12-05 10:52:44", "<a href=\"https://shorturl.fm/oxYfz\" rel=\"nofollow ugc\">https://shorturl.fm/oxYfz</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1121", "556", "Pedro3898", "Pedro3898@gmail.com", "", "125.25.32.168", "2025-12-05 05:54:36", "2025-12-05 10:54:36", "<a href=\"https://shorturl.fm/56G4J\" rel=\"nofollow ugc\">https://shorturl.fm/56G4J</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1122", "1", "Progon_hkSn", "lqpbthzciSn@xrumer-xrumer1.store", "https://xrumer-2026.ru", "212.34.129.45", "2025-12-05 11:57:59", "2025-12-05 16:57:59", "<a href=\"https://xrumer-2026.ru\" rel=\"nofollow ugc\">прогон хрумером</a> \r\nРегулярное обновление программы Хрумер позволяет использовать все новые функции.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1123", "1", "888starz_pjkt", "zqgdxipkukt@ingushetdomaz.pro", "https://kingbaowow.com", "178.20.42.76", "2025-12-05 17:10:46", "2025-12-05 22:10:46", "To safeguard user information and uphold fairness, the platform uses state-of-the-art security protocols. \r\n888starz game <a href=\"http://www.kingbaowow.com\" rel=\"nofollow ugc\">https://kingbaowow.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1124", "1", "888starz_tcMt", "yijcoaispMt@igurant1.online", "https://888starz-eng.com", "88.210.35.166", "2025-12-05 22:42:04", "2025-12-06 03:42:04", "To secure user data, 888starz utilizes the latest encryption technologies. \r\n888starz bénin <a href=\"888starz-eng.com/fr\" rel=\"nofollow ugc\">https://888starz-eng.com/fr/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1125", "1", "888starz_jfpt", "ffmsuhwedpt@problemno.shop", "https://photalife.com", "89.110.99.186", "2025-12-06 03:03:55", "2025-12-06 08:03:55", "In addition to classic casino games, 888starz features innovative slots and live dealer experiences. \r\n888starz site <a href=\"https://www.cuatromcafes.com\" rel=\"nofollow ugc\">https://cuatromcafes.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1126", "556", "Dustin1266", "Dustin1266@gmail.com", "", "171.80.1.54", "2025-12-06 05:40:34", "2025-12-06 10:40:34", "<a href=\"https://shorturl.fm/RrIAi\" rel=\"nofollow ugc\">https://shorturl.fm/RrIAi</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1127", "556", "Jordyn1627", "Jordyn1627@gmail.com", "", "202.4.125.221", "2025-12-06 08:36:58", "2025-12-06 13:36:58", "<a href=\"https://shorturl.fm/d22XS\" rel=\"nofollow ugc\">https://shorturl.fm/d22XS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1128", "556", "Dana4010", "Dana4010@gmail.com", "", "119.93.83.106", "2025-12-06 16:29:07", "2025-12-06 21:29:07", "<a href=\"https://shorturl.fm/NzC8h\" rel=\"nofollow ugc\">https://shorturl.fm/NzC8h</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1129", "531", "ph978casino", "ph978casino@ph978casino.com", "https://ph978casino.com", "143.58.144.105", "2025-12-07 04:39:36", "2025-12-07 09:39:36", "Smart bankroll management is key with any online gaming, especially when strategy matters – like at places emphasizing skill. Thinking of it as a mental battle, not just luck, is a good approach. Check out <a href=\'https://ph978casino.com\' rel=\"nofollow ugc\">ph978 casino vip</a> for a curated, strategic experience – remember responsible play!", "0", "0", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1130", "556", "Angel2371", "Angel2371@gmail.com", "", "220.170.182.39", "2025-12-07 12:37:26", "2025-12-07 17:37:26", "<a href=\"https://shorturl.fm/Qd6VQ\" rel=\"nofollow ugc\">https://shorturl.fm/Qd6VQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1131", "556", "Dominique2808", "Dominique2808@gmail.com", "", "185.183.105.157", "2025-12-07 15:56:10", "2025-12-07 20:56:10", "<a href=\"https://shorturl.fm/eKHcI\" rel=\"nofollow ugc\">https://shorturl.fm/eKHcI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1132", "1", "Progon_cbSn", "zbxvnccniSn@xrumer-2026.ru", "https://xrumer-2026.ru", "212.34.129.45", "2025-12-08 03:31:19", "2025-12-08 08:31:19", "<a href=\"https://xrumer-2026.ru\" rel=\"nofollow ugc\">профессиональный прогон хрумером</a> \r\nХрумер позволяет существенно сократить время на выполнение рутинных задач, связанных с продвижением.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1133", "556", "Tristan2191", "Tristan2191@gmail.com", "", "161.248.117.190", "2025-12-08 04:10:34", "2025-12-08 09:10:34", "<a href=\"https://shorturl.fm/y9VJz\" rel=\"nofollow ugc\">https://shorturl.fm/y9VJz</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1134", "556", "Aspen3082", "Aspen3082@gmail.com", "", "103.176.96.129", "2025-12-08 14:11:10", "2025-12-08 19:11:10", "<a href=\"https://shorturl.fm/BL0sg\" rel=\"nofollow ugc\">https://shorturl.fm/BL0sg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1135", "556", "Reese2494", "Reese2494@gmail.com", "", "163.61.112.14", "2025-12-08 23:43:50", "2025-12-09 04:43:50", "<a href=\"https://shorturl.fm/0bhwr\" rel=\"nofollow ugc\">https://shorturl.fm/0bhwr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1136", "556", "Oscar1222", "Oscar1222@gmail.com", "", "103.166.159.245", "2025-12-09 07:04:56", "2025-12-09 12:04:56", "<a href=\"https://shorturl.fm/U1rP2\" rel=\"nofollow ugc\">https://shorturl.fm/U1rP2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1137", "1", "xrumer_eloa", "cgkdkmtqnoa@xrumer-exp.ru", "https://xrumer-exp.ru", "212.34.129.45", "2025-12-10 06:36:07", "2025-12-10 11:36:07", "<a href=\"https://xrumer-exp.ru\" rel=\"nofollow ugc\">прогон хрумером</a> поможет значительно повысить видимость вашего сайта в поисковых системах. \r\nНеобходимо учитывать тематику и аудиторию ресурсов, на которых вы собираетесь размещать свои ссылки.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1138", "556", "Heidi4429", "Heidi4429@gmail.com", "", "170.246.183.250", "2025-12-10 19:54:07", "2025-12-11 00:54:07", "<a href=\"https://shorturl.fm/kLaLN\" rel=\"nofollow ugc\">https://shorturl.fm/kLaLN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1139", "1", "Holden2329", "Holden2329@gmail.com", "", "170.246.183.250", "2025-12-10 19:54:22", "2025-12-11 00:54:22", "<a href=\"https://shorturl.fm/yiyFJ\" rel=\"nofollow ugc\">https://shorturl.fm/yiyFJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1140", "556", "Lila1524", "Lila1524@gmail.com", "", "162.240.154.26", "2025-12-10 19:56:25", "2025-12-11 00:56:25", "<a href=\"https://shorturl.fm/rAPZh\" rel=\"nofollow ugc\">https://shorturl.fm/rAPZh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1141", "556", "Ron1902", "Ron1902@gmail.com", "", "121.143.20.143", "2025-12-10 22:36:38", "2025-12-11 03:36:38", "<a href=\"https://shorturl.fm/5IkWi\" rel=\"nofollow ugc\">https://shorturl.fm/5IkWi</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1142", "1", "Cedric321", "Cedric321@gmail.com", "", "121.143.20.143", "2025-12-10 22:36:53", "2025-12-11 03:36:53", "<a href=\"https://shorturl.fm/UT569\" rel=\"nofollow ugc\">https://shorturl.fm/UT569</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1143", "556", "Connie1382", "Connie1382@gmail.com", "", "121.4.22.37", "2025-12-10 23:38:00", "2025-12-11 04:38:00", "<a href=\"https://shorturl.fm/O9erG\" rel=\"nofollow ugc\">https://shorturl.fm/O9erG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1144", "1", "betfinal_apEa", "cwggbiswlEa@ugaritopari.site", "https://animehider.com", "62.113.116.213", "2025-12-11 13:54:55", "2025-12-11 18:54:55", "من المعروف أن بيتاينال هو منصة تقدم خدمات متنوعة من البحرية الرياضية. تتفرد هذه المنصة بتقديم خبرة فريدة لمحبي المراهنات. تُعتبر المراهنات الألعاب من أكثر الخيارات شعبية في السنوات الأخيرة. \r\nفي النهاية، تعتبر بيتاينال خيارًا ممتازًا للمهتمين الذين يبحثون عن مجموعة متنوعة من الخيارات. من خلال هذه المنصة، يمكن لللاعبين الاستمتاع بتجربة فريدة في عالم المراهنات الرياضية وأيضًا الموارد التعليمية المتاح دائمًا. \r\nbetfinal <a href=\"http://animehider.com/\" / rel=\"nofollow ugc\">https://animehider.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1145", "556", "Anika2291", "Anika2291@gmail.com", "", "167.99.76.151", "2025-12-11 17:57:31", "2025-12-11 22:57:31", "<a href=\"https://shorturl.fm/Yez0d\" rel=\"nofollow ugc\">https://shorturl.fm/Yez0d</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1146", "556", "Billy626", "Billy626@gmail.com", "", "62.133.63.236", "2025-12-13 05:40:07", "2025-12-13 10:40:07", "<a href=\"https://shorturl.fm/eAZG2\" rel=\"nofollow ugc\">https://shorturl.fm/eAZG2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1147", "1", "888starz_diOr", "lfuzuglbuOr@ingushetdomaz.pro", "https://888starzuzbets.com", "178.20.42.76", "2025-12-13 10:49:47", "2025-12-13 15:49:47", "Tezkor va samimiy yordam xizmatlari, foydalanuvchilar uchun muhim ahamiyatga ega  \r\n888starz app download apk <a href=\"https://uportshop.com/888starz-oyinlar-va-onlayn-tikish-platformasi-foydalanuvchilar-uchun-qulay-xavfsiz-va-bonuslar-bilan-toldirilgan\" rel=\"nofollow ugc\">https://uportshop.com/888starz-oyinlar-va-onlayn-tikish-platformasi-foydalanuvchilar-uchun-qulay-xavfsiz-va-bonuslar-bilan-toldirilgan/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1148", "1", "888starz_xjoi", "kcesxzphsoi@ugaritopari.site", "https://888starz-casino-egypt.com", "62.113.116.213", "2025-12-13 20:06:39", "2025-12-14 01:06:39", "بشكل عام، تُعد 888starz الخيار الأفضل للمرابطين. يمكنك الوثوق بهذه المنصة لتوفير بيئة آمنة للمراهنة  \r\n \r\nستارز 888 <a href=\"https://www.9newstelugu.com/888-starz-%d9%85%d8%b5%d8%b1-%d8%a7%d9%84%d9%85%d9%88%d9%82%d8%b9-%d8%a7%d9%84%d8%b1%d8%b3%d9%85%d9%8a-%d9%84%d9%84%d9%85%d8%b1%d8%a7%d9%87%d9%86%d8%a7%d8%aa-%d8%a7%d9%84%d8%b1%d9%8a%d8%a7%d8%b6%d9%8a\" rel=\"nofollow ugc\">https://9newstelugu.com/888-starz-%d9%85%d8%b5%d8%b1-%d8%a7%d9%84%d9%85%d9%88%d9%82%d8%b9-%d8%a7%d9%84%d8%b1%d8%b3%d9%85%d9%8a-%d9%84%d9%84%d9%85%d8%b1%d8%a7%d9%87%d9%86%d8%a7%d8%aa-%d8%a7%d9%84%d8%b1%d9%8a%d8%a7%d8%b6%d9%8a/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1149", "556", "Kirk358", "Kirk358@gmail.com", "", "173.44.141.142", "2025-12-14 19:44:45", "2025-12-15 00:44:45", "<a href=\"https://shorturl.fm/HcXwE\" rel=\"nofollow ugc\">https://shorturl.fm/HcXwE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1150", "556", "Aubree2536", "Aubree2536@gmail.com", "", "188.166.222.160", "2025-12-15 01:21:42", "2025-12-15 06:21:42", "<a href=\"https://shorturl.fm/RoZhT\" rel=\"nofollow ugc\">https://shorturl.fm/RoZhT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1151", "551", "Don3054", "Don3054@gmail.com", "", "182.53.28.230", "2025-12-15 07:07:02", "2025-12-15 12:07:02", "<a href=\"https://shorturl.fm/20A0g\" rel=\"nofollow ugc\">https://shorturl.fm/20A0g</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1152", "556", "Sophia456", "Sophia456@gmail.com", "", "122.103.113.173", "2025-12-16 03:41:42", "2025-12-16 08:41:42", "<a href=\"https://shorturl.fm/g34nF\" rel=\"nofollow ugc\">https://shorturl.fm/g34nF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1153", "556", "Preston4537", "Preston4537@gmail.com", "", "47.81.14.7", "2025-12-16 08:09:19", "2025-12-16 13:09:19", "<a href=\"https://shorturl.fm/40V9t\" rel=\"nofollow ugc\">https://shorturl.fm/40V9t</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1154", "556", "Antonio4375", "Antonio4375@gmail.com", "", "78.13.218.250", "2025-12-16 11:25:35", "2025-12-16 16:25:35", "<a href=\"https://shorturl.fm/GlbXN\" rel=\"nofollow ugc\">https://shorturl.fm/GlbXN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1155", "1", "888starz_fjKi", "lhcftaliqKi@ugaritopari.site", "https://888starzegypteg.com", "62.113.116.213", "2025-12-16 14:13:06", "2025-12-16 19:13:06", "تُعد 888starz مصر من المنصات البارزة التي تقدم خدمات متنوعة للاعبين. تحتل هذه المنصة مكانة خاصة في سوق الألعاب. يوفر 888starz تجربة مستخدم رائعة تتناسب مع احتياجات اللاعبين. يوفر للاعبين فرصة الاستمتاع بمختلف الألعاب التي تشمل القمار والألعاب الرياضية. \r\n \r\nالشكل العام للواجهة في 888starz سهل الاستخدام، مما يسهل على اللاعبين التنقل بين الأقسام المختلفة. توفر المنصة خيارات متعددة للإيداع والسحب، مما يجعل التعامل المالي سلسًا وآمنًا. تعمل 888starz على تلبية احتياجات اللاعبين بطرق متعددة. تركز 888starz على تقديم مستوى عالٍ من الأمان والمصداقية. \r\n \r\n888starz <a href=\"http://www.888starzegypteg.com/\" / rel=\"nofollow ugc\">https://888starzegypteg.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1156", "556", "Haven3935", "Haven3935@gmail.com", "", "103.180.126.166", "2025-12-16 21:11:37", "2025-12-17 02:11:37", "<a href=\"https://shorturl.fm/DmMY5\" rel=\"nofollow ugc\">https://shorturl.fm/DmMY5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1157", "556", "Angel87", "Angel87@gmail.com", "", "139.162.82.206", "2025-12-16 23:52:08", "2025-12-17 04:52:08", "<a href=\"https://shorturl.fm/BpCiC\" rel=\"nofollow ugc\">https://shorturl.fm/BpCiC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1158", "1", "Damon4451", "Damon4451@gmail.com", "", "139.162.82.206", "2025-12-16 23:52:25", "2025-12-17 04:52:25", "<a href=\"https://shorturl.fm/Cxwjr\" rel=\"nofollow ugc\">https://shorturl.fm/Cxwjr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1159", "1", "vulkanspie_ltsn", "utmywptilsn@ingushetdomaz.pro", "http://agrogradnjacompany.com/728-2/", "178.20.42.76", "2025-12-17 11:09:08", "2025-12-17 16:09:08", "Warto rowniez pamietac o regulaminie, aby uniknac nieprzyjemnosci.  \r\nvulkanspiele kod promocyjny bez depozytu <a href=\"https://www.agrogradnjacompany.com/728-2\" rel=\"nofollow ugc\">https://agrogradnjacompany.com/728-2/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1160", "556", "v7sbbet", "admin@v7sbbet.com", "https://v7sbbet.com", "156.245.246.131", "2025-12-17 12:38:50", "2025-12-17 17:38:50", "I\'ve been hitting up v7sbbet lately, mainly for their sports betting. Solid selection of bets, and they update the odds really quickly. It\'s gotten me a few wins...give it a try! <a href=\'https://v7sbbet.com\' rel=\"nofollow ugc\">v7sbbet</a>", "0", "0", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1161", "556", "Jamie2639", "Jamie2639@gmail.com", "", "13.229.225.101", "2025-12-18 07:47:52", "2025-12-18 12:47:52", "<a href=\"https://shorturl.fm/w85Th\" rel=\"nofollow ugc\">https://shorturl.fm/w85Th</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1162", "556", "Pamela2750", "Pamela2750@gmail.com", "", "103.175.202.190", "2025-12-18 14:13:25", "2025-12-18 19:13:25", "<a href=\"https://shorturl.fm/X2DfX\" rel=\"nofollow ugc\">https://shorturl.fm/X2DfX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1163", "1", "Karl2816", "Karl2816@gmail.com", "", "103.175.202.190", "2025-12-18 14:13:41", "2025-12-18 19:13:41", "<a href=\"https://shorturl.fm/ZpnjK\" rel=\"nofollow ugc\">https://shorturl.fm/ZpnjK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1164", "556", "Anika2105", "Anika2105@gmail.com", "", "179.43.117.214", "2025-12-18 15:09:19", "2025-12-18 20:09:19", "<a href=\"https://shorturl.fm/RtROc\" rel=\"nofollow ugc\">https://shorturl.fm/RtROc</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1165", "551", "Bobby3729", "Bobby3729@gmail.com", "", "139.177.229.250", "2025-12-19 09:36:18", "2025-12-19 14:36:18", "<a href=\"https://shorturl.fm/SbLpy\" rel=\"nofollow ugc\">https://shorturl.fm/SbLpy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1166", "556", "Harmony4031", "Harmony4031@gmail.com", "", "139.177.229.113", "2025-12-19 10:22:08", "2025-12-19 15:22:08", "<a href=\"https://shorturl.fm/CCAMC\" rel=\"nofollow ugc\">https://shorturl.fm/CCAMC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1167", "1", "1win_toMt", "obbdmwaouMt@ingushetdomaz.pro", "https://1win-download.org.in/", "62.113.116.213", "2025-12-19 12:26:04", "2025-12-19 17:26:04", "The 1win app has become increasingly popular among users. A diverse set of features is available through this app. The app\'s interface has been noted for its ease of use. \r\n \r\nUsers can easily navigate through the different sections. This simplicity contributes to a better overall experience. The developers frequently update the app to provide new features and improvements. \r\n \r\none win app download apk <a href=\"https://heartkrafted.com/download-1win-application-apk-android-ios-setup/\" / rel=\"nofollow ugc\">one win app download apk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1168", "556", "Briana1311", "Briana1311@gmail.com", "", "139.177.229.165", "2025-12-19 19:41:08", "2025-12-20 00:41:08", "<a href=\"https://shorturl.fm/YGvla\" rel=\"nofollow ugc\">https://shorturl.fm/YGvla</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1169", "556", "Norma138", "Norma138@gmail.com", "", "139.177.229.158", "2025-12-20 07:09:28", "2025-12-20 12:09:28", "<a href=\"https://shorturl.fm/em5Hy\" rel=\"nofollow ugc\">https://shorturl.fm/em5Hy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1170", "556", "Hugh1490", "Hugh1490@gmail.com", "", "139.177.229.20", "2025-12-20 09:59:37", "2025-12-20 14:59:37", "<a href=\"https://shorturl.fm/DcViI\" rel=\"nofollow ugc\">https://shorturl.fm/DcViI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1171", "556", "Carolyn3517", "Carolyn3517@gmail.com", "", "139.177.229.46", "2025-12-20 15:49:13", "2025-12-20 20:49:13", "<a href=\"https://shorturl.fm/PBeOV\" rel=\"nofollow ugc\">https://shorturl.fm/PBeOV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1172", "556", "Conner2321", "Conner2321@gmail.com", "", "139.177.229.10", "2025-12-20 17:13:58", "2025-12-20 22:13:58", "<a href=\"https://shorturl.fm/rRBHj\" rel=\"nofollow ugc\">https://shorturl.fm/rRBHj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1173", "556", "Dawn3897", "Dawn3897@gmail.com", "", "139.177.229.216", "2025-12-20 23:18:37", "2025-12-21 04:18:37", "<a href=\"https://shorturl.fm/QXSzK\" rel=\"nofollow ugc\">https://shorturl.fm/QXSzK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1174", "556", "Anaya2576", "Anaya2576@gmail.com", "", "139.177.229.237", "2025-12-21 13:54:43", "2025-12-21 18:54:43", "<a href=\"https://shorturl.fm/uwJhg\" rel=\"nofollow ugc\">https://shorturl.fm/uwJhg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1175", "556", "Cayden244", "Cayden244@gmail.com", "", "139.177.229.234", "2025-12-22 06:48:07", "2025-12-22 11:48:07", "<a href=\"https://shorturl.fm/aPQNd\" rel=\"nofollow ugc\">https://shorturl.fm/aPQNd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1176", "556", "Eleanor3245", "Eleanor3245@gmail.com", "", "103.130.241.237", "2025-12-22 13:53:08", "2025-12-22 18:53:08", "<a href=\"https://shorturl.fm/AYfLR\" rel=\"nofollow ugc\">https://shorturl.fm/AYfLR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1177", "1", "888starz_rwMr", "dhkthhhszMr@ingushetdomaz.pro", "https://888starz-bettings.com/", "62.113.116.213", "2025-12-22 19:19:17", "2025-12-23 00:19:17", "Players can rely on the platform\'s secure payment methods for safe transactions. \r\n888star <a href=\"http://www.tarikhravai.ir/888starz-betting-sri-lanka-2025-official-website-casino-and-bet-on-sports/\" / rel=\"nofollow ugc\">https://tarikhravai.ir/888starz-betting-sri-lanka-2025-official-website-casino-and-bet-on-sports/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1178", "556", "Ellis939", "Ellis939@gmail.com", "", "139.177.229.22", "2025-12-22 22:26:09", "2025-12-23 03:26:09", "<a href=\"https://shorturl.fm/3lUmT\" rel=\"nofollow ugc\">https://shorturl.fm/3lUmT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1179", "556", "Lyla4703", "Lyla4703@gmail.com", "", "139.177.229.233", "2025-12-23 01:09:45", "2025-12-23 06:09:45", "<a href=\"https://shorturl.fm/B1ZuB\" rel=\"nofollow ugc\">https://shorturl.fm/B1ZuB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1180", "556", "Brady4723", "Brady4723@gmail.com", "", "38.181.76.217", "2025-12-23 03:03:26", "2025-12-23 08:03:26", "<a href=\"https://shorturl.fm/S9SVk\" rel=\"nofollow ugc\">https://shorturl.fm/S9SVk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1181", "1", "Avtoservis_lmSt", "zmobtjgfpSt@lvdskjn.store", "https://servis-toyota-moskva.ru/remont-toyota-v-moskve/", "45.11.20.111", "2025-12-23 13:06:25", "2025-12-23 18:06:25", "Если вы ищете надежный автосервис для вашей Тойота в Москве, вам повезло. Профессионалы помогут вам с ремонтом и техническим обслуживанием. \r\nЕсли вам нужен качественный и надежный <a href=\"https://servis-toyota-moskva.ru/remont-toyota-v-moskve/\" / rel=\"nofollow ugc\"> автосервис Toyota</a>, мы предлагаем широкий спектр услуг для вашего автомобиля. \r\nДля Тойота необходим высокий уровень квалификации. Каждый механик проходит специальное обучение и сертификацию. \r\nВ нашем сервисе используются современные технологии и оборудование. Благодаря этому, мы можем гарантировать качество выполняемых работ. \r\nОбращаясь в автосервис Тойота, вы можете рассчитывать на высокое качество услуг. Наши клиенты всегда остаются довольны результатом работ.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1182", "1", "888starz_lupr", "vxzcuqkjxpr@ingushetdomaz.pro", "https://888starz-casino-egypt.com/", "178.20.42.76", "2025-12-23 13:26:17", "2025-12-23 18:26:17", "تقدم خيارات متعددة للمراهنات. يتيح للمستخدمين والمسابقات الرياضية. والربح. \r\n \r\nبواجهة مستخدم سهلة الاستخدام. محتوى متجدد بشكل دوري. والرهانات الرياضية. \r\n \r\n888starz app <a href=\"https://apexglobalinternational.com/%d8%aa%d9%86%d8%b2%d9%8a%d9%84-888starz-%d9%81%d9%8a-%d9%85%d8%b5%d8%b1-%d8%aa%d8%b7%d8%a8%d9%8a%d9%82-android-apk-%d9%88%d8%aa%d8%ab%d8%a8%d9%8a%d8%aa-ios-%d9%85%d8%b9-%d8%af%d9%84%d9%8a/\" / rel=\"nofollow ugc\">https://apexglobalinternational.com/%d8%aa%d9%86%d8%b2%d9%8a%d9%84-888starz-%d9%81%d9%8a-%d9%85%d8%b5%d8%b1-%d8%aa%d8%b7%d8%a8%d9%8a%d9%82-android-apk-%d9%88%d8%aa%d8%ab%d8%a8%d9%8a%d8%aa-ios-%d9%85%d8%b9-%d8%af%d9%84%d9%8a/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1183", "556", "Kane1579", "Kane1579@gmail.com", "", "71.199.202.233", "2025-12-23 20:14:27", "2025-12-24 01:14:27", "<a href=\"https://shorturl.fm/2GyjN\" rel=\"nofollow ugc\">https://shorturl.fm/2GyjN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1184", "531", "Alec3618", "Alec3618@gmail.com", "", "71.199.202.233", "2025-12-23 20:14:43", "2025-12-24 01:14:43", "<a href=\"https://shorturl.fm/xkoTt\" rel=\"nofollow ugc\">https://shorturl.fm/xkoTt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1185", "556", "Walter139", "Walter139@gmail.com", "", "140.238.184.182", "2025-12-24 01:28:51", "2025-12-24 06:28:51", "<a href=\"https://shorturl.fm/DOorg\" rel=\"nofollow ugc\">https://shorturl.fm/DOorg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1186", "1", "Luca1969", "Luca1969@gmail.com", "", "113.192.12.95", "2025-12-24 13:48:40", "2025-12-24 18:48:40", "<a href=\"https://shorturl.fm/wMQAQ\" rel=\"nofollow ugc\">https://shorturl.fm/wMQAQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1187", "1", "yuridiches_seKi", "lvaqbajrrKi@yuridicheskaya-konsultaciya34.ru", "https://yuridicheskaya-konsultaciya34.ru", "212.34.129.45", "2025-12-24 14:42:45", "2025-12-24 19:42:45", "Получите <a href=\"https://yuridicheskaya-konsultaciya34.ru\" rel=\"nofollow ugc\">онлайн консультацию юриста</a>, которая поможет решить ваши вопросы быстро и эффективно. \r\nВ современном мире юридические консультации стали крайне важными. Каждый из нас может столкнуться с правовыми трудностями. Поэтому важно иметь возможность обратиться за профессиональной помощью. \r\n \r\nУслуги юридической консультации включают в себя множество аспектов. К ним относятся семейные, жилищные, трудовые споры и многие другие. Каждая ситуация уникальна и требует квалифицированного вмешательства. \r\n \r\nКроме того, опытные юристы помогут найти выход из любых сложностей. Знание законодательства позволяет им находить наиболее выгодные варианты. Важно понимать, что грамотная юридическая помощь может стать решающим фактором. \r\n \r\nНахождение надежной юридической компании играет ключевую роль. Изучение отзывов и репутации фирмы поможет сделать правильный выбор. Иногда стоит потратить время на исследование, чтобы избежать ошибки в выборе.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1188", "1", "888starz_mePt", "yicwcjzlmPt@igurant1.online", "https://888starzuzbets.com/", "88.210.35.166", "2025-12-25 01:18:55", "2025-12-25 06:18:55", "888starz UZ bozorida barqaror ishlaydigan kazino hisoblanadi \r\n \r\nstarz 888 <a href=\"http://www.indiancrafts79.com/xavfsizlik-mobil-ilova-va-bonuslarni-tadbiq-etish-orqali-888starz-oyin-tajribangizni-yaxshilang\" rel=\"nofollow ugc\">https://indiancrafts79.com/xavfsizlik-mobil-ilova-va-bonuslarni-tadbiq-etish-orqali-888starz-oyin-tajribangizni-yaxshilang/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1189", "556", "Jamal1332", "Jamal1332@gmail.com", "", "36.138.125.105", "2025-12-25 20:54:28", "2025-12-26 01:54:28", "<a href=\"https://shorturl.fm/QLp3d\" rel=\"nofollow ugc\">https://shorturl.fm/QLp3d</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1190", "1", "melbet_nnpn", "vtbroyknkpn@ingushetdomaz.pro", "https://elenagatilova.ru", "62.113.116.213", "2025-12-25 23:00:10", "2025-12-26 04:00:10", "Для того, чтобы начать использовать приложение <a href=\"https://elenagatilova.ru\" rel=\"nofollow ugc\">melbet скачать казино</a>, необходимо скачать приложение на свой смартфон. \r\n является известной платформой для ставок на спорт и другие события . Это позволяет пользователям выбирать из огромного количества вариантов, соответствующих их интересам и предпочтениям. Melbet  создал простой и понятный веб-сайт для всех желающих сделать ставку. Кроме того, Melbet  гарантирует безопасность и анонимность всех транзакций . \r\n \r\nmelbet ru <a href=\"http://www.elenagatilova.ru\" rel=\"nofollow ugc\">https://elenagatilova.ru/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1191", "1", "melbet_bcEt", "inyhzhnjhEt@ingushetdomaz.pro", "https://melbetcomzerkalo.ru", "178.20.42.76", "2025-12-25 23:00:11", "2025-12-26 04:00:11", "Для доступа к услугам букмекерской конторы или казино <a href=\"https://melbetcomzerkalo.ru\" rel=\"nofollow ugc\">мелбет казино</a> можно воспользоваться официальным зеркалом, которое предлагает доступ к ставкам на спорт и широкому спектру казино-игр. \r\nочень популярная онлайн-платформа для ставок . Melbet предлагает разнообразные виды ставок на спорт и киберспорт . Благодаря  функциональному дизайну и интуитивно понятному меню , даже новые пользователи могут легко ориентироваться на сайте . \r\ncasino online bet <a href=\"https://www.melbetcomzerkalo.ru\" rel=\"nofollow ugc\">https://melbetcomzerkalo.ru/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1192", "556", "Carmen3840", "Carmen3840@gmail.com", "", "143.92.142.96", "2025-12-26 05:16:06", "2025-12-26 10:16:06", "<a href=\"https://shorturl.fm/LgRak\" rel=\"nofollow ugc\">https://shorturl.fm/LgRak</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1193", "556", "Adelyn4948", "Adelyn4948@gmail.com", "", "103.122.67.165", "2025-12-26 14:40:50", "2025-12-26 19:40:50", "<a href=\"https://shorturl.fm/vynL7\" rel=\"nofollow ugc\">https://shorturl.fm/vynL7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1194", "556", "Martha396", "Martha396@gmail.com", "", "111.6.239.81", "2025-12-27 07:46:28", "2025-12-27 12:46:28", "<a href=\"https://shorturl.fm/mhIRa\" rel=\"nofollow ugc\">https://shorturl.fm/mhIRa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1195", "1", "Alma3051", "Alma3051@gmail.com", "", "111.6.172.36", "2025-12-27 16:50:12", "2025-12-27 21:50:12", "<a href=\"https://shorturl.fm/patCd\" rel=\"nofollow ugc\">https://shorturl.fm/patCd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1196", "1", "doverennos_yesa", "gmhqfynybsa@konsultaciya-yurista-msk01.store", "https://vc.ru/opinions/2279340-doverennost-na-predstavlenie-interesov-fizicheskogo-litsa", "212.34.129.45", "2025-12-28 00:01:23", "2025-12-28 05:01:23", "Для оформления <a href=\"https://vc.ru/opinions/2279340-doverennost-na-predstavlenie-interesov-fizicheskogo-litsa\" rel=\"nofollow ugc\">доверенности на представление интересов физического лица</a> необходимо внимательно изучить все нюансы и детали, связанные с этим процессом, включая выбор вида доверенности, которая может быть нотариальной или простой, и определение полномочий, которые будут предоставлены представителю. \r\n Доверенность на представление интересов - это документ, который дает право одному лицу представлять интересы другого.  Это означает, что лицо, получившее доверенность, может совершать различные юридические действия, такие как заключение контрактов, открытие банковских счетов и т.д.  Доверенность может быть выдана как физическому, так и юридическому лицу.  Доверенность должна быть оформлена в соответствии с действующим законодательством. \r\n \r\n Процесс получения доверенности включает в себя несколько шагов.  Первый шаг - это определение цели доверенности и определение лиц, участвующих в этом процессе.  Доверенность может быть либо генеральной, либо специальной.  Генеральная доверенность дает право на широкий спектр действий, а специальная доверенность ограничивает действия конкретными полномочиями. \r\n \r\n## Раздел 2: Виды доверенностей \r\n Видов доверенностей несколько, и каждая имеет свои характеристики.  Основные виды доверенностей - это генеральная и специальная доверенность. Генеральная доверенность дает право на совершение любых действий от имени доверителя.  Специальная доверенность, наоборот, ограничивает полномочия конкретными действиями, указанными в доверенности. \r\n \r\nКаждый вид доверенности имеет свои преимущества и недостатки.  Генеральная доверенность удобна тем, что позволяет быстро и эффективно решать различные вопросы, не требуя дополнительных согласований.  Однако, такая доверенность также может нести риски, связанные с возможными злоупотреблениями со стороны доверенного лица. Специальная доверенность, хотя и ограничивает действия, обеспечивает большую безопасность и контроль над действиями доверенного лица. \r\n \r\n## Раздел 3: Процесс оформления доверенности \r\n Оформление доверенности требует выполнения определенных действий.  Первый шаг - это определение цели доверенности и составление списка полномочий, которые будут предоставлены доверенному лицу.  Заключение доверенности оформляется путем подписания документа. Доверенность должна быть подписана как доверителем, так и доверенным лицом. В некоторых случаях может быть??ана нотариальное удостоверение.  Нотариальное удостоверение добавляет доверенности дополнительную юридическую силу и признает ее действительность. \r\n \r\n## Раздел 4: Правила использования доверенности \r\nИспользование доверенности регулируется определенным набором правил.  Доверенное лицо должно действовать в интересах доверителя и использовать предоставленные полномочия только для целей, указанных в доверенности. Срок действия доверенности также является важным аспектом.  Доверенность может быть выдана на определенный срок или на неопределенный период. По истечении срока действия доверенность?ает свою силу.  В случае если доверенность выдана на неопределенный период, она может быть отменена доверителем в любое время.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1197", "556", "Penelope4719", "Penelope4719@gmail.com", "", "103.242.105.204", "2025-12-28 12:47:41", "2025-12-28 17:47:41", "<a href=\"https://shorturl.fm/UQUGl\" rel=\"nofollow ugc\">https://shorturl.fm/UQUGl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1198", "1", "888starz_qpsa", "bornzcmplsa@ingushetdomaz.pro", "https://888starz-bettings.com/", "62.113.116.213", "2025-12-28 15:05:28", "2025-12-28 20:05:28", "The 888starz platform has been gaining popularity among online gamers and sports bettors . The platform provides an extensive selection of games and betting options, catering to different tastes and preferences.  888starz offers an impressive collection of games, ensuring that users never run out of options. Furthermore, the platform is designed to be accessible and easy to navigate, making it a great choice for both beginners and experienced players. \r\n These bonuses and promotions can help users increase their chances of winning and make their gaming experience even more enjoyable. In addition to its games and bonuses, 888starz also prioritizes user safety and security . The platform uses state-of-the-art technology to ensure that all transactions and user data are protected. \r\n \r\n888starz зеркало <a href=\"https://bloggerok.bloggersdelight.dk/2025/08/24/%d0%ba%d0%b0%d0%ba-%d1%81%d0%b4%d0%b5%d0%bb%d0%b0%d1%82%d1%8c-%d0%bf%d0%b5%d1%80%d0%b2%d1%83%d1%8e-%d1%81%d1%82%d0%b0%d0%b2%d0%ba%d1%83-%d0%bd%d0%b0-%d1%84%d1%83%d1%82%d0%b1%d0%be%d0%bb-%d0%b2-888star\" rel=\"nofollow ugc\">https://bloggerok.bloggersdelight.dk/2025/08/24/%d0%ba%d0%b0%d0%ba-%d1%81%d0%b4%d0%b5%d0%bb%d0%b0%d1%82%d1%8c-%d0%bf%d0%b5%d1%80%d0%b2%d1%83%d1%8e-%d1%81%d1%82%d0%b0%d0%b2%d0%ba%d1%83-%d0%bd%d0%b0-%d1%84%d1%83%d1%82%d0%b1%d0%be%d0%bb-%d0%b2-888star/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1199", "1", "betfinal_dkmn", "kezgzftijmn@ingushetdomaz.pro", "https://kulaistechnopower.com/", "178.20.42.76", "2025-12-28 15:44:48", "2025-12-28 20:44:48", "هناك الكثير من الناس يلعبون عليها اليوم، لأنها توفر لهم الكثير من الخيارات، حيث يمكنهم اللعب دون أي قلق. betfinal تعتبر منصة رياضية متطورة للغاية \r\nتعتبر منصة رياضية متطورة للغاية، حيث يمكن لللاعبين اللعب بكل يسر، حيث يتم توفير جميع الخدمات اللازمة لهم. \r\nتعتبر هذه المنصة منصة رياضية مرنة جدًا، حيث يمكن لللاعبين اللعب بكل راحة، حيث يتم توفير جميع الأدوات اللازمة لهم. \r\n \r\n \r\nbetfinal saudi arabia <a href=\"https://www.kulaistechnopower.com\" rel=\"nofollow ugc\">https://kulaistechnopower.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1200", "556", "Johnny653", "Johnny653@gmail.com", "", "113.59.41.169", "2025-12-29 08:33:50", "2025-12-29 13:33:50", "<a href=\"https://shorturl.fm/ZjnDa\" rel=\"nofollow ugc\">https://shorturl.fm/ZjnDa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1201", "556", "Atticus3510", "Atticus3510@gmail.com", "", "110.42.197.225", "2025-12-29 08:46:43", "2025-12-29 13:46:43", "<a href=\"https://shorturl.fm/E3p7a\" rel=\"nofollow ugc\">https://shorturl.fm/E3p7a</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1202", "1", "Aspen3633", "Aspen3633@gmail.com", "", "110.42.197.225", "2025-12-29 08:47:00", "2025-12-29 13:47:00", "<a href=\"https://shorturl.fm/xlAyr\" rel=\"nofollow ugc\">https://shorturl.fm/xlAyr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1203", "556", "Marie4975", "Marie4975@gmail.com", "", "52.80.11.51", "2025-12-29 10:06:07", "2025-12-29 15:06:07", "<a href=\"https://shorturl.fm/AcxG4\" rel=\"nofollow ugc\">https://shorturl.fm/AcxG4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1204", "556", "Coraline984", "Coraline984@gmail.com", "", "167.179.119.220", "2025-12-30 17:46:59", "2025-12-30 22:46:59", "<a href=\"https://shorturl.fm/wHAJY\" rel=\"nofollow ugc\">https://shorturl.fm/wHAJY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1205", "1", "besplatnay_zbKt", "xyrqlbivdKt@konsultaciya-yurista42.ru", "https://konsultaciya-yurista42.ru", "212.34.129.45", "2025-12-31 12:11:56", "2025-12-31 17:11:56", "В случае если вам необходима помощь в решении юридических вопросов, вы можете воспользоваться услугой <a href=\"https://konsultaciya-yurista42.ru\" rel=\"nofollow ugc\">бесплатные юр консультации</a> для решения ваших конкретных проблем. \r\n является первым шагом к решению юридических проблем. Это особенно важно  когда возникает потребность в понимании юридических аспектов той или иной ситуации. Кроме того,  она позволяет оценить уровень экспертизы юриста . \r\nБесплатная консультация юриста способствует повышению доверия между клиентом и юридической компанией . Это крайне важно  поскольку она дает возможность клиенту оценить все \"за\" и \"против\". Кроме того,  она демонстрирует готовность юриста помочь и понять клиента . \r\n \r\n## Раздел 2: Преимущества бесплатной консультации юриста \r\nПреимущества бесплатной консультации юриста  включают в себя возможность получить профессиональную оценку ситуации . Это очень важно  поскольку она дает клиенту возможность понять, какие последствия могут иметь его действия. Бесплатная консультация юриста дает возможность клиенту оценить опыт и квалификацию юриста . \r\nКроме того,  дает клиенту представление о том, как будет работать юридическая команда. Бесплатная консультация юриста способствует повышению доверия между клиентом и юридической компанией . \r\n \r\n## Раздел 3: Как проходит бесплатная консультация юриста \r\nБесплатная консультация юриста  позволяет клиенту чувствовать себя спокойно и уверенно . Это крайне важно потому что позволяет клиенту получить максимально полную информацию . Бесплатная консультация юриста должна быть индивидуализированной и адаптированной к конкретным потребностям клиента . \r\nКроме того,  может включать в себя анализ документов и других материалов . Бесплатная консультация юриста  должна быть основана на понимании и уважении интересов клиента. \r\n \r\n## Раздел 4: Заключение \r\nВ заключение,  позволяет клиенту получить необходимую информацию и поддержку . Это крайне важно  дает возможность клиенту получить четкое представление о его правах и обязанностях . Бесплатная консультация юриста  должна быть основана на принципах конфиденциальности и профессионализма. \r\nКроме того,  она позволяет клиенту оценить уровень экспертизы юриста . Бесплатная консультация юриста  дает клиенту чувство безопасности и уверенности в принятии правильного решения.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1206", "1", "888starz_daMa", "synncdvvjMa@ingushetdomaz.pro", "https://888starz2.ru/", "62.113.116.213", "2025-12-31 15:31:42", "2025-12-31 20:31:42", "Основная цель 888starz - предоставить игрокам максимально комфортный опыт , что достигается за счет тщательного подбора игровых вариантов.  888starz работает в соответствии с международными стандартами , что дает гарантию безопасности и честности игрового процесса. \r\n 888starz уделяет большое внимание безопасности и честности игрового процесса , что гарантирует сохранность личной информации и средств игроков.  888starz имеет лицензию на осуществление деятельности , что обеспечивает честность и прозрачность игр. \r\n \r\n Алгоритмы платформы основаны на случайном генераторе чисел , что гарантирует честность и справедливость игрового процесса.  Платформа обеспечивает максимальную безопасность и комфорт для игроков , что делает игру на 888starz максимально безопасной и приятной. \r\n \r\n Игроки могут выбрать из различных категорий игр , что делает ее особенно привлекательной для пользователей.  Платформа предлагает различные бонусы и акции , что увеличивает шансы на выигрыш и делает игровой процесс более приятным. \r\n \r\n888starz официальный сайт <a href=\"https://www.888starz2.ru/\" / rel=\"nofollow ugc\">https://888starz2.ru/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1207", "1", "888starz_bkei", "wnnzujvtsei@ingushetdomaz.pro", "https://shop.uzo1.com/skachayte-888starz-na-iphone-i-nachnite-igrat-v-onlaynkazino-v-uzbekistane/", "178.20.42.76", "2025-12-31 16:15:30", "2025-12-31 21:15:30", "The 888starz app is a popular choice for online gaming enthusiasts, offering a wide range of games and sports betting options, including slots, poker, and live sports .  The 888starz app can be found by searching for \"888starz\" in the App Store search bar, and then clicking on the \"Get\" button to initiate the download . Once the app is installed, users can create an account or log in to an existing one, and start exploring the various games and betting options available . \r\n \r\n The app\'s games are developed by top providers, ensuring high-quality graphics and sound effects .  The 888starz app is also available in multiple languages, making it accessible to users from different countries and regions. The 888starz app is a great choice for users who want to enjoy online gaming on-the-go, with its convenient and user-friendly interface . \r\n \r\n888 stars <a href=\"https://www.car.digitalsafar.pk/stmt-blb-fy-str-888-lkzynw-llktrwny-mn-khll-lntrnt-fy-msr/\" / rel=\"nofollow ugc\">https://car.digitalsafar.pk/stmt-blb-fy-str-888-lkzynw-llktrwny-mn-khll-lntrnt-fy-msr/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1208", "556", "Isaiah1131", "Isaiah1131@gmail.com", "", "223.206.57.96", "2025-12-31 16:20:29", "2025-12-31 21:20:29", "<a href=\"https://shorturl.fm/pkPHa\" rel=\"nofollow ugc\">https://shorturl.fm/pkPHa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1209", "1", "kak_cvEt", "uwtxybzrjEt@lvdskjn.store", "https://ne-popadis.org/", "46.8.14.213", "2025-12-31 19:38:56", "2026-01-01 00:38:56", "Как не попасться на мошенников <a href=\"http://www.ne-popadis.org\" rel=\"nofollow ugc\">https://ne-popadis.org/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1210", "1", "888starz_ypEr", "xtctqftogEr@igurant1.online", "https://indianhandicraftitems.com/888starz-oyin-platformasi-va-onlayn-tikish-xizmatidir-foydalanuvchilar-uchun-qulaylik-xavfsizlik-va-bonuslar-haqida/", "88.210.35.166", "2026-01-01 02:51:15", "2026-01-01 07:51:15", "888starz is a popular online gaming platform that offers a wide range of games and entertainment options for players . The platform  offers a variety of payment options and fast withdrawal processes .  players can enjoy a range of games, from classic slots to live dealer games. \r\n \r\nPlayers can access 888starz from anywhere in the world, using their desktop or mobile devices . The platform  provides a helpful FAQ section and 24/7 customer support.  \r\n \r\nhttps://openstudio.site/?document_srl=2720237 <a href=\"http://www.indianhandicraftitems.com/888starz-oyin-platformasi-va-onlayn-tikish-xizmatidir-foydalanuvchilar-uchun-qulaylik-xavfsizlik-va-bonuslar-haqida\" rel=\"nofollow ugc\">https://indianhandicraftitems.com/888starz-oyin-platformasi-va-onlayn-tikish-xizmatidir-foydalanuvchilar-uchun-qulaylik-xavfsizlik-va-bonuslar-haqida/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1211", "556", "Lee3530", "Lee3530@gmail.com", "", "37.58.48.214", "2026-01-01 06:05:54", "2026-01-01 11:05:54", "<a href=\"https://shorturl.fm/oty0O\" rel=\"nofollow ugc\">https://shorturl.fm/oty0O</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1212", "531", "Travis4938", "Travis4938@gmail.com", "", "197.164.101.14", "2026-01-01 12:57:24", "2026-01-01 17:57:24", "<a href=\"https://shorturl.fm/PlG6d\" rel=\"nofollow ugc\">https://shorturl.fm/PlG6d</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1213", "556", "Henry3020", "Henry3020@gmail.com", "", "43.167.212.67", "2026-01-02 05:05:58", "2026-01-02 10:05:58", "<a href=\"https://shorturl.fm/927qM\" rel=\"nofollow ugc\">https://shorturl.fm/927qM</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1214", "556", "Shelby4847", "Shelby4847@gmail.com", "", "43.133.166.229", "2026-01-02 06:22:25", "2026-01-02 11:22:25", "<a href=\"https://shorturl.fm/dMF99\" rel=\"nofollow ugc\">https://shorturl.fm/dMF99</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1215", "556", "Kiera4074", "Kiera4074@gmail.com", "", "43.167.177.45", "2026-01-02 13:26:50", "2026-01-02 18:26:50", "<a href=\"https://shorturl.fm/SGpNO\" rel=\"nofollow ugc\">https://shorturl.fm/SGpNO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1216", "556", "Caroline4487", "Caroline4487@gmail.com", "", "45.126.125.211", "2026-01-03 08:56:10", "2026-01-03 13:56:10", "<a href=\"https://shorturl.fm/MkHoW\" rel=\"nofollow ugc\">https://shorturl.fm/MkHoW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1217", "1", "Jaden4873", "Jaden4873@gmail.com", "", "45.126.125.211", "2026-01-03 08:56:25", "2026-01-03 13:56:25", "<a href=\"https://shorturl.fm/euU2a\" rel=\"nofollow ugc\">https://shorturl.fm/euU2a</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1218", "556", "Dorothy4413", "Dorothy4413@gmail.com", "", "43.153.151.64", "2026-01-03 19:56:07", "2026-01-04 00:56:07", "<a href=\"https://shorturl.fm/hngQJ\" rel=\"nofollow ugc\">https://shorturl.fm/hngQJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1219", "556", "Diego3289", "Diego3289@gmail.com", "", "13.114.63.20", "2026-01-04 04:44:55", "2026-01-04 09:44:55", "<a href=\"https://shorturl.fm/2QAqh\" rel=\"nofollow ugc\">https://shorturl.fm/2QAqh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1220", "1", "yurist_qcOi", "ahouojhtlOi@konsultaciya-yurista3.ru", "https://konsultaciya-yurista3.ru", "212.34.129.45", "2026-01-04 11:57:14", "2026-01-04 16:57:14", "Если вам нужна <a href=\"https://konsultaciya-yurista3.ru\" rel=\"nofollow ugc\">юридические услуги для бизнеса</a>, то не нужно тратить время на долгие поиски нужной информации – все, что вам нужно, доступно быстро и легко. \r\n предлагает возможность получить профессиональную помощь без финансовых затрат . Это особенно важно  когда люди сталкиваются с необходимостью защиты своих прав и интересов. Бесплатная юридическая консультация  дает возможность людям получить необходимую информацию и поддержку в сложных юридических ситуациях. \r\n \r\nБесплатная юридическая консультация предоставляется высококвалифицированными специалистами, которые имеют глубокое понимание юридических вопросов . Это  позволяет людям своевременно выявить и решить потенциальные юридические проблемы . Кроме того, бесплатная юридическая консультация может включать в себя не только консультации, но и представление интересов в суде и участие в других юридических процедурах . \r\n \r\n## Раздел 2: Преимущества бесплатной юридической консультации \r\nБесплатная юридическая консультация  помогает людям ориентироваться в сложной системе правовых норм и процедур . Это особенно важно для людей, которые не имеют опыта в юридических вопросах и не знают, как правильно действовать в сложных ситуациях . Бесплатная юридическая консультация включает в себя анализ конкретных ситуаций и предоставление индивидуальных рекомендаций . \r\n \r\nБесплатная юридическая консультация  имеет важное значение для предотвращения эскалации конфликтов и разрешения споров на ранней стадии. Это значительно упрощает процесс получения юридической помощи для людей, которые не имеют опыта в юридических вопросах . Кроме того, бесплатная юридическая консультация  включает в себя предоставление необходимой информации и поддержки в сложных юридических ситуациях . \r\n \r\n## Раздел 3: Организации, предоставляющие бесплатную юридическую консультацию \r\nБесплатная юридическая консультация может быть оказана различными организациями, включая общественные центры, юридические клиники и государственные учреждения . Это особенно важно для людей, которые не имеют опыта в юридических вопросах и не знают, как правильно действовать в сложных ситуациях . Бесплатная юридическая консультация предоставляется высококвалифицированными специалистами, которые имеют глубокое понимание юридических вопросов . \r\n \r\nБесплатная юридическая консультация  может включать в себя не только консультации, но и представление интересов в суде и участие в других юридических процедурах . Это значительно упрощает процесс получения юридической помощи для людей, которые не имеют опыта в юридических вопросах . Кроме того, бесплатная юридическая консультация  дает возможность людям получить необходимую помощь и поддержку в решении их юридических проблем. \r\n \r\n## Раздел 4: Заключение \r\nБесплатная юридическая консультация  играет ключевую роль в обеспечении доступа к правосудию для всех слоев населения. Это особенно важно  когда люди сталкиваются с необходимостью защиты своих прав и интересов. Бесплатная юридическая консультация  дает возможность людям получить необходимую информацию и поддержку в сложных юридических ситуациях. \r\n \r\nБесплатная юридическая консультация предоставляется высококвалифицированными специалистами, которые имеют глубокое понимание юридических вопросов . Это  позволяет людям своевременно выявить и решить потенциальные юридические проблемы . Кроме того, бесплатная юридическая консультация  имеет важное значение для предотвращения эскалации конфликтов и разрешения споров на ранней стадии .", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1221", "556", "Sharon4059", "Sharon4059@gmail.com", "", "103.51.205.108", "2026-01-04 13:09:22", "2026-01-04 18:09:22", "<a href=\"https://shorturl.fm/Ok2rS\" rel=\"nofollow ugc\">https://shorturl.fm/Ok2rS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1222", "556", "Rosemary1439", "Rosemary1439@gmail.com", "", "125.230.212.24", "2026-01-04 17:32:13", "2026-01-04 22:32:13", "<a href=\"https://shorturl.fm/2ygEl\" rel=\"nofollow ugc\">https://shorturl.fm/2ygEl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1223", "556", "Colleen4232", "Colleen4232@gmail.com", "", "223.113.134.102", "2026-01-04 21:32:58", "2026-01-05 02:32:58", "<a href=\"https://shorturl.fm/yPTlG\" rel=\"nofollow ugc\">https://shorturl.fm/yPTlG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1224", "1", "Kourtney3287", "Kourtney3287@gmail.com", "", "223.113.134.102", "2026-01-04 21:33:22", "2026-01-05 02:33:22", "<a href=\"https://shorturl.fm/lS20X\" rel=\"nofollow ugc\">https://shorturl.fm/lS20X</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1225", "551", "Lola1120", "Lola1120@gmail.com", "", "103.58.75.222", "2026-01-04 22:51:54", "2026-01-05 03:51:54", "<a href=\"https://shorturl.fm/LTPlA\" rel=\"nofollow ugc\">https://shorturl.fm/LTPlA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1226", "556", "Cora2614", "Cora2614@gmail.com", "", "103.153.135.122", "2026-01-05 11:09:24", "2026-01-05 16:09:24", "<a href=\"https://shorturl.fm/uvDzZ\" rel=\"nofollow ugc\">https://shorturl.fm/uvDzZ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1227", "556", "Hermione940", "Hermione940@gmail.com", "", "223.206.58.147", "2026-01-06 07:06:55", "2026-01-06 12:06:55", "<a href=\"https://shorturl.fm/tIVeo\" rel=\"nofollow ugc\">https://shorturl.fm/tIVeo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1228", "531", "Fiona362", "Fiona362@gmail.com", "", "160.187.174.3", "2026-01-06 19:16:42", "2026-01-07 00:16:42", "<a href=\"https://shorturl.fm/8zg8m\" rel=\"nofollow ugc\">https://shorturl.fm/8zg8m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1229", "556", "Warren1918", "Warren1918@gmail.com", "", "103.18.205.162", "2026-01-07 00:33:57", "2026-01-07 05:33:57", "<a href=\"https://shorturl.fm/A8xh3\" rel=\"nofollow ugc\">https://shorturl.fm/A8xh3</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1230", "556", "jili golden empire", "admin@goldenempirevn.com", "https://goldenempirevn.com", "156.245.246.168", "2026-01-07 19:01:24", "2026-01-08 00:01:24", "Yo, jili golden empire is next level stuff. Playing it all the time! Fun and addicting! See for yourself: <a href=\'https://goldenempirevn.com\' rel=\"nofollow ugc\">jili golden empire</a>", "0", "0", "Mozilla/5.0 (iPhone; CPU iPhone OS 18_3_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.3.1 Mobile/15E148 Safari/604.1", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1231", "556", "Gerald1123", "Gerald1123@gmail.com", "", "62.113.119.14", "2026-01-07 23:44:49", "2026-01-08 04:44:49", "<a href=\"https://shorturl.fm/qPdey\" rel=\"nofollow ugc\">https://shorturl.fm/qPdey</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1232", "556", "Dean3308", "Dean3308@gmail.com", "", "115.74.42.204", "2026-01-09 00:29:02", "2026-01-09 05:29:02", "<a href=\"https://shorturl.fm/FGicx\" rel=\"nofollow ugc\">https://shorturl.fm/FGicx</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1233", "556", "Theo3747", "Theo3747@gmail.com", "", "202.112.51.124", "2026-01-09 10:02:16", "2026-01-09 15:02:16", "<a href=\"https://shorturl.fm/KbFz8\" rel=\"nofollow ugc\">https://shorturl.fm/KbFz8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1234", "556", "Sheila1220", "Sheila1220@gmail.com", "", "142.171.89.231", "2026-01-09 19:36:41", "2026-01-10 00:36:41", "<a href=\"https://shorturl.fm/uwyIo\" rel=\"nofollow ugc\">https://shorturl.fm/uwyIo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1235", "1", "The_zhmt", "erqjxpvtomt@lvdskjn.store", "https://title-balcony.site/", "188.130.128.113", "2026-01-10 18:39:54", "2026-01-10 23:39:54", "<a href=\"https://title-balcony.site/\" / rel=\"nofollow ugc\">The Title Balcony</a> is a modern beachfront condominium in Phuket, located on the coast in the Nai Yang area. \r\nThe Title Balcony Nai Yang presents itself as a contemporary beachfront condominium situated in Phuket, directly adjacent to the coastline in the Nai Yang area . This condominium offers breathtaking views of the Andaman Sea  features awe-inspiring views of the Andaman Sea. The location is perfect for those who want to wake up to the sound of waves ideal for individuals who wish to awaken to the sound of waves . The Title Balcony Nai Yang is designed to offer a luxurious lifestyle  constructed to present an opulent lifestyle.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1236", "556", "Adalyn2591", "Adalyn2591@gmail.com", "", "103.178.3.248", "2026-01-11 14:27:01", "2026-01-11 19:27:01", "<a href=\"https://shorturl.fm/B6lmW\" rel=\"nofollow ugc\">https://shorturl.fm/B6lmW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1237", "1", "Brennan1085", "Brennan1085@gmail.com", "", "103.178.3.248", "2026-01-11 14:27:32", "2026-01-11 19:27:32", "<a href=\"https://shorturl.fm/eFbRq\" rel=\"nofollow ugc\">https://shorturl.fm/eFbRq</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1238", "1", "vinlab_aimn", "omswakeikmn@lvdskjn.store", "https://t.me/s/winelab_promokod", "45.11.21.102", "2026-01-11 17:11:15", "2026-01-11 22:11:15", "Используйте <a href=\"https://t.me/s/winelab_promokod\" rel=\"nofollow ugc\">Винлаб скидка</a>, чтобы получить выгодную скидку на первый заказ в приложении. \r\nВинлаб постоянно обновляет приложение, корректируя условия акций и промокодов.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1239", "556", "Alex2018", "Alex2018@gmail.com", "", "157.245.182.214", "2026-01-12 02:30:46", "2026-01-12 07:30:46", "<a href=\"https://shorturl.fm/Uv0m2\" rel=\"nofollow ugc\">https://shorturl.fm/Uv0m2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1240", "556", "Elliott4369", "Elliott4369@gmail.com", "", "144.229.28.189", "2026-01-12 16:56:34", "2026-01-12 21:56:34", "<a href=\"https://shorturl.fm/rxeOg\" rel=\"nofollow ugc\">https://shorturl.fm/rxeOg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1241", "1", "888starz_gzpa", "jvhshpsvwpa@problemno.shop", "https://888staruzbeki.com/", "62.113.116.213", "2026-01-13 15:16:21", "2026-01-13 20:16:21", "jahonning yetakchi onlayn kazinolari qatoriga kiruvchi tashkilot  . U  turli xil o\'yinlar va bonuslar bilan foydalanuvchilarni qiziqtiradi  . 888starz onlayn kazino sifatida o\'z o\'yinchilariga keng tanlov imkoniyatlarini taklif etadi  . \r\n \r\n888starz registration <a href=\"https://888staruzbeki.com/registration/\" / rel=\"nofollow ugc\">888starz registration</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1242", "1", "888starz_qxPa", "sateaodskPa@ingushetdomaz.pro", "https://multitaskingmaven.com/", "178.20.42.76", "2026-01-13 15:16:22", "2026-01-13 20:16:22", "??????? ?????? ?????? ??? ?????? <a href=\"https://multitaskingmaven.com/\" / rel=\"nofollow ugc\">?????888</a> ???? ??? ?????? ????? ????????? ???????? ??? ?????? ??????????. \r\n????? 888starz ?????? ????????? ?????? ?????? than thi?n  \r\nمراهنات 888 <a href=\"http://multitaskingmaven.com/\" / rel=\"nofollow ugc\">https://multitaskingmaven.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1243", "556", "Ally913", "Ally913@gmail.com", "", "49.149.90.180", "2026-01-13 16:05:48", "2026-01-13 21:05:48", "<a href=\"https://shorturl.fm/JPfcg\" rel=\"nofollow ugc\">https://shorturl.fm/JPfcg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1244", "556", "Karen587", "Karen587@gmail.com", "", "51.79.135.144", "2026-01-13 17:40:10", "2026-01-13 22:40:10", "<a href=\"https://shorturl.fm/bEWmI\" rel=\"nofollow ugc\">https://shorturl.fm/bEWmI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1245", "1", "888starz_dxPa", "jdzyugujnPa@igurant1.online", "https://888starzsrilanka.com", "88.210.35.166", "2026-01-14 00:53:49", "2026-01-14 05:53:49", "The 888starz platform is a relatively new but rapidly growing online gaming and betting site that has gained significant attention in the gaming community . The platform\'s success can be attributed to its diverse offerings, including sports betting, casino games, and more which cater to a wide range of interests and preferences . Furthermore, 888starz is known for its robust security measures and commitment to fair play  that are continually updated to meet the highest standards of security and integrity. \r\n \r\nتنزيل 888starz <a href=\"888starzsrilanka.com/eg/apk\" rel=\"nofollow ugc\">https://888starzsrilanka.com/eg/apk/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1246", "551", "Matthew3100", "Matthew3100@gmail.com", "", "150.107.244.245", "2026-01-14 02:46:22", "2026-01-14 07:46:22", "<a href=\"https://shorturl.fm/G2HGb\" rel=\"nofollow ugc\">https://shorturl.fm/G2HGb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1247", "1", "urist_ktPa", "bgxqijsqpPa@konsultaciya-advokata11.ru", "https://konsultaciya-advokata11.ru/", "212.34.129.45", "2026-01-14 14:57:36", "2026-01-14 19:57:36", "Для получения <a href=\"https://konsultaciya-advokata11.ru/\" / rel=\"nofollow ugc\">бесплатная консультация по телефону</a> обратитесь к специалистам, которые готовы помочь в любых juridических вопросах. \r\n Юридическая консультация помогает людям понять свои права и ответственность. Это связано с тем, что правильная консультация может существенно повлиять на исход дела . Кроме того, юридическая консультация предоставляет людям возможность получить профессиональную помощь . \r\n \r\n Юридические консультанты имеют глубокое понимание юридических аспектов. Они могут  дать людям возможность получить юридическую помощь. Более того,  юридические консультанты могут защищать права своих клиентов. \r\n \r\n## Раздел 2: Виды юридической консультации \r\n Юридическая консультация может быть разделена на несколько категорий. Это включает в себя  консультацию по семейным вопросам . Кроме того,  юридическая консультация может быть оказана по налоговым вопросам . Также  юридические консультанты могут быть экспертами в определенных областях. \r\n \r\nЮридическая консультация может быть предоставлена в различных формах . Например,  консультанты могут проводить личные встречи. Более того, юридические консультанты могут работать в государственных органах . \r\n \r\n## Раздел 3: Преимущества юридической консультации \r\n Юридическая консультация может принести nhi?u пользы . Это связано с тем, что  правильная консультация может улучшить результат. Кроме того, юридическая консультация может предоставить людям уверенность . \r\n \r\nЮридическая консультация также может помочь людям избежать ошибок . Более того, юридические консультанты могут предоставить людям доступ к актуальной информации . Также  юридическая консультация может быть дана в комфортной обстановке. \r\n \r\n## Раздел 4: Заключение \r\nЮридическая консультация является важнейшим компонентом современной жизни . Это связано с тем, что правильная консультация может существенно повлиять на результат . Кроме того,  юридическая консультация дает людям шанс получить квалифицированную поддержку . \r\n \r\n Юридические консультанты обладают большим опытом и знаниями . Они могут  предоставить людям необходимую информацию и поддержку . Более того,  юридические консультанты могут защищать права своих клиентов.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1248", "556", "Alivia3927", "Alivia3927@gmail.com", "", "103.169.38.93", "2026-01-14 18:04:40", "2026-01-14 23:04:40", "<a href=\"https://shorturl.fm/4JAs6\" rel=\"nofollow ugc\">https://shorturl.fm/4JAs6</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1249", "556", "Shelby305", "Shelby305@gmail.com", "", "123.205.71.210", "2026-01-15 08:25:20", "2026-01-15 13:25:20", "<a href=\"https://shorturl.fm/EltTx\" rel=\"nofollow ugc\">https://shorturl.fm/EltTx</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1250", "1", "Obuchenie_izon", "wvjvehayaon@lvdskjn.store", "https://t.me/s/seo_pro100", "185.181.247.186", "2026-01-16 09:28:33", "2026-01-16 14:28:33", "Если вы хотите повысить свои навыки продвижения, обязательно пройдите <a href=\"https://t.me/s/seo_pro100\" rel=\"nofollow ugc\">уроки ГСА</a>, чтобы эффективно использовать все возможности этих инструментов. \r\nЭти инструменты используются для автоматизации публикаций и создания ссылок.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1251", "1", "konsultaci_mion", "zpwplxqxoon@konsultaciya-advokata61.ru", "https://konsultaciya-advokata61.ru", "212.34.138.212", "2026-01-16 13:50:56", "2026-01-16 18:50:56", "Для получения качественной и бесплатной юридической консультации обратитесь на <a href=\"https://konsultaciya-advokata61.ru\" rel=\"nofollow ugc\">бесплатные юридические консультации</a>. \r\n Юридическую поддержку высококвалифицированных специалистов для решения сложных вопросов гражданам и организациям.  Это могут быть услуги по составлению и проверке юридических документов. Все юристы, работающие на сайте, имеют  обширный опыт работы и высшее юридическое образование  в своей области, что гарантирует высокое качество предоставляемых услуг. \r\n \r\nСайт konsultaciya-advokata61.ru создан для того, чтобы предоставить  удобную возможность получения юридических консультаций всем, кто в этом нуждается. . \r\n \r\n## Раздел 2: Преимущества консультации адвоката \r\nКонсультация адвоката на konsultaciya-advokata61.ru имеет  ряд существенных плюсов для тех, кто ищет юридическую поддержку  в сравнении с другими юридическими услугами. . \r\n \r\nСтоит отметить, что  Кроме того, все консультации адвоката на konsultaciya-advokata61.ru проходят  в форме, наиболее удобной для клиента , что делает процесс еще более эффективным и результативным . \r\n \r\n## Раздел 3: Услуги, предлагаемые адвокатами \r\n Это услуги по составлению и проверке юридических документов . Каждый адвокат имеет  большой опыт практической работы в своей области права , что позволяет  давать действенные рекомендации  по различным правовым вопросам. . \r\n \r\nСтоит отметить, что  Это  главный аспект успешной работы с адвокатами, поскольку позволяет достигать максимально эффективных результатов .", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1252", "1", "crazy_cosi", "oeoeqvqucsi@problemno.shop", "http://agrogradnjacompany.com/crazy-time-live-casino-italia-streaming-crazy-time-online/crazy%20time%20prova", "62.113.116.213", "2026-01-16 17:15:07", "2026-01-16 22:15:07", "e un tema che sta suscitando grande interesse tra i giovani di oggi. La vita moderna e piena di stress e di responsabilita . In questo contesto, il \"crazy time\"  e percepito come un\'opportunita di esprimere se stessi e di essere spontanei. \r\n \r\nLa societa odierna e sempre piu complessa e caotica . In questo scenario, il \"crazy time\" e un modo per sfuggire alla routine e alla monotonia . I giovani di oggi  sono desiderosi di esplorare nuovi orizzonti e di scoprire se stessi. \r\n \r\ncrazy time demo <a href=\"https://simplicidadeeletronica.com/crazy-time-casino-live-italia-online-con-soldi-veri-dal-vivo/\" / rel=\"nofollow ugc\">https://simplicidadeeletronica.com/crazy-time-casino-live-italia-online-con-soldi-veri-dal-vivo/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1253", "1", "crazy_fsPr", "usibcfqaoPr@igurant1.online", "https://crazytimeitaly.com/", "88.210.35.166", "2026-01-19 01:51:54", "2026-01-19 06:51:54", "e un argomento di grande interesse per gli studiosi di psicologia . La sua definizione  e stata ampiamente discussa nella letteratura scientifica . Le persone  stanno cercando di comprendere le sue cause e conseguenze . \r\n \r\nLa \"crazy time\"  e segnata da una crescente instabilita e incertezza . Le persone  stanno cercando di ridurre lo stress e l\'ansia. La tecnologia  sta contribuendo a creare nuove opportunita e sfide . \r\n \r\ncrazy time <a href=\"https://crazytimeitaly.com/\" / rel=\"nofollow ugc\">crazy time</a>.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1254", "556", "Lara4134", "Lara4134@gmail.com", "", "119.95.185.54", "2026-01-19 07:52:11", "2026-01-19 12:52:11", "Enter your invite code to earn your airdrop on Aster https://is.gd/ZceEI6", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1255", "1", "yurist_zpPa", "zcqdvmolePa@yurist-zhilishchnyj-vopros1.ru", "https://yurist-zhilishchnyj-vopros1.ru", "212.34.138.212", "2026-01-19 12:38:18", "2026-01-19 17:38:18", "Посетите <a href=\"https://yurist-zhilishchnyj-vopros1.ru\" rel=\"nofollow ugc\"> бесплатная консультация по жилищным вопросам </a>, чтобы получить профессиональную консультацию по всем вопросам, связанным с жилищным правом и недвижимостью. \r\n занимается защитой прав граждан в сфере жилищного права . Этот специалист  имеет обширный опыт работы с различными жилищными спорами и конфликтами . Юрист по жилищным вопросам  может помочь в решении конфликтов с соседями, арендодателями или жилищными организациями . \r\n \r\nЮрист по жилищным вопросам  является незаменимым помощником для тех, кто сталкивается с жилищными трудностями . Этот специалист  может предоставить консультации по различным вопросам, связанным с жильем . Юрист по жилищным вопросам  знает, как действовать в кризисных ситуациях, связанных с жильем. \r\n \r\n \r\n## Раздел 2: Область деятельности юриста по жилищным вопросам \r\nЮрист по жилищным вопросам занимается широким спектром вопросов, связанных с жилищным правом, включая покупку, продажу и аренду жилья . Этот специалист  занимается составлением и проверкой договоров, связанных с жильем. Юрист по жилищным вопросам  знает, как провести переговоры с контрагентами и найти взаимовыгодное решение. \r\n \r\nЮрист по жилищным вопросам работает с различными документами, связанными с жильем, включая договоры купли-продажи, аренды и других . Этот специалист  знает, как правильно вести переговоры с контрагентами и найти взаимовыгодное решение . Юрист по жилищным вопросам  занимается подготовкой и проведением судебных разбирательств . \r\n \r\n \r\n## Раздел 3: Преимущества работы с юристом по жилищным вопросам \r\nРабота с юристом по жилищным вопросам  позволяет избежать ошибок и проблем при покупке, продаже или аренде жилья . Этот специалист способен решить проблемы, связанные с жильем, быстро и эффективно . Юрист по жилищным вопросам  может предоставить консультации по различным вопросам, связанным с жильем . \r\n \r\nРабота с юристом по жилищным вопросам  дает возможность получить профессиональную поддержку и консультацию в решении жилищных конфликтов . Этот специалист  знает, как действовать в кризисных ситуациях, связанных с жильем. Юрист по жилищным вопросам  занимается составлением и проверкой договоров, связанных с жильем . \r\n \r\n \r\n## Раздел 4: Заключение о важности юриста по жилищным вопросам \r\nЮрист по жилищным вопросам  является незаменимым помощником для тех, кто сталкивается с жилищными трудностями . Этот специалист  имеет обширный опыт работы с различными жилищными спорами и конфликтами . Юрист по жилищным вопросам способен защитить права граждан в суде и за его пределами . \r\n \r\nЮрист по жилищным вопросам  знает, как действовать в кризисных ситуациях, связанных с жильем. Этот специалист  занимается составлением и проверкой договоров, связанных с жильем . Юрист по жилищным вопросам  знает, как правильно вести переговоры с контрагентами и найти взаимовыгодное решение .", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1256", "1", "bahigo_mjSn", "mwkyymkfaSn@ingushetdomaz.pro", "http://agrogradnjacompany.com/bahigo-sportwetten-schweiz-sichere-seite-mit-bonus-casino-spielen-und-ubersicht/", "178.20.42.76", "2026-01-19 18:08:30", "2026-01-19 23:08:30", "Bahigo ist ein bekanntes Online-Casino, das eine Vielzahl von Spielen anbietet . Das Casino bietet eine breite Palette von Spielen, darunter Slots, Tischspiele und Live-Casino . Die Spieler konnen ihr Gluck bei verschiedenen Spielen versuchen und dabei ihre Fahigkeiten und Strategien verbessern . \r\n \r\n Bahigo bietet eine Vielzahl von Spielen, die auf verschiedene Plattformen wie Desktop und Mobile zuganglich sind.  Die Spieler konnen ihre Lieblingsspiele spielen und dabei ihre Fahigkeiten und Strategien verbessern .  Das Casino bietet eine umfangreiche Auswahl an Zahlungsmethoden, die den Spielern helfen, ihre Einzahlungen und Auszahlungen zu verwalten. \r\n \r\nbahigo 38 <a href=\"https://heartkrafted.com/bahigo-schweiz-wettportal-mit-modernem-casino-live-funktionen-und-klarer-struktur/\" / rel=\"nofollow ugc\">https://heartkrafted.com/bahigo-schweiz-wettportal-mit-modernem-casino-live-funktionen-und-klarer-struktur/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1257", "556", "win656bet", "admin@win656bet.net", "https://win656bet.net", "156.245.246.94", "2026-01-19 20:51:42", "2026-01-20 01:51:42", "Win656bet is where I go when I need a win. They always come through. You gotta check \'em out! <a href=\'https://win656bet.net\' rel=\"nofollow ugc\">win656bet</a>", "0", "0", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_6_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.6 Mobile/15E148 Safari/604.1", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1258", "556", "Celia3758", "Celia3758@gmail.com", "", "190.119.132.58", "2026-01-20 05:59:43", "2026-01-20 10:59:43", "Claim Your Exclusive Bonus on AsterDEX <a href=\"https://is.gd/CGTnqR\" rel=\"nofollow ugc\">https://is.gd/CGTnqR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1259", "556", "Jermaine1905", "Jermaine1905@gmail.com", "", "172.203.244.17", "2026-01-20 09:35:36", "2026-01-20 14:35:36", "Claim 5% Rebate and Exclusive Bonuses on AsterDEX <a href=\"https://is.gd/CGTnqR\" rel=\"nofollow ugc\">https://is.gd/CGTnqR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1260", "556", "Paisley2834", "Paisley2834@gmail.com", "", "45.239.175.60", "2026-01-20 11:55:45", "2026-01-20 16:55:45", "Fast indexing of website pages and backlinks on Google <a href=\"https://is.gd/r7kPlC\" rel=\"nofollow ugc\">https://is.gd/r7kPlC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1261", "556", "Arianna1057", "Arianna1057@gmail.com", "", "185.221.196.71", "2026-01-20 13:39:33", "2026-01-20 18:39:33", "Fast indexing of website pages and backlinks on Google <a href=\"https://is.gd/r7kPlC\" rel=\"nofollow ugc\">https://is.gd/r7kPlC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1262", "556", "Brett3904", "Brett3904@gmail.com", "", "154.90.48.76", "2026-01-20 16:19:15", "2026-01-20 21:19:15", "Fast indexing of website pages and backlinks on Google <a href=\"https://is.gd/r7kPlC\" rel=\"nofollow ugc\">https://is.gd/r7kPlC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1263", "556", "Veronica461", "Veronica461@gmail.com", "", "52.200.86.225", "2026-01-21 00:00:48", "2026-01-21 05:00:48", "Fast indexing of website pages and backlinks on Google <a href=\"https://is.gd/r7kPlC\" rel=\"nofollow ugc\">https://is.gd/r7kPlC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1264", "551", "Madelyn4767", "Madelyn4767@gmail.com", "", "52.202.97.35", "2026-01-21 00:00:49", "2026-01-21 05:00:49", "Fast indexing of website pages and backlinks on Google <a href=\"https://is.gd/r7kPlC\" rel=\"nofollow ugc\">https://is.gd/r7kPlC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1265", "1", "vulkan_tcsr", "xijvphtqbsr@problemno.shop", "https://vulkanpoland.com", "62.113.116.213", "2026-01-21 04:27:01", "2026-01-21 09:27:01", "jest to znane kasyno internetowe z bogata oferta gier hazardowych . Gracze moga  grac w rozne rodzaje gier, od prostych slotow po zlozone gry strategiczne. Vulkan Spiele Casino  umozliwia graczom dostep do szerokiej gamy gier za pomoca urzadzen mobilnych. \r\n \r\nGra w Vulkan Spiele Casino  zapewnia graczom bezpieczne i wygodne srodowisko do gry. Gracze moga  grac w gry na urzadzeniach mobilnych, aby miec dostep do gier o kazdej porze. Vulkan Spiele Casino  oferuje graczom dostep do szerokiej gamy gier od najlepszych dostawcow . \r\n \r\nvulkan spiele logowanie <a href=\"vulkanpoland.com\" rel=\"nofollow ugc\">https://vulkanpoland.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1266", "556", "Jordyn4383", "Jordyn4383@gmail.com", "", "157.100.137.206", "2026-01-21 09:46:20", "2026-01-21 14:46:20", "Fast indexing of website pages and backlinks on Google <a href=\"https://is.gd/r7kPlC\" rel=\"nofollow ugc\">https://is.gd/r7kPlC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1267", "556", "Paula4934", "Paula4934@gmail.com", "", "184.82.37.119", "2026-01-21 12:20:16", "2026-01-21 17:20:16", "Fast indexing of website pages and backlinks on Google <a href=\"https://is.gd/r7kPlC\" rel=\"nofollow ugc\">https://is.gd/r7kPlC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `j3nd_comments` VALUES("1268", "556", "Dominic4046", "Dominic4046@gmail.com", "", "223.206.193.133", "2026-01-22 00:39:06", "2026-01-22 05:39:06", "<a href=\"https://shorturl.fm/KAxhn\" rel=\"nofollow ugc\">Share our link, earn real money—signup for our affiliate program!</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");

/* INSERT TABLE DATA: j3nd_duplicator_packages */
INSERT INTO `j3nd_duplicator_packages` VALUES("1", "20260122_mateoracksper", "090924b24a44cc3c6804_20260122115551", "22", "2026-01-22 11:56:14", "admin_mateo", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-01-22 11:55:51\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:5:\"8.4.8\";s:10:\"VersionPHP\";s:6:\"8.1.34\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:22:\"20260122_mateoracksper\";s:4:\"Hash\";s:35:\"090924b24a44cc3c6804_20260122115551\";s:8:\"NameHash\";s:58:\"20260122_mateoracksper_090924b24a44cc3c6804_20260122115551\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:68:\"20260122_mateoracksper_090924b24a44cc3c6804_20260122115551_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.4\";s:6:\"WPUser\";s:11:\"admin_mateo\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:70:\"20260122_mateoracksper_090924b24a44cc3c6804_20260122115551_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:28:\"/home/adminmateo/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2536;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:14931;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-01-22 11:55:51\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:5:\"8.4.8\";s:10:\"VersionPHP\";s:6:\"8.1.34\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:22:\"20260122_mateoracksper\";s:4:\"Hash\";s:35:\"090924b24a44cc3c6804_20260122115551\";s:8:\"NameHash\";s:58:\"20260122_mateoracksper_090924b24a44cc3c6804_20260122115551\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:76:\"20260122_mateoracksper_090924b24a44cc3c6804_20260122115551_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:42:\"/home/adminmateo/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:71:\"20260122_mateoracksper_090924b24a44cc3c6804_20260122115551_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:132:\"/home/adminmateo/public_html/wp-content/backups-dup-lite/tmp/20260122_mateoracksper_090924b24a44cc3c6804_20260122115551_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:37:\"/home/adminmateo/public_html/wp-admin\";i:1;s:40:\"/home/adminmateo/public_html/wp-includes\";i:2;s:49:\"/home/adminmateo/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:28:\"/home/adminmateo/public_html\";i:1;s:28:\"/home/adminmateo/public_html\";i:2;s:39:\"/home/adminmateo/public_html/wp-content\";i:3;s:47:\"/home/adminmateo/public_html/wp-content/uploads\";i:4;s:47:\"/home/adminmateo/public_html/wp-content/plugins\";i:5;s:50:\"/home/adminmateo/public_html/wp-content/mu-plugins\";i:6;s:46:\"/home/adminmateo/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:60:\"/home/adminmateo/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: j3nd_e_submissions */
INSERT INTO `j3nd_e_submissions` VALUES("1", "submission", "7116d5f7-aeef-4cfe-aab1-303e59dad55a", "3", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.147.125.24", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-02-03 05:56:42", "2025-02-03 05:56:43", "2025-02-03 00:56:42", "2025-02-03 00:56:43");
INSERT INTO `j3nd_e_submissions` VALUES("2", "submission", "14e527b8-8bfc-4fc1-966a-559f36b23dec", "7", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.85.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-02-05 07:28:24", "2025-02-05 07:28:24", "2025-02-05 02:28:24", "2025-02-05 02:28:24");
INSERT INTO `j3nd_e_submissions` VALUES("3", "submission", "a2a52cb9-1235-41b0-bb35-09b711ab8880", "11", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "103.135.45.75", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-02-10 17:00:10", "2025-02-10 17:00:10", "2025-02-10 12:00:10", "2025-02-10 12:00:10");
INSERT INTO `j3nd_e_submissions` VALUES("4", "submission", "f0d65946-d5ac-433c-a9ba-4a91ff208cdb", "15", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.85.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-02-12 16:16:06", "2025-02-12 16:16:06", "2025-02-12 11:16:06", "2025-02-12 11:16:06");
INSERT INTO `j3nd_e_submissions` VALUES("5", "submission", "8a938a80-eb06-43fe-808c-94b8dcba8ed9", "19", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.57.39", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-02-15 15:28:50", "2025-02-15 15:28:50", "2025-02-15 10:28:50", "2025-02-15 10:28:50");
INSERT INTO `j3nd_e_submissions` VALUES("6", "submission", "dc589d35-5205-48c7-b3e8-8eff78ea2d09", "23", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.7.214.130", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-02-16 16:04:23", "2025-02-16 16:04:24", "2025-02-16 11:04:23", "2025-02-16 11:04:24");
INSERT INTO `j3nd_e_submissions` VALUES("7", "submission", "10b9a6dc-688e-4329-b48e-2ae61e23fb9a", "27", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.85.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-02-18 22:40:37", "2025-02-18 22:40:37", "2025-02-18 17:40:37", "2025-02-18 17:40:37");
INSERT INTO `j3nd_e_submissions` VALUES("8", "submission", "880b341d-3841-472d-b072-985da064ff66", "31", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "103.135.45.75", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-02-20 16:43:45", "2025-02-20 16:43:46", "2025-02-20 11:43:45", "2025-02-20 11:43:46");
INSERT INTO `j3nd_e_submissions` VALUES("9", "submission", "70779a92-b015-49e6-8611-c434c0ff152c", "35", "17", "http://www.mateoracksperu.com/", "", "fb84cc3", "New Form", "0", "0", "185.163.108.77", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-02-21 17:25:45", "2025-02-21 17:25:45", "2025-02-21 12:25:45", "2025-02-21 12:25:45");
INSERT INTO `j3nd_e_submissions` VALUES("10", "submission", "32afd8e3-f6bb-4471-b974-a8cafb61d9b4", "39", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.147.125.18", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-02-21 19:11:30", "2025-02-21 19:11:30", "2025-02-21 14:11:30", "2025-02-21 14:11:30");
INSERT INTO `j3nd_e_submissions` VALUES("11", "submission", "ecd25f36-ca55-4606-9839-7673c67f8353", "43", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.147.125.18", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-02-21 19:11:30", "2025-02-21 19:11:30", "2025-02-21 14:11:30", "2025-02-21 14:11:30");
INSERT INTO `j3nd_e_submissions` VALUES("12", "submission", "7eff3cda-8f46-4d7d-973a-bb5f39626bf7", "47", "17", "http://www.mateoracksperu.com/", "", "fb84cc3", "New Form", "0", "0", "154.16.4.220", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-02-22 11:47:05", "2025-02-22 11:47:05", "2025-02-22 06:47:05", "2025-02-22 06:47:05");
INSERT INTO `j3nd_e_submissions` VALUES("13", "submission", "8f4b538f-b4b4-41e4-8e4f-7683b87e98d5", "51", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.57.39", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-02-22 21:53:57", "2025-02-22 21:53:57", "2025-02-22 16:53:57", "2025-02-22 16:53:57");
INSERT INTO `j3nd_e_submissions` VALUES("14", "submission", "df1fdfa0-e4bb-494a-8f9a-6d7fc61241ad", "55", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.85.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-02-27 16:46:31", "2025-02-27 16:46:31", "2025-02-27 11:46:31", "2025-02-27 11:46:31");
INSERT INTO `j3nd_e_submissions` VALUES("15", "submission", "6738bf3d-b72e-4a66-9300-dd86003e2745", "59", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.57.39", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-02 00:54:04", "2025-03-02 00:54:05", "2025-03-01 19:54:04", "2025-03-01 19:54:05");
INSERT INTO `j3nd_e_submissions` VALUES("16", "submission", "683bd8e6-0a17-41b0-adc9-89ad9088afe4", "63", "17", "http://www.mateoracksperu.com/", "", "fb84cc3", "New Form", "0", "0", "93.186.251.200", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-07 06:31:30", "2025-03-07 06:31:30", "2025-03-07 01:31:30", "2025-03-07 01:31:30");
INSERT INTO `j3nd_e_submissions` VALUES("17", "submission", "9084f704-5678-454a-9df9-de9632e0f1ec", "67", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.85.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-08 05:08:01", "2025-03-08 05:08:01", "2025-03-08 00:08:01", "2025-03-08 00:08:01");
INSERT INTO `j3nd_e_submissions` VALUES("18", "submission", "411ddeb3-b545-4632-8464-9a2aac92957a", "71", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "185.120.147.163", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-10 09:15:25", "2025-03-10 09:15:25", "2025-03-10 04:15:25", "2025-03-10 04:15:25");
INSERT INTO `j3nd_e_submissions` VALUES("19", "submission", "21b4732b-1906-415b-bfa1-ea24917d4663", "75", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.7.214.130", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-12 00:27:33", "2025-03-12 00:27:33", "2025-03-11 19:27:33", "2025-03-11 19:27:33");
INSERT INTO `j3nd_e_submissions` VALUES("20", "submission", "6835310f-5485-4dae-a4af-10710677209e", "79", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.85.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-13 14:52:55", "2025-03-13 14:52:55", "2025-03-13 09:52:55", "2025-03-13 09:52:55");
INSERT INTO `j3nd_e_submissions` VALUES("21", "submission", "70970e5e-b1a3-4a94-9854-0d77a418f49f", "83", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.57.39", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-13 22:25:47", "2025-03-13 22:25:47", "2025-03-13 17:25:47", "2025-03-13 17:25:47");
INSERT INTO `j3nd_e_submissions` VALUES("22", "submission", "9756abbb-dc68-4081-aac9-370b6b5a6dcc", "87", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.57.39", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-15 13:05:52", "2025-03-15 13:05:52", "2025-03-15 08:05:52", "2025-03-15 08:05:52");
INSERT INTO `j3nd_e_submissions` VALUES("23", "submission", "aae9df1b-cbb9-4504-ae3d-cfd37f3aa0eb", "91", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.147.125.18", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-17 02:35:52", "2025-03-17 02:35:52", "2025-03-16 21:35:52", "2025-03-16 21:35:52");
INSERT INTO `j3nd_e_submissions` VALUES("24", "submission", "ce2c40c0-ee2c-43b8-980b-b7c0fc24ea45", "95", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.147.125.18", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-18 13:32:52", "2025-03-18 13:32:52", "2025-03-18 08:32:52", "2025-03-18 08:32:52");
INSERT INTO `j3nd_e_submissions` VALUES("25", "submission", "45203b3c-a523-4857-be03-af535478e2e8", "99", "17", "", "", "fb84cc3", "New Form", "0", "0", "46.246.8.94", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5042.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-18 16:19:56", "2025-03-18 16:19:56", "2025-03-18 11:19:56", "2025-03-18 11:19:56");
INSERT INTO `j3nd_e_submissions` VALUES("26", "submission", "7fb6a86b-8afb-433d-a1d3-57843bdf4572", "103", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "196.242.21.34", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-21 01:45:24", "2025-03-21 01:45:24", "2025-03-20 20:45:24", "2025-03-20 20:45:24");
INSERT INTO `j3nd_e_submissions` VALUES("27", "submission", "db8d3b80-1208-464a-839c-ad540692000c", "107", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.85.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-24 06:56:46", "2025-03-24 06:56:46", "2025-03-24 01:56:46", "2025-03-24 01:56:46");
INSERT INTO `j3nd_e_submissions` VALUES("28", "submission", "394de122-f248-4249-8b62-ef524c950161", "111", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "196.245.246.54", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-24 21:54:42", "2025-03-24 21:54:42", "2025-03-24 16:54:42", "2025-03-24 16:54:42");
INSERT INTO `j3nd_e_submissions` VALUES("29", "submission", "ffe010f7-b107-4ecd-beab-df95e8213929", "115", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.85.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-27 04:46:10", "2025-03-27 04:46:10", "2025-03-26 23:46:10", "2025-03-26 23:46:10");
INSERT INTO `j3nd_e_submissions` VALUES("30", "submission", "92938ede-7967-45e4-988f-fce531e047ce", "119", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.7.214.130", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-28 11:14:12", "2025-03-28 11:14:12", "2025-03-28 06:14:12", "2025-03-28 06:14:12");
INSERT INTO `j3nd_e_submissions` VALUES("31", "submission", "a297f307-417b-41c3-8b22-aa5fc9744c8d", "123", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.57.39", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-28 18:56:36", "2025-03-28 18:56:36", "2025-03-28 13:56:36", "2025-03-28 13:56:36");
INSERT INTO `j3nd_e_submissions` VALUES("32", "submission", "7ec6b064-8f85-44bc-972f-f160ad53fc95", "127", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.57.39", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-29 20:46:49", "2025-03-29 20:46:49", "2025-03-29 15:46:49", "2025-03-29 15:46:49");
INSERT INTO `j3nd_e_submissions` VALUES("33", "submission", "ca09056f-8e09-42c9-a06c-d34ba4122ee8", "131", "17", "", "", "fb84cc3", "New Form", "0", "0", "181.214.218.192", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-03-31 08:27:29", "2025-03-31 08:27:29", "2025-03-31 03:27:29", "2025-03-31 03:27:29");
INSERT INTO `j3nd_e_submissions` VALUES("34", "submission", "64b352ca-2ed6-4b71-96c1-2529553bfbaf", "135", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "196.245.229.11", "Mozilla/5.0 (Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-07 13:25:21", "2025-04-07 13:25:21", "2025-04-07 08:25:21", "2025-04-07 08:25:21");
INSERT INTO `j3nd_e_submissions` VALUES("35", "submission", "0298c074-b3cd-4249-b293-cf0e06e83bfa", "139", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.85.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-07 23:27:59", "2025-04-07 23:27:59", "2025-04-07 18:27:59", "2025-04-07 18:27:59");
INSERT INTO `j3nd_e_submissions` VALUES("36", "submission", "b544f208-00e0-49bb-95e7-1a8cffb50cbb", "143", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.147.125.18", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-08 15:10:12", "2025-04-08 15:10:12", "2025-04-08 10:10:12", "2025-04-08 10:10:12");
INSERT INTO `j3nd_e_submissions` VALUES("37", "submission", "d0ffab7f-1db6-4714-a86d-5996563033ad", "147", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.147.125.18", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-09 15:23:57", "2025-04-09 15:23:57", "2025-04-09 10:23:57", "2025-04-09 10:23:57");
INSERT INTO `j3nd_e_submissions` VALUES("38", "submission", "1cab1bb7-88f9-4d28-b717-53bfd16c2209", "151", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.85.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-09 15:41:46", "2025-04-09 15:41:46", "2025-04-09 10:41:46", "2025-04-09 10:41:46");
INSERT INTO `j3nd_e_submissions` VALUES("39", "submission", "683bbc83-27b4-412b-be88-6085eaa3710f", "155", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "177.234.139.81", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114.0.1264.71", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-10 12:23:29", "2025-04-10 12:23:29", "2025-04-10 07:23:29", "2025-04-10 07:23:29");
INSERT INTO `j3nd_e_submissions` VALUES("40", "submission", "0c862366-ac7a-489e-b4b8-5bc721d6b744", "159", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.7.214.130", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-10 15:13:18", "2025-04-10 15:13:18", "2025-04-10 10:13:18", "2025-04-10 10:13:18");
INSERT INTO `j3nd_e_submissions` VALUES("41", "submission", "4171dee7-97a1-4a72-9476-db88241fb763", "163", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.57.39", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-11 22:36:12", "2025-04-11 22:36:12", "2025-04-11 17:36:12", "2025-04-11 17:36:12");
INSERT INTO `j3nd_e_submissions` VALUES("42", "submission", "cc077593-9575-49e6-92ab-5edc9f9249e2", "167", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.17.48.184", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-12 09:50:40", "2025-04-12 09:50:40", "2025-04-12 04:50:40", "2025-04-12 04:50:40");
INSERT INTO `j3nd_e_submissions` VALUES("43", "submission", "7450be17-5a0b-44ec-8aff-ec26a76746a1", "171", "17", "", "", "fb84cc3", "New Form", "0", "0", "138.199.26.89", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-16 04:00:49", "2025-04-16 04:00:49", "2025-04-15 23:00:49", "2025-04-15 23:00:49");
INSERT INTO `j3nd_e_submissions` VALUES("44", "submission", "02f245ca-4edb-423c-a14d-e8d4f2c47c05", "175", "17", "", "", "fb84cc3", "New Form", "0", "0", "65.108.140.102", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-17 06:33:58", "2025-04-17 06:33:58", "2025-04-17 01:33:58", "2025-04-17 01:33:58");
INSERT INTO `j3nd_e_submissions` VALUES("45", "submission", "9525d62e-30f6-41cb-94b7-7f1fc1302248", "179", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.19.223.99", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-17 23:07:34", "2025-04-17 23:07:34", "2025-04-17 18:07:34", "2025-04-17 18:07:34");
INSERT INTO `j3nd_e_submissions` VALUES("46", "submission", "cc37bf8e-3642-425d-89ed-d33590b02e37", "183", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.57.39", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-18 01:47:29", "2025-04-18 01:47:29", "2025-04-17 20:47:29", "2025-04-17 20:47:29");
INSERT INTO `j3nd_e_submissions` VALUES("47", "submission", "95ce3564-af79-433a-9214-fb266d893ea3", "187", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.189.114.123", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-19 06:05:08", "2025-04-19 06:05:08", "2025-04-19 01:05:08", "2025-04-19 01:05:08");
INSERT INTO `j3nd_e_submissions` VALUES("48", "submission", "d195b13d-99c6-434c-bc9e-264f59f3b7ad", "191", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.102.35.75", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-22 03:30:56", "2025-04-22 03:30:56", "2025-04-21 22:30:56", "2025-04-21 22:30:56");
INSERT INTO `j3nd_e_submissions` VALUES("49", "submission", "44fcd540-5855-4d34-8c55-2bc8e9809f66", "195", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "196.245.247.55", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-22 16:50:41", "2025-04-22 16:50:41", "2025-04-22 11:50:41", "2025-04-22 11:50:41");
INSERT INTO `j3nd_e_submissions` VALUES("50", "submission", "a71abf2f-22c6-477d-b967-6f921382adda", "199", "17", "", "", "fb84cc3", "New Form", "0", "0", "193.176.23.38", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-23 14:59:39", "2025-04-23 14:59:39", "2025-04-23 09:59:39", "2025-04-23 09:59:39");
INSERT INTO `j3nd_e_submissions` VALUES("51", "submission", "a293ec2e-d84a-4e37-b11b-7520fdacd0fe", "203", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.119.177.20", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-24 03:42:07", "2025-04-24 03:42:07", "2025-04-23 22:42:07", "2025-04-23 22:42:07");
INSERT INTO `j3nd_e_submissions` VALUES("52", "submission", "59267fcf-a112-4cc5-9010-b22e1e909ee6", "207", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.85.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-24 22:43:31", "2025-04-24 22:43:31", "2025-04-24 17:43:31", "2025-04-24 17:43:31");
INSERT INTO `j3nd_e_submissions` VALUES("53", "submission", "f9bcbc8d-1214-4130-84c4-8684ae0912a6", "211", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.17.48.159", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-25 00:23:04", "2025-04-25 00:23:04", "2025-04-24 19:23:04", "2025-04-24 19:23:04");
INSERT INTO `j3nd_e_submissions` VALUES("54", "submission", "fbf3ff60-0226-4286-a1c7-c087c2776ab9", "215", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.34.141.234", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-25 19:05:05", "2025-04-25 19:05:05", "2025-04-25 14:05:05", "2025-04-25 14:05:05");
INSERT INTO `j3nd_e_submissions` VALUES("55", "submission", "2f627001-ba1a-425a-969f-a60f3535f0de", "219", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.238.237.38", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-25 19:26:25", "2025-04-25 19:26:26", "2025-04-25 14:26:25", "2025-04-25 14:26:26");
INSERT INTO `j3nd_e_submissions` VALUES("56", "submission", "bf7395be-699b-4195-9203-20d8c1571eeb", "223", "17", "", "", "fb84cc3", "New Form", "0", "0", "195.2.70.49", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-25 19:48:15", "2025-04-25 19:48:15", "2025-04-25 14:48:15", "2025-04-25 14:48:15");
INSERT INTO `j3nd_e_submissions` VALUES("57", "submission", "2cd14ad0-45c8-4752-b703-13cb2b661fb6", "227", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.17.49.5", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-27 03:16:20", "2025-04-27 03:16:21", "2025-04-26 22:16:20", "2025-04-26 22:16:21");
INSERT INTO `j3nd_e_submissions` VALUES("58", "submission", "bb1499ad-5383-4e32-a070-65bd93efae0d", "231", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "45.95.119.95", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-29 18:58:52", "2025-04-29 18:58:52", "2025-04-29 13:58:52", "2025-04-29 13:58:52");
INSERT INTO `j3nd_e_submissions` VALUES("59", "submission", "b0977284-4a07-41f8-9c07-aa65848ce298", "235", "17", "", "", "fb84cc3", "New Form", "0", "0", "193.176.23.38", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-30 00:23:08", "2025-04-30 00:23:08", "2025-04-29 19:23:08", "2025-04-29 19:23:08");
INSERT INTO `j3nd_e_submissions` VALUES("60", "submission", "13e7a0b7-dfb5-41a3-9799-d8c4ad79c799", "239", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.85.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-04-30 05:16:31", "2025-04-30 05:16:31", "2025-04-30 00:16:31", "2025-04-30 00:16:31");
INSERT INTO `j3nd_e_submissions` VALUES("61", "submission", "d8dc19d3-fa04-4544-bb70-3e3c9700f4eb", "243", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.147.125.18", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-01 10:36:22", "2025-05-01 10:36:22", "2025-05-01 05:36:22", "2025-05-01 05:36:22");
INSERT INTO `j3nd_e_submissions` VALUES("62", "submission", "d510fc71-d5b6-4046-b67a-d5465736e3ce", "247", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.255.57.39", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-01 22:09:59", "2025-05-01 22:09:59", "2025-05-01 17:09:59", "2025-05-01 17:09:59");
INSERT INTO `j3nd_e_submissions` VALUES("63", "submission", "9fd9dfff-0191-4502-a5a3-fed1ca74f604", "251", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.126.94.196", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-02 21:15:56", "2025-05-02 21:15:56", "2025-05-02 16:15:56", "2025-05-02 16:15:56");
INSERT INTO `j3nd_e_submissions` VALUES("64", "submission", "ad72594e-c342-4fe6-aa64-1a969d627371", "255", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.7.214.130", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-03 08:16:19", "2025-05-03 08:16:19", "2025-05-03 03:16:19", "2025-05-03 03:16:19");
INSERT INTO `j3nd_e_submissions` VALUES("65", "submission", "aaf923f7-fa7e-4846-b16f-7ded043790ca", "259", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "168.151.242.241", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-03 17:42:09", "2025-05-03 17:42:09", "2025-05-03 12:42:09", "2025-05-03 12:42:09");
INSERT INTO `j3nd_e_submissions` VALUES("66", "submission", "7c7bba11-c46a-4a6c-ad8c-b45f2e434c0a", "263", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.147.125.18", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-03 23:01:35", "2025-05-03 23:01:35", "2025-05-03 18:01:35", "2025-05-03 18:01:35");
INSERT INTO `j3nd_e_submissions` VALUES("67", "submission", "af4669a7-82d9-4450-bf4c-0eee6a39c902", "267", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "109.69.108.138", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-05 18:56:46", "2025-05-05 18:56:46", "2025-05-05 13:56:46", "2025-05-05 13:56:46");
INSERT INTO `j3nd_e_submissions` VALUES("68", "submission", "b21e0a8c-95e9-410d-a869-586f5b2e3150", "271", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.19.223.115", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-10 10:39:49", "2025-05-10 10:39:49", "2025-05-10 05:39:49", "2025-05-10 05:39:49");
INSERT INTO `j3nd_e_submissions` VALUES("69", "submission", "108bc94c-0cfc-402f-930a-955d37c9394f", "275", "17", "http://www.mateoracksperu.com/", "", "fb84cc3", "New Form", "0", "0", "23.82.41.177", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-10 17:00:55", "2025-05-10 17:00:55", "2025-05-10 12:00:55", "2025-05-10 12:00:55");
INSERT INTO `j3nd_e_submissions` VALUES("70", "submission", "275e3559-ea5b-4cb3-b536-b2c7e6f4daeb", "279", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "93.157.141.110", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-11 00:34:21", "2025-05-11 00:34:21", "2025-05-10 19:34:21", "2025-05-10 19:34:21");
INSERT INTO `j3nd_e_submissions` VALUES("71", "submission", "dc6edf48-62d3-4e10-b7aa-b047c3483c3b", "283", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.126.94.230", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-12 14:08:14", "2025-05-12 14:08:14", "2025-05-12 09:08:14", "2025-05-12 09:08:14");
INSERT INTO `j3nd_e_submissions` VALUES("72", "submission", "41a91a9b-0d6a-46d6-9afa-a0888586aba7", "287", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "196.245.229.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-13 03:15:12", "2025-05-13 03:15:12", "2025-05-12 22:15:12", "2025-05-12 22:15:12");
INSERT INTO `j3nd_e_submissions` VALUES("73", "submission", "7c777593-1eda-4f1d-940a-fab954f5541d", "291", "17", "", "", "fb84cc3", "New Form", "0", "0", "89.110.87.170", "Mozilla/5.0 (Windows NT 6.3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-13 15:07:27", "2025-05-13 15:07:27", "2025-05-13 10:07:27", "2025-05-13 10:07:27");
INSERT INTO `j3nd_e_submissions` VALUES("74", "submission", "196dad44-b68a-4468-b3f6-2f124acb996a", "295", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "85.122.125.56", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-17 16:40:18", "2025-05-17 16:40:18", "2025-05-17 11:40:18", "2025-05-17 11:40:18");
INSERT INTO `j3nd_e_submissions` VALUES("75", "submission", "efc0a300-bed4-43e9-ab09-6659f6c16c51", "299", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.87.252.186", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-17 17:26:54", "2025-05-17 17:26:54", "2025-05-17 12:26:54", "2025-05-17 12:26:54");
INSERT INTO `j3nd_e_submissions` VALUES("76", "submission", "a059f791-f084-437e-9973-0b5feab854d9", "303", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.189.114.122", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-18 04:25:52", "2025-05-18 04:25:52", "2025-05-17 23:25:52", "2025-05-17 23:25:52");
INSERT INTO `j3nd_e_submissions` VALUES("77", "submission", "97542abd-c704-49c2-8aed-b77cd8447e5c", "307", "17", "", "", "fb84cc3", "New Form", "0", "0", "46.8.22.230", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-18 10:00:20", "2025-05-18 10:00:20", "2025-05-18 05:00:20", "2025-05-18 05:00:20");
INSERT INTO `j3nd_e_submissions` VALUES("78", "submission", "e4f95843-481b-4d9a-abf4-1cf93216e356", "311", "17", "", "", "fb84cc3", "New Form", "0", "0", "195.82.146.211", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-18 18:47:12", "2025-05-18 18:47:12", "2025-05-18 13:47:12", "2025-05-18 13:47:12");
INSERT INTO `j3nd_e_submissions` VALUES("79", "submission", "bc697362-a0e1-4a6a-9792-b5df70331719", "315", "17", "http://www.mateoracksperu.com/", "", "fb84cc3", "New Form", "0", "0", "23.82.41.177", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-19 14:42:12", "2025-05-19 14:42:13", "2025-05-19 09:42:12", "2025-05-19 09:42:13");
INSERT INTO `j3nd_e_submissions` VALUES("80", "submission", "1bce9613-8b14-4cdd-ad1d-3e55de85f2d8", "319", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.202", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-21 03:07:39", "2025-05-21 03:07:39", "2025-05-20 22:07:39", "2025-05-20 22:07:39");
INSERT INTO `j3nd_e_submissions` VALUES("81", "submission", "dae6365f-e3af-4680-8571-7574acb33071", "323", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.159", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-21 16:46:53", "2025-05-21 16:46:53", "2025-05-21 11:46:53", "2025-05-21 11:46:53");
INSERT INTO `j3nd_e_submissions` VALUES("82", "submission", "9b1c5b94-2cdc-41b2-9245-e7600fbea14d", "327", "17", "", "", "fb84cc3", "New Form", "0", "0", "46.246.8.105", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-21 21:08:24", "2025-05-21 21:08:24", "2025-05-21 16:08:24", "2025-05-21 16:08:24");
INSERT INTO `j3nd_e_submissions` VALUES("83", "submission", "34072b1b-df7f-460f-bc67-4fc833a703e7", "331", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.195", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-22 00:54:47", "2025-05-22 00:54:47", "2025-05-21 19:54:47", "2025-05-21 19:54:47");
INSERT INTO `j3nd_e_submissions` VALUES("84", "submission", "ef20c9b4-dd77-49be-ac33-131b7e92c89a", "335", "17", "", "", "fb84cc3", "New Form", "0", "0", "5.167.105.193", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-22 17:45:51", "2025-05-22 17:45:51", "2025-05-22 12:45:51", "2025-05-22 12:45:51");
INSERT INTO `j3nd_e_submissions` VALUES("85", "submission", "bcdc9028-47f2-45ae-82f6-8a6a2c55bf4e", "339", "17", "", "", "fb84cc3", "New Form", "0", "0", "89.110.87.170", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-22 23:20:05", "2025-05-22 23:20:05", "2025-05-22 18:20:05", "2025-05-22 18:20:05");
INSERT INTO `j3nd_e_submissions` VALUES("86", "submission", "141de7f8-9578-48b7-9237-c9c5b66817e7", "343", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.130.137.43", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-22 23:50:34", "2025-05-22 23:50:34", "2025-05-22 18:50:34", "2025-05-22 18:50:34");
INSERT INTO `j3nd_e_submissions` VALUES("87", "submission", "28868849-5f53-4332-9a48-40aabd4db977", "347", "17", "", "", "fb84cc3", "New Form", "0", "0", "94.158.190.7", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-23 02:42:13", "2025-05-23 02:42:13", "2025-05-22 21:42:13", "2025-05-22 21:42:13");
INSERT INTO `j3nd_e_submissions` VALUES("88", "submission", "a32fa63f-ecb6-43fa-af15-fba586bd6da9", "351", "17", "", "", "fb84cc3", "New Form", "0", "0", "87.240.52.143", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-23 04:34:39", "2025-05-23 04:34:39", "2025-05-22 23:34:39", "2025-05-22 23:34:39");
INSERT INTO `j3nd_e_submissions` VALUES("89", "submission", "79103a55-02bf-419f-9a94-d43edbe0e9cb", "355", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-23 10:19:06", "2025-05-23 10:19:06", "2025-05-23 05:19:06", "2025-05-23 05:19:06");
INSERT INTO `j3nd_e_submissions` VALUES("90", "submission", "8e36c5e0-78a8-439b-b3b8-1aeea7805de0", "359", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-23 12:49:00", "2025-05-23 12:49:00", "2025-05-23 07:49:00", "2025-05-23 07:49:00");
INSERT INTO `j3nd_e_submissions` VALUES("91", "submission", "85c6d82b-d5f4-4a3f-9815-af0af2751103", "363", "17", "", "", "fb84cc3", "New Form", "0", "0", "176.209.244.17", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-23 13:59:31", "2025-05-23 13:59:31", "2025-05-23 08:59:31", "2025-05-23 08:59:31");
INSERT INTO `j3nd_e_submissions` VALUES("92", "submission", "834c5e9d-c489-447e-b335-3e91ed9511d8", "367", "17", "", "", "fb84cc3", "New Form", "0", "0", "86.106.74.250", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-23 14:27:15", "2025-05-23 14:27:15", "2025-05-23 09:27:15", "2025-05-23 09:27:15");
INSERT INTO `j3nd_e_submissions` VALUES("93", "submission", "3f9c8704-8acb-4116-8343-b64eee53dee8", "371", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-23 14:31:44", "2025-05-23 14:31:44", "2025-05-23 09:31:44", "2025-05-23 09:31:44");
INSERT INTO `j3nd_e_submissions` VALUES("94", "submission", "df62cf8e-c073-4182-baa1-004f98631525", "375", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.19.223.202", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-23 22:29:27", "2025-05-23 22:29:27", "2025-05-23 17:29:27", "2025-05-23 17:29:27");
INSERT INTO `j3nd_e_submissions` VALUES("95", "submission", "65bc8e2c-7a7c-4a53-8cd8-015e4a046828", "379", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.195", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-24 02:59:15", "2025-05-24 02:59:15", "2025-05-23 21:59:15", "2025-05-23 21:59:15");
INSERT INTO `j3nd_e_submissions` VALUES("96", "submission", "5169d092-a1dc-46ce-bd32-8d3495d2a922", "383", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-24 07:56:22", "2025-05-24 07:56:22", "2025-05-24 02:56:22", "2025-05-24 02:56:22");
INSERT INTO `j3nd_e_submissions` VALUES("97", "submission", "aa09b417-4599-4caa-a37f-b722f9bb3328", "387", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-24 07:56:24", "2025-05-24 07:56:24", "2025-05-24 02:56:24", "2025-05-24 02:56:24");
INSERT INTO `j3nd_e_submissions` VALUES("98", "submission", "708ecec0-0b4c-4f4b-b8d6-6f8fb442cf96", "391", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.32", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-24 10:11:14", "2025-05-24 10:11:14", "2025-05-24 05:11:14", "2025-05-24 05:11:14");
INSERT INTO `j3nd_e_submissions` VALUES("99", "submission", "5fd01cc0-d4bb-4cb2-a947-976dfad48db1", "395", "17", "", "", "fb84cc3", "New Form", "0", "0", "31.43.185.65", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-24 21:56:10", "2025-05-24 21:56:10", "2025-05-24 16:56:10", "2025-05-24 16:56:10");
INSERT INTO `j3nd_e_submissions` VALUES("100", "submission", "a92101b1-9f84-4091-abfa-b8f80aa31b83", "399", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.195", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-24 23:47:59", "2025-05-24 23:47:59", "2025-05-24 18:47:59", "2025-05-24 18:47:59");
INSERT INTO `j3nd_e_submissions` VALUES("101", "submission", "c39f47f9-f83e-4f40-8fa2-b85fb455b82b", "403", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.19.223.101", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-25 06:33:49", "2025-05-25 06:33:49", "2025-05-25 01:33:49", "2025-05-25 01:33:49");
INSERT INTO `j3nd_e_submissions` VALUES("102", "submission", "bd2e251e-b735-430c-bc6c-02d506735541", "407", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.88.97.157", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-25 09:28:36", "2025-05-25 09:28:37", "2025-05-25 04:28:36", "2025-05-25 04:28:37");
INSERT INTO `j3nd_e_submissions` VALUES("103", "submission", "7765229b-8130-4084-b0f2-745a44c6ee55", "411", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.195", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-25 10:07:22", "2025-05-25 10:07:22", "2025-05-25 05:07:22", "2025-05-25 05:07:22");
INSERT INTO `j3nd_e_submissions` VALUES("104", "submission", "db900691-b0f4-4d9a-a978-c71c0e7d895e", "415", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.104.189.234", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-25 15:48:52", "2025-05-25 15:48:53", "2025-05-25 10:48:52", "2025-05-25 10:48:53");
INSERT INTO `j3nd_e_submissions` VALUES("105", "submission", "1df2b8e0-abf6-4262-8e13-f165e8a3fa66", "419", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "109.69.108.85", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-25 22:12:32", "2025-05-25 22:12:32", "2025-05-25 17:12:32", "2025-05-25 17:12:32");
INSERT INTO `j3nd_e_submissions` VALUES("106", "submission", "de6a1f28-ec97-4ea6-80c7-4584952d80b2", "423", "17", "", "", "fb84cc3", "New Form", "0", "0", "5.137.90.176", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-26 03:29:54", "2025-05-26 03:29:54", "2025-05-25 22:29:54", "2025-05-25 22:29:54");
INSERT INTO `j3nd_e_submissions` VALUES("107", "submission", "d889ad41-a5c1-4d49-a925-dce4add3a07a", "427", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.179.188.136", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-26 04:14:41", "2025-05-26 04:14:41", "2025-05-25 23:14:41", "2025-05-25 23:14:41");
INSERT INTO `j3nd_e_submissions` VALUES("108", "submission", "bc99c9ff-6fc5-4be2-9423-b1a70b9c1ca6", "431", "17", "", "", "fb84cc3", "New Form", "0", "0", "94.142.138.56", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-26 11:33:29", "2025-05-26 11:33:30", "2025-05-26 06:33:29", "2025-05-26 06:33:30");
INSERT INTO `j3nd_e_submissions` VALUES("109", "submission", "71c70deb-3e7c-432f-8460-c36970c1deb2", "435", "17", "", "", "fb84cc3", "New Form", "0", "0", "195.82.146.212", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-26 14:06:29", "2025-05-26 14:06:29", "2025-05-26 09:06:29", "2025-05-26 09:06:29");
INSERT INTO `j3nd_e_submissions` VALUES("110", "submission", "8b62549c-f418-4972-adb7-bee35300ccaa", "439", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.192.55.207", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-26 15:19:43", "2025-05-26 15:19:43", "2025-05-26 10:19:43", "2025-05-26 10:19:43");
INSERT INTO `j3nd_e_submissions` VALUES("111", "submission", "76c9e223-364b-4fd8-843f-2538a1f11ed0", "443", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.190.42.200", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-26 16:22:52", "2025-05-26 16:22:52", "2025-05-26 11:22:52", "2025-05-26 11:22:52");
INSERT INTO `j3nd_e_submissions` VALUES("112", "submission", "0ea4d18a-6b33-4961-b244-b41a93b2ae5e", "447", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.54.40.191", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-26 19:26:10", "2025-05-26 19:26:10", "2025-05-26 14:26:10", "2025-05-26 14:26:10");
INSERT INTO `j3nd_e_submissions` VALUES("113", "submission", "8ce187cf-7d6d-4202-914a-81094f338938", "451", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.77.56.148", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-27 11:42:07", "2025-05-27 11:42:07", "2025-05-27 06:42:07", "2025-05-27 06:42:07");
INSERT INTO `j3nd_e_submissions` VALUES("114", "submission", "5dc4aad8-3ab0-4a84-8c61-9d1044d37581", "455", "17", "", "", "fb84cc3", "New Form", "0", "0", "195.82.146.212", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-27 15:08:20", "2025-05-27 15:08:20", "2025-05-27 10:08:20", "2025-05-27 10:08:20");
INSERT INTO `j3nd_e_submissions` VALUES("115", "submission", "9af83764-e844-4e00-9489-118b7bcc961b", "459", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.84.177.118", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-27 22:03:17", "2025-05-27 22:03:17", "2025-05-27 17:03:17", "2025-05-27 17:03:17");
INSERT INTO `j3nd_e_submissions` VALUES("116", "submission", "211aafe6-67fa-4f2f-bdd9-e2d0df522ad3", "463", "17", "", "", "fb84cc3", "New Form", "0", "0", "130.195.221.172", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-28 14:35:34", "2025-05-28 14:35:34", "2025-05-28 09:35:34", "2025-05-28 09:35:34");
INSERT INTO `j3nd_e_submissions` VALUES("117", "submission", "416e62b5-9dfb-4e1d-b6e8-97f6297d03ec", "467", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.113.3.149", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-28 16:40:32", "2025-05-28 16:40:32", "2025-05-28 11:40:32", "2025-05-28 11:40:32");
INSERT INTO `j3nd_e_submissions` VALUES("118", "submission", "1f1c42b7-b148-47b3-8ad6-9c1a307dc876", "471", "17", "", "", "fb84cc3", "New Form", "0", "0", "80.92.206.106", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-28 17:49:09", "2025-05-28 17:49:09", "2025-05-28 12:49:09", "2025-05-28 12:49:09");
INSERT INTO `j3nd_e_submissions` VALUES("119", "submission", "711049f2-8e1e-441f-8476-150bcf7ece4e", "475", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.41.9.95", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-29 09:49:29", "2025-05-29 09:49:29", "2025-05-29 04:49:29", "2025-05-29 04:49:29");
INSERT INTO `j3nd_e_submissions` VALUES("120", "submission", "5d634afb-f2f6-416a-b4fb-681c87270d48", "479", "17", "", "", "fb84cc3", "New Form", "0", "0", "181.214.218.146", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-29 15:51:15", "2025-05-29 15:51:15", "2025-05-29 10:51:15", "2025-05-29 10:51:15");
INSERT INTO `j3nd_e_submissions` VALUES("121", "submission", "22d52a6c-32ef-47d1-a4a1-3f2318a80818", "483", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.207.67.228", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-29 22:17:15", "2025-05-29 22:17:15", "2025-05-29 17:17:15", "2025-05-29 17:17:15");
INSERT INTO `j3nd_e_submissions` VALUES("122", "submission", "6a04c7fb-36aa-4196-ab81-b1c298397ddd", "487", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.130.129.112", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-30 04:45:36", "2025-05-30 04:45:37", "2025-05-29 23:45:36", "2025-05-29 23:45:37");
INSERT INTO `j3nd_e_submissions` VALUES("123", "submission", "6583c54a-391c-4ef7-8be3-1947c6d4c07e", "491", "17", "", "", "fb84cc3", "New Form", "0", "0", "89.110.67.19", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-30 15:19:22", "2025-05-30 15:19:22", "2025-05-30 10:19:22", "2025-05-30 10:19:22");
INSERT INTO `j3nd_e_submissions` VALUES("124", "submission", "1068c64a-e986-40f5-b18a-36da1e19a1a0", "495", "17", "", "", "fb84cc3", "New Form", "0", "0", "129.227.46.182", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-30 16:29:28", "2025-05-30 16:29:28", "2025-05-30 11:29:28", "2025-05-30 11:29:28");
INSERT INTO `j3nd_e_submissions` VALUES("125", "submission", "6935fc7b-1ddd-4f0d-855d-f5ae8d0ba190", "499", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.205", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-30 19:05:12", "2025-05-30 19:05:12", "2025-05-30 14:05:12", "2025-05-30 14:05:12");
INSERT INTO `j3nd_e_submissions` VALUES("126", "submission", "541c99b3-1be6-45de-a67f-8628b0a91f14", "503", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.173", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-30 19:40:23", "2025-05-30 19:40:23", "2025-05-30 14:40:23", "2025-05-30 14:40:23");
INSERT INTO `j3nd_e_submissions` VALUES("127", "submission", "a92081d3-b2a0-40fc-9900-365e79d68e46", "507", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.171", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-30 20:28:58", "2025-05-30 20:28:58", "2025-05-30 15:28:58", "2025-05-30 15:28:58");
INSERT INTO `j3nd_e_submissions` VALUES("128", "submission", "b959fcad-ce6c-486a-97b7-8ea5400af45b", "511", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.202", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-30 20:49:34", "2025-05-30 20:49:34", "2025-05-30 15:49:34", "2025-05-30 15:49:34");
INSERT INTO `j3nd_e_submissions` VALUES("129", "submission", "16cd1040-f2ae-4853-ab8d-5253c3c8e517", "515", "17", "", "", "fb84cc3", "New Form", "0", "0", "191.96.67.230", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-30 23:41:49", "2025-05-30 23:41:49", "2025-05-30 18:41:49", "2025-05-30 18:41:49");
INSERT INTO `j3nd_e_submissions` VALUES("130", "submission", "cc9c8606-245d-4451-b283-2c8200b726ed", "519", "17", "", "", "fb84cc3", "New Form", "0", "0", "181.214.218.232", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-31 11:42:45", "2025-05-31 11:42:45", "2025-05-31 06:42:45", "2025-05-31 06:42:45");
INSERT INTO `j3nd_e_submissions` VALUES("131", "submission", "bc575af5-96ee-41c6-a7d2-650f8348d873", "523", "17", "", "", "fb84cc3", "New Form", "0", "0", "203.188.190.35", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-31 14:57:37", "2025-05-31 14:57:37", "2025-05-31 09:57:37", "2025-05-31 09:57:37");
INSERT INTO `j3nd_e_submissions` VALUES("132", "submission", "c7441862-c1d3-42a8-86d6-65e8ec0246a4", "527", "17", "", "", "fb84cc3", "New Form", "0", "0", "195.82.146.213", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-05-31 16:30:26", "2025-05-31 16:30:26", "2025-05-31 11:30:26", "2025-05-31 11:30:26");
INSERT INTO `j3nd_e_submissions` VALUES("133", "submission", "180f95dc-4a4d-4e70-bb71-197ae78507cb", "531", "17", "", "", "fb84cc3", "New Form", "0", "0", "195.82.146.211", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-01 12:22:51", "2025-06-01 12:22:51", "2025-06-01 07:22:51", "2025-06-01 07:22:51");
INSERT INTO `j3nd_e_submissions` VALUES("134", "submission", "4463c3e9-0794-478f-93a3-c9cdcc0927fc", "535", "17", "", "", "fb84cc3", "New Form", "0", "0", "155.2.217.18", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-01 14:18:24", "2025-06-01 14:18:24", "2025-06-01 09:18:24", "2025-06-01 09:18:24");
INSERT INTO `j3nd_e_submissions` VALUES("135", "submission", "3bcff009-7d4b-43ca-a8ac-c17524ce1b55", "539", "17", "", "", "fb84cc3", "New Form", "0", "0", "158.69.119.16", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-01 20:43:06", "2025-06-01 20:43:07", "2025-06-01 15:43:06", "2025-06-01 15:43:07");
INSERT INTO `j3nd_e_submissions` VALUES("136", "submission", "ea4eff67-007c-4e93-b07a-d520ef77a3e9", "543", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.154.138.93", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-02 08:50:10", "2025-06-02 08:50:10", "2025-06-02 03:50:10", "2025-06-02 03:50:10");
INSERT INTO `j3nd_e_submissions` VALUES("137", "submission", "fc07e2c7-cba7-4d8c-97eb-2eb76da9d004", "547", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.20", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-02 09:03:50", "2025-06-02 09:03:50", "2025-06-02 04:03:50", "2025-06-02 04:03:50");
INSERT INTO `j3nd_e_submissions` VALUES("138", "submission", "27caef6a-0484-45d0-87d6-6ea793f5d4b4", "551", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.84.96.179", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-02 10:46:19", "2025-06-02 10:46:19", "2025-06-02 05:46:19", "2025-06-02 05:46:19");
INSERT INTO `j3nd_e_submissions` VALUES("139", "submission", "7664df2d-464c-4cb5-ba12-9f0a987250c6", "555", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.99", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-02 11:05:27", "2025-06-02 11:05:27", "2025-06-02 06:05:27", "2025-06-02 06:05:27");
INSERT INTO `j3nd_e_submissions` VALUES("140", "submission", "82dc9b17-aef7-4898-8960-2f4e9d1d60d4", "559", "17", "", "", "fb84cc3", "New Form", "0", "0", "46.8.193.63", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-02 14:56:59", "2025-06-02 14:56:59", "2025-06-02 09:56:59", "2025-06-02 09:56:59");
INSERT INTO `j3nd_e_submissions` VALUES("141", "submission", "4c437cc5-84ea-4c8c-bbc8-35485a41058b", "563", "17", "", "", "fb84cc3", "New Form", "0", "0", "195.82.146.213", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-02 19:11:50", "2025-06-02 19:11:50", "2025-06-02 14:11:50", "2025-06-02 14:11:50");
INSERT INTO `j3nd_e_submissions` VALUES("142", "submission", "c5fd69e7-7d12-487d-8d34-6a223a6f3542", "567", "17", "", "", "fb84cc3", "New Form", "0", "0", "83.143.242.18", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-02 21:10:31", "2025-06-02 21:10:31", "2025-06-02 16:10:31", "2025-06-02 16:10:31");
INSERT INTO `j3nd_e_submissions` VALUES("143", "submission", "1fd245a3-b0b3-45d1-8cca-f481b5cdfdc8", "571", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.8.17.148", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-03 09:31:41", "2025-06-03 09:31:41", "2025-06-03 04:31:41", "2025-06-03 04:31:41");
INSERT INTO `j3nd_e_submissions` VALUES("144", "submission", "4943fe68-89b0-4fc8-ad37-00600eb7ff9e", "575", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.32", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-03 12:41:17", "2025-06-03 12:41:17", "2025-06-03 07:41:17", "2025-06-03 07:41:17");
INSERT INTO `j3nd_e_submissions` VALUES("145", "submission", "db34dbeb-3b20-46e8-9417-c3517f6d3f28", "579", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.32", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-03 12:41:18", "2025-06-03 12:41:18", "2025-06-03 07:41:18", "2025-06-03 07:41:18");
INSERT INTO `j3nd_e_submissions` VALUES("146", "submission", "7f57007d-27ea-48bf-8781-97fc065e9869", "583", "17", "", "", "fb84cc3", "New Form", "0", "0", "89.208.106.223", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-03 15:18:35", "2025-06-03 15:18:35", "2025-06-03 10:18:35", "2025-06-03 10:18:35");
INSERT INTO `j3nd_e_submissions` VALUES("147", "submission", "639ae4ab-dc16-42fb-9429-b0a6f87fe615", "587", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.108.239", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-03 16:51:53", "2025-06-03 16:51:53", "2025-06-03 11:51:53", "2025-06-03 11:51:53");
INSERT INTO `j3nd_e_submissions` VALUES("148", "submission", "b70764a9-5e80-458b-9bcc-9a2c1d7e9ed6", "591", "17", "", "", "fb84cc3", "New Form", "0", "0", "158.69.118.188", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-03 21:35:39", "2025-06-03 21:35:39", "2025-06-03 16:35:39", "2025-06-03 16:35:39");
INSERT INTO `j3nd_e_submissions` VALUES("149", "submission", "30e1644e-8a5a-4ea3-be1b-53214a688b9e", "595", "17", "", "", "fb84cc3", "New Form", "0", "0", "89.110.87.170", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-04 05:57:58", "2025-06-04 05:57:58", "2025-06-04 00:57:58", "2025-06-04 00:57:58");
INSERT INTO `j3nd_e_submissions` VALUES("150", "submission", "ad1908f2-172a-4ed0-9f65-8e8f76e96e2f", "599", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.202", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-04 07:49:07", "2025-06-04 07:49:07", "2025-06-04 02:49:07", "2025-06-04 02:49:07");
INSERT INTO `j3nd_e_submissions` VALUES("151", "submission", "e814a146-1fbd-40e4-95c3-3d43a69125d4", "603", "17", "http://www.mateoracksperu.com/", "", "fb84cc3", "New Form", "0", "0", "38.180.54.133", "Mozilla/5.0 (Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-04 15:59:52", "2025-06-04 15:59:52", "2025-06-04 10:59:52", "2025-06-04 10:59:52");
INSERT INTO `j3nd_e_submissions` VALUES("152", "submission", "7edf7cdd-2531-496d-b954-dde59fc032e5", "607", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.159", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-04 16:32:02", "2025-06-04 16:32:02", "2025-06-04 11:32:02", "2025-06-04 11:32:02");
INSERT INTO `j3nd_e_submissions` VALUES("153", "submission", "63e9ed18-0b70-4d87-9ece-5bb5cf4cbc39", "611", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.179", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-05 02:09:14", "2025-06-05 02:09:14", "2025-06-04 21:09:14", "2025-06-04 21:09:14");
INSERT INTO `j3nd_e_submissions` VALUES("154", "submission", "d7377e86-8e59-4c46-9670-fb698aef9723", "615", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.191", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-05 02:48:36", "2025-06-05 02:48:36", "2025-06-04 21:48:36", "2025-06-04 21:48:36");
INSERT INTO `j3nd_e_submissions` VALUES("155", "submission", "ac0e98fc-b434-4fba-ae64-b2696b76e781", "619", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.158", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-05 02:51:15", "2025-06-05 02:51:15", "2025-06-04 21:51:15", "2025-06-04 21:51:15");
INSERT INTO `j3nd_e_submissions` VALUES("156", "submission", "f253c81e-e55b-432a-b582-fcd945d2e2d9", "623", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-05 04:10:19", "2025-06-05 04:10:19", "2025-06-04 23:10:19", "2025-06-04 23:10:19");
INSERT INTO `j3nd_e_submissions` VALUES("157", "submission", "e0845078-5e58-4bdd-be88-bbfb53ad5309", "627", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.181", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-05 06:44:31", "2025-06-05 06:44:31", "2025-06-05 01:44:31", "2025-06-05 01:44:31");
INSERT INTO `j3nd_e_submissions` VALUES("158", "submission", "4537f03e-4eec-4383-aae4-90747c1017f6", "631", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.181.137.80", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-05 07:21:46", "2025-06-05 07:21:46", "2025-06-05 02:21:46", "2025-06-05 02:21:46");
INSERT INTO `j3nd_e_submissions` VALUES("159", "submission", "9d5a2741-691c-45c1-a358-d5e707fdec44", "635", "17", "", "", "fb84cc3", "New Form", "0", "0", "69.167.29.7", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-05 09:13:07", "2025-06-05 09:13:07", "2025-06-05 04:13:07", "2025-06-05 04:13:07");
INSERT INTO `j3nd_e_submissions` VALUES("160", "submission", "cd6b29cc-d8b7-4c53-a3aa-0d5b04f42382", "639", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.86.203.105", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-05 13:12:11", "2025-06-05 13:12:12", "2025-06-05 08:12:11", "2025-06-05 08:12:12");
INSERT INTO `j3nd_e_submissions` VALUES("161", "submission", "c9833f12-7f1d-4b08-8f4d-d404e7eccad1", "643", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.44.250", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-05 13:30:58", "2025-06-05 13:30:58", "2025-06-05 08:30:58", "2025-06-05 08:30:58");
INSERT INTO `j3nd_e_submissions` VALUES("162", "submission", "59994b72-fbee-4612-8066-647b9aacbbcc", "647", "17", "", "", "fb84cc3", "New Form", "0", "0", "91.84.102.194", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-05 13:56:17", "2025-06-05 13:56:17", "2025-06-05 08:56:17", "2025-06-05 08:56:17");
INSERT INTO `j3nd_e_submissions` VALUES("163", "submission", "e243e2d6-e84f-4072-98d4-08931dd4a476", "651", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.242", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-05 14:39:27", "2025-06-05 14:39:27", "2025-06-05 09:39:27", "2025-06-05 09:39:27");
INSERT INTO `j3nd_e_submissions` VALUES("164", "submission", "579ebe9c-5547-461d-833f-79a77583d35c", "655", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.244", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-05 16:36:11", "2025-06-05 16:36:11", "2025-06-05 11:36:11", "2025-06-05 11:36:11");
INSERT INTO `j3nd_e_submissions` VALUES("165", "submission", "2f05e3b3-c400-495c-9024-4c90dd0d7bba", "659", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.91.21.6", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-05 19:31:40", "2025-06-05 19:31:40", "2025-06-05 14:31:40", "2025-06-05 14:31:40");
INSERT INTO `j3nd_e_submissions` VALUES("166", "submission", "d24f3340-9436-4701-947e-20a538f2bde1", "663", "17", "", "", "fb84cc3", "New Form", "0", "0", "3.129.209.77", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-05 22:05:51", "2025-06-05 22:05:51", "2025-06-05 17:05:51", "2025-06-05 17:05:51");
INSERT INTO `j3nd_e_submissions` VALUES("167", "submission", "981eabc7-14fe-4bc7-ac67-76329542b0d4", "667", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.187.29.153", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-06 10:21:41", "2025-06-06 10:21:41", "2025-06-06 05:21:41", "2025-06-06 05:21:41");
INSERT INTO `j3nd_e_submissions` VALUES("168", "submission", "4b9d88bc-04c4-49e6-9550-739467562298", "671", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-06 11:50:17", "2025-06-06 11:50:17", "2025-06-06 06:50:17", "2025-06-06 06:50:17");
INSERT INTO `j3nd_e_submissions` VALUES("169", "submission", "80df5374-58ea-4384-8386-cec5c46b69a8", "675", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-06 14:59:57", "2025-06-06 14:59:57", "2025-06-06 09:59:57", "2025-06-06 09:59:57");
INSERT INTO `j3nd_e_submissions` VALUES("170", "submission", "09bd1cd1-09b6-4b23-bcec-a90a78439172", "679", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.229", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-06 15:23:31", "2025-06-06 15:23:31", "2025-06-06 10:23:31", "2025-06-06 10:23:31");
INSERT INTO `j3nd_e_submissions` VALUES("171", "submission", "bca06184-9c34-4800-a41b-b4dfc40ada82", "683", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.54.135.119", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-06 18:19:43", "2025-06-06 18:19:43", "2025-06-06 13:19:43", "2025-06-06 13:19:43");
INSERT INTO `j3nd_e_submissions` VALUES("172", "submission", "d83b785a-19a4-46d1-9b10-687bc951cb2a", "687", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.11.21.173", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-06 21:29:56", "2025-06-06 21:29:56", "2025-06-06 16:29:56", "2025-06-06 16:29:56");
INSERT INTO `j3nd_e_submissions` VALUES("173", "submission", "4d93e0c9-1d78-409c-a450-c2b415ac4cd2", "691", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-07 04:21:09", "2025-06-07 04:21:09", "2025-06-06 23:21:09", "2025-06-06 23:21:09");
INSERT INTO `j3nd_e_submissions` VALUES("174", "submission", "2b19b7cb-77f9-40f7-bec6-4c66138be726", "695", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-07 04:31:55", "2025-06-07 04:31:55", "2025-06-06 23:31:55", "2025-06-06 23:31:55");
INSERT INTO `j3nd_e_submissions` VALUES("175", "submission", "32fa36ad-88ea-402c-84cb-63a75d6700ef", "699", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.126.94.214", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-07 13:46:12", "2025-06-07 13:46:12", "2025-06-07 08:46:12", "2025-06-07 08:46:12");
INSERT INTO `j3nd_e_submissions` VALUES("176", "submission", "18cf3a58-9e23-4a8f-b19d-0681e626da6c", "703", "17", "", "", "fb84cc3", "New Form", "0", "0", "196.196.52.5", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-07 15:56:13", "2025-06-07 15:56:13", "2025-06-07 10:56:13", "2025-06-07 10:56:13");
INSERT INTO `j3nd_e_submissions` VALUES("177", "submission", "230c6786-2340-485a-b98d-1163a40b2051", "707", "17", "", "", "fb84cc3", "New Form", "0", "0", "83.67.232.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-07 16:03:30", "2025-06-07 16:03:30", "2025-06-07 11:03:30", "2025-06-07 11:03:30");
INSERT INTO `j3nd_e_submissions` VALUES("178", "submission", "25caa8e6-9b55-4e6b-a87c-5971c59fc55a", "711", "17", "", "", "fb84cc3", "New Form", "0", "0", "154.213.163.183", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-07 16:13:54", "2025-06-07 16:13:54", "2025-06-07 11:13:54", "2025-06-07 11:13:54");
INSERT INTO `j3nd_e_submissions` VALUES("179", "submission", "122a6498-c301-42c9-86b6-3c452d4b32dd", "715", "17", "", "", "fb84cc3", "New Form", "0", "0", "196.196.52.6", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-07 18:35:02", "2025-06-07 18:35:03", "2025-06-07 13:35:02", "2025-06-07 13:35:03");
INSERT INTO `j3nd_e_submissions` VALUES("180", "submission", "cb8c9d24-03f0-45da-bb17-2d38872f165b", "719", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.206.169.11", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-07 23:57:32", "2025-06-07 23:57:32", "2025-06-07 18:57:32", "2025-06-07 18:57:32");
INSERT INTO `j3nd_e_submissions` VALUES("181", "submission", "614cf5e8-a66f-4168-8557-6829865d675e", "723", "17", "", "", "fb84cc3", "New Form", "0", "0", "46.246.8.77", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-08 01:41:00", "2025-06-08 01:41:01", "2025-06-07 20:41:00", "2025-06-07 20:41:01");
INSERT INTO `j3nd_e_submissions` VALUES("182", "submission", "a80a4053-b640-4dff-835b-4800c8b05af6", "727", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.34.109", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-08 04:21:55", "2025-06-08 04:21:56", "2025-06-07 23:21:55", "2025-06-07 23:21:56");
INSERT INTO `j3nd_e_submissions` VALUES("183", "submission", "40f33ae7-fe45-49d2-bd48-2ad5ac259f0d", "731", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.116.213", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-08 12:02:57", "2025-06-08 12:02:57", "2025-06-08 07:02:57", "2025-06-08 07:02:57");
INSERT INTO `j3nd_e_submissions` VALUES("184", "submission", "b30d5076-94f6-443c-b1ad-ac1f0a0ffb56", "735", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.34.148", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-08 15:16:24", "2025-06-08 15:16:24", "2025-06-08 10:16:24", "2025-06-08 10:16:24");
INSERT INTO `j3nd_e_submissions` VALUES("185", "submission", "d13fbe23-71e0-4a6b-ae07-56d0de7ab9c2", "739", "17", "", "", "fb84cc3", "New Form", "0", "0", "31.43.185.65", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-09 03:08:58", "2025-06-09 03:08:58", "2025-06-08 22:08:58", "2025-06-08 22:08:58");
INSERT INTO `j3nd_e_submissions` VALUES("186", "submission", "bb95a67a-36fd-4f08-b2d8-ed22e067dca5", "743", "17", "", "", "fb84cc3", "New Form", "0", "0", "5.142.206.152", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-09 07:55:09", "2025-06-09 07:55:10", "2025-06-09 02:55:09", "2025-06-09 02:55:10");
INSERT INTO `j3nd_e_submissions` VALUES("187", "submission", "998da595-3fda-424a-9b42-11ba63ecdf46", "747", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-09 16:00:12", "2025-06-09 16:00:12", "2025-06-09 11:00:12", "2025-06-09 11:00:12");
INSERT INTO `j3nd_e_submissions` VALUES("188", "submission", "9042afa9-fc05-43fa-8749-4fc898133efd", "751", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.84.96.179", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-10 01:27:14", "2025-06-10 01:27:14", "2025-06-09 20:27:14", "2025-06-09 20:27:14");
INSERT INTO `j3nd_e_submissions` VALUES("189", "submission", "a1237242-1595-48d6-ad80-ad2f91b697d1", "755", "17", "", "", "fb84cc3", "New Form", "0", "0", "31.171.130.93", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-10 06:10:17", "2025-06-10 06:10:17", "2025-06-10 01:10:17", "2025-06-10 01:10:17");
INSERT INTO `j3nd_e_submissions` VALUES("190", "submission", "2d1f2cfb-a79e-41ad-a8bc-dcf81f963fe8", "759", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.128.199.191", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-10 07:27:10", "2025-06-10 07:27:10", "2025-06-10 02:27:10", "2025-06-10 02:27:10");
INSERT INTO `j3nd_e_submissions` VALUES("191", "submission", "48886b7f-a89d-45b8-beda-ca3e4eeba48c", "763", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.195", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-10 07:32:41", "2025-06-10 07:32:41", "2025-06-10 02:32:41", "2025-06-10 02:32:41");
INSERT INTO `j3nd_e_submissions` VALUES("192", "submission", "f9c28cd5-f29a-4811-b4ed-e9b68c135f1d", "767", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.102.37.187", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Herring/95.1.8810.11", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-10 08:59:26", "2025-06-10 08:59:27", "2025-06-10 03:59:26", "2025-06-10 03:59:27");
INSERT INTO `j3nd_e_submissions` VALUES("193", "submission", "17352fe9-6c3e-4db8-bdae-a9bf02b0c6de", "771", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.128.199.240", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-10 09:15:14", "2025-06-10 09:15:14", "2025-06-10 04:15:14", "2025-06-10 04:15:14");
INSERT INTO `j3nd_e_submissions` VALUES("194", "submission", "ddd48b39-f835-4a24-8442-dc74069f08f9", "775", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.126.94.234", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-10 18:30:38", "2025-06-10 18:30:38", "2025-06-10 13:30:38", "2025-06-10 13:30:38");
INSERT INTO `j3nd_e_submissions` VALUES("195", "submission", "3346bd1f-6cf3-431f-b2f0-69667775e2cf", "779", "17", "", "", "fb84cc3", "New Form", "0", "0", "91.84.102.194", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-10 22:50:20", "2025-06-10 22:50:21", "2025-06-10 17:50:20", "2025-06-10 17:50:21");
INSERT INTO `j3nd_e_submissions` VALUES("196", "submission", "ada8f3be-0d6b-4634-b6f6-53a2ad96fdad", "783", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.130.218.240", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-11 06:31:25", "2025-06-11 06:31:25", "2025-06-11 01:31:25", "2025-06-11 01:31:25");
INSERT INTO `j3nd_e_submissions` VALUES("197", "submission", "369878fc-0627-4010-9fb4-86ae03a22d82", "787", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.84.98.145", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-11 11:53:44", "2025-06-11 11:53:44", "2025-06-11 06:53:44", "2025-06-11 06:53:44");
INSERT INTO `j3nd_e_submissions` VALUES("198", "submission", "631e0128-01d7-4d5a-adc1-6c7fad0bae5c", "791", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.192.69.157", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-11 13:01:46", "2025-06-11 13:01:46", "2025-06-11 08:01:46", "2025-06-11 08:01:46");
INSERT INTO `j3nd_e_submissions` VALUES("199", "submission", "715b7491-e732-4aa4-920a-118cb5ff5cab", "795", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.30.37.90", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-11 13:41:46", "2025-06-11 13:41:46", "2025-06-11 08:41:46", "2025-06-11 08:41:46");
INSERT INTO `j3nd_e_submissions` VALUES("200", "submission", "20a089ea-c66c-40f4-8f18-b12d3c242582", "799", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.97", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-11 21:48:55", "2025-06-11 21:48:55", "2025-06-11 16:48:55", "2025-06-11 16:48:55");
INSERT INTO `j3nd_e_submissions` VALUES("201", "submission", "8ad76d96-2b85-4e81-9481-03e64e17ce67", "803", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.15.176", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-12 02:04:54", "2025-06-12 02:04:54", "2025-06-11 21:04:54", "2025-06-11 21:04:54");
INSERT INTO `j3nd_e_submissions` VALUES("202", "submission", "dbe5aee1-e615-42bb-831b-eadb352dba93", "807", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-13 02:05:18", "2025-06-13 02:05:19", "2025-06-12 21:05:18", "2025-06-12 21:05:19");
INSERT INTO `j3nd_e_submissions` VALUES("203", "submission", "b920e0d7-b5d0-47c5-b0d8-6bd1752e794f", "811", "17", "", "", "fb84cc3", "New Form", "0", "0", "172.120.81.91", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-13 05:36:15", "2025-06-13 05:36:15", "2025-06-13 00:36:15", "2025-06-13 00:36:15");
INSERT INTO `j3nd_e_submissions` VALUES("204", "submission", "5b38d514-ff97-4c2b-a5bd-c2918339da1b", "815", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.86.200.186", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-13 09:56:35", "2025-06-13 09:56:35", "2025-06-13 04:56:35", "2025-06-13 04:56:35");
INSERT INTO `j3nd_e_submissions` VALUES("205", "submission", "f82bfb96-1eaa-4574-90cf-6186bab32627", "819", "17", "", "", "fb84cc3", "New Form", "0", "0", "83.67.232.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-13 10:25:17", "2025-06-13 10:25:18", "2025-06-13 05:25:17", "2025-06-13 05:25:18");
INSERT INTO `j3nd_e_submissions` VALUES("206", "submission", "45a4f374-0bc2-420e-9d07-6a9bd7c82785", "823", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.84.96.179", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-13 12:45:42", "2025-06-13 12:45:42", "2025-06-13 07:45:42", "2025-06-13 07:45:42");
INSERT INTO `j3nd_e_submissions` VALUES("207", "submission", "2df16193-aafa-4110-a58b-d88ae4614ca9", "827", "17", "", "", "fb84cc3", "New Form", "0", "0", "195.82.146.212", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-13 15:34:57", "2025-06-13 15:34:57", "2025-06-13 10:34:57", "2025-06-13 10:34:57");
INSERT INTO `j3nd_e_submissions` VALUES("208", "submission", "1803e6d8-e54f-444c-9c75-a214969718fb", "831", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.147.88.88", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-13 15:38:26", "2025-06-13 15:38:26", "2025-06-13 10:38:26", "2025-06-13 10:38:26");
INSERT INTO `j3nd_e_submissions` VALUES("209", "submission", "8452eee8-57e5-4dd3-ad64-faa35e45e1c7", "835", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-14 05:45:43", "2025-06-14 05:45:43", "2025-06-14 00:45:43", "2025-06-14 00:45:43");
INSERT INTO `j3nd_e_submissions` VALUES("210", "submission", "a2e53370-f0cf-4f7f-9863-6ce8b3d75bfb", "839", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.95.243.89", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-14 06:30:47", "2025-06-14 06:30:47", "2025-06-14 01:30:47", "2025-06-14 01:30:47");
INSERT INTO `j3nd_e_submissions` VALUES("211", "submission", "313aa681-fd33-4038-95e0-51c8963976df", "843", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.63", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-14 07:00:46", "2025-06-14 07:00:46", "2025-06-14 02:00:46", "2025-06-14 02:00:46");
INSERT INTO `j3nd_e_submissions` VALUES("212", "submission", "43b76311-68be-499d-ab9f-30b939e4190e", "847", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.72", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-14 08:26:27", "2025-06-14 08:26:27", "2025-06-14 03:26:27", "2025-06-14 03:26:27");
INSERT INTO `j3nd_e_submissions` VALUES("213", "submission", "18916022-5997-4378-bec8-23b8017dac51", "851", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.30.32", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-14 09:45:27", "2025-06-14 09:45:27", "2025-06-14 04:45:27", "2025-06-14 04:45:27");
INSERT INTO `j3nd_e_submissions` VALUES("214", "submission", "e4fcd668-298f-467b-ba9a-b5be0caed787", "855", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.30.49", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-14 10:11:19", "2025-06-14 10:11:19", "2025-06-14 05:11:19", "2025-06-14 05:11:19");
INSERT INTO `j3nd_e_submissions` VALUES("215", "submission", "96e34225-0758-4b5e-bce5-c7699122f0af", "859", "17", "", "", "fb84cc3", "New Form", "0", "0", "203.188.182.31", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-14 12:07:15", "2025-06-14 12:07:15", "2025-06-14 07:07:15", "2025-06-14 07:07:15");
INSERT INTO `j3nd_e_submissions` VALUES("216", "submission", "fd23aee7-8b62-4eba-8cb5-9838525efaa4", "863", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-14 14:47:14", "2025-06-14 14:47:14", "2025-06-14 09:47:14", "2025-06-14 09:47:14");
INSERT INTO `j3nd_e_submissions` VALUES("217", "submission", "b9794bf7-b123-4a7a-bc5a-79ad9eff32af", "867", "17", "", "", "fb84cc3", "New Form", "0", "0", "46.8.155.215", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-14 15:10:55", "2025-06-14 15:10:55", "2025-06-14 10:10:55", "2025-06-14 10:10:55");
INSERT INTO `j3nd_e_submissions` VALUES("218", "submission", "ac402afa-ac5d-407d-9468-7917c70ece98", "871", "17", "", "", "fb84cc3", "New Form", "0", "0", "93.81.249.57", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-14 17:31:49", "2025-06-14 17:31:50", "2025-06-14 12:31:49", "2025-06-14 12:31:50");
INSERT INTO `j3nd_e_submissions` VALUES("219", "submission", "2b73d943-1a53-45f8-b07a-73d119451239", "875", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.130.136.42", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-14 21:37:33", "2025-06-14 21:37:33", "2025-06-14 16:37:33", "2025-06-14 16:37:33");
INSERT INTO `j3nd_e_submissions` VALUES("220", "submission", "1bd40c34-ae5f-4b92-84d9-4bf94f5dbe57", "879", "17", "http://www.mateoracksperu.com/", "", "fb84cc3", "New Form", "0", "0", "38.180.54.133", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-14 22:15:53", "2025-06-14 22:15:53", "2025-06-14 17:15:53", "2025-06-14 17:15:53");
INSERT INTO `j3nd_e_submissions` VALUES("221", "submission", "fad71e5d-bfae-43a4-9825-7a652d012bb0", "883", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.202", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-15 05:23:10", "2025-06-15 05:23:10", "2025-06-15 00:23:10", "2025-06-15 00:23:10");
INSERT INTO `j3nd_e_submissions` VALUES("222", "submission", "bf28af04-1a6b-4059-a77c-975e38eafd12", "887", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.194.178.31", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-15 06:49:11", "2025-06-15 06:49:11", "2025-06-15 01:49:11", "2025-06-15 01:49:11");
INSERT INTO `j3nd_e_submissions` VALUES("223", "submission", "a4f572d1-01f8-452f-92fc-cee9d83f1e88", "891", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.196", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-15 07:54:05", "2025-06-15 07:54:05", "2025-06-15 02:54:05", "2025-06-15 02:54:05");
INSERT INTO `j3nd_e_submissions` VALUES("224", "submission", "6cb2074d-eb4e-4f11-b5dd-2361f785c55f", "895", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.194.178.37", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-15 08:24:21", "2025-06-15 08:24:21", "2025-06-15 03:24:21", "2025-06-15 03:24:21");
INSERT INTO `j3nd_e_submissions` VALUES("225", "submission", "bcd0d84c-13cd-4747-8e38-659c25d6f3b7", "899", "17", "", "", "fb84cc3", "New Form", "0", "0", "5.142.221.169", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-16 02:50:19", "2025-06-16 02:50:19", "2025-06-15 21:50:19", "2025-06-15 21:50:19");
INSERT INTO `j3nd_e_submissions` VALUES("226", "submission", "9607e4bb-12b9-4e74-a48e-2bb5be58bb84", "903", "17", "", "", "fb84cc3", "New Form", "0", "0", "94.142.138.56", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-16 05:50:09", "2025-06-16 05:50:09", "2025-06-16 00:50:09", "2025-06-16 00:50:09");
INSERT INTO `j3nd_e_submissions` VALUES("227", "submission", "7c2ae95e-6a4f-44ea-a933-e3a2c9b3b620", "907", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.84.96.179", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-16 07:47:32", "2025-06-16 07:47:32", "2025-06-16 02:47:32", "2025-06-16 02:47:32");
INSERT INTO `j3nd_e_submissions` VALUES("228", "submission", "e2f5a502-caef-4484-b8f0-b41cb7e7e131", "911", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-16 18:10:15", "2025-06-16 18:10:15", "2025-06-16 13:10:15", "2025-06-16 13:10:15");
INSERT INTO `j3nd_e_submissions` VALUES("229", "submission", "4886291f-02c5-41f5-a204-47d7824124a9", "915", "17", "", "", "fb84cc3", "New Form", "0", "0", "154.213.203.209", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-16 23:56:06", "2025-06-16 23:56:06", "2025-06-16 18:56:06", "2025-06-16 18:56:06");
INSERT INTO `j3nd_e_submissions` VALUES("230", "submission", "dada2a8a-c5ff-405f-ad08-50a8ed9a3113", "919", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.77.222.46", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-17 07:52:01", "2025-06-17 07:52:02", "2025-06-17 02:52:01", "2025-06-17 02:52:02");
INSERT INTO `j3nd_e_submissions` VALUES("231", "submission", "87a85a95-6d83-496e-9e8e-0a9d423e0915", "923", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.17.48.64", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-17 09:31:43", "2025-06-17 09:31:44", "2025-06-17 04:31:43", "2025-06-17 04:31:44");
INSERT INTO `j3nd_e_submissions` VALUES("232", "submission", "90bc3ef5-3082-41b3-b658-0edc97ca8276", "927", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.163.5.64", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 00:59:46", "2025-06-18 00:59:46", "2025-06-17 19:59:46", "2025-06-17 19:59:46");
INSERT INTO `j3nd_e_submissions` VALUES("233", "submission", "70036c68-077f-46e2-bd65-30e2aedf2c2b", "931", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.224", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 02:29:57", "2025-06-18 02:29:57", "2025-06-17 21:29:57", "2025-06-17 21:29:57");
INSERT INTO `j3nd_e_submissions` VALUES("234", "submission", "4ba0b5ac-f1ef-46e5-ac4d-8a9f4ee1d6c0", "935", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.194.178.40", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 03:35:15", "2025-06-18 03:35:15", "2025-06-17 22:35:15", "2025-06-17 22:35:15");
INSERT INTO `j3nd_e_submissions` VALUES("235", "submission", "9e696e7b-d785-422c-ad97-f7353fe95340", "939", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.194.178.26", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 03:36:55", "2025-06-18 03:36:55", "2025-06-17 22:36:55", "2025-06-17 22:36:55");
INSERT INTO `j3nd_e_submissions` VALUES("236", "submission", "53eae0ba-ddc2-4fd4-83c0-8e01ae050e1c", "943", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 04:24:08", "2025-06-18 04:24:08", "2025-06-17 23:24:08", "2025-06-17 23:24:08");
INSERT INTO `j3nd_e_submissions` VALUES("237", "submission", "5e119b86-41a4-4d27-9a61-0baa19fa8572", "947", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.231", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 06:44:32", "2025-06-18 06:44:32", "2025-06-18 01:44:32", "2025-06-18 01:44:32");
INSERT INTO `j3nd_e_submissions` VALUES("238", "submission", "4952bfda-fcb3-4243-9eee-5b1f198f64ec", "951", "17", "", "", "fb84cc3", "New Form", "0", "0", "194.127.173.106", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 07:57:58", "2025-06-18 07:57:59", "2025-06-18 02:57:58", "2025-06-18 02:57:59");
INSERT INTO `j3nd_e_submissions` VALUES("239", "submission", "03aed265-80de-4d53-b4e1-da370949365b", "955", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.147.213.251", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 08:02:06", "2025-06-18 08:02:06", "2025-06-18 03:02:06", "2025-06-18 03:02:06");
INSERT INTO `j3nd_e_submissions` VALUES("240", "submission", "3fee4fb1-1ad2-4494-ab60-e9078abac3df", "959", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.36.92", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 09:54:14", "2025-06-18 09:54:14", "2025-06-18 04:54:14", "2025-06-18 04:54:14");
INSERT INTO `j3nd_e_submissions` VALUES("241", "submission", "04a7afe2-22a7-4881-88f8-d9ec8ae0d57e", "963", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.194.178.98", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 12:06:15", "2025-06-18 12:06:15", "2025-06-18 07:06:15", "2025-06-18 07:06:15");
INSERT INTO `j3nd_e_submissions` VALUES("242", "submission", "05e974ef-03c4-445c-b945-3b1449c792b6", "967", "17", "", "", "fb84cc3", "New Form", "0", "0", "195.82.146.212", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 13:02:02", "2025-06-18 13:02:03", "2025-06-18 08:02:02", "2025-06-18 08:02:03");
INSERT INTO `j3nd_e_submissions` VALUES("243", "submission", "3f9e6ac8-8efa-4fd3-b7ef-7cf2d339058c", "971", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.229", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 13:14:38", "2025-06-18 13:14:38", "2025-06-18 08:14:38", "2025-06-18 08:14:38");
INSERT INTO `j3nd_e_submissions` VALUES("244", "submission", "25f623ca-b06e-4f2f-8bac-0b20eff31249", "975", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.147.214.14", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 17:42:51", "2025-06-18 17:42:51", "2025-06-18 12:42:51", "2025-06-18 12:42:51");
INSERT INTO `j3nd_e_submissions` VALUES("245", "submission", "f058e4b4-e312-4f09-be99-d8713bfdc43f", "979", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.194.178.98", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 18:10:16", "2025-06-18 18:10:17", "2025-06-18 13:10:16", "2025-06-18 13:10:17");
INSERT INTO `j3nd_e_submissions` VALUES("246", "submission", "4c1e17fc-3879-42f6-b733-28f764479a0b", "983", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.36.89", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 18:46:38", "2025-06-18 18:46:39", "2025-06-18 13:46:38", "2025-06-18 13:46:39");
INSERT INTO `j3nd_e_submissions` VALUES("247", "submission", "dd1f71bd-8f32-4f80-89cc-bcd99e32b46f", "987", "17", "", "", "fb84cc3", "New Form", "0", "0", "91.84.99.54", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 21:10:56", "2025-06-18 21:10:56", "2025-06-18 16:10:56", "2025-06-18 16:10:56");
INSERT INTO `j3nd_e_submissions` VALUES("248", "submission", "2433d231-f025-4e80-8a93-fe5198a29cbe", "991", "17", "", "", "fb84cc3", "New Form", "0", "0", "91.230.225.98", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-18 23:22:32", "2025-06-18 23:22:33", "2025-06-18 18:22:32", "2025-06-18 18:22:33");
INSERT INTO `j3nd_e_submissions` VALUES("249", "submission", "4dcd9cec-0d01-476d-97e1-528227659d93", "995", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.154.138.249", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 00:24:42", "2025-06-19 00:24:42", "2025-06-18 19:24:42", "2025-06-18 19:24:42");
INSERT INTO `j3nd_e_submissions` VALUES("250", "submission", "d37f428b-f849-4cf7-b373-ffc21e2d0540", "999", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.91.21.9", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 06:15:40", "2025-06-19 06:15:41", "2025-06-19 01:15:40", "2025-06-19 01:15:41");
INSERT INTO `j3nd_e_submissions` VALUES("251", "submission", "09608659-1359-44ac-a55c-74ae2dbcafbe", "1003", "17", "", "", "fb84cc3", "New Form", "0", "0", "194.195.91.7", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 08:30:42", "2025-06-19 08:30:42", "2025-06-19 03:30:42", "2025-06-19 03:30:42");
INSERT INTO `j3nd_e_submissions` VALUES("252", "submission", "83a714df-6761-439c-9593-4249be61df7c", "1007", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.44.42", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 09:47:47", "2025-06-19 09:47:47", "2025-06-19 04:47:47", "2025-06-19 04:47:47");
INSERT INTO `j3nd_e_submissions` VALUES("253", "submission", "343b4e71-a2fd-433a-99f0-3e5e0057ee17", "1011", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.147.213.251", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 11:33:27", "2025-06-19 11:33:27", "2025-06-19 06:33:27", "2025-06-19 06:33:27");
INSERT INTO `j3nd_e_submissions` VALUES("254", "submission", "35dc9965-5cc5-45f5-8634-5077642ca100", "1015", "17", "", "", "fb84cc3", "New Form", "0", "0", "194.127.173.106", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 11:38:08", "2025-06-19 11:38:08", "2025-06-19 06:38:08", "2025-06-19 06:38:08");
INSERT INTO `j3nd_e_submissions` VALUES("255", "submission", "7ae5d0b1-5f66-45e4-8b6c-7401b6aebebb", "1019", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.44.9", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 12:07:57", "2025-06-19 12:07:58", "2025-06-19 07:07:57", "2025-06-19 07:07:58");
INSERT INTO `j3nd_e_submissions` VALUES("256", "submission", "a9a37e57-aefa-41f9-9607-917ed48646c8", "1023", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.233", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 12:45:42", "2025-06-19 12:45:42", "2025-06-19 07:45:42", "2025-06-19 07:45:42");
INSERT INTO `j3nd_e_submissions` VALUES("257", "submission", "f43f1e51-f070-475f-b8a0-7c15a64a18e4", "1027", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.244", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 12:59:31", "2025-06-19 12:59:31", "2025-06-19 07:59:31", "2025-06-19 07:59:31");
INSERT INTO `j3nd_e_submissions` VALUES("258", "submission", "b064da4b-6973-483b-9cb2-eed8a1f96135", "1031", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.192.70.246", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 14:08:58", "2025-06-19 14:08:58", "2025-06-19 09:08:58", "2025-06-19 09:08:58");
INSERT INTO `j3nd_e_submissions` VALUES("259", "submission", "49d11488-85ba-4af2-b51f-9c17840243c5", "1035", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 15:10:16", "2025-06-19 15:10:17", "2025-06-19 10:10:16", "2025-06-19 10:10:17");
INSERT INTO `j3nd_e_submissions` VALUES("260", "submission", "257db48f-1670-4bac-974e-3965a21b2988", "1039", "17", "", "", "fb84cc3", "New Form", "0", "0", "176.67.83.250", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 16:38:33", "2025-06-19 16:38:33", "2025-06-19 11:38:33", "2025-06-19 11:38:33");
INSERT INTO `j3nd_e_submissions` VALUES("261", "submission", "788782e8-e5d7-4993-bf05-d12b7e8a1353", "1043", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.86.203.105", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 18:18:18", "2025-06-19 18:18:18", "2025-06-19 13:18:18", "2025-06-19 13:18:18");
INSERT INTO `j3nd_e_submissions` VALUES("262", "submission", "3cee2cd1-4348-4fd0-93ce-d2d6a1b1753e", "1047", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.44.3", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 20:55:22", "2025-06-19 20:55:22", "2025-06-19 15:55:22", "2025-06-19 15:55:22");
INSERT INTO `j3nd_e_submissions` VALUES("263", "submission", "d4e9fe1b-72b6-4c07-a971-8c8e62ee3b28", "1051", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.147.214.14", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 21:13:36", "2025-06-19 21:13:36", "2025-06-19 16:13:36", "2025-06-19 16:13:36");
INSERT INTO `j3nd_e_submissions` VALUES("264", "submission", "f4610c33-b055-4806-8540-63c1300d3b47", "1055", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.199.157.7", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 21:28:24", "2025-06-19 21:28:24", "2025-06-19 16:28:24", "2025-06-19 16:28:24");
INSERT INTO `j3nd_e_submissions` VALUES("265", "submission", "11bffda7-bd5d-41e5-acf6-dc7ab2a52af4", "1059", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.243", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 21:32:44", "2025-06-19 21:32:45", "2025-06-19 16:32:44", "2025-06-19 16:32:45");
INSERT INTO `j3nd_e_submissions` VALUES("266", "submission", "926a724e-92f9-42bb-9330-5fa6d05e6507", "1063", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-19 22:11:03", "2025-06-19 22:11:03", "2025-06-19 17:11:03", "2025-06-19 17:11:03");
INSERT INTO `j3nd_e_submissions` VALUES("267", "submission", "5c76156e-807d-4207-95a4-ed1a0cce48c5", "1067", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.44.28", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-20 02:06:28", "2025-06-20 02:06:29", "2025-06-19 21:06:28", "2025-06-19 21:06:29");
INSERT INTO `j3nd_e_submissions` VALUES("268", "submission", "a3e7b4de-52c7-44ba-9007-cad32bb8bbe5", "1071", "17", "", "", "fb84cc3", "New Form", "0", "0", "5.183.130.110", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-20 16:27:47", "2025-06-20 16:27:47", "2025-06-20 11:27:47", "2025-06-20 11:27:47");
INSERT INTO `j3nd_e_submissions` VALUES("269", "submission", "4e668100-b4d4-4734-aec2-15435cdaa64c", "1075", "17", "", "", "fb84cc3", "New Form", "0", "0", "109.172.84.31", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-20 21:17:15", "2025-06-20 21:17:15", "2025-06-20 16:17:15", "2025-06-20 16:17:15");
INSERT INTO `j3nd_e_submissions` VALUES("270", "submission", "a15ba42f-7377-484b-b0ae-483c582748f3", "1079", "17", "", "", "fb84cc3", "New Form", "0", "0", "93.81.249.57", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-20 22:10:42", "2025-06-20 22:10:43", "2025-06-20 17:10:42", "2025-06-20 17:10:43");
INSERT INTO `j3nd_e_submissions` VALUES("271", "submission", "523aa3d4-528d-42c7-9997-e121a0475205", "1083", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.163.5.64", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-21 02:56:40", "2025-06-21 02:56:40", "2025-06-20 21:56:40", "2025-06-20 21:56:40");
INSERT INTO `j3nd_e_submissions` VALUES("272", "submission", "022bde20-17c8-4f92-b4f5-58163c0e0291", "1087", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.94.47.150", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-21 08:42:03", "2025-06-21 08:42:03", "2025-06-21 03:42:03", "2025-06-21 03:42:03");
INSERT INTO `j3nd_e_submissions` VALUES("273", "submission", "e7f77de4-3908-4d11-a66a-4aa56f56ac9e", "1091", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.179.188.136", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-21 09:54:45", "2025-06-21 09:54:46", "2025-06-21 04:54:45", "2025-06-21 04:54:46");
INSERT INTO `j3nd_e_submissions` VALUES("274", "submission", "ffe73af8-0da2-4e2b-88b2-a08e6b1220ef", "1095", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.199.157.9", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-21 12:45:34", "2025-06-21 12:45:34", "2025-06-21 07:45:34", "2025-06-21 07:45:34");
INSERT INTO `j3nd_e_submissions` VALUES("275", "submission", "84aeb3c1-69a0-4eb1-882f-4f853808dfb6", "1099", "17", "", "", "fb84cc3", "New Form", "0", "0", "31.184.215.152", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-21 18:55:06", "2025-06-21 18:55:06", "2025-06-21 13:55:06", "2025-06-21 13:55:06");
INSERT INTO `j3nd_e_submissions` VALUES("276", "submission", "9b3682c4-0f6a-4abb-abb3-608cc3c9f93e", "1103", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.19.223.115", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-21 21:08:59", "2025-06-21 21:08:59", "2025-06-21 16:08:59", "2025-06-21 16:08:59");
INSERT INTO `j3nd_e_submissions` VALUES("277", "submission", "2f716453-3fb8-4bcb-9af7-0f6feb7f7d91", "1107", "17", "", "", "fb84cc3", "New Form", "0", "0", "91.201.113.132", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-21 23:07:48", "2025-06-21 23:07:48", "2025-06-21 18:07:48", "2025-06-21 18:07:48");
INSERT INTO `j3nd_e_submissions` VALUES("278", "submission", "5495bd27-98ce-45c3-b603-d301ea47f064", "1111", "17", "", "", "fb84cc3", "New Form", "0", "0", "46.37.123.141", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-21 23:36:54", "2025-06-21 23:36:55", "2025-06-21 18:36:54", "2025-06-21 18:36:55");
INSERT INTO `j3nd_e_submissions` VALUES("279", "submission", "b036d3f1-3a2a-41a2-ac59-a593360ae944", "1115", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.15.73.61", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-22 17:07:52", "2025-06-22 17:07:52", "2025-06-22 12:07:52", "2025-06-22 12:07:52");
INSERT INTO `j3nd_e_submissions` VALUES("280", "submission", "27f3dd97-f3c9-4e24-9c69-fc011d5d8265", "1119", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.43", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-22 20:14:14", "2025-06-22 20:14:14", "2025-06-22 15:14:14", "2025-06-22 15:14:14");
INSERT INTO `j3nd_e_submissions` VALUES("281", "submission", "1f559b9f-56ed-41f1-85d5-6379da5fe3c8", "1123", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-22 21:10:06", "2025-06-22 21:10:06", "2025-06-22 16:10:06", "2025-06-22 16:10:06");
INSERT INTO `j3nd_e_submissions` VALUES("282", "submission", "2ab8a4a3-5cc9-48e5-a717-f3914be14d68", "1127", "17", "", "", "fb84cc3", "New Form", "0", "0", "216.151.184.120", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-23 05:36:29", "2025-06-23 05:36:29", "2025-06-23 00:36:29", "2025-06-23 00:36:29");
INSERT INTO `j3nd_e_submissions` VALUES("283", "submission", "02b09ca4-2be8-46a4-b7e6-b72c67cfdf6f", "1131", "17", "", "", "fb84cc3", "New Form", "0", "0", "94.46.220.5", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-23 06:01:09", "2025-06-23 06:01:09", "2025-06-23 01:01:09", "2025-06-23 01:01:09");
INSERT INTO `j3nd_e_submissions` VALUES("284", "submission", "f58f2db8-c9b0-4c4e-ac5c-82369ecfde94", "1135", "17", "", "", "fb84cc3", "New Form", "0", "0", "216.131.110.214", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-23 12:16:38", "2025-06-23 12:16:38", "2025-06-23 07:16:38", "2025-06-23 07:16:38");
INSERT INTO `j3nd_e_submissions` VALUES("285", "submission", "7f41b595-797f-44b9-8bb3-fc6b7fc5079f", "1139", "17", "", "", "fb84cc3", "New Form", "0", "0", "216.169.134.124", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-23 12:37:31", "2025-06-23 12:37:31", "2025-06-23 07:37:31", "2025-06-23 07:37:31");
INSERT INTO `j3nd_e_submissions` VALUES("286", "submission", "30880302-1101-43d6-a13e-c56733d1e023", "1143", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.34.104.131", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-23 13:32:58", "2025-06-23 13:32:58", "2025-06-23 08:32:58", "2025-06-23 08:32:58");
INSERT INTO `j3nd_e_submissions` VALUES("287", "submission", "383e2484-3032-471e-821b-d947066bca81", "1147", "17", "", "", "fb84cc3", "New Form", "0", "0", "93.81.249.57", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-23 14:36:06", "2025-06-23 14:36:06", "2025-06-23 09:36:06", "2025-06-23 09:36:06");
INSERT INTO `j3nd_e_submissions` VALUES("288", "submission", "2e1a1258-7abd-4e9f-93ff-4f3e67487fe0", "1151", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.30.37.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-23 15:07:48", "2025-06-23 15:07:49", "2025-06-23 10:07:48", "2025-06-23 10:07:49");
INSERT INTO `j3nd_e_submissions` VALUES("289", "submission", "0417a0a2-e696-4d06-88e2-e7f8ae59c5e1", "1155", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.32", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-23 18:03:26", "2025-06-23 18:03:26", "2025-06-23 13:03:26", "2025-06-23 13:03:26");
INSERT INTO `j3nd_e_submissions` VALUES("290", "submission", "afab9bbd-8f63-4de4-9e2f-5bf4af1f16d8", "1159", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.17.60.187", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-24 00:25:25", "2025-06-24 00:25:25", "2025-06-23 19:25:25", "2025-06-23 19:25:25");
INSERT INTO `j3nd_e_submissions` VALUES("291", "submission", "d950cf02-409d-4d82-b9b8-9ba475a4f360", "1163", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.93.178.155", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-24 03:03:57", "2025-06-24 03:03:57", "2025-06-23 22:03:57", "2025-06-23 22:03:57");
INSERT INTO `j3nd_e_submissions` VALUES("292", "submission", "a82cf0e0-62e8-4600-9215-e19aa0ebf82e", "1167", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.147.85.86", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-24 03:15:18", "2025-06-24 03:15:18", "2025-06-23 22:15:18", "2025-06-23 22:15:18");
INSERT INTO `j3nd_e_submissions` VALUES("293", "submission", "7b06fb96-2cf5-4bb1-b8c9-893fc370a2f3", "1171", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.140.159.32", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-24 07:59:05", "2025-06-24 07:59:05", "2025-06-24 02:59:05", "2025-06-24 02:59:05");
INSERT INTO `j3nd_e_submissions` VALUES("294", "submission", "d9ae6a23-882b-4f4f-aca8-27fc709e0ca9", "1175", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.163.5.64", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-24 16:05:01", "2025-06-24 16:05:01", "2025-06-24 11:05:01", "2025-06-24 11:05:01");
INSERT INTO `j3nd_e_submissions` VALUES("295", "submission", "e93afb47-a30c-4169-8bea-530b1d942c86", "1179", "17", "http://www.mateoracksperu.com/", "", "fb84cc3", "New Form", "0", "0", "196.242.141.2", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-24 17:25:41", "2025-06-24 17:25:41", "2025-06-24 12:25:41", "2025-06-24 12:25:41");
INSERT INTO `j3nd_e_submissions` VALUES("296", "submission", "cbbf32cc-4ccb-476a-88a8-8ec34134f332", "1183", "17", "", "", "fb84cc3", "New Form", "0", "0", "31.171.154.56", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-25 04:25:13", "2025-06-25 04:25:14", "2025-06-24 23:25:13", "2025-06-24 23:25:14");
INSERT INTO `j3nd_e_submissions` VALUES("297", "submission", "9a450cea-dd2b-4ba8-9936-b1ffb9e01b7c", "1187", "17", "", "", "fb84cc3", "New Form", "0", "0", "86.54.25.127", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-25 05:27:23", "2025-06-25 05:27:23", "2025-06-25 00:27:23", "2025-06-25 00:27:23");
INSERT INTO `j3nd_e_submissions` VALUES("298", "submission", "11efc9fd-fbd4-4ac5-a5c8-b93316ac999c", "1191", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.154.138.228", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-25 19:39:54", "2025-06-25 19:39:54", "2025-06-25 14:39:54", "2025-06-25 14:39:54");
INSERT INTO `j3nd_e_submissions` VALUES("299", "submission", "a79a13d6-784b-4c4a-a02f-b86daca66e48", "1195", "17", "", "", "fb84cc3", "New Form", "0", "0", "216.151.184.120", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-26 06:42:14", "2025-06-26 06:42:14", "2025-06-26 01:42:14", "2025-06-26 01:42:14");
INSERT INTO `j3nd_e_submissions` VALUES("300", "submission", "b42814df-aae5-4a8e-a63e-dc428760fb09", "1199", "17", "", "", "fb84cc3", "New Form", "0", "0", "138.199.18.153", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-26 12:07:58", "2025-06-26 12:07:59", "2025-06-26 07:07:58", "2025-06-26 07:07:59");
INSERT INTO `j3nd_e_submissions` VALUES("301", "submission", "af527440-24be-4677-b99d-b2270f448bab", "1203", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.102.218", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-26 15:46:54", "2025-06-26 15:46:55", "2025-06-26 10:46:54", "2025-06-26 10:46:55");
INSERT INTO `j3nd_e_submissions` VALUES("302", "submission", "4237eaac-6a6e-4c2e-a4fd-ddfa3f69c1ff", "1207", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.47.22", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-26 19:24:06", "2025-06-26 19:24:06", "2025-06-26 14:24:06", "2025-06-26 14:24:06");
INSERT INTO `j3nd_e_submissions` VALUES("303", "submission", "f4e0fc5c-36c7-49c4-b654-75c8a9a81cb1", "1211", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "45.95.118.213", "Mozilla/5.0 (X11; Linux i686; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-27 00:45:46", "2025-06-27 00:45:46", "2025-06-26 19:45:46", "2025-06-26 19:45:46");
INSERT INTO `j3nd_e_submissions` VALUES("304", "submission", "7fc0fb03-ef45-4782-b994-d9794dd33efe", "1215", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.54.141.230", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-27 02:00:18", "2025-06-27 02:00:18", "2025-06-26 21:00:18", "2025-06-26 21:00:18");
INSERT INTO `j3nd_e_submissions` VALUES("305", "submission", "17e3fa5d-7a4c-4f97-a1db-b26050381347", "1219", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.172", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-27 04:58:10", "2025-06-27 04:58:11", "2025-06-26 23:58:10", "2025-06-26 23:58:11");
INSERT INTO `j3nd_e_submissions` VALUES("306", "submission", "5f35a497-01ff-4e93-afab-27e8523e1baf", "1223", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.108.239", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-27 07:02:56", "2025-06-27 07:02:56", "2025-06-27 02:02:56", "2025-06-27 02:02:56");
INSERT INTO `j3nd_e_submissions` VALUES("307", "submission", "19c18a10-36e1-435e-9ec0-7a28a036f98a", "1227", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.196", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-27 08:13:21", "2025-06-27 08:13:22", "2025-06-27 03:13:21", "2025-06-27 03:13:22");
INSERT INTO `j3nd_e_submissions` VALUES("308", "submission", "a440a760-a71f-47cc-b73a-630d4bb0f9f2", "1231", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "45.95.117.237", "Mozilla/5.0 (X11; Linux i686; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-27 08:40:27", "2025-06-27 08:40:28", "2025-06-27 03:40:27", "2025-06-27 03:40:28");
INSERT INTO `j3nd_e_submissions` VALUES("309", "submission", "5cc14d34-0ebe-4920-b423-48d2638667cf", "1235", "17", "", "", "fb84cc3", "New Form", "0", "0", "87.240.52.143", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-27 08:55:16", "2025-06-27 08:55:16", "2025-06-27 03:55:16", "2025-06-27 03:55:16");
INSERT INTO `j3nd_e_submissions` VALUES("310", "submission", "e2685ded-f659-4847-aed7-34f7dc4773d3", "1239", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.43", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-27 11:20:16", "2025-06-27 11:20:16", "2025-06-27 06:20:16", "2025-06-27 06:20:16");
INSERT INTO `j3nd_e_submissions` VALUES("311", "submission", "4dcb73ca-d554-46d9-9d19-9b9925cdd980", "1243", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.97", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-27 16:43:27", "2025-06-27 16:43:27", "2025-06-27 11:43:27", "2025-06-27 11:43:27");
INSERT INTO `j3nd_e_submissions` VALUES("312", "submission", "aa0d8214-9725-4a45-ac89-c08fae543281", "1247", "17", "", "", "fb84cc3", "New Form", "0", "0", "203.188.164.29", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-27 23:09:22", "2025-06-27 23:09:22", "2025-06-27 18:09:22", "2025-06-27 18:09:22");
INSERT INTO `j3nd_e_submissions` VALUES("313", "submission", "0d0724c9-0bc9-4d9d-b926-6a69e40600d2", "1251", "17", "", "", "fb84cc3", "New Form", "0", "0", "46.246.8.142", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-28 03:21:25", "2025-06-28 03:21:25", "2025-06-27 22:21:25", "2025-06-27 22:21:25");
INSERT INTO `j3nd_e_submissions` VALUES("314", "submission", "c4732903-b455-4b3d-b2ac-8bae483a9461", "1255", "17", "", "", "fb84cc3", "New Form", "0", "0", "159.100.19.63", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-28 08:39:15", "2025-06-28 08:39:16", "2025-06-28 03:39:15", "2025-06-28 03:39:16");
INSERT INTO `j3nd_e_submissions` VALUES("315", "submission", "b732e765-7246-4d8d-899c-40a48e47c7a9", "1259", "17", "", "", "fb84cc3", "New Form", "0", "0", "91.206.14.75", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.53 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-28 10:11:43", "2025-06-28 10:11:43", "2025-06-28 05:11:43", "2025-06-28 05:11:43");
INSERT INTO `j3nd_e_submissions` VALUES("316", "submission", "d0220cf6-6ebe-468f-b487-03bf07a81959", "1263", "17", "", "", "fb84cc3", "New Form", "0", "0", "165.231.182.70", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-28 12:17:40", "2025-06-28 12:17:40", "2025-06-28 07:17:40", "2025-06-28 07:17:40");
INSERT INTO `j3nd_e_submissions` VALUES("317", "submission", "df25ab81-5bc5-43b7-8a38-3169b5202fd8", "1267", "17", "", "", "fb84cc3", "New Form", "0", "0", "159.100.19.63", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-28 12:46:58", "2025-06-28 12:46:59", "2025-06-28 07:46:58", "2025-06-28 07:46:59");
INSERT INTO `j3nd_e_submissions` VALUES("318", "submission", "0a88b02e-6053-4d77-add2-37f87174df67", "1271", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.176", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-28 14:57:47", "2025-06-28 14:57:47", "2025-06-28 09:57:47", "2025-06-28 09:57:47");
INSERT INTO `j3nd_e_submissions` VALUES("319", "submission", "bf4ab176-a681-4839-abb8-d0df92e1adfc", "1275", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.147.85.86", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-28 23:57:26", "2025-06-28 23:57:26", "2025-06-28 18:57:26", "2025-06-28 18:57:26");
INSERT INTO `j3nd_e_submissions` VALUES("320", "submission", "e73555ca-11e4-4901-91ea-9fc63ea64b37", "1279", "17", "", "", "fb84cc3", "New Form", "0", "0", "191.96.168.175", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-29 04:24:22", "2025-06-29 04:24:22", "2025-06-28 23:24:22", "2025-06-28 23:24:22");
INSERT INTO `j3nd_e_submissions` VALUES("321", "submission", "1a29f241-eefe-4f28-b362-7dedffd57896", "1283", "17", "", "", "fb84cc3", "New Form", "0", "0", "91.84.102.194", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-29 09:17:23", "2025-06-29 09:17:24", "2025-06-29 04:17:23", "2025-06-29 04:17:24");
INSERT INTO `j3nd_e_submissions` VALUES("322", "submission", "564aab8a-4799-41ba-bc42-75c5050487db", "1287", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.44.41", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-29 09:33:57", "2025-06-29 09:33:57", "2025-06-29 04:33:57", "2025-06-29 04:33:57");
INSERT INTO `j3nd_e_submissions` VALUES("323", "submission", "9076c674-fd08-4999-8526-18e7901e3eb3", "1291", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.162.189.24", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-29 15:42:10", "2025-06-29 15:42:10", "2025-06-29 10:42:10", "2025-06-29 10:42:10");
INSERT INTO `j3nd_e_submissions` VALUES("324", "submission", "12a010e9-68b4-4efb-9477-4ef08d6fbcfc", "1295", "17", "", "", "fb84cc3", "New Form", "0", "0", "93.152.230.160", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-30 07:17:28", "2025-06-30 07:17:28", "2025-06-30 02:17:28", "2025-06-30 02:17:28");
INSERT INTO `j3nd_e_submissions` VALUES("325", "submission", "45f0b9d2-d4d3-4f92-891d-dbf17879c47a", "1299", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.128.199.12", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-30 08:29:43", "2025-06-30 08:29:43", "2025-06-30 03:29:43", "2025-06-30 03:29:43");
INSERT INTO `j3nd_e_submissions` VALUES("326", "submission", "2948808c-5f61-48d4-8ae3-35cad0998fdc", "1303", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.34", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-30 09:08:40", "2025-06-30 09:08:40", "2025-06-30 04:08:40", "2025-06-30 04:08:40");
INSERT INTO `j3nd_e_submissions` VALUES("327", "submission", "11acd77b-894f-4f6a-be28-f93dedcec533", "1307", "17", "", "", "fb84cc3", "New Form", "0", "0", "104.28.222.73", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-30 15:32:13", "2025-06-30 15:32:14", "2025-06-30 10:32:13", "2025-06-30 10:32:14");
INSERT INTO `j3nd_e_submissions` VALUES("328", "submission", "2f7e0a60-eec6-41b7-8d00-9b3b70ef3ba0", "1311", "17", "", "", "fb84cc3", "New Form", "0", "0", "5.35.37.46", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-30 20:48:51", "2025-06-30 20:48:51", "2025-06-30 15:48:51", "2025-06-30 15:48:51");
INSERT INTO `j3nd_e_submissions` VALUES("329", "submission", "85a9d7fc-a626-43e4-8d44-f949ed62150c", "1315", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.102.37.185", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-30 22:58:55", "2025-06-30 22:58:55", "2025-06-30 17:58:55", "2025-06-30 17:58:55");
INSERT INTO `j3nd_e_submissions` VALUES("330", "submission", "0608c6fa-d4fb-4829-a2fb-0c77d519cfc6", "1319", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.30.37.105", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-06-30 23:16:32", "2025-06-30 23:16:32", "2025-06-30 18:16:32", "2025-06-30 18:16:32");
INSERT INTO `j3nd_e_submissions` VALUES("331", "submission", "433e99c5-e9f4-4107-bda9-84268b13c43a", "1323", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.30.37.214", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-01 02:31:31", "2025-07-01 02:31:31", "2025-06-30 21:31:31", "2025-06-30 21:31:31");
INSERT INTO `j3nd_e_submissions` VALUES("332", "submission", "2a0159bb-ab34-4df1-a952-75e18208e3e5", "1327", "17", "", "", "fb84cc3", "New Form", "0", "0", "191.96.168.179", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-01 02:42:55", "2025-07-01 02:42:55", "2025-06-30 21:42:55", "2025-06-30 21:42:55");
INSERT INTO `j3nd_e_submissions` VALUES("333", "submission", "dd0f7351-81d6-484d-9503-0ce5f7d29198", "1331", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.30.37.177", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-01 11:54:33", "2025-07-01 11:54:34", "2025-07-01 06:54:33", "2025-07-01 06:54:34");
INSERT INTO `j3nd_e_submissions` VALUES("334", "submission", "fcab211d-c9e2-4c04-80f1-079abbe75add", "1335", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.163.5.64", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-01 13:00:48", "2025-07-01 13:00:48", "2025-07-01 08:00:48", "2025-07-01 08:00:48");
INSERT INTO `j3nd_e_submissions` VALUES("335", "submission", "b24e51e6-4742-423b-ac28-9f8c05445fbd", "1339", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.17.49.3", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-01 14:19:16", "2025-07-01 14:19:16", "2025-07-01 09:19:16", "2025-07-01 09:19:16");
INSERT INTO `j3nd_e_submissions` VALUES("336", "submission", "435c0e90-9aeb-4c3c-9162-8c2a3b3d5aae", "1343", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.54.141.230", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-01 20:40:19", "2025-07-01 20:40:19", "2025-07-01 15:40:19", "2025-07-01 15:40:19");
INSERT INTO `j3nd_e_submissions` VALUES("337", "submission", "63f9ab88-face-44fa-9eac-72f90c28c88e", "1347", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.34", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-02 02:21:52", "2025-07-02 02:21:52", "2025-07-01 21:21:52", "2025-07-01 21:21:52");
INSERT INTO `j3nd_e_submissions` VALUES("338", "submission", "99e73f3f-7f86-44f6-9fa5-9c02ddb38fca", "1351", "17", "", "", "fb84cc3", "New Form", "0", "0", "86.102.17.77", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-02 16:01:39", "2025-07-02 16:01:39", "2025-07-02 11:01:39", "2025-07-02 11:01:39");
INSERT INTO `j3nd_e_submissions` VALUES("339", "submission", "91ac77d2-2b49-4135-beec-958082f3c3da", "1355", "17", "", "", "fb84cc3", "New Form", "0", "0", "165.231.182.99", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-02 16:35:24", "2025-07-02 16:35:24", "2025-07-02 11:35:24", "2025-07-02 11:35:24");
INSERT INTO `j3nd_e_submissions` VALUES("340", "submission", "b27640da-9c54-4374-93c8-7114e4edfef4", "1359", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.179.188.136", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-02 23:09:49", "2025-07-02 23:09:49", "2025-07-02 18:09:49", "2025-07-02 18:09:49");
INSERT INTO `j3nd_e_submissions` VALUES("341", "submission", "8533ac1d-1cf1-49a4-9f0a-5f1b11765cab", "1363", "17", "", "", "fb84cc3", "New Form", "0", "0", "5.181.0.254", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-03 01:16:11", "2025-07-03 01:16:11", "2025-07-02 20:16:11", "2025-07-02 20:16:11");
INSERT INTO `j3nd_e_submissions` VALUES("342", "submission", "4dcfe71a-ad8d-456a-8e55-0db076ec92d9", "1367", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.154.138.171", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-03 02:51:07", "2025-07-03 02:51:07", "2025-07-02 21:51:07", "2025-07-02 21:51:07");
INSERT INTO `j3nd_e_submissions` VALUES("343", "submission", "d31639f3-22b9-4fbd-b08c-11a22184bfa7", "1371", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.104.80", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-03 08:18:11", "2025-07-03 08:18:12", "2025-07-03 03:18:11", "2025-07-03 03:18:12");
INSERT INTO `j3nd_e_submissions` VALUES("344", "submission", "32180492-e75e-420e-8d9b-00d03a91efc9", "1375", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.104.80", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-03 08:18:13", "2025-07-03 08:18:14", "2025-07-03 03:18:13", "2025-07-03 03:18:14");
INSERT INTO `j3nd_e_submissions` VALUES("345", "submission", "05a03a2e-6059-4b1c-aaee-ff32bd1a1fc3", "1379", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.86.200.220", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-03 10:13:54", "2025-07-03 10:13:54", "2025-07-03 05:13:54", "2025-07-03 05:13:54");
INSERT INTO `j3nd_e_submissions` VALUES("346", "submission", "59b60893-f82f-4932-9c5b-e3045dedc5e0", "1383", "17", "", "", "fb84cc3", "New Form", "0", "0", "93.81.249.57", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-03 13:53:26", "2025-07-03 13:53:26", "2025-07-03 08:53:26", "2025-07-03 08:53:26");
INSERT INTO `j3nd_e_submissions` VALUES("347", "submission", "9dd9f212-1999-45f8-ad89-b9d60e0f6e91", "1387", "17", "", "", "fb84cc3", "New Form", "0", "0", "89.37.63.207", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-03 14:39:37", "2025-07-03 14:39:38", "2025-07-03 09:39:37", "2025-07-03 09:39:38");
INSERT INTO `j3nd_e_submissions` VALUES("348", "submission", "91604363-277b-43c8-a2ca-8a1d1cd2b25a", "1391", "17", "", "", "fb84cc3", "New Form", "0", "0", "93.81.249.57", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-03 15:48:14", "2025-07-03 15:48:15", "2025-07-03 10:48:14", "2025-07-03 10:48:15");
INSERT INTO `j3nd_e_submissions` VALUES("349", "submission", "3a2b38a0-f1aa-4952-b775-96bd18190e21", "1395", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.108.239", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-03 16:06:37", "2025-07-03 16:06:38", "2025-07-03 11:06:37", "2025-07-03 11:06:38");
INSERT INTO `j3nd_e_submissions` VALUES("350", "submission", "368aadf6-7872-4920-93df-a59f339e80de", "1399", "17", "", "", "fb84cc3", "New Form", "0", "0", "51.210.112.19", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-03 22:16:30", "2025-07-03 22:16:30", "2025-07-03 17:16:30", "2025-07-03 17:16:30");
INSERT INTO `j3nd_e_submissions` VALUES("351", "submission", "72526301-cbb1-431f-bbd5-2a2cba2937a4", "1403", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.20.14", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-04 01:54:32", "2025-07-04 01:54:32", "2025-07-03 20:54:32", "2025-07-03 20:54:32");
INSERT INTO `j3nd_e_submissions` VALUES("352", "submission", "5e5e15d6-c679-4de5-b44b-3517ab350eef", "1407", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.20.16", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-04 05:06:31", "2025-07-04 05:06:31", "2025-07-04 00:06:31", "2025-07-04 00:06:31");
INSERT INTO `j3nd_e_submissions` VALUES("353", "submission", "efb25111-d68d-4af8-be1b-ffdc0b57b982", "1411", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.163.97.250", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-04 15:17:32", "2025-07-04 15:17:32", "2025-07-04 10:17:32", "2025-07-04 10:17:32");
INSERT INTO `j3nd_e_submissions` VALUES("354", "submission", "939af6d4-f161-4909-bc02-b799e223df5c", "1415", "17", "http://www.mateoracksperu.com/", "", "fb84cc3", "New Form", "0", "0", "75.119.130.41", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-04 16:46:33", "2025-07-04 16:46:33", "2025-07-04 11:46:33", "2025-07-04 11:46:33");
INSERT INTO `j3nd_e_submissions` VALUES("355", "submission", "46599d9e-18b1-47ed-847d-9b19b2c63958", "1419", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.97", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-04 18:25:44", "2025-07-04 18:25:44", "2025-07-04 13:25:44", "2025-07-04 13:25:44");
INSERT INTO `j3nd_e_submissions` VALUES("356", "submission", "607920ed-270f-4cd7-916e-0f0f2d2e97b4", "1423", "17", "", "", "fb84cc3", "New Form", "0", "0", "31.171.130.103", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-04 19:16:41", "2025-07-04 19:16:41", "2025-07-04 14:16:41", "2025-07-04 14:16:41");
INSERT INTO `j3nd_e_submissions` VALUES("357", "submission", "3b734cc2-2d87-4ecb-b6ef-34881c817e32", "1427", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.102.57.219", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-05 05:19:21", "2025-07-05 05:19:21", "2025-07-05 00:19:21", "2025-07-05 00:19:21");
INSERT INTO `j3nd_e_submissions` VALUES("358", "submission", "b77c0e55-d1ca-4a05-bbb2-c327af324214", "1431", "17", "", "", "fb84cc3", "New Form", "0", "0", "93.152.230.160", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-05 08:31:33", "2025-07-05 08:31:33", "2025-07-05 03:31:33", "2025-07-05 03:31:33");
INSERT INTO `j3nd_e_submissions` VALUES("359", "submission", "0f08575b-a4f2-4b84-bfd2-3e33f812b588", "1435", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.192.71.134", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-06 02:33:10", "2025-07-06 02:33:10", "2025-07-05 21:33:10", "2025-07-05 21:33:10");
INSERT INTO `j3nd_e_submissions` VALUES("360", "submission", "6e2e7aaf-4cdf-4024-b468-57a0f5bc5a33", "1439", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.84.96.179", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-06 08:09:53", "2025-07-06 08:09:53", "2025-07-06 03:09:53", "2025-07-06 03:09:53");
INSERT INTO `j3nd_e_submissions` VALUES("361", "submission", "ebc1b416-5f89-4543-9894-2f167e639dba", "1443", "17", "", "", "fb84cc3", "New Form", "0", "0", "194.32.120.85", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-06 17:26:46", "2025-07-06 17:26:46", "2025-07-06 12:26:46", "2025-07-06 12:26:46");
INSERT INTO `j3nd_e_submissions` VALUES("362", "submission", "41a50c43-4518-4576-9262-b17e2e3d3d1d", "1447", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.163.4.241", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-06 23:07:50", "2025-07-06 23:07:50", "2025-07-06 18:07:50", "2025-07-06 18:07:50");
INSERT INTO `j3nd_e_submissions` VALUES("363", "submission", "289b6865-c341-44a8-bc29-83af9309de73", "1451", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-07 05:01:27", "2025-07-07 05:01:27", "2025-07-07 00:01:27", "2025-07-07 00:01:27");
INSERT INTO `j3nd_e_submissions` VALUES("364", "submission", "45b8e09c-2247-4666-aa25-9826732a5a29", "1455", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "45.95.117.56", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-07 08:17:21", "2025-07-07 08:17:21", "2025-07-07 03:17:21", "2025-07-07 03:17:21");
INSERT INTO `j3nd_e_submissions` VALUES("365", "submission", "b267459c-aa18-466d-8829-d178e51508c9", "1459", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.102.37.190", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.134 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-07 09:00:55", "2025-07-07 09:00:55", "2025-07-07 04:00:55", "2025-07-07 04:00:55");
INSERT INTO `j3nd_e_submissions` VALUES("366", "submission", "2f08bad7-60a5-48b8-9f4a-d89bceea192e", "1463", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.140.159.32", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-07 09:54:19", "2025-07-07 09:54:19", "2025-07-07 04:54:19", "2025-07-07 04:54:19");
INSERT INTO `j3nd_e_submissions` VALUES("367", "submission", "ebe92879-1b4c-4451-8c72-b65778e9bc35", "1467", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-07 15:13:38", "2025-07-07 15:13:39", "2025-07-07 10:13:38", "2025-07-07 10:13:39");
INSERT INTO `j3nd_e_submissions` VALUES("368", "submission", "458fc6d7-8dcd-4355-bb06-65d950a29b5d", "1471", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-07 16:09:45", "2025-07-07 16:09:45", "2025-07-07 11:09:45", "2025-07-07 11:09:45");
INSERT INTO `j3nd_e_submissions` VALUES("369", "submission", "bf2cc3bc-a923-44a9-b542-fda57c461603", "1475", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-07 16:17:41", "2025-07-07 16:17:41", "2025-07-07 11:17:41", "2025-07-07 11:17:41");
INSERT INTO `j3nd_e_submissions` VALUES("370", "submission", "328a5218-33ee-4a39-93bb-2deeb1787b17", "1479", "17", "", "", "fb84cc3", "New Form", "0", "0", "165.231.182.121", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-07 17:16:45", "2025-07-07 17:16:45", "2025-07-07 12:16:45", "2025-07-07 12:16:45");
INSERT INTO `j3nd_e_submissions` VALUES("371", "submission", "458d1b09-a07e-4686-a849-0fce82e84490", "1483", "17", "", "", "fb84cc3", "New Form", "0", "0", "146.120.161.147", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-08 00:27:12", "2025-07-08 00:27:12", "2025-07-07 19:27:12", "2025-07-07 19:27:12");
INSERT INTO `j3nd_e_submissions` VALUES("372", "submission", "ab68bdd7-fb17-4848-b807-205d907eeb43", "1487", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-08 03:50:33", "2025-07-08 03:50:34", "2025-07-07 22:50:33", "2025-07-07 22:50:34");
INSERT INTO `j3nd_e_submissions` VALUES("373", "submission", "4464af80-7c13-477c-8742-ecf934f30998", "1491", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.100.99", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-08 07:45:45", "2025-07-08 07:45:45", "2025-07-08 02:45:45", "2025-07-08 02:45:45");
INSERT INTO `j3nd_e_submissions` VALUES("374", "submission", "31f68d85-5236-45da-8830-381d52b73533", "1495", "17", "", "", "fb84cc3", "New Form", "0", "0", "86.62.30.15", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-09 10:04:06", "2025-07-09 10:04:06", "2025-07-09 05:04:06", "2025-07-09 05:04:06");
INSERT INTO `j3nd_e_submissions` VALUES("375", "submission", "d745c2c1-9d32-4a01-b243-e681a8fd982d", "1499", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.88.97.10", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-09 10:25:13", "2025-07-09 10:25:13", "2025-07-09 05:25:13", "2025-07-09 05:25:13");
INSERT INTO `j3nd_e_submissions` VALUES("376", "submission", "d528a4a7-4698-46a8-90e7-13f26c016d3c", "1503", "17", "", "", "fb84cc3", "New Form", "0", "0", "109.234.38.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-09 11:38:18", "2025-07-09 11:38:18", "2025-07-09 06:38:18", "2025-07-09 06:38:18");
INSERT INTO `j3nd_e_submissions` VALUES("377", "submission", "1362587d-aa96-42ea-9551-5b1caf3eda18", "1507", "17", "", "", "fb84cc3", "New Form", "0", "0", "91.84.99.54", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-09 16:29:15", "2025-07-09 16:29:16", "2025-07-09 11:29:15", "2025-07-09 11:29:16");
INSERT INTO `j3nd_e_submissions` VALUES("378", "submission", "ed2b46e6-d19f-482f-96ed-f91f776d5f56", "1511", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.147.84.194", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-09 16:46:30", "2025-07-09 16:46:30", "2025-07-09 11:46:30", "2025-07-09 11:46:30");
INSERT INTO `j3nd_e_submissions` VALUES("379", "submission", "7b9193fd-bf84-4cf0-b51a-006474238896", "1515", "17", "", "", "fb84cc3", "New Form", "0", "0", "86.106.74.251", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-09 18:42:02", "2025-07-09 18:42:03", "2025-07-09 13:42:02", "2025-07-09 13:42:03");
INSERT INTO `j3nd_e_submissions` VALUES("380", "submission", "bf5cef89-906f-4b44-8d17-313e143d0202", "1519", "17", "", "", "fb84cc3", "New Form", "0", "0", "93.81.249.57", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-10 14:05:12", "2025-07-10 14:05:12", "2025-07-10 09:05:12", "2025-07-10 09:05:12");
INSERT INTO `j3nd_e_submissions` VALUES("381", "submission", "076549b4-d3bd-4dd4-932f-72d7f44fcaf4", "1523", "17", "", "", "fb84cc3", "New Form", "0", "0", "93.81.249.57", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-10 14:05:34", "2025-07-10 14:05:34", "2025-07-10 09:05:34", "2025-07-10 09:05:34");
INSERT INTO `j3nd_e_submissions` VALUES("382", "submission", "7a892015-c21b-4433-ba32-d2d3137291df", "1527", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.163.4.241", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-10 20:04:12", "2025-07-10 20:04:12", "2025-07-10 15:04:12", "2025-07-10 15:04:12");
INSERT INTO `j3nd_e_submissions` VALUES("383", "submission", "2a78b3be-7e95-465d-83a4-430011df18ac", "1531", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.108.239", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-10 21:00:40", "2025-07-10 21:00:40", "2025-07-10 16:00:40", "2025-07-10 16:00:40");
INSERT INTO `j3nd_e_submissions` VALUES("384", "submission", "3998f47f-3f4f-49ad-ab9e-1214dd1405f6", "1535", "17", "", "", "fb84cc3", "New Form", "0", "0", "165.231.182.114", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-11 08:57:45", "2025-07-11 08:57:45", "2025-07-11 03:57:45", "2025-07-11 03:57:45");
INSERT INTO `j3nd_e_submissions` VALUES("385", "submission", "9e1eb1ca-901c-4a8a-b47f-61ee3015d5de", "1539", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.154.138.41", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-11 11:39:52", "2025-07-11 11:39:52", "2025-07-11 06:39:52", "2025-07-11 06:39:52");
INSERT INTO `j3nd_e_submissions` VALUES("386", "submission", "2136ccd4-0a6a-4e87-b24b-0aa60fef571f", "1543", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.181.247.126", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-11 13:02:22", "2025-07-11 13:02:22", "2025-07-11 08:02:22", "2025-07-11 08:02:22");
INSERT INTO `j3nd_e_submissions` VALUES("387", "submission", "727bef0e-4035-4d71-82c7-580bc71e34df", "1547", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.134.63.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-11 19:27:51", "2025-07-11 19:27:51", "2025-07-11 14:27:51", "2025-07-11 14:27:51");
INSERT INTO `j3nd_e_submissions` VALUES("388", "submission", "3d17a191-da31-4c58-a7ab-fe1f2f5e6ce7", "1551", "17", "", "", "fb84cc3", "New Form", "0", "0", "159.100.19.63", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-12 05:53:42", "2025-07-12 05:53:42", "2025-07-12 00:53:42", "2025-07-12 00:53:42");
INSERT INTO `j3nd_e_submissions` VALUES("389", "submission", "e6c9de07-851c-4fee-9e87-c4488247d213", "1555", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.147.85.86", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-12 11:54:00", "2025-07-12 11:54:01", "2025-07-12 06:54:00", "2025-07-12 06:54:01");
INSERT INTO `j3nd_e_submissions` VALUES("390", "submission", "08d4a476-6efa-4fd4-a23e-2df1357a0b40", "1559", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.246", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-12 19:08:43", "2025-07-12 19:08:43", "2025-07-12 14:08:43", "2025-07-12 14:08:43");
INSERT INTO `j3nd_e_submissions` VALUES("391", "submission", "e3244d8f-8e67-4c14-b600-a05952b87328", "1563", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.241", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-12 21:38:54", "2025-07-12 21:38:54", "2025-07-12 16:38:54", "2025-07-12 16:38:54");
INSERT INTO `j3nd_e_submissions` VALUES("392", "submission", "be4e0b5e-2422-47b0-b30e-74aac1fd38a4", "1567", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.19.223.19", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-13 02:23:34", "2025-07-13 02:23:34", "2025-07-12 21:23:34", "2025-07-12 21:23:34");
INSERT INTO `j3nd_e_submissions` VALUES("393", "submission", "7a91e31a-a5a7-45b9-99bc-fa6a0b09fcf8", "1571", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.242", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-13 08:48:43", "2025-07-13 08:48:43", "2025-07-13 03:48:43", "2025-07-13 03:48:43");
INSERT INTO `j3nd_e_submissions` VALUES("394", "submission", "d062f148-9fcf-47c3-a247-8c6c5a124708", "1575", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.246", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-13 09:16:37", "2025-07-13 09:16:37", "2025-07-13 04:16:37", "2025-07-13 04:16:37");
INSERT INTO `j3nd_e_submissions` VALUES("395", "submission", "d736b5bb-8342-43d5-b895-7d9a9d36460a", "1579", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.203", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-13 09:39:00", "2025-07-13 09:39:00", "2025-07-13 04:39:00", "2025-07-13 04:39:00");
INSERT INTO `j3nd_e_submissions` VALUES("396", "submission", "fd834c56-b26c-42a6-9154-c575281edf44", "1583", "17", "", "", "fb84cc3", "New Form", "0", "0", "69.16.147.123", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-13 11:00:15", "2025-07-13 11:00:16", "2025-07-13 06:00:15", "2025-07-13 06:00:16");
INSERT INTO `j3nd_e_submissions` VALUES("397", "submission", "76d086ec-f57b-48d3-b428-8ca03e4b3a6c", "1587", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.46", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-13 15:33:08", "2025-07-13 15:33:08", "2025-07-13 10:33:08", "2025-07-13 10:33:08");
INSERT INTO `j3nd_e_submissions` VALUES("398", "submission", "6897d099-a058-450e-a9be-6b9e6d7db639", "1591", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.244", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-13 16:32:50", "2025-07-13 16:32:50", "2025-07-13 11:32:50", "2025-07-13 11:32:50");
INSERT INTO `j3nd_e_submissions` VALUES("399", "submission", "a834d596-c19a-4ccd-bad1-9dbd2af33990", "1595", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.163.96.108", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-13 17:50:12", "2025-07-13 17:50:12", "2025-07-13 12:50:12", "2025-07-13 12:50:12");
INSERT INTO `j3nd_e_submissions` VALUES("400", "submission", "a306c8aa-4736-4676-8391-dee8d29bc4a9", "1599", "17", "", "", "fb84cc3", "New Form", "0", "0", "136.169.148.110", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-14 01:18:33", "2025-07-14 01:18:33", "2025-07-13 20:18:33", "2025-07-13 20:18:33");
INSERT INTO `j3nd_e_submissions` VALUES("401", "submission", "eaf58895-c402-47b8-9e20-692c0a85e326", "1603", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.130.128.83", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-14 01:44:49", "2025-07-14 01:44:49", "2025-07-13 20:44:49", "2025-07-13 20:44:49");
INSERT INTO `j3nd_e_submissions` VALUES("402", "submission", "46691bce-46a9-473e-b511-081daae0948f", "1607", "17", "", "", "fb84cc3", "New Form", "0", "0", "93.81.249.57", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-14 07:05:00", "2025-07-14 07:05:00", "2025-07-14 02:05:00", "2025-07-14 02:05:00");
INSERT INTO `j3nd_e_submissions` VALUES("403", "submission", "2a700821-6c1f-4c89-8ed4-6384950e90cd", "1611", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-14 16:20:52", "2025-07-14 16:20:52", "2025-07-14 11:20:52", "2025-07-14 11:20:52");
INSERT INTO `j3nd_e_submissions` VALUES("404", "submission", "0cd408b2-f291-4feb-b6c4-63d22b357bb0", "1615", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "45.95.117.2", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-14 18:36:39", "2025-07-14 18:36:39", "2025-07-14 13:36:39", "2025-07-14 13:36:39");
INSERT INTO `j3nd_e_submissions` VALUES("405", "submission", "b8a34fbf-aded-462b-944d-43b9f2e4c799", "1619", "17", "http://www.mateoracksperu.com/", "", "fb84cc3", "New Form", "0", "0", "75.119.130.41", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-14 20:12:16", "2025-07-14 20:12:16", "2025-07-14 15:12:16", "2025-07-14 15:12:16");
INSERT INTO `j3nd_e_submissions` VALUES("406", "submission", "2533a18e-29ff-47bc-9ab9-7b905848b268", "1623", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.119.36.9", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-15 09:28:15", "2025-07-15 09:28:15", "2025-07-15 04:28:15", "2025-07-15 04:28:15");
INSERT INTO `j3nd_e_submissions` VALUES("407", "submission", "333ab437-2bc5-4fd5-a79c-96234e35c67f", "1627", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-15 09:38:48", "2025-07-15 09:38:48", "2025-07-15 04:38:48", "2025-07-15 04:38:48");
INSERT INTO `j3nd_e_submissions` VALUES("408", "submission", "3cc90d82-a39a-4c06-bf8d-1bf7b313af39", "1631", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-15 09:56:17", "2025-07-15 09:56:17", "2025-07-15 04:56:17", "2025-07-15 04:56:17");
INSERT INTO `j3nd_e_submissions` VALUES("409", "submission", "4e7f7e53-a60d-4d1f-aa5a-ff665e6274f0", "1635", "17", "", "", "fb84cc3", "New Form", "0", "0", "195.200.31.217", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-15 12:51:33", "2025-07-15 12:51:34", "2025-07-15 07:51:33", "2025-07-15 07:51:34");
INSERT INTO `j3nd_e_submissions` VALUES("410", "submission", "3eb27a94-f1ea-4c0b-9fbe-9eae3bd25753", "1639", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-15 15:45:07", "2025-07-15 15:45:07", "2025-07-15 10:45:07", "2025-07-15 10:45:07");
INSERT INTO `j3nd_e_submissions` VALUES("411", "submission", "eb8e9dc3-6400-4790-9d73-eac3dfd00a47", "1643", "17", "", "", "fb84cc3", "New Form", "0", "0", "192.111.134.10", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-15 23:06:27", "2025-07-15 23:06:27", "2025-07-15 18:06:27", "2025-07-15 18:06:27");
INSERT INTO `j3nd_e_submissions` VALUES("412", "submission", "38f19258-725b-4aab-8e8e-58b3b0370ec2", "1647", "17", "", "", "fb84cc3", "New Form", "0", "0", "5.253.31.95", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-16 01:52:07", "2025-07-16 01:52:07", "2025-07-15 20:52:07", "2025-07-15 20:52:07");
INSERT INTO `j3nd_e_submissions` VALUES("413", "submission", "171ca8bc-40aa-4cb4-b05e-97a085621f0e", "1651", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.108", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-16 02:59:58", "2025-07-16 02:59:59", "2025-07-15 21:59:58", "2025-07-15 21:59:59");
INSERT INTO `j3nd_e_submissions` VALUES("414", "submission", "b0efc064-6031-4bce-aedc-d7c3dbde9497", "1655", "17", "", "", "fb84cc3", "New Form", "0", "0", "128.90.170.20", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-16 03:03:44", "2025-07-16 03:03:44", "2025-07-15 22:03:44", "2025-07-15 22:03:44");
INSERT INTO `j3nd_e_submissions` VALUES("415", "submission", "92808457-3018-42f3-aef2-d6fe21a314c2", "1659", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.54.141.230", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-16 04:19:35", "2025-07-16 04:19:35", "2025-07-15 23:19:35", "2025-07-15 23:19:35");
INSERT INTO `j3nd_e_submissions` VALUES("416", "submission", "10ccd6fd-88d2-4794-9816-88467cced11e", "1663", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-16 05:03:17", "2025-07-16 05:03:17", "2025-07-16 00:03:17", "2025-07-16 00:03:17");
INSERT INTO `j3nd_e_submissions` VALUES("417", "submission", "eabba7d8-b30b-45d1-90c6-cb39307da6e9", "1667", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.245.105.66", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-16 09:07:20", "2025-07-16 09:07:20", "2025-07-16 04:07:20", "2025-07-16 04:07:20");
INSERT INTO `j3nd_e_submissions` VALUES("418", "submission", "ccbf3898-df0f-4503-8eca-91024da9b529", "1671", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.108", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-16 13:00:27", "2025-07-16 13:00:27", "2025-07-16 08:00:27", "2025-07-16 08:00:27");
INSERT INTO `j3nd_e_submissions` VALUES("419", "submission", "d2781e55-f6ac-41db-9391-41382fc65664", "1675", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.108", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-16 16:40:33", "2025-07-16 16:40:33", "2025-07-16 11:40:33", "2025-07-16 11:40:33");
INSERT INTO `j3nd_e_submissions` VALUES("420", "submission", "52aa33a7-26e2-400d-8e96-6a09f33bd8d3", "1679", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.115", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-16 23:35:34", "2025-07-16 23:35:34", "2025-07-16 18:35:34", "2025-07-16 18:35:34");
INSERT INTO `j3nd_e_submissions` VALUES("421", "submission", "824a114d-92b3-405e-aa57-a103055ef1e3", "1683", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.115", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-17 04:43:12", "2025-07-17 04:43:12", "2025-07-16 23:43:12", "2025-07-16 23:43:12");
INSERT INTO `j3nd_e_submissions` VALUES("422", "submission", "b5e50737-4eef-4bf0-b50c-ebb13e875104", "1687", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.19.223.103", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-17 08:45:21", "2025-07-17 08:45:21", "2025-07-17 03:45:21", "2025-07-17 03:45:21");
INSERT INTO `j3nd_e_submissions` VALUES("423", "submission", "298118d1-60f2-4f5c-9558-5167d6c80418", "1691", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.43", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-17 16:39:45", "2025-07-17 16:39:45", "2025-07-17 11:39:45", "2025-07-17 11:39:45");
INSERT INTO `j3nd_e_submissions` VALUES("424", "submission", "43846246-8fe2-4cba-9995-e869aecfa8a1", "1695", "17", "", "", "fb84cc3", "New Form", "0", "0", "181.214.218.181", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-18 08:52:41", "2025-07-18 08:52:42", "2025-07-18 03:52:41", "2025-07-18 03:52:42");
INSERT INTO `j3nd_e_submissions` VALUES("425", "submission", "47f1b085-dcfa-4ef7-b418-63f5c1d8f16d", "1699", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.236", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-18 14:50:07", "2025-07-18 14:50:07", "2025-07-18 09:50:07", "2025-07-18 09:50:07");
INSERT INTO `j3nd_e_submissions` VALUES("426", "submission", "71cd3a22-d99e-4052-9008-798476647b7e", "1703", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.108", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-18 16:04:45", "2025-07-18 16:04:45", "2025-07-18 11:04:45", "2025-07-18 11:04:45");
INSERT INTO `j3nd_e_submissions` VALUES("427", "submission", "eba3046d-fa34-45f6-a3f8-d3a15f36e2bd", "1707", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.108", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-18 17:23:08", "2025-07-18 17:23:08", "2025-07-18 12:23:08", "2025-07-18 12:23:08");
INSERT INTO `j3nd_e_submissions` VALUES("428", "submission", "91799f4d-01f3-4b4c-a44c-91cd5b75ca01", "1711", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.108", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-18 20:20:07", "2025-07-18 20:20:07", "2025-07-18 15:20:07", "2025-07-18 15:20:07");
INSERT INTO `j3nd_e_submissions` VALUES("429", "submission", "13cd0d7d-da6f-4021-b322-0ff2ad90dc7b", "1715", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.179.188.136", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-19 05:53:57", "2025-07-19 05:53:57", "2025-07-19 00:53:57", "2025-07-19 00:53:57");
INSERT INTO `j3nd_e_submissions` VALUES("430", "submission", "1f2603d5-425b-49a5-95c9-ac8afaa2d930", "1719", "17", "", "", "fb84cc3", "New Form", "0", "0", "89.175.12.245", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-19 08:38:24", "2025-07-19 08:38:24", "2025-07-19 03:38:24", "2025-07-19 03:38:24");
INSERT INTO `j3nd_e_submissions` VALUES("431", "submission", "4143279b-fe05-462c-9fb1-f258b8508fbd", "1723", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.97", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-19 14:35:56", "2025-07-19 14:35:56", "2025-07-19 09:35:56", "2025-07-19 09:35:56");
INSERT INTO `j3nd_e_submissions` VALUES("432", "submission", "6f9bc49f-9ab4-43a8-822f-d78dc5968497", "1727", "17", "http://www.mateoracksperu.com/", "", "fb84cc3", "New Form", "0", "0", "185.61.217.35", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edge/44.18363.8131", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-19 15:23:24", "2025-07-19 15:23:24", "2025-07-19 10:23:24", "2025-07-19 10:23:24");
INSERT INTO `j3nd_e_submissions` VALUES("433", "submission", "e3550f7b-ab0f-4852-be67-98d5bafc0724", "1731", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "80.211.114.167", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edge/44.18363.8131", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-19 17:37:00", "2025-07-19 17:37:01", "2025-07-19 12:37:00", "2025-07-19 12:37:01");
INSERT INTO `j3nd_e_submissions` VALUES("434", "submission", "54bd5f36-71c7-4dc9-b359-6e0520c00f8a", "1735", "17", "", "", "fb84cc3", "New Form", "0", "0", "5.142.214.111", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-20 08:31:30", "2025-07-20 08:31:30", "2025-07-20 03:31:30", "2025-07-20 03:31:30");
INSERT INTO `j3nd_e_submissions` VALUES("435", "submission", "389e65a5-b9e4-4d6f-b632-d705eae50846", "1739", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.235", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-20 09:01:34", "2025-07-20 09:01:34", "2025-07-20 04:01:34", "2025-07-20 04:01:34");
INSERT INTO `j3nd_e_submissions` VALUES("436", "submission", "c4ce9466-0ef0-4f8b-b41d-c90f9fd0b714", "1743", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.163.5.230", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-20 09:04:40", "2025-07-20 09:04:40", "2025-07-20 04:04:40", "2025-07-20 04:04:40");
INSERT INTO `j3nd_e_submissions` VALUES("437", "submission", "2f319744-b880-461c-8449-2add5e375568", "1747", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.235", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-20 09:12:41", "2025-07-20 09:12:41", "2025-07-20 04:12:41", "2025-07-20 04:12:41");
INSERT INTO `j3nd_e_submissions` VALUES("438", "submission", "015d5880-dfc1-442a-a6e9-e35eb797eb62", "1751", "17", "", "", "fb84cc3", "New Form", "0", "0", "91.219.215.46", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-20 18:00:00", "2025-07-20 18:00:00", "2025-07-20 13:00:00", "2025-07-20 13:00:00");
INSERT INTO `j3nd_e_submissions` VALUES("439", "submission", "9c746dcc-2c31-4d41-b9da-1733454e55e8", "1755", "17", "", "", "fb84cc3", "New Form", "0", "0", "194.246.81.112", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-21 17:54:40", "2025-07-21 17:54:40", "2025-07-21 12:54:40", "2025-07-21 12:54:40");
INSERT INTO `j3nd_e_submissions` VALUES("440", "submission", "603669a4-ffa5-4cfb-b33a-ac3a477fc626", "1759", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.77.216.2", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.134 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-21 18:55:14", "2025-07-21 18:55:14", "2025-07-21 13:55:14", "2025-07-21 13:55:14");
INSERT INTO `j3nd_e_submissions` VALUES("441", "submission", "22373a8d-ed50-4ac1-8a75-16c4febd63a8", "1763", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-22 04:57:35", "2025-07-22 04:57:35", "2025-07-21 23:57:35", "2025-07-21 23:57:35");
INSERT INTO `j3nd_e_submissions` VALUES("442", "submission", "d582717d-46b1-4317-9083-db2756c8855f", "1767", "17", "", "", "fb84cc3", "New Form", "0", "0", "109.107.179.186", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-22 05:35:48", "2025-07-22 05:35:48", "2025-07-22 00:35:48", "2025-07-22 00:35:48");
INSERT INTO `j3nd_e_submissions` VALUES("443", "submission", "58506f1b-087f-4b04-bc0f-57626eaede61", "1771", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.86.202.132", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-22 06:19:56", "2025-07-22 06:19:56", "2025-07-22 01:19:56", "2025-07-22 01:19:56");
INSERT INTO `j3nd_e_submissions` VALUES("444", "submission", "8d27f8c5-4268-49ca-804c-803c2d95eab0", "1775", "17", "", "", "fb84cc3", "New Form", "0", "0", "203.188.190.67", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-22 08:09:16", "2025-07-22 08:09:16", "2025-07-22 03:09:16", "2025-07-22 03:09:16");
INSERT INTO `j3nd_e_submissions` VALUES("445", "submission", "fc6233a0-673b-4866-bbf1-8505da9341c2", "1779", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.86.202.154", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-22 13:51:24", "2025-07-22 13:51:25", "2025-07-22 08:51:24", "2025-07-22 08:51:25");
INSERT INTO `j3nd_e_submissions` VALUES("446", "submission", "701360db-a15d-40e9-b419-3b56350c1b9f", "1783", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.43", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-22 14:03:07", "2025-07-22 14:03:07", "2025-07-22 09:03:07", "2025-07-22 09:03:07");
INSERT INTO `j3nd_e_submissions` VALUES("447", "submission", "56bc86da-7325-43c0-801e-85432f4c5752", "1787", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-22 15:39:53", "2025-07-22 15:39:53", "2025-07-22 10:39:53", "2025-07-22 10:39:53");
INSERT INTO `j3nd_e_submissions` VALUES("448", "submission", "c728ae1b-5a31-4c03-9bd9-5dddcb84d80b", "1791", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-22 15:43:13", "2025-07-22 15:43:13", "2025-07-22 10:43:13", "2025-07-22 10:43:13");
INSERT INTO `j3nd_e_submissions` VALUES("449", "submission", "016a9913-a15d-4517-a37f-914403457be4", "1795", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-22 15:55:35", "2025-07-22 15:55:35", "2025-07-22 10:55:35", "2025-07-22 10:55:35");
INSERT INTO `j3nd_e_submissions` VALUES("450", "submission", "73fc9949-a9db-45a6-ac2a-41d1d8ba59d6", "1799", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.30.36.106", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-22 18:55:35", "2025-07-22 18:55:35", "2025-07-22 13:55:35", "2025-07-22 13:55:35");
INSERT INTO `j3nd_e_submissions` VALUES("451", "submission", "d67905f7-dd48-4937-a412-f87f0c3d5aa2", "1803", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.108.221", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 00:03:09", "2025-07-23 00:03:10", "2025-07-22 19:03:09", "2025-07-22 19:03:10");
INSERT INTO `j3nd_e_submissions` VALUES("452", "submission", "028d9826-4a36-4520-b041-a2b4a298d7bf", "1807", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.17.60.74", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 00:54:54", "2025-07-23 00:54:54", "2025-07-22 19:54:54", "2025-07-22 19:54:54");
INSERT INTO `j3nd_e_submissions` VALUES("453", "submission", "c0fb7108-e283-464c-8359-2f32a7f436c8", "1811", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.44.226", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 03:36:24", "2025-07-23 03:36:24", "2025-07-22 22:36:24", "2025-07-22 22:36:24");
INSERT INTO `j3nd_e_submissions` VALUES("454", "submission", "75fdeb71-db00-40b1-b26c-f844ffdb16ff", "1815", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.130.129.112", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 05:07:27", "2025-07-23 05:07:27", "2025-07-23 00:07:27", "2025-07-23 00:07:27");
INSERT INTO `j3nd_e_submissions` VALUES("455", "submission", "b37f5364-7317-433d-8055-740ded40c64f", "1819", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.44.230", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 05:57:23", "2025-07-23 05:57:23", "2025-07-23 00:57:23", "2025-07-23 00:57:23");
INSERT INTO `j3nd_e_submissions` VALUES("456", "submission", "08a72a7f-64a7-49ca-b658-0d9bb6151bf5", "1823", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.113.113.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 07:12:43", "2025-07-23 07:12:44", "2025-07-23 02:12:43", "2025-07-23 02:12:44");
INSERT INTO `j3nd_e_submissions` VALUES("457", "submission", "bbf74e5d-033c-4060-a69e-7a2e9548c30e", "1827", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.110", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 07:59:17", "2025-07-23 07:59:17", "2025-07-23 02:59:17", "2025-07-23 02:59:17");
INSERT INTO `j3nd_e_submissions` VALUES("458", "submission", "155ee5a1-1c24-48cc-a379-d6ad4fc94d74", "1831", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.113", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 08:10:29", "2025-07-23 08:10:30", "2025-07-23 03:10:29", "2025-07-23 03:10:30");
INSERT INTO `j3nd_e_submissions` VALUES("459", "submission", "e76ea5e4-fe27-4f40-b4da-adf913c88d39", "1835", "17", "", "", "fb84cc3", "New Form", "0", "0", "205.185.193.123", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 08:43:55", "2025-07-23 08:43:55", "2025-07-23 03:43:55", "2025-07-23 03:43:55");
INSERT INTO `j3nd_e_submissions` VALUES("460", "submission", "1c47d90c-d0bd-448f-bb20-2e23424f9099", "1839", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.115", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 08:53:58", "2025-07-23 08:53:59", "2025-07-23 03:53:58", "2025-07-23 03:53:59");
INSERT INTO `j3nd_e_submissions` VALUES("461", "submission", "c0a7ef65-a6c0-4928-a5aa-7530770947d6", "1843", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.44.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 12:59:14", "2025-07-23 12:59:15", "2025-07-23 07:59:14", "2025-07-23 07:59:15");
INSERT INTO `j3nd_e_submissions` VALUES("462", "submission", "e5e0845a-1656-4c50-a55f-afe3e762377e", "1847", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.115", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 13:04:51", "2025-07-23 13:04:51", "2025-07-23 08:04:51", "2025-07-23 08:04:51");
INSERT INTO `j3nd_e_submissions` VALUES("463", "submission", "583d8a69-020c-4d18-9a9b-f27c0bbb284a", "1851", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.115", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 13:04:58", "2025-07-23 13:04:58", "2025-07-23 08:04:58", "2025-07-23 08:04:58");
INSERT INTO `j3nd_e_submissions` VALUES("464", "submission", "326e5d3f-2093-4bc2-a581-63443042ba3b", "1855", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.115", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 13:05:04", "2025-07-23 13:05:04", "2025-07-23 08:05:04", "2025-07-23 08:05:04");
INSERT INTO `j3nd_e_submissions` VALUES("465", "submission", "38a8ec3e-c33d-4a94-841a-e8c5eda12da9", "1859", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.115", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 13:05:46", "2025-07-23 13:05:46", "2025-07-23 08:05:46", "2025-07-23 08:05:46");
INSERT INTO `j3nd_e_submissions` VALUES("466", "submission", "fa52fa98-3b9d-4541-a5bc-2f4fbc79a7d1", "1863", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.147.212.251", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 13:19:10", "2025-07-23 13:19:11", "2025-07-23 08:19:10", "2025-07-23 08:19:11");
INSERT INTO `j3nd_e_submissions` VALUES("467", "submission", "2412da05-509c-4b4c-8dc4-f3bd2733364d", "1867", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.138", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 13:54:41", "2025-07-23 13:54:41", "2025-07-23 08:54:41", "2025-07-23 08:54:41");
INSERT INTO `j3nd_e_submissions` VALUES("468", "submission", "1e97a23c-6c19-4fa5-93f3-4242ef61afa3", "1871", "17", "", "", "fb84cc3", "New Form", "0", "0", "69.16.157.195", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 18:08:26", "2025-07-23 18:08:26", "2025-07-23 13:08:26", "2025-07-23 13:08:26");
INSERT INTO `j3nd_e_submissions` VALUES("469", "submission", "4a6b6831-f3a9-4a8f-8e93-060b010f6794", "1875", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.86.202.206", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-23 23:09:34", "2025-07-23 23:09:34", "2025-07-23 18:09:34", "2025-07-23 18:09:34");
INSERT INTO `j3nd_e_submissions` VALUES("470", "submission", "ffa41121-65ee-4468-bfa6-7bf047d93fe2", "1879", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.108", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-24 00:43:43", "2025-07-24 00:43:43", "2025-07-23 19:43:43", "2025-07-23 19:43:43");
INSERT INTO `j3nd_e_submissions` VALUES("471", "submission", "836aaf24-17b2-4199-bf1e-c2058d9d2a1d", "1883", "17", "", "", "fb84cc3", "New Form", "0", "0", "88.210.3.196", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-24 02:30:38", "2025-07-24 02:30:38", "2025-07-23 21:30:38", "2025-07-23 21:30:38");
INSERT INTO `j3nd_e_submissions` VALUES("472", "submission", "424b5865-2719-4509-9ab0-f9d7e44d2db5", "1887", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.104.80", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-24 18:40:05", "2025-07-24 18:40:06", "2025-07-24 13:40:05", "2025-07-24 13:40:06");
INSERT INTO `j3nd_e_submissions` VALUES("473", "submission", "624d0558-c291-40e2-b152-7459e25f2608", "1891", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.34", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-24 22:44:35", "2025-07-24 22:44:35", "2025-07-24 17:44:35", "2025-07-24 17:44:35");
INSERT INTO `j3nd_e_submissions` VALUES("474", "submission", "0c099c5e-8119-4f24-8528-cb7ad03fb9bc", "1895", "17", "", "", "fb84cc3", "New Form", "0", "0", "5.45.85.90", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-25 07:48:17", "2025-07-25 07:48:17", "2025-07-25 02:48:17", "2025-07-25 02:48:17");
INSERT INTO `j3nd_e_submissions` VALUES("475", "submission", "aecea3da-e983-41a0-ba4c-affa14c76634", "1899", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.46", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-25 08:00:56", "2025-07-25 08:00:56", "2025-07-25 03:00:56", "2025-07-25 03:00:56");
INSERT INTO `j3nd_e_submissions` VALUES("476", "submission", "c54d9f30-00f4-440c-bea8-1dd5df39e9f6", "1903", "17", "http://www.mateoracksperu.com/", "", "fb84cc3", "New Form", "0", "0", "185.99.2.145", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-25 09:19:04", "2025-07-25 09:19:04", "2025-07-25 04:19:04", "2025-07-25 04:19:04");
INSERT INTO `j3nd_e_submissions` VALUES("477", "submission", "d6a8f7bd-252b-45ae-8c7c-db1aeac6be76", "1907", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.97", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-26 08:21:30", "2025-07-26 08:21:30", "2025-07-26 03:21:30", "2025-07-26 03:21:30");
INSERT INTO `j3nd_e_submissions` VALUES("478", "submission", "2144f050-a69b-4f6b-afc9-86b3d83f1138", "1911", "17", "", "", "fb84cc3", "New Form", "0", "0", "109.248.142.254", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-26 14:20:15", "2025-07-26 14:20:15", "2025-07-26 09:20:15", "2025-07-26 09:20:15");
INSERT INTO `j3nd_e_submissions` VALUES("479", "submission", "35268686-cc24-4925-8815-a3a48658ae9e", "1915", "17", "", "", "fb84cc3", "New Form", "0", "0", "193.138.7.184", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-26 23:59:51", "2025-07-26 23:59:51", "2025-07-26 18:59:51", "2025-07-26 18:59:51");
INSERT INTO `j3nd_e_submissions` VALUES("480", "submission", "a3f90b57-613d-48e5-af6e-c9968e9bf510", "1919", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.36.147", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-27 02:53:28", "2025-07-27 02:53:29", "2025-07-26 21:53:28", "2025-07-26 21:53:29");
INSERT INTO `j3nd_e_submissions` VALUES("481", "submission", "e9fae388-7189-47d8-ba9e-1437bba8d200", "1923", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "185.210.216.179", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-27 04:44:52", "2025-07-27 04:44:52", "2025-07-26 23:44:52", "2025-07-26 23:44:52");
INSERT INTO `j3nd_e_submissions` VALUES("482", "submission", "186407b8-e59b-4c0a-8a15-0503e5860383", "1927", "17", "", "", "fb84cc3", "New Form", "0", "0", "194.32.120.182", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-27 05:54:15", "2025-07-27 05:54:15", "2025-07-27 00:54:15", "2025-07-27 00:54:15");
INSERT INTO `j3nd_e_submissions` VALUES("483", "submission", "c09f2f22-cc99-4eb4-b667-8960dd8b1bd4", "1931", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.89.242.96", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-27 06:50:22", "2025-07-27 06:50:22", "2025-07-27 01:50:22", "2025-07-27 01:50:22");
INSERT INTO `j3nd_e_submissions` VALUES("484", "submission", "55b616ac-1c60-467d-903b-240ef97e40e5", "1935", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.36.155", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-27 09:27:42", "2025-07-27 09:27:42", "2025-07-27 04:27:42", "2025-07-27 04:27:42");
INSERT INTO `j3nd_e_submissions` VALUES("485", "submission", "93b2705f-c91a-412f-9739-1a77cdb4cdb1", "1939", "17", "", "", "fb84cc3", "New Form", "0", "0", "194.32.120.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-27 11:52:56", "2025-07-27 11:52:56", "2025-07-27 06:52:56", "2025-07-27 06:52:56");
INSERT INTO `j3nd_e_submissions` VALUES("486", "submission", "a224903a-5eea-40ef-99c2-c7a1f815ce6a", "1943", "17", "", "", "fb84cc3", "New Form", "0", "0", "194.32.120.170", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-27 12:20:40", "2025-07-27 12:20:40", "2025-07-27 07:20:40", "2025-07-27 07:20:40");
INSERT INTO `j3nd_e_submissions` VALUES("487", "submission", "b5395a17-0c7a-40dc-9507-6de0d9ed0e5f", "1947", "17", "", "", "fb84cc3", "New Form", "0", "0", "46.45.238.58", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-27 13:35:46", "2025-07-27 13:35:46", "2025-07-27 08:35:46", "2025-07-27 08:35:46");
INSERT INTO `j3nd_e_submissions` VALUES("488", "submission", "bef4aba5-4a31-4443-9ac2-bdbbf500ddd0", "1951", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.108", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-27 14:06:40", "2025-07-27 14:06:40", "2025-07-27 09:06:40", "2025-07-27 09:06:40");
INSERT INTO `j3nd_e_submissions` VALUES("489", "submission", "2b252984-340d-4883-bd4b-79ab63146a70", "1955", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.108", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-27 14:34:17", "2025-07-27 14:34:17", "2025-07-27 09:34:17", "2025-07-27 09:34:17");
INSERT INTO `j3nd_e_submissions` VALUES("490", "submission", "b2c0e1f8-2a95-46a8-957a-c8c192094b07", "1959", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.169", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-27 16:03:26", "2025-07-27 16:03:26", "2025-07-27 11:03:26", "2025-07-27 11:03:26");
INSERT INTO `j3nd_e_submissions` VALUES("491", "submission", "0b11d6d7-ab64-4cb6-a5c6-0fc97c53e4ed", "1963", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.36.227", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-27 18:40:01", "2025-07-27 18:40:01", "2025-07-27 13:40:01", "2025-07-27 13:40:01");
INSERT INTO `j3nd_e_submissions` VALUES("492", "submission", "241ad0f8-835a-4628-bda7-deba7acd478c", "1967", "17", "", "", "fb84cc3", "New Form", "0", "0", "5.142.214.111", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-27 19:45:48", "2025-07-27 19:45:48", "2025-07-27 14:45:48", "2025-07-27 14:45:48");
INSERT INTO `j3nd_e_submissions` VALUES("493", "submission", "42646221-e406-4cf6-a421-4f764f302e27", "1971", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.49", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-27 21:37:59", "2025-07-27 21:37:59", "2025-07-27 16:37:59", "2025-07-27 16:37:59");
INSERT INTO `j3nd_e_submissions` VALUES("494", "submission", "fb5db9c4-91d9-427a-be08-3599746272fe", "1975", "17", "", "", "fb84cc3", "New Form", "0", "0", "87.240.52.143", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-27 23:40:36", "2025-07-27 23:40:36", "2025-07-27 18:40:36", "2025-07-27 18:40:36");
INSERT INTO `j3nd_e_submissions` VALUES("495", "submission", "73d528eb-9d48-40e8-89ba-36b6a5b4d8be", "1979", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.36.233", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-28 00:23:38", "2025-07-28 00:23:38", "2025-07-27 19:23:38", "2025-07-27 19:23:38");
INSERT INTO `j3nd_e_submissions` VALUES("496", "submission", "c831ee23-4d49-436e-a7c1-a781a8848a85", "1983", "17", "", "", "fb84cc3", "New Form", "0", "0", "188.163.97.77", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-28 00:59:17", "2025-07-28 00:59:17", "2025-07-27 19:59:17", "2025-07-27 19:59:17");
INSERT INTO `j3nd_e_submissions` VALUES("497", "submission", "398a0202-9197-45bf-902e-975ca3af7ad0", "1987", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.192.70.168", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-28 01:59:13", "2025-07-28 01:59:13", "2025-07-27 20:59:13", "2025-07-27 20:59:13");
INSERT INTO `j3nd_e_submissions` VALUES("498", "submission", "5e49c566-ffa1-44ee-aed4-044ec0715a17", "1991", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.192.70.167", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-28 02:53:50", "2025-07-28 02:53:50", "2025-07-27 21:53:50", "2025-07-27 21:53:50");
INSERT INTO `j3nd_e_submissions` VALUES("499", "submission", "1fd6a2d7-6b7c-4650-88d9-ce5d5afca297", "1995", "17", "", "", "fb84cc3", "New Form", "0", "0", "213.226.101.98", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-28 20:17:25", "2025-07-28 20:17:25", "2025-07-28 15:17:25", "2025-07-28 15:17:25");
INSERT INTO `j3nd_e_submissions` VALUES("500", "submission", "a6eb08ce-036d-4962-9d33-f63b53e165a7", "1999", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.100.99", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-28 22:38:34", "2025-07-28 22:38:35", "2025-07-28 17:38:34", "2025-07-28 17:38:35");
INSERT INTO `j3nd_e_submissions` VALUES("501", "submission", "d4ed6d3d-b49d-4473-85b7-6f9f323ffbde", "2003", "17", "", "", "fb84cc3", "New Form", "0", "0", "89.175.12.245", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-29 11:23:13", "2025-07-29 11:23:13", "2025-07-29 06:23:13", "2025-07-29 06:23:13");
INSERT INTO `j3nd_e_submissions` VALUES("502", "submission", "4b11ca06-2ef4-4cc7-9a61-81353760fd91", "2007", "17", "", "", "fb84cc3", "New Form", "0", "0", "93.81.249.57", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-30 00:22:38", "2025-07-30 00:22:38", "2025-07-29 19:22:38", "2025-07-29 19:22:38");
INSERT INTO `j3nd_e_submissions` VALUES("503", "submission", "6b035af6-7be6-4867-a135-33155d01104c", "2011", "17", "", "", "fb84cc3", "New Form", "0", "0", "191.96.168.186", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-30 01:58:39", "2025-07-30 01:58:39", "2025-07-29 20:58:39", "2025-07-29 20:58:39");
INSERT INTO `j3nd_e_submissions` VALUES("504", "submission", "b42840b4-2a7d-4039-b636-9d5ad677fc38", "2015", "17", "", "", "fb84cc3", "New Form", "0", "0", "156.248.82.155", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-30 05:46:29", "2025-07-30 05:46:29", "2025-07-30 00:46:29", "2025-07-30 00:46:29");
INSERT INTO `j3nd_e_submissions` VALUES("505", "submission", "8a04b11b-d8bd-41fe-a5a7-55f12c18ee78", "2019", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.20", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-30 08:10:49", "2025-07-30 08:10:50", "2025-07-30 03:10:49", "2025-07-30 03:10:50");
INSERT INTO `j3nd_e_submissions` VALUES("506", "submission", "1be0654f-a9f7-4e16-9031-10c5e3bac619", "2023", "17", "", "", "fb84cc3", "New Form", "0", "0", "5.142.214.111", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-30 09:12:07", "2025-07-30 09:12:07", "2025-07-30 04:12:07", "2025-07-30 04:12:07");
INSERT INTO `j3nd_e_submissions` VALUES("507", "submission", "5dc84e94-d939-4ee0-b124-aef1e0872bfe", "2027", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.48", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-30 10:35:50", "2025-07-30 10:35:50", "2025-07-30 05:35:50", "2025-07-30 05:35:50");
INSERT INTO `j3nd_e_submissions` VALUES("508", "submission", "5f885d66-0b8f-443a-86b6-d8e9671d90d2", "2031", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.84", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-31 02:19:31", "2025-07-31 02:19:31", "2025-07-30 21:19:31", "2025-07-30 21:19:31");
INSERT INTO `j3nd_e_submissions` VALUES("509", "submission", "b7110a00-d191-4ce3-bf6e-eed15196d5eb", "2035", "17", "", "", "fb84cc3", "New Form", "0", "0", "109.110.169.10", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-31 06:18:54", "2025-07-31 06:18:54", "2025-07-31 01:18:54", "2025-07-31 01:18:54");
INSERT INTO `j3nd_e_submissions` VALUES("510", "submission", "27a5561e-ed7f-4502-ad22-d6562b8d8a55", "2039", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.211", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-31 10:47:05", "2025-07-31 10:47:05", "2025-07-31 05:47:05", "2025-07-31 05:47:05");
INSERT INTO `j3nd_e_submissions` VALUES("511", "submission", "1423417e-53e4-40ae-a84f-b496b8ab5a91", "2043", "17", "", "", "fb84cc3", "New Form", "0", "0", "46.8.107.47", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-31 11:52:14", "2025-07-31 11:52:14", "2025-07-31 06:52:14", "2025-07-31 06:52:14");
INSERT INTO `j3nd_e_submissions` VALUES("512", "submission", "2d074f44-39c2-44ee-ab32-43abd8bafc9b", "2047", "17", "", "", "fb84cc3", "New Form", "0", "0", "91.84.109.103", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-07-31 20:11:58", "2025-07-31 20:11:58", "2025-07-31 15:11:58", "2025-07-31 15:11:58");
INSERT INTO `j3nd_e_submissions` VALUES("513", "submission", "c3e0fdf4-8679-4aef-9953-a4c1389a8379", "2051", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.108", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-01 08:29:40", "2025-08-01 08:29:40", "2025-08-01 03:29:40", "2025-08-01 03:29:40");
INSERT INTO `j3nd_e_submissions` VALUES("514", "submission", "bc51d002-a77d-45ff-b57e-117a1ec8ef85", "2055", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.104.80", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-01 09:17:13", "2025-08-01 09:17:13", "2025-08-01 04:17:13", "2025-08-01 04:17:13");
INSERT INTO `j3nd_e_submissions` VALUES("515", "submission", "d5b66b18-6cd7-4619-bb6b-5e97d2417923", "2059", "17", "http://www.mateoracksperu.com/", "", "fb84cc3", "New Form", "0", "0", "80.87.206.61", "Mozilla/5.0 (Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-01 16:51:34", "2025-08-01 16:51:35", "2025-08-01 11:51:34", "2025-08-01 11:51:35");
INSERT INTO `j3nd_e_submissions` VALUES("516", "submission", "46c03d74-ce08-457c-8a8b-12f1d59a4eb0", "2063", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.34", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-01 18:41:14", "2025-08-01 18:41:14", "2025-08-01 13:41:14", "2025-08-01 13:41:14");
INSERT INTO `j3nd_e_submissions` VALUES("517", "submission", "cf4c6416-1393-41e4-b885-80dc1646ccd1", "2067", "17", "", "", "fb84cc3", "New Form", "0", "0", "41.59.65.202", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-02 01:00:25", "2025-08-02 01:00:25", "2025-08-01 20:00:25", "2025-08-01 20:00:25");
INSERT INTO `j3nd_e_submissions` VALUES("518", "submission", "4e84204e-ca88-4f1c-b0d3-553885f561da", "2071", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.200.73.108", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-02 02:43:34", "2025-08-02 02:43:34", "2025-08-01 21:43:34", "2025-08-01 21:43:34");
INSERT INTO `j3nd_e_submissions` VALUES("519", "submission", "2dc70ec8-98e5-4f76-9957-41d0e9b2f5c4", "2075", "17", "", "", "fb84cc3", "New Form", "0", "0", "5.137.222.98", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-02 03:19:25", "2025-08-02 03:19:25", "2025-08-01 22:19:25", "2025-08-01 22:19:25");
INSERT INTO `j3nd_e_submissions` VALUES("520", "submission", "563160fe-6c8c-45e0-bb1b-df1f32f5cf5d", "2079", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.194.178.29", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-02 06:20:03", "2025-08-02 06:20:04", "2025-08-02 01:20:03", "2025-08-02 01:20:04");
INSERT INTO `j3nd_e_submissions` VALUES("521", "submission", "8423d028-2499-4468-a46c-4a06deed7f56", "2083", "17", "", "", "fb84cc3", "New Form", "0", "0", "151.106.8.43", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-02 06:56:17", "2025-08-02 06:56:17", "2025-08-02 01:56:17", "2025-08-02 01:56:17");
INSERT INTO `j3nd_e_submissions` VALUES("522", "submission", "d4b274c3-f795-4d94-b6c5-0ad87d82aa76", "2087", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.194.178.28", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-02 09:23:26", "2025-08-02 09:23:26", "2025-08-02 04:23:26", "2025-08-02 04:23:26");
INSERT INTO `j3nd_e_submissions` VALUES("523", "submission", "2e3cd3be-b6a3-4458-a2d0-1a4ee25ec663", "2091", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.147.84.194", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-02 14:01:55", "2025-08-02 14:01:55", "2025-08-02 09:01:55", "2025-08-02 09:01:55");
INSERT INTO `j3nd_e_submissions` VALUES("524", "submission", "ba84832b-9ec8-4170-b7b7-3dd8a4f0a0f3", "2095", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.89.70.31", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-02 14:44:40", "2025-08-02 14:44:40", "2025-08-02 09:44:40", "2025-08-02 09:44:40");
INSERT INTO `j3nd_e_submissions` VALUES("525", "submission", "681a0817-f22a-4f25-92ed-4ee86c5cc333", "2099", "17", "", "", "fb84cc3", "New Form", "0", "0", "191.96.168.182", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-02 15:28:48", "2025-08-02 15:28:48", "2025-08-02 10:28:48", "2025-08-02 10:28:48");
INSERT INTO `j3nd_e_submissions` VALUES("526", "submission", "10da9907-a835-4cb1-b745-658d2f48173f", "2103", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.30.36.5", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-02 18:19:28", "2025-08-02 18:19:28", "2025-08-02 13:19:28", "2025-08-02 13:19:28");
INSERT INTO `j3nd_e_submissions` VALUES("527", "submission", "4ae31e21-7278-4639-a96c-5ab9f2a25622", "2107", "17", "http://www.mateoracksperu.com/", "", "fb84cc3", "New Form", "0", "0", "80.87.206.125", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-02 18:29:12", "2025-08-02 18:29:12", "2025-08-02 13:29:12", "2025-08-02 13:29:12");
INSERT INTO `j3nd_e_submissions` VALUES("528", "submission", "16a3e86b-29c2-47c1-b308-3df49bf71a23", "2111", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.30.36.49", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-02 22:03:54", "2025-08-02 22:03:54", "2025-08-02 17:03:54", "2025-08-02 17:03:54");
INSERT INTO `j3nd_e_submissions` VALUES("529", "submission", "8a98d1f6-6e67-4d51-891d-ec494d9d79c0", "2115", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.30.36.17", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-02 22:16:55", "2025-08-02 22:16:56", "2025-08-02 17:16:55", "2025-08-02 17:16:56");
INSERT INTO `j3nd_e_submissions` VALUES("530", "submission", "5035e93c-42a3-4f96-bedc-b6b2734100c4", "2119", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.194.178.4", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-02 22:23:11", "2025-08-02 22:23:11", "2025-08-02 17:23:11", "2025-08-02 17:23:11");
INSERT INTO `j3nd_e_submissions` VALUES("531", "submission", "6461f636-2b79-436d-a2b8-58f04e773a2c", "2123", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.194.178.8", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-02 22:54:49", "2025-08-02 22:54:49", "2025-08-02 17:54:49", "2025-08-02 17:54:49");
INSERT INTO `j3nd_e_submissions` VALUES("532", "submission", "00cf9f53-8759-406f-a746-4708a967664b", "2127", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.30.36.221", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-03 00:38:34", "2025-08-03 00:38:34", "2025-08-02 19:38:34", "2025-08-02 19:38:34");
INSERT INTO `j3nd_e_submissions` VALUES("533", "submission", "0af700ea-ef5e-40cf-9990-2882902cbd9f", "2131", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.54.128.8", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-03 01:36:41", "2025-08-03 01:36:41", "2025-08-02 20:36:41", "2025-08-02 20:36:41");
INSERT INTO `j3nd_e_submissions` VALUES("534", "submission", "106ce82c-d9e7-433c-afd0-2925fd41ccab", "2135", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.30.36.30", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-03 03:59:58", "2025-08-03 03:59:58", "2025-08-02 22:59:58", "2025-08-02 22:59:58");
INSERT INTO `j3nd_e_submissions` VALUES("535", "submission", "a7195ed9-6824-44c4-8188-29c5a8c1ab0d", "2139", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.139.53.46", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-03 04:28:28", "2025-08-03 04:28:28", "2025-08-02 23:28:28", "2025-08-02 23:28:28");
INSERT INTO `j3nd_e_submissions` VALUES("536", "submission", "747e2e49-b0ef-49d4-a164-78ffd3db1804", "2143", "17", "http://www.mateoracksperu.com/", "", "fb84cc3", "New Form", "0", "0", "185.99.2.145", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-03 19:24:41", "2025-08-03 19:24:41", "2025-08-03 14:24:41", "2025-08-03 14:24:41");
INSERT INTO `j3nd_e_submissions` VALUES("537", "submission", "0c1038ce-4b1f-41be-8ef9-aa921fa2f27a", "2147", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.86.202.212", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-05 01:36:47", "2025-08-05 01:36:47", "2025-08-04 20:36:47", "2025-08-04 20:36:47");
INSERT INTO `j3nd_e_submissions` VALUES("538", "submission", "590dfb04-5dd0-4119-a92d-e33192ddeb3d", "2151", "17", "", "", "fb84cc3", "New Form", "0", "0", "91.217.249.43", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-05 04:52:38", "2025-08-05 04:52:39", "2025-08-04 23:52:38", "2025-08-04 23:52:39");
INSERT INTO `j3nd_e_submissions` VALUES("539", "submission", "32f2d158-36d9-4004-8934-1817035fe416", "2155", "17", "", "", "fb84cc3", "New Form", "0", "0", "146.120.161.147", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-05 16:48:55", "2025-08-05 16:48:56", "2025-08-05 11:48:55", "2025-08-05 11:48:56");
INSERT INTO `j3nd_e_submissions` VALUES("540", "submission", "c0c934f4-b3a3-45bb-b905-876ca62afc70", "2159", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.118.231.97", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-05 17:39:40", "2025-08-05 17:39:40", "2025-08-05 12:39:40", "2025-08-05 12:39:40");
INSERT INTO `j3nd_e_submissions` VALUES("541", "submission", "cd942330-4ca1-49db-ba37-251f89814f9f", "2163", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.44.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-05 21:36:28", "2025-08-05 21:36:28", "2025-08-05 16:36:28", "2025-08-05 16:36:28");
INSERT INTO `j3nd_e_submissions` VALUES("542", "submission", "fb9de042-7291-41ca-a7b7-b295b3439789", "2167", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.144", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-05 21:57:23", "2025-08-05 21:57:23", "2025-08-05 16:57:23", "2025-08-05 16:57:23");
INSERT INTO `j3nd_e_submissions` VALUES("543", "submission", "167c212e-45d5-43a6-b3da-7a2b8409f5ed", "2171", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.44.161", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-05 23:44:25", "2025-08-05 23:44:25", "2025-08-05 18:44:25", "2025-08-05 18:44:25");
INSERT INTO `j3nd_e_submissions` VALUES("544", "submission", "d25c3d17-fae2-4030-a96e-4fce35805b7c", "2175", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.192.70.240", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-06 01:01:26", "2025-08-06 01:01:27", "2025-08-05 20:01:26", "2025-08-05 20:01:27");
INSERT INTO `j3nd_e_submissions` VALUES("545", "submission", "53a9aa3c-6f1e-4cd9-8e2b-1ace97338d61", "2179", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.49", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-06 02:49:46", "2025-08-06 02:49:46", "2025-08-05 21:49:46", "2025-08-05 21:49:46");
INSERT INTO `j3nd_e_submissions` VALUES("546", "submission", "777ce82e-dd68-4cf3-95ef-28f657137307", "2183", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.44.194", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-06 09:28:09", "2025-08-06 09:28:09", "2025-08-06 04:28:09", "2025-08-06 04:28:09");
INSERT INTO `j3nd_e_submissions` VALUES("547", "submission", "4254e283-592c-448c-8931-16b0cfc47d7a", "2187", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.19.223.16", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-06 21:39:58", "2025-08-06 21:39:58", "2025-08-06 16:39:58", "2025-08-06 16:39:58");
INSERT INTO `j3nd_e_submissions` VALUES("548", "submission", "fe599ad0-b86c-4a28-83f7-9bda3219f6d7", "2191", "17", "", "", "fb84cc3", "New Form", "0", "0", "216.24.213.239", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-06 23:57:13", "2025-08-06 23:57:13", "2025-08-06 18:57:13", "2025-08-06 18:57:13");
INSERT INTO `j3nd_e_submissions` VALUES("549", "submission", "5092ec00-9ee1-4f7a-8587-0e807e00622a", "2195", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.108.239", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-07 04:08:17", "2025-08-07 04:08:17", "2025-08-06 23:08:17", "2025-08-06 23:08:17");
INSERT INTO `j3nd_e_submissions` VALUES("550", "submission", "a9adccb2-a41f-4de4-a914-276e0ae06d10", "2199", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.94", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-07 06:17:18", "2025-08-07 06:17:18", "2025-08-07 01:17:18", "2025-08-07 01:17:18");
INSERT INTO `j3nd_e_submissions` VALUES("551", "submission", "3d996749-cfd5-4e97-8a1f-fd080b054d9b", "2203", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.44.159", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-07 08:24:53", "2025-08-07 08:24:53", "2025-08-07 03:24:53", "2025-08-07 03:24:53");
INSERT INTO `j3nd_e_submissions` VALUES("552", "submission", "68bd5d3b-5183-4a83-b9d8-72c7851e6cbe", "2207", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.44.175", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-07 08:37:17", "2025-08-07 08:37:17", "2025-08-07 03:37:17", "2025-08-07 03:37:17");
INSERT INTO `j3nd_e_submissions` VALUES("553", "submission", "114a0a44-629f-4da4-a13d-681e655d905c", "2211", "17", "", "", "fb84cc3", "New Form", "0", "0", "43.130.12.103", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-07 08:54:54", "2025-08-07 08:54:54", "2025-08-07 03:54:54", "2025-08-07 03:54:54");
INSERT INTO `j3nd_e_submissions` VALUES("554", "submission", "871a5436-442c-409a-a4f0-ba212f87d863", "2215", "17", "", "", "fb84cc3", "New Form", "0", "0", "85.203.44.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-07 14:24:50", "2025-08-07 14:24:50", "2025-08-07 09:24:50", "2025-08-07 09:24:50");
INSERT INTO `j3nd_e_submissions` VALUES("555", "submission", "7035a752-c130-48fd-98b6-6a3a839ad740", "2219", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.48", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-07 15:42:51", "2025-08-07 15:42:52", "2025-08-07 10:42:51", "2025-08-07 10:42:52");
INSERT INTO `j3nd_e_submissions` VALUES("556", "submission", "d517a2a7-a874-4a4a-9765-da015a28078d", "2223", "17", "", "", "fb84cc3", "New Form", "0", "0", "146.120.161.147", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-07 16:15:55", "2025-08-07 16:15:55", "2025-08-07 11:15:55", "2025-08-07 11:15:55");
INSERT INTO `j3nd_e_submissions` VALUES("557", "submission", "b0575f7e-c95d-476d-90cb-2245b3fff774", "2227", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.195", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-08 00:49:19", "2025-08-08 00:49:19", "2025-08-07 19:49:19", "2025-08-07 19:49:19");
INSERT INTO `j3nd_e_submissions` VALUES("558", "submission", "c3677b47-a64a-4e7e-87a9-9a7b0b1350d6", "2231", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.89.70.31", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-08 01:36:17", "2025-08-08 01:36:17", "2025-08-07 20:36:17", "2025-08-07 20:36:17");
INSERT INTO `j3nd_e_submissions` VALUES("559", "submission", "a30298ae-b94b-4c4d-bb5a-cad72348b899", "2235", "17", "", "", "fb84cc3", "New Form", "0", "0", "116.202.220.253", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-08 03:36:13", "2025-08-08 03:36:13", "2025-08-07 22:36:13", "2025-08-07 22:36:13");
INSERT INTO `j3nd_e_submissions` VALUES("560", "submission", "8b5a6042-9992-444c-8540-9855d100a5f5", "2239", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.192.69.35", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-08 05:19:19", "2025-08-08 05:19:20", "2025-08-08 00:19:19", "2025-08-08 00:19:20");
INSERT INTO `j3nd_e_submissions` VALUES("561", "submission", "e56bd0f0-cc6e-4fc0-9742-8ef61057bfb2", "2243", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.194.178.8", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-08 05:33:37", "2025-08-08 05:33:37", "2025-08-08 00:33:37", "2025-08-08 00:33:37");
INSERT INTO `j3nd_e_submissions` VALUES("562", "submission", "4b13aedc-7fe1-4a44-a7b0-190a75ce9358", "2247", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.194.178.6", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-08 06:03:54", "2025-08-08 06:03:54", "2025-08-08 01:03:54", "2025-08-08 01:03:54");
INSERT INTO `j3nd_e_submissions` VALUES("563", "submission", "8b29f01f-2fdd-431e-954c-a4d7b1062afe", "2251", "17", "", "", "fb84cc3", "New Form", "0", "0", "216.169.134.120", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-08 08:09:09", "2025-08-08 08:09:09", "2025-08-08 03:09:09", "2025-08-08 03:09:09");
INSERT INTO `j3nd_e_submissions` VALUES("564", "submission", "fd6042e5-0b18-4965-93fd-a8b072f82f5c", "2255", "17", "", "", "fb84cc3", "New Form", "0", "0", "216.151.184.120", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-08 14:19:42", "2025-08-08 14:19:42", "2025-08-08 09:19:42", "2025-08-08 09:19:42");
INSERT INTO `j3nd_e_submissions` VALUES("565", "submission", "b0dea6ca-af69-4220-9f08-c5a80c7c3281", "2259", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "194.102.38.239", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-08 14:20:59", "2025-08-08 14:20:59", "2025-08-08 09:20:59", "2025-08-08 09:20:59");
INSERT INTO `j3nd_e_submissions` VALUES("566", "submission", "59ea61f4-de82-4796-958c-55ecc3f02239", "2263", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.192.69.10", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-08 15:10:51", "2025-08-08 15:10:51", "2025-08-08 10:10:51", "2025-08-08 10:10:51");
INSERT INTO `j3nd_e_submissions` VALUES("567", "submission", "cee136ae-ac3b-488b-8668-6efc2b6b208f", "2267", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.194.178.46", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-08 21:50:07", "2025-08-08 21:50:08", "2025-08-08 16:50:07", "2025-08-08 16:50:08");
INSERT INTO `j3nd_e_submissions` VALUES("568", "submission", "eef6f3c9-b85a-42c4-b798-b65537f79e0c", "2271", "17", "", "", "fb84cc3", "New Form", "0", "0", "31.171.130.119", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-09 06:25:37", "2025-08-09 06:25:37", "2025-08-09 01:25:37", "2025-08-09 01:25:37");
INSERT INTO `j3nd_e_submissions` VALUES("569", "submission", "e343e225-496f-4247-8e57-b9d0174cd123", "2275", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.43", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-09 09:54:20", "2025-08-09 09:54:21", "2025-08-09 04:54:20", "2025-08-09 04:54:21");
INSERT INTO `j3nd_e_submissions` VALUES("570", "submission", "aecc8186-8f26-468a-a6a3-212631dcfd5d", "2279", "17", "", "", "fb84cc3", "New Form", "0", "0", "203.188.183.158", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-10 03:17:52", "2025-08-10 03:17:52", "2025-08-09 22:17:52", "2025-08-09 22:17:52");
INSERT INTO `j3nd_e_submissions` VALUES("571", "submission", "aaa8a226-d56f-40ed-b40b-cacfc057f203", "2283", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.107.128", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-10 03:20:33", "2025-08-10 03:20:33", "2025-08-09 22:20:33", "2025-08-09 22:20:33");
INSERT INTO `j3nd_e_submissions` VALUES("572", "submission", "a063801b-540e-4c3d-9258-1f9541b0afea", "2287", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.77.216.3", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-10 08:21:35", "2025-08-10 08:21:35", "2025-08-10 03:21:35", "2025-08-10 03:21:35");
INSERT INTO `j3nd_e_submissions` VALUES("573", "submission", "d77d1a3e-53f8-4134-ac75-c3e948f5dc54", "2291", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.54.128.8", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-10 08:22:57", "2025-08-10 08:22:57", "2025-08-10 03:22:57", "2025-08-10 03:22:57");
INSERT INTO `j3nd_e_submissions` VALUES("574", "submission", "42ab0043-4104-4d1a-a32c-230187f0f73d", "2295", "17", "", "", "fb84cc3", "New Form", "0", "0", "176.118.188.18", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-10 23:23:43", "2025-08-10 23:23:43", "2025-08-10 18:23:43", "2025-08-10 18:23:43");
INSERT INTO `j3nd_e_submissions` VALUES("575", "submission", "d4cd3438-5c67-4142-a3d8-fe458cf9d45a", "2299", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.43", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-10 23:53:32", "2025-08-10 23:53:32", "2025-08-10 18:53:32", "2025-08-10 18:53:32");
INSERT INTO `j3nd_e_submissions` VALUES("576", "submission", "50e63505-521d-458f-9e7b-32ede8802449", "2303", "17", "", "", "fb84cc3", "New Form", "0", "0", "78.29.53.57", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.53 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-11 17:45:40", "2025-08-11 17:45:41", "2025-08-11 12:45:40", "2025-08-11 12:45:41");
INSERT INTO `j3nd_e_submissions` VALUES("577", "submission", "3071093c-04d2-4054-b7f2-0064453d9a7f", "2307", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.54.128.8", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-11 21:54:35", "2025-08-11 21:54:35", "2025-08-11 16:54:35", "2025-08-11 16:54:35");
INSERT INTO `j3nd_e_submissions` VALUES("578", "submission", "c8e677e4-efcd-48ed-9da0-8ea489255158", "2311", "17", "", "", "fb84cc3", "New Form", "0", "0", "195.78.54.26", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-12 06:14:04", "2025-08-12 06:14:04", "2025-08-12 01:14:04", "2025-08-12 01:14:04");
INSERT INTO `j3nd_e_submissions` VALUES("579", "submission", "b3a2ff65-a09d-416c-967d-7667e600d430", "2315", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "81.181.107.34", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-12 18:28:21", "2025-08-12 18:28:21", "2025-08-12 13:28:21", "2025-08-12 13:28:21");
INSERT INTO `j3nd_e_submissions` VALUES("580", "submission", "493c7998-5e7c-4f6f-a300-104f2c6bb2e3", "2319", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.54.128.8", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-13 06:03:25", "2025-08-13 06:03:25", "2025-08-13 01:03:25", "2025-08-13 01:03:25");
INSERT INTO `j3nd_e_submissions` VALUES("581", "submission", "e812ce91-ba03-4f5c-b35d-e2b79d6e12fa", "2323", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "38.114.122.149", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-13 20:33:30", "2025-08-13 20:33:30", "2025-08-13 15:33:30", "2025-08-13 15:33:30");
INSERT INTO `j3nd_e_submissions` VALUES("582", "submission", "d072f702-63aa-4952-aedd-a5574ffa0cf0", "2327", "17", "", "", "fb84cc3", "New Form", "0", "0", "62.210.80.46", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-14 06:00:57", "2025-08-14 06:00:57", "2025-08-14 01:00:57", "2025-08-14 01:00:57");
INSERT INTO `j3nd_e_submissions` VALUES("583", "submission", "14c2994f-50bf-4364-ad21-6d25e1062e02", "2331", "17", "", "", "fb84cc3", "New Form", "0", "0", "37.19.223.11", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-14 13:12:58", "2025-08-14 13:12:58", "2025-08-14 08:12:58", "2025-08-14 08:12:58");
INSERT INTO `j3nd_e_submissions` VALUES("584", "submission", "be0f90c0-2406-4259-b96d-67f92b9a48f2", "2335", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.97", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-14 17:20:14", "2025-08-14 17:20:14", "2025-08-14 12:20:14", "2025-08-14 12:20:14");
INSERT INTO `j3nd_e_submissions` VALUES("585", "submission", "03c16d70-f76f-4461-8864-41f96c207f1b", "2339", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.97", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-14 19:34:07", "2025-08-14 19:34:07", "2025-08-14 14:34:07", "2025-08-14 14:34:07");
INSERT INTO `j3nd_e_submissions` VALUES("586", "submission", "0a300197-02cd-44cb-879a-7676ac26cb4d", "2343", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.182.124.160", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-14 23:48:55", "2025-08-14 23:48:55", "2025-08-14 18:48:55", "2025-08-14 18:48:55");
INSERT INTO `j3nd_e_submissions` VALUES("587", "submission", "6036804e-2953-43dc-af79-4044ee2de45a", "2347", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.253", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-15 03:37:07", "2025-08-15 03:37:07", "2025-08-14 22:37:07", "2025-08-14 22:37:07");
INSERT INTO `j3nd_e_submissions` VALUES("588", "submission", "11120fdf-44cf-4887-bb7c-23d19ae1b243", "2351", "17", "", "", "fb84cc3", "New Form", "0", "0", "146.120.161.147", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-15 08:07:45", "2025-08-15 08:07:45", "2025-08-15 03:07:45", "2025-08-15 03:07:45");
INSERT INTO `j3nd_e_submissions` VALUES("589", "submission", "cab154cc-aa91-4f90-80ec-7856e731ec7d", "2355", "17", "", "", "fb84cc3", "New Form", "0", "0", "98.159.226.248", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-15 17:54:36", "2025-08-15 17:54:36", "2025-08-15 12:54:36", "2025-08-15 12:54:36");
INSERT INTO `j3nd_e_submissions` VALUES("590", "submission", "602c978d-df1e-423c-947e-3e9c6c0b44ee", "2359", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.89.70.30", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-16 11:42:09", "2025-08-16 11:42:10", "2025-08-16 06:42:09", "2025-08-16 06:42:10");
INSERT INTO `j3nd_e_submissions` VALUES("591", "submission", "e84abc70-afcd-421d-9930-7ab6037594ba", "2363", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.100.99", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-16 12:09:48", "2025-08-16 12:09:48", "2025-08-16 07:09:48", "2025-08-16 07:09:48");
INSERT INTO `j3nd_e_submissions` VALUES("592", "submission", "9c7201e2-1f5f-41f8-a956-cacc979b1327", "2367", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.54.128.8", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-16 16:53:22", "2025-08-16 16:53:22", "2025-08-16 11:53:22", "2025-08-16 11:53:22");
INSERT INTO `j3nd_e_submissions` VALUES("593", "submission", "0e923bd0-9881-4c39-ab65-7ce7b88620c3", "2371", "17", "", "", "fb84cc3", "New Form", "0", "0", "89.175.12.245", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-16 20:22:20", "2025-08-16 20:22:20", "2025-08-16 15:22:20", "2025-08-16 15:22:20");
INSERT INTO `j3nd_e_submissions` VALUES("594", "submission", "6162f6b3-e610-4651-8eaf-1cddd5a99131", "2375", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.89.70.30", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-17 08:20:36", "2025-08-17 08:20:37", "2025-08-17 03:20:36", "2025-08-17 03:20:37");
INSERT INTO `j3nd_e_submissions` VALUES("595", "submission", "f206402a-4480-4496-b935-1354c5c7e48b", "2379", "17", "", "", "fb84cc3", "New Form", "0", "0", "165.231.182.114", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-17 13:26:12", "2025-08-17 13:26:12", "2025-08-17 08:26:12", "2025-08-17 08:26:12");
INSERT INTO `j3nd_e_submissions` VALUES("596", "submission", "0356e412-8e9d-4bbc-b62d-74f1677d5df0", "2383", "17", "", "", "fb84cc3", "New Form", "0", "0", "83.221.18.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-18 09:41:16", "2025-08-18 09:41:16", "2025-08-18 04:41:16", "2025-08-18 04:41:16");
INSERT INTO `j3nd_e_submissions` VALUES("597", "submission", "b033f214-1f85-40c4-8ab5-69ea1b88fed9", "2387", "17", "", "", "fb84cc3", "New Form", "0", "0", "181.214.218.113", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-18 18:54:43", "2025-08-18 18:54:43", "2025-08-18 13:54:43", "2025-08-18 13:54:43");
INSERT INTO `j3nd_e_submissions` VALUES("598", "submission", "e58af157-bead-4160-9058-5deabcff3436", "2391", "17", "", "", "fb84cc3", "New Form", "0", "0", "159.100.19.127", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-19 04:50:19", "2025-08-19 04:50:19", "2025-08-18 23:50:19", "2025-08-18 23:50:19");
INSERT INTO `j3nd_e_submissions` VALUES("599", "submission", "9bf196f4-178d-4f57-a649-f4dd82097911", "2395", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.147.85.86", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-19 11:09:11", "2025-08-19 11:09:11", "2025-08-19 06:09:11", "2025-08-19 06:09:11");
INSERT INTO `j3nd_e_submissions` VALUES("600", "submission", "9f7a011f-ac37-423a-bcb1-95f1f459c057", "2399", "17", "", "", "fb84cc3", "New Form", "0", "0", "79.142.79.34", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-19 11:29:40", "2025-08-19 11:29:40", "2025-08-19 06:29:40", "2025-08-19 06:29:40");
INSERT INTO `j3nd_e_submissions` VALUES("601", "submission", "afa1cfaa-a2bd-47cc-8898-203b8b07d78f", "2407", "17", "", "", "fb84cc3", "New Form", "0", "0", "192.142.0.178", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-19 14:02:01", "2025-08-19 14:02:02", "2025-08-19 09:02:01", "2025-08-19 09:02:02");
INSERT INTO `j3nd_e_submissions` VALUES("602", "submission", "95fb634e-3604-4ab8-9249-f1a7b22d86e0", "2405", "17", "", "", "fb84cc3", "New Form", "0", "0", "192.142.0.178", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-19 14:02:01", "2025-08-19 14:02:02", "2025-08-19 09:02:01", "2025-08-19 09:02:02");
INSERT INTO `j3nd_e_submissions` VALUES("603", "submission", "3457debd-0eba-48b5-b0ec-c1c3634eaa2f", "2411", "17", "", "", "fb84cc3", "New Form", "0", "0", "192.142.0.178", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-19 14:02:06", "2025-08-19 14:02:06", "2025-08-19 09:02:06", "2025-08-19 09:02:06");
INSERT INTO `j3nd_e_submissions` VALUES("604", "submission", "e0920319-9a8e-48f9-8a21-67fcfbaa3203", "2415", "17", "", "", "fb84cc3", "New Form", "0", "0", "79.133.41.55", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-19 21:31:48", "2025-08-19 21:31:48", "2025-08-19 16:31:48", "2025-08-19 16:31:48");
INSERT INTO `j3nd_e_submissions` VALUES("605", "submission", "a73cd03c-979c-47c5-bcdc-25459f109990", "2419", "17", "", "", "fb84cc3", "New Form", "0", "0", "185.39.19.49", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-19 22:30:15", "2025-08-19 22:30:15", "2025-08-19 17:30:15", "2025-08-19 17:30:15");
INSERT INTO `j3nd_e_submissions` VALUES("606", "submission", "6186e853-984c-41e9-a727-4e11aeaf86ec", "2423", "17", "", "", "fb84cc3", "New Form", "0", "0", "83.221.18.162", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-20 00:15:43", "2025-08-20 00:15:43", "2025-08-19 19:15:43", "2025-08-19 19:15:43");
INSERT INTO `j3nd_e_submissions` VALUES("607", "submission", "d776c194-1c35-42d2-91b0-0a0a5b49d748", "2427", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.100.99", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-20 00:53:53", "2025-08-20 00:53:53", "2025-08-19 19:53:53", "2025-08-19 19:53:53");
INSERT INTO `j3nd_e_submissions` VALUES("608", "submission", "f512c536-896b-44cd-ae0d-7f6ee292365c", "2431", "17", "", "", "fb84cc3", "New Form", "0", "0", "192.142.0.178", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-20 01:20:15", "2025-08-20 01:20:15", "2025-08-19 20:20:15", "2025-08-19 20:20:15");
INSERT INTO `j3nd_e_submissions` VALUES("609", "submission", "04c3f865-c984-47f0-bccd-c3c4bdaa0149", "2435", "17", "", "", "fb84cc3", "New Form", "0", "0", "95.54.128.8", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-20 03:06:34", "2025-08-20 03:06:34", "2025-08-19 22:06:34", "2025-08-19 22:06:34");
INSERT INTO `j3nd_e_submissions` VALUES("610", "submission", "19d804d3-7331-4441-b456-b7d74fe080b6", "2439", "17", "", "", "fb84cc3", "New Form", "0", "0", "5.165.143.51", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-20 10:21:09", "2025-08-20 10:21:09", "2025-08-20 05:21:09", "2025-08-20 05:21:09");
INSERT INTO `j3nd_e_submissions` VALUES("611", "submission", "c57e3ccb-f637-4d28-9c44-3a7a1028ca0a", "2443", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.102.37.152", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.134 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-20 17:11:29", "2025-08-20 17:11:29", "2025-08-20 12:11:29", "2025-08-20 12:11:29");
INSERT INTO `j3nd_e_submissions` VALUES("612", "submission", "1d8ca84a-d3ba-483b-9be5-8708c75e0355", "2447", "17", "", "", "fb84cc3", "New Form", "0", "0", "192.142.0.178", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-21 01:45:40", "2025-08-21 01:45:40", "2025-08-20 20:45:40", "2025-08-20 20:45:40");
INSERT INTO `j3nd_e_submissions` VALUES("613", "submission", "eb0fbd3a-7482-4b88-9dba-c58833c6deae", "2451", "17", "", "", "fb84cc3", "New Form", "0", "0", "92.119.36.101", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-21 07:30:37", "2025-08-21 07:30:37", "2025-08-21 02:30:37", "2025-08-21 02:30:37");
INSERT INTO `j3nd_e_submissions` VALUES("614", "submission", "f356aebe-2023-4ce3-8be8-e64aa2cbaca5", "2455", "17", "", "", "fb84cc3", "New Form", "0", "0", "79.133.41.55", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-21 17:53:24", "2025-08-21 17:53:24", "2025-08-21 12:53:24", "2025-08-21 12:53:24");
INSERT INTO `j3nd_e_submissions` VALUES("615", "submission", "df6259b6-d3aa-4d84-98f0-d74550ce395a", "2459", "17", "", "", "fb84cc3", "New Form", "0", "0", "212.102.57.148", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-21 19:16:59", "2025-08-21 19:16:59", "2025-08-21 14:16:59", "2025-08-21 14:16:59");
INSERT INTO `j3nd_e_submissions` VALUES("616", "submission", "51da7160-1c85-4a37-b123-ef3b090b3469", "2463", "17", "", "", "fb84cc3", "New Form", "0", "0", "45.89.70.31", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-22 11:58:09", "2025-08-22 11:58:09", "2025-08-22 06:58:09", "2025-08-22 06:58:09");
INSERT INTO `j3nd_e_submissions` VALUES("617", "submission", "cb95e436-5a06-4a9f-9aed-55c57041467e", "2467", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "92.118.228.66", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-22 16:33:33", "2025-08-22 16:33:34", "2025-08-22 11:33:33", "2025-08-22 11:33:34");
INSERT INTO `j3nd_e_submissions` VALUES("618", "submission", "f52fd096-23bc-4039-bff8-8611ec1456de", "2471", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.176", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-23 02:14:40", "2025-08-23 02:14:40", "2025-08-22 21:14:40", "2025-08-22 21:14:40");
INSERT INTO `j3nd_e_submissions` VALUES("619", "submission", "0a158501-8021-4a41-a22c-3984f074d13b", "2475", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.166", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-23 07:45:47", "2025-08-23 07:45:47", "2025-08-23 02:45:47", "2025-08-23 02:45:47");
INSERT INTO `j3nd_e_submissions` VALUES("620", "submission", "43e060d3-432c-4459-a7a4-e22cbe664a68", "2479", "17", "", "", "fb84cc3", "New Form", "0", "0", "165.231.182.116", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5042.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-23 09:05:17", "2025-08-23 09:05:17", "2025-08-23 04:05:17", "2025-08-23 04:05:17");
INSERT INTO `j3nd_e_submissions` VALUES("621", "submission", "f9b8d93b-0b63-41ba-9dc6-42f06ca6f8f7", "2483", "17", "", "", "fb84cc3", "New Form", "0", "0", "109.248.143.90", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-23 13:09:39", "2025-08-23 13:09:40", "2025-08-23 08:09:39", "2025-08-23 08:09:40");
INSERT INTO `j3nd_e_submissions` VALUES("622", "submission", "1df673ab-f3e4-4dc5-b208-4467d6505b27", "2487", "17", "", "", "fb84cc3", "New Form", "0", "0", "82.118.29.205", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-23 13:54:14", "2025-08-23 13:54:15", "2025-08-23 08:54:14", "2025-08-23 08:54:15");
INSERT INTO `j3nd_e_submissions` VALUES("623", "submission", "ad4a0c4f-e192-4372-ad48-5b2fcf83433e", "2491", "17", "http://www.mateoracksperu.com", "", "fb84cc3", "New Form", "0", "0", "89.117.94.246", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-23 20:15:11", "2025-08-23 20:15:11", "2025-08-23 15:15:11", "2025-08-23 15:15:11");
INSERT INTO `j3nd_e_submissions` VALUES("624", "submission", "332862c3-e7ff-4447-b5f3-2b32149820a3", "2495", "17", "", "", "fb84cc3", "New Form", "0", "0", "77.246.104.80", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-23 23:56:58", "2025-08-23 23:56:59", "2025-08-23 18:56:58", "2025-08-23 18:56:59");
INSERT INTO `j3nd_e_submissions` VALUES("625", "submission", "46919435-dc9f-48aa-ae44-2a99d420ca23", "2499", "17", "", "", "fb84cc3", "New Form", "0", "0", "84.247.50.198", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"17\"}", "2025-08-24 08:54:58", "2025-08-24 08:54:58", "2025-08-24 03:54:58", "2025-08-24 03:54:58");
INSERT INTO `j3nd_e_submissions` VALUES("626", "submission", "6e5202d0-145d-4488-aba4-1ada30447002", "2503", "17", "", "", "fb84cc3", "New Form", "0", "0", "1